package Locale::CLDR::Transformations::Bgn::Ru_latn::Ru;
# This file auto generated from Data\common\transforms\ru_Latn-ru-BGN.xml
#	on Sun 24 Apr  8:12:42 am GMT

use version;

our $VERSION = version->declare('v0.29.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q((?^u:\p{Upper})),
					after   => q((?^u:[^\p{Lower}])),
					replace => q((?^u:ʹ)),
					result  => q(Ь),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ʹ)),
					result  => q(ь),
					revisit => 0,
				},
				{
					before  => q((?^u:\p{Upper})),
					after   => q((?^u:[^\p{Lower}])),
					replace => q((?^u:ʺ)),
					result  => q(Ъ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ʺ)),
					result  => q(ъ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:K[Hh])),
					result  => q(Х),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:k[Hh])),
					result  => q(х),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:T·S)),
					result  => q(ТС),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:T·s)),
					result  => q(Тс),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:t·S)),
					result  => q(тС),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:t·s)),
					result  => q(тс),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:T[Ss])),
					result  => q(Ц),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:t[Ss])),
					result  => q(ц),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:C[Hh])),
					result  => q(Ч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:c[Hh])),
					result  => q(ч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:S[Hh]·C[Hh])),
					result  => q(ШЧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:S[Hh]·c[Hh])),
					result  => q(Шч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:s[Hh]·C[Hh])),
					result  => q(шЧ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:s[Hh]·c[Hh])),
					result  => q(шч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:S[Hh][Cc][Hh])),
					result  => q(Щ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:s[Hh][Cc][Hh])),
					result  => q(щ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:S[Hh])),
					result  => q(Ш),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:s[Hh])),
					result  => q(ш),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:Y[Ee])),
					result  => q(Е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:y[Ee])),
					result  => q(е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:Y[Ëë])),
					result  => q(Ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:y[Ëë])),
					result  => q(ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:Y[Uu])),
					result  => q(Ю),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:y[Uu])),
					result  => q(ю),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:Y[Aa])),
					result  => q(Я),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:y[Aa])),
					result  => q(я),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?^u:[^ \p{L} \p{M} \p{N}])),
					replace => q((?^u:yy)),
					result  => q(ый),
					revisit => 0,
				},
				{
					before  => q((?^u:[^ \p{L} \p{M} \p{N}])),
					after   => q((?^u:[^aeëiouyAEËIOUY])),
					replace => q((?^u:Y)),
					result  => q(Ы),
					revisit => 0,
				},
				{
					before  => q((?^u:[^ \p{L} \p{M} \p{N}])),
					after   => q((?^u:[^aeëiouyAEËIOUY])),
					replace => q((?^u:y)),
					result  => q(ы),
					revisit => 0,
				},
				{
					before  => q((?^u:(?[[БВГДЖЙКЛМНПРСТФХЦЧШЩЭ] + [бвгджйклмнпрстфхцчшщэ]]))),
					after   => q(),
					replace => q((?^u:Y)),
					result  => q(Ы),
					revisit => 0,
				},
				{
					before  => q((?^u:(?[[БВГДЖЙКЛМНПРСТФХЦЧШЩЭ] + [бвгджйклмнпрстфхцчшщэ]]))),
					after   => q(),
					replace => q((?^u:y)),
					result  => q(ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:Y)),
					result  => q(Й),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:y)),
					result  => q(й),
					revisit => 0,
				},
				{
					before  => q((?^u:[^ \p{L} \p{M} \p{N}])),
					after   => q(),
					replace => q((?^u:E)),
					result  => q(Э),
					revisit => 0,
				},
				{
					before  => q((?^u:[^ \p{L} \p{M} \p{N}])),
					after   => q(),
					replace => q((?^u:e)),
					result  => q(э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:·E)),
					result  => q(Э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:·e)),
					result  => q(э),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:E)),
					result  => q(Е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:e)),
					result  => q(е),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:A)),
					result  => q(А),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:a)),
					result  => q(а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:B)),
					result  => q(Б),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:b)),
					result  => q(б),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:V)),
					result  => q(В),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:v)),
					result  => q(в),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:G)),
					result  => q(Г),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:g)),
					result  => q(г),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:D)),
					result  => q(Д),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:d)),
					result  => q(д),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:Ë)),
					result  => q(Ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:ë)),
					result  => q(ё),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:Z[Hh])),
					result  => q(Ж),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:z[Hh])),
					result  => q(ж),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:Z)),
					result  => q(З),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:z)),
					result  => q(з),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:I)),
					result  => q(И),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:i)),
					result  => q(и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:K)),
					result  => q(К),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:k)),
					result  => q(к),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:L)),
					result  => q(Л),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:l)),
					result  => q(л),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:M)),
					result  => q(М),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:m)),
					result  => q(м),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:N)),
					result  => q(Н),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:n)),
					result  => q(н),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:O)),
					result  => q(О),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:o)),
					result  => q(о),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:P)),
					result  => q(П),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:p)),
					result  => q(п),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:R)),
					result  => q(Р),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:r)),
					result  => q(р),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:S)),
					result  => q(С),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:s)),
					result  => q(с),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:T)),
					result  => q(Т),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:t)),
					result  => q(т),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:U)),
					result  => q(У),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:u)),
					result  => q(у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:F)),
					result  => q(Ф),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:f)),
					result  => q(ф),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:·Y)),
					result  => q(Ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:·y)),
					result  => q(ы),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q((?^u:·)),
					result  => q(),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
