=head1

Locale::CLDR::Locales::My - Package for language Burmese

=cut

package Locale::CLDR::Locales::My;
# This file auto generated from Data\common\main\my.xml
#	on Wed 10 Feb  8:16:28 am GMT

use version;

our $VERSION = version->declare('v0.28.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => 'HashRef',
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(အနုတ်→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(သုည),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←←ဒသမ→→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(တစ်),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(နှစ်),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(သုံး),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(လေး),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ငါး),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ခြောက်),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(ခုနှစ်),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(ရှစ်),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ကိုး),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ဆယ်),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(ဆယ့်[→→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(←←ဆယ်[→→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←←ရာ),
				},
				'101' => {
					base_value => q(101),
					divisor => q(100),
					rule => q(←←ရာ့[→→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←←ထောင်),
				},
				'1001' => {
					base_value => q(1001),
					divisor => q(1000),
					rule => q(←←ထောင့်[→→]),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(←←သောင်း[→→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←←သိန်း[→→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←←သန်း[→→]),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(←←ကုဋေ[→→]),
				},
				'100000000000000' => {
					base_value => q(100000000000000),
					divisor => q(100000000000000),
					rule => q(←←ကောဋိ[→→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(အနုတ်→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(ပထမ),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(ဒုတိယ),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(တတိယ),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(စတုတ္ထ),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ပဉ္စမ),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ဆဋ္ဌမ),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(သတ္တမ),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(အဋ္ဌမ),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(နဝမ),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ဒသမ),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}၊{1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'အဘ်ခါဇီရန်',
 				'af' => 'အာဖရိကန်းစ်',
 				'agq' => 'အာဂ်ဟိန်း',
 				'ak' => 'အာကိန်',
 				'am' => 'အန်ဟာရစျချ',
 				'ang' => 'အင်္ဂလိပ်စာဟောင်း',
 				'ar' => 'အာရေဗီ',
 				'ar_001' => 'အရေဗီ(ပုံမှန်)',
 				'arn' => 'မာပုချီ',
 				'as' => 'အက္စမီစ်',
 				'asa' => 'အာစု',
 				'az' => 'အော်ဇောဘိုင်ဂျောနီ',
 				'az@alt=short' => 'အဇာရီ',
 				'ba' => 'ဘက်ရှ်ကီအာ',
 				'ban' => 'ဘာလီ',
 				'bas' => 'ဘာဆာ',
 				'be' => 'ဘီလာရု',
 				'bem' => 'ဘိန်ဘာ',
 				'bez' => 'ဘီနာ',
 				'bg' => 'ဘူဂေးရီးယား',
 				'bgn' => 'အနောက်ပိုင်းဘဲလိုချီ',
 				'bm' => 'ဘန်ဘာရာ',
 				'bn' => 'ဘင်္ဂါလီ',
 				'bo' => 'တိဘက်',
 				'br' => 'ဘရီတွန်',
 				'brx' => 'ဗိုဒို',
 				'bs' => 'ဘော့စ်နီးယား',
 				'ca' => 'ကာတာလန်',
 				'ce' => 'ချေချင်း',
 				'cgg' => 'ချီဂါ',
 				'chr' => 'ချာရိုကီ',
 				'ckb' => 'ဆိုရာနီ ကူဒစ်ရှ်',
 				'co' => 'ခိုစီကန်',
 				'cr' => 'ခရီး',
 				'cs' => 'ချက်',
 				'cv' => 'ချူဗက်ရှ်',
 				'cy' => 'ဝေလ',
 				'da' => 'ဒိန်းမတ်',
 				'dak' => 'ဒါကိုတာ',
 				'dav' => 'တိုင်တာ',
 				'de' => 'ဂျာမန်',
 				'de_AT' => 'ဩစတြီးယ ဂျာမန်',
 				'de_CH' => 'ဆွစ် အမြင့် ဂျာမန်',
 				'del' => 'ဒီလာဝဲ',
 				'dje' => 'ဇာမာ',
 				'dsb' => 'အောက်ဆိုဘီအမ်',
 				'dua' => 'ဒူအလာ',
 				'dum' => 'အလယ်ပိုင်း ဒတ်ချ်',
 				'dyo' => 'ဂျိုလာ-ဖွန်ရီ',
 				'dz' => 'ဒွန်ကာ',
 				'ebu' => 'အမ်ဘူ',
 				'ee' => 'ဝီ',
 				'egy' => 'ရှေးဟောင်း အီဂျစ်',
 				'el' => 'ဂရိ',
 				'en' => 'အင်္ဂလိပ်',
 				'en_AU' => 'ဩစတြေးလျှ အင်္ဂလိပ်',
 				'en_CA' => 'ကနေဒါ အင်္ဂလိပ်',
 				'en_GB' => 'ဗြိတိသျှ အင်္ဂလိပ်',
 				'en_GB@alt=short' => 'အင်္ဂလိပ်(ယူကေ)',
 				'en_US' => 'အမေရိကန် အင်္ဂလိပ်',
 				'en_US@alt=short' => 'အင်္ဂလိပ်(ယူအက်စ်)',
 				'enm' => 'အလယ်ပိုင်း အင်္ဂလိပ်',
 				'eo' => 'အက္စပရန္တို',
 				'es' => 'စပိန်',
 				'es_419' => 'လက်တင်အမေရိက စပိန်',
 				'es_ES' => 'စပိန်(ဥရောပ)',
 				'et' => 'အက်စ်တိုးနီးရန်း',
 				'eu' => 'ဘစ်က္ကီ',
 				'fa' => 'ပါရှန်',
 				'fi' => 'ဖင်နစ်ရှ်',
 				'fil' => 'ဖိလစ်ပီနို',
 				'fj' => 'ဖီဂျီ',
 				'fo' => 'ဖာရိုအိစ်',
 				'fr' => 'ပြင်သစ်',
 				'fr_CA' => 'ကနေဒါ ပြင်သစ်',
 				'fr_CH' => 'ဆွစ် ပြင်သစ်',
 				'frm' => 'အလယ်ပိုင်းပြင်သစ်',
 				'fro' => 'ပြင်သစ်ဟောင်း',
 				'frr' => 'မြောက်ပိုင်း ဖရီစီရန်',
 				'frs' => 'အရှေ့ပိုင်း ဖရီစီရန်',
 				'fy' => 'အနောက်ပိုင်း ဖရီစီရန်',
 				'ga' => 'အိုင်းရစ်',
 				'gag' => 'ဂါဂါဇ်',
 				'gl' => 'ဂါလာစီယံ',
 				'gmh' => 'အလယ်ပိုင်းအမြင့်ဂျာမန်',
 				'gn' => 'ဂူအာရာနီ',
 				'grc' => 'ရှေးဟောင်း ဂရိ',
 				'gsw' => 'ဆွစ် ဂျာမန်',
 				'gu' => 'ဂူဂျာရသီ',
 				'guz' => 'ဂူစီး',
 				'gv' => 'မန်းဇ်',
 				'ha' => 'ဟာဥစာ',
 				'haw' => 'ဟာဝေယံ',
 				'he' => 'ဟီးဘရူး',
 				'hi' => 'ဟိန္ဒီ',
 				'hr' => 'ခရိုအေရှန်',
 				'hsb' => 'အပေါ်ဆိုဘီအမ်',
 				'ht' => 'ဟာအီတီအန်',
 				'hu' => 'ဟန်ဂေရီ',
 				'hy' => 'အာမေနီအန်',
 				'id' => 'အင်ဒိုနီးရှား',
 				'ig' => 'အစ္ဂဘို',
 				'ii' => 'စီချွမ် ရီ',
 				'is' => 'အိုင်စ်လန္ဒီ',
 				'it' => 'အီတလီ',
 				'iu' => 'အီနုခ်တီတု',
 				'ja' => 'ဂျပန်',
 				'jgo' => 'ဂွမ်ဘာ',
 				'jmc' => 'မချာမီ',
 				'jpr' => 'ဂျူဒီယို-ပါရှန်',
 				'jrb' => 'ဂျူဒီယို-အာရေဗျ',
 				'jv' => 'ဂျာဗားနီးစ်',
 				'ka' => 'ဂျော်ဂျီယန်',
 				'kab' => 'ခဘိုင်လ်',
 				'kac' => 'ကချင်',
 				'kam' => 'ခမ်ဘာ',
 				'kde' => 'မာခွန်ဒီ',
 				'kea' => 'ခဘူဗာဒီအာနူ',
 				'kg' => 'ကွန်ဂို',
 				'kha' => 'ခါစီ',
 				'khq' => 'ခိုရာ ချီအီနီ',
 				'ki' => 'ခီခူယူ',
 				'kk' => 'ခါဇါခ်',
 				'kl' => 'ခလာအ်လီဆပ်',
 				'kln' => 'ခါလိမ်ဂျင်',
 				'km' => 'ခမာ',
 				'kn' => 'ကန္နာဒါ',
 				'ko' => 'ကိုးရီးယား',
 				'koi' => 'ကိုမီ-ပါမြက်',
 				'kok' => 'ကွန်ကနီ',
 				'ks' => 'ကက်ရှ်မီရီ',
 				'ksb' => 'ရှန်ဘာလာ',
 				'ksf' => 'ဘာဖီအာ',
 				'ku' => 'ကဒ်',
 				'kw' => 'ခိုနီရှ်',
 				'ky' => 'ခရူဂစ်',
 				'la' => 'လက်တင်',
 				'lag' => 'လန်ဂီ',
 				'lb' => 'လူဇင်ဘတ်က်',
 				'lg' => 'ဂန်ဒီ',
 				'lkt' => 'လာကိုတာ',
 				'ln' => 'လင်ဂါလာ',
 				'lo' => 'လာအို',
 				'lrc' => 'မြောက်လူရီ',
 				'lt' => 'လစ္သူအာနီယံ',
 				'lu' => 'လူဘာ-ခါတန်ဂါ',
 				'luo' => 'လူအို',
 				'luy' => 'လူရီအာ',
 				'lv' => 'လက္ဘီအံ',
 				'mas' => 'မာဆိုင်',
 				'mer' => 'မီရု',
 				'mfe' => 'မိုရှီစ်ယန်း',
 				'mg' => 'အာလာဂါစီ',
 				'mga' => 'အလယ်ပိုင်း အိုင်းရစ်',
 				'mgh' => 'မာခူဝါ-မီအီတို',
 				'mgo' => 'မီတာ',
 				'mi' => 'မောင်းရီ (နယူးဇီလန်ကျွန်းရှိ ပင်ရင်းတိုင်းရင်းသားလူမျိုး)',
 				'mk' => 'မာစီဒိုနီယံ',
 				'ml' => 'မလေးရာလမ်',
 				'mn' => 'မွန်ဂိုလီးယန်း',
 				'mnc' => 'မန်ချူး',
 				'mni' => 'မနိပူရီ',
 				'moh' => 'မိုဟော့ခ်',
 				'mr' => 'မာရသီ',
 				'ms' => 'မလေး',
 				'mt' => 'မောလ္တီစ်',
 				'mua' => 'မန်ဒန်း',
 				'mul' => 'အကြိမ်များစွာ ဘာသာစကားများ',
 				'my' => 'ဗမာ',
 				'mzn' => 'မာဇန်ဒါရန်နီ',
 				'naq' => 'နာမာ',
 				'nb' => 'ဘွတ်မော်လ်',
 				'nd' => 'တောင်ဒီဘီလီ',
 				'nds' => 'အနိမ့် ဂျာမန်',
 				'ne' => 'နီပါလီ',
 				'nl' => 'ဒတ်ချ်',
 				'nl_BE' => 'ဖလီမစ်ရှ်',
 				'nmg' => 'ဝါဆီအို',
 				'nn' => 'နော်ဝေး နီးနော်စ်ခ်',
 				'no' => 'နော်ဝေး',
 				'nqo' => 'နကို',
 				'nus' => 'နူအာ',
 				'nyn' => 'ယန်ကိုလီ',
 				'om' => 'အိုရိုမို',
 				'or' => 'အိုရီရာ',
 				'pa' => 'ပန်ချာပီ',
 				'peo' => 'ပါရှန် အဟောင်း',
 				'pi' => 'ပါဠိ',
 				'pl' => 'ပိုလန်',
 				'ps' => 'ပါရှ်တို',
 				'pt' => 'ပေါ်တူဂီ',
 				'pt_BR' => 'ဘရာဇီး ပေါ်တူဂီ',
 				'pt_PT' => 'ဥရောပ ပေါ်တူဂီ',
 				'qu' => 'ခက်ချ်ဝါ',
 				'quc' => 'ခီခ်အီချီ',
 				'rm' => 'ရောမ',
 				'rn' => 'ရွန်ဒီ',
 				'ro' => 'ရိုမေနီယား',
 				'rof' => 'ရွမ်ဘို',
 				'root' => 'မူလရင်းမြစ်',
 				'ru' => 'ရုရှ',
 				'rw' => 'ကင်ရာဝန်ဒါ',
 				'rwk' => 'ဝါ',
 				'sa' => 'သင်္သကရိုက်',
 				'saq' => 'ဆန်ဘူရု',
 				'sbp' => 'ဆန်ဂု',
 				'sco' => 'စကော့',
 				'sd' => 'စင်ဒီ',
 				'se' => 'တောင်ဆာမိ',
 				'seh' => 'စီနာ',
 				'ses' => 'ခိုရာဘိုရို ဆမ်နီ',
 				'sg' => 'ဆမ်ဂို',
 				'sga' => 'အိုင်းရစ် ဟောင်း',
 				'shi' => 'တာချယ်လ်ဟစ်',
 				'shn' => 'ရှမ်း',
 				'si' => 'ဆင်ဟာလ',
 				'sk' => 'စလိုဗက်',
 				'sl' => 'စလိုဗေးနီးယမ်း',
 				'sma' => 'တောင်ပိုင်း ဆာမိ',
 				'smj' => 'လူလီ ဆာမိ',
 				'smn' => 'အီနာရီ ဆာမိ',
 				'sms' => 'ခိုလ် ဆာမိ',
 				'sn' => 'ရှိနာ',
 				'so' => 'ဆိုမာလီ',
 				'sq' => 'အယ်လ်ဘေးနီးယန်း',
 				'sr' => 'ဆားဗီးယန်း',
 				'sv' => 'ဆွီဒင်',
 				'sw' => 'ဆြာဟီလီ',
 				'swc' => 'ခွန်ဂို စွာဟီလီ',
 				'ta' => 'တမီးလ်',
 				'te' => 'တီလီဂု',
 				'teo' => 'တီဆို',
 				'tg' => 'တာဂျစ်',
 				'th' => 'ထိုင်း',
 				'ti' => 'တီဂ်ရင်ရာ',
 				'tk' => 'တခ္မင်',
 				'to' => 'တွန်ဂါ',
 				'tr' => 'တာကစ်',
 				'tt' => 'တတာ',
 				'twq' => 'တာဆာဝါခ်',
 				'tzm' => 'အလယ်အက်တ်လက်စ် တာမာဇိုက်',
 				'ug' => 'ဝီဂါ',
 				'uk' => 'ယူကရိန်း',
 				'und' => 'မသိ သို့မဟုတ် မရှိ သော ဘာသာစကား',
 				'ur' => 'အော်ဒူ',
 				'uz' => 'ဦးဇ်ဘက်',
 				'vai' => 'ဗိုင်',
 				'vi' => 'ဗီယက်နမ်',
 				'vun' => 'ဗန်ဂျို',
 				'wbp' => 'ဝေါလ်ပါရီ',
 				'wo' => 'ဝူလိုဖ်',
 				'xh' => 'ဇိုစာ',
 				'xog' => 'ဆိုဂါ',
 				'yo' => 'ရိုရုဘာ',
 				'zgh' => 'မိုရိုကန် တွမ်မဇိုတ် စံ',
 				'zh' => 'တရုတ်',
 				'zh_Hans' => 'ရိုးရှင်းသော တရုတ်',
 				'zh_Hant' => 'ရှေးရိုးစဉ်လာ တရုတ်',
 				'zu' => 'ဇူလူ',
 				'zxx' => 'ဘာသာစကား နှင့် ပတ်သက် သောအရာမရှိ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'အာရေဗျ',
 			'Armn' => 'အာမေးနီးယား',
 			'Beng' => 'ဘင်္ဂါလီ',
 			'Bopo' => 'ဘိုပို',
 			'Brah' => 'ဗြဟ္မမီ',
 			'Brai' => 'ဘရေ',
 			'Cyrl' => 'စစ်ရိလစ်',
 			'Deva' => 'ဒီဗနာဂရီ',
 			'Ethi' => 'အီသီယိုးပီးယား',
 			'Geor' => 'ဂျော်ဂျီယန်',
 			'Grek' => 'ဂရိ',
 			'Gujr' => 'ဂုဂျာရသီ',
 			'Guru' => 'ဂူရူ',
 			'Hang' => 'ဟန်ဂူးလ်',
 			'Hani' => 'ဟန်',
 			'Hans' => 'ရိုးရှင်းသော တရုတ်',
 			'Hans@alt=stand-alone' => 'ရိုးရှင်းသော ဟန်',
 			'Hant' => 'ရှေးရိုးစဉ်လာ တရုတ်',
 			'Hant@alt=stand-alone' => 'ရှေးရိုးစဉ်လာဟန်',
 			'Hebr' => 'ဟီဗရူး',
 			'Hira' => 'ဟိရဂဏ',
 			'Hrkt' => 'ခတခဏ သို့မဟုတ် ဟိရဂဏ',
 			'Java' => 'ဂျာဗားနီးစ်',
 			'Jpan' => 'ဂျပန်',
 			'Kali' => 'ကယားလီ',
 			'Kana' => 'ခတခဏ',
 			'Khmr' => 'ခမာ',
 			'Knda' => 'ခန္နာဒါ',
 			'Kore' => 'ကိုးရီးယား',
 			'Laoo' => 'လာအို',
 			'Latn' => 'လက်တင်',
 			'Mlym' => 'မာလာရာလန်',
 			'Mong' => 'မွန်ဂိုလီးယား',
 			'Mymr' => 'မြန်မာ',
 			'Orya' => 'အိုရာ',
 			'Sinh' => 'ဆင်ဟာလ',
 			'Tale' => 'တိုင်လီ',
 			'Taml' => 'တမီးလ်',
 			'Telu' => 'တီလု',
 			'Tglg' => 'တဂလော့ဂ်',
 			'Thaa' => 'သာအ်',
 			'Thai' => 'ထိုင်း',
 			'Tibt' => 'တိဘက်',
 			'Visp' => 'မြင်နိုင်သော စကား',
 			'Xpeo' => 'ပါရှန် အဟောင်း',
 			'Yiii' => 'ရီ',
 			'Zsym' => 'သင်္ကေတ',
 			'Zxxx' => 'မရေးထားသော',
 			'Zyyy' => 'အများနှင့်သက်ဆိုင်သော',
 			'Zzzz' => 'မသိ သို့မဟုတ် မရှိသော စကားလုံး',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ကမ္ဘာ',
 			'002' => 'အာဖရိက',
 			'003' => 'မြောက် အမေရိက',
 			'005' => 'တောင် အမေရိက',
 			'009' => 'သမုဒ္ဒရာဒေသ',
 			'011' => 'အနောက် အာဖရိက',
 			'013' => 'အလယ်ပိုင်း အမေရိက',
 			'014' => 'အရှေ့ပိုင်း အာဖရိက',
 			'015' => 'မြောက်ပိုင်း အာဖရိက',
 			'017' => 'အလယ်ပိုင်း အာဖရိက',
 			'018' => 'တောင်ပိုင်း အာဖရိက',
 			'019' => 'အမေရိကများ',
 			'021' => 'မြောက်ပိုင်း အမေရိက',
 			'029' => 'ကာရီဘီယံ',
 			'030' => 'အရှေ့ပိုင်း အာရှ',
 			'034' => 'တောင်ပိုင်း အာရှ',
 			'035' => 'အရှေ့တောင်ပိုင်းအာရှ',
 			'039' => 'တောင်ပိုင်း ဥရောပ',
 			'053' => 'ဩစတြေးလျနှင့် နယူးဇီလန်',
 			'054' => 'မီလာနီးရှား',
 			'057' => 'မိုင်ခရိုနီရှားနယ်',
 			'061' => 'ပိုလီနီရှား',
 			'142' => 'အာရှ',
 			'143' => 'အလယ် အာရှ',
 			'145' => 'အနောက် အာရှ',
 			'150' => 'ဥရောပ',
 			'151' => 'အရှေ့ပိုင်း ဥရောပ',
 			'154' => 'မြောက်ပိုင်း ဥရောပ',
 			'155' => 'အနောက်ပိုင်း ဥရောပ',
 			'419' => 'လက်တင်အမေရိက',
 			'AC' => 'အက်စ်စင်ရှီအွန်ကျွန်း',
 			'AD' => 'အန်ဒိုရာ',
 			'AE' => 'ယူအေအီး',
 			'AF' => 'အာဖဂန်နစ္စတန်',
 			'AG' => 'အန်တီဂုအာနှင့်ဘာဘုဒါ',
 			'AI' => 'အန်ဂွီလာ',
 			'AL' => 'အဲလ်ဘာနီအာ',
 			'AM' => 'အာမေနီးယား',
 			'AO' => 'အင်ဂိုလာ',
 			'AQ' => 'အန္တာတိက',
 			'AR' => 'အာဂျင်တီးနား',
 			'AS' => 'အမေရိကန် စမိုအ',
 			'AT' => 'ဩစတြီးယား',
 			'AU' => 'ဩစတြေးလျ',
 			'AW' => 'အာရုဘာ',
 			'AX' => 'အာလန်ကျွန်း',
 			'AZ' => 'အဇာဘိုင်ဂျန်',
 			'BA' => 'ဘော့စနီးယား နှင့် ဟာဇီဂိုဘီးနား',
 			'BB' => 'ဘာဘဒိုးစ်',
 			'BD' => 'ဘင်္ဂလားဒေ့ရှ်',
 			'BE' => 'ဘယ်လ်ဂျီယမ်',
 			'BF' => 'ဘာကီနာ ဖာဆို',
 			'BG' => 'ဘူဂေးရီးယား',
 			'BH' => 'ဘာရိန်း',
 			'BI' => 'BI',
 			'BJ' => 'ဘီနင်',
 			'BL' => 'စိန့်ဘာသီလီမိုင်',
 			'BM' => 'ဘာမူဒါ',
 			'BN' => 'ဘရူနိုင်း',
 			'BO' => 'ဘိုလီးဘီးယား',
 			'BQ' => 'ကာရီဘီယံနယ်သာလန်',
 			'BR' => 'ဘရာဇီး',
 			'BS' => 'ဘဟားမား',
 			'BT' => 'ဘူတန်',
 			'BV' => 'ဘူဗက်ကျွန်း',
 			'BW' => 'BW',
 			'BY' => 'ဘီလာရုစ်',
 			'BZ' => 'ဘေလီဇ်',
 			'CA' => 'ကနေဒါ',
 			'CC' => 'ကိုကိုး ကျွန်းစု',
 			'CD' => 'ကွန်ဂို-ကင်ရှာစ',
 			'CD@alt=variant' => 'ကွန်ဂို (DRC)',
 			'CF' => 'အလယ်ပိုင်း အာဖရိက ပြည်ထောင်စု',
 			'CG' => 'ကွန်ဂို-ဘရာဇာဗီလ်',
 			'CG@alt=variant' => 'ကွန်ဂို (Republic)',
 			'CH' => 'ဆွစ်ဇလန်',
 			'CI' => 'အိုင်ဗရီကိုစ့်',
 			'CI@alt=variant' => 'အိုက်ဗရီကို့စ်',
 			'CK' => 'ကွတ် ကျွန်းစု',
 			'CL' => 'ချီလီ',
 			'CM' => 'ကင်မရွန်း',
 			'CN' => 'တရုတ်',
 			'CO' => 'ကိုလံဘီယာ',
 			'CP' => 'ကလစ်ပါတန်ကျွန်း',
 			'CR' => 'ကော့စ်တာရီကာ',
 			'CU' => 'ကျူးဘား',
 			'CV' => 'ခေ့ပ်ဗာဒူ',
 			'CW' => 'ခူရာကာအို',
 			'CX' => 'ခရစ်စမတ် ကျွန်း',
 			'CY' => 'ဆိုက်ပရက်စ်',
 			'CZ' => 'ချက် ပြည်ထောင်စု',
 			'DE' => 'ဂျာမဏီ',
 			'DG' => 'ဒီအေဂိုဂရာစီအာ',
 			'DJ' => 'ဂျီဘူတီ',
 			'DK' => 'ဒိန်းမတ်',
 			'DM' => 'ဒိုမီနီကာ',
 			'DO' => 'ဒိုမီနီကန်',
 			'DZ' => 'DZ',
 			'EA' => 'ဆယ်ဥတာနှင့်မယ်လီလ်လာ',
 			'EC' => 'အီကွေဒေါ',
 			'EE' => 'အက်စတိုးနီးယား',
 			'EG' => 'EG',
 			'EH' => 'EH',
 			'ER' => 'အီရီတရီအာ',
 			'ES' => 'စပိန်',
 			'ET' => 'အီသီယိုးပီးယား',
 			'EU' => 'ဥရောပသမဂ္ဂ',
 			'FI' => 'ဖင်လန်',
 			'FJ' => 'ဖီဂျီ',
 			'FK' => 'ဖောက်ကလန် ကျွန်းစု',
 			'FK@alt=variant' => 'ဖော့ခ်လန်ကျွန်းစု(အီလားစ် မောလ်ဗီနာစ်)',
 			'FM' => 'မိုင်ခရိုနီရှား',
 			'FO' => 'ဖာရိုး ကျွန်းစုများ',
 			'FR' => 'ပြင်သစ်',
 			'GA' => 'ဂါဘွန်',
 			'GB' => 'ယူနိုက်တက်ကင်းဒမ်း',
 			'GB@alt=short' => 'ယူကေ',
 			'GD' => 'ဂရီနာဒါ',
 			'GE' => 'ဂျော်ဂျီယာ',
 			'GF' => 'ပြင်သစ် ဂီယာနာ',
 			'GG' => 'ဂွန်းဇီ',
 			'GH' => 'ဂါနာ',
 			'GI' => 'ဂျီဘရော်လ်တာ',
 			'GL' => 'ဂရင်းလန်း',
 			'GM' => 'ဂန်ဘီရာ',
 			'GN' => 'ဂီးနီ',
 			'GP' => 'ဂူအာဒီလုပ်',
 			'GQ' => 'အီကွေတာ ဂီရာနာ',
 			'GR' => 'ဂရိ',
 			'GS' => 'တောင် ဂျော်ဂျီယာ နှင့် တောင် ဆင်းဒဝစ်ဂျ် ကျွန်းစုများ',
 			'GT' => 'ဂွာတီမာလာ',
 			'GU' => 'ဂူအမ်',
 			'GW' => 'ဂီရာနာ-ဘီစ်စာဥ',
 			'GY' => 'ဂူရာနာ',
 			'HK' => 'တရုတ်၏ အထူးအုပ်ချုပ်ခွင့်ရ ဟောင်ကောင်',
 			'HK@alt=short' => 'ဟောင်ကောင်',
 			'HM' => 'ဟတ်ကျွန်းနှင့်မက်ဒေါနယ်ကျွန်းစု',
 			'HN' => 'ဟွန်ဒူးရပ်စ်',
 			'HR' => 'ခရိုအေးရှား',
 			'HT' => 'ဟေတီ',
 			'HU' => 'ဟန်ဂေရီ',
 			'IC' => 'ကာနာရီကျွန်းစု',
 			'ID' => 'အင်ဒိုနီးရှား',
 			'IE' => 'အိုင်ယာလန်',
 			'IL' => 'အစ္စရေး',
 			'IM' => 'မန်ကျွန်း',
 			'IN' => 'အိန္ဒိယ',
 			'IO' => 'ဗြိတိသျှ အိန္ဒြိယ သမုဒ္ဒရာ ပိုင်နက်',
 			'IQ' => 'အီရတ်',
 			'IR' => 'အီရန်',
 			'IS' => 'အိုက်စလန်',
 			'IT' => 'အီတလီ',
 			'JE' => 'ဂျာစီ',
 			'JM' => 'ဂျမေကာ',
 			'JO' => 'ဂျော်ဒန်',
 			'JP' => 'ဂျပန်',
 			'KE' => 'KE',
 			'KG' => 'ခရူဂစ်စတန်',
 			'KH' => 'ကမ္ဘောဒီးယား',
 			'KI' => 'ခီရီဘာတီ',
 			'KM' => 'ကိုမိုရိုစ်',
 			'KN' => 'စိန့်ကစ်နှင့်နီဗီစ်',
 			'KP' => 'မြောက်ကိုရီးယား',
 			'KR' => 'တောင်ကိုရီးယား',
 			'KW' => 'ကူဝိတ်',
 			'KY' => 'ကေမန် ကျွန်းစု',
 			'KZ' => 'ကာဇက်စတန်',
 			'LA' => 'လာအို',
 			'LB' => 'လက်ဘနွန်',
 			'LC' => 'စိန့်လူစီအာ',
 			'LI' => 'လစ်ခ်ထင်စတိုင်',
 			'LK' => 'သီရိလင်္ကာ',
 			'LR' => 'လိုင်ဘေးရီးယား',
 			'LS' => 'လီဆိုသို',
 			'LT' => 'လစ်သူယေးနီးယား',
 			'LU' => 'လူဇင်ဘတ်',
 			'LV' => 'လတ်ဗီးယား',
 			'LY' => 'LY',
 			'MA' => 'MA',
 			'MC' => 'မိုနာကို',
 			'MD' => 'မောလ်ဒိုဗာ',
 			'ME' => 'မွန်တီနိဂရိုး',
 			'MF' => 'စိန့်မာတင်',
 			'MG' => 'မာဒါဂတ်စကာ',
 			'MH' => 'မာရှယ် ကျွန်းစု',
 			'MK' => 'မာစီဒိုးနီးယား',
 			'MK@alt=variant' => 'မာစီဒိုနီအာ',
 			'ML' => 'မာလီ',
 			'MM' => 'မြန်မာ',
 			'MN' => 'မွန်ဂိုးလီးယား',
 			'MO' => 'တရုတ်၏ အထူးအုပ်ချုပ်ခွင့်ရ မကာအို',
 			'MO@alt=short' => 'မကာအို',
 			'MP' => 'တောင်ပိုင်းမာရီအာနာကျွန်းစု',
 			'MQ' => 'မာတီနီကီ',
 			'MR' => 'မောရီတာနီအာ',
 			'MS' => 'မောင့်စဲရက်',
 			'MT' => 'မောလ်တာ',
 			'MU' => 'မော်ရေရှားစ်',
 			'MV' => 'မော်လ်ဒိုက်',
 			'MW' => 'မာလာဝီ',
 			'MX' => 'မက္ကဆီကို',
 			'MY' => 'မလေးရှား',
 			'MZ' => 'မိုဇန်ဘစ်',
 			'NA' => 'နမ်မီးဘီးယား',
 			'NC' => 'နယူး ကယ်လီဒိုနီးယား',
 			'NE' => 'နိုင်ဂျာ',
 			'NF' => 'နောဖော့ခ်ကျွန်း',
 			'NG' => 'နိုင်ဂျီးရီးယား',
 			'NI' => 'နီကာရာဂွာ',
 			'NL' => 'နယ်သာလန်',
 			'NO' => 'နော်ဝေ',
 			'NP' => 'နီပေါ',
 			'NR' => 'နာဥူရူ',
 			'NU' => 'နီဥူအေ',
 			'NZ' => 'နယူးဇီလန်',
 			'OM' => 'အိုမန်',
 			'PA' => 'ပနားမား',
 			'PE' => 'ပီရူး',
 			'PF' => 'ပြင်သစ် ပေါ်လီနေးရှား',
 			'PG' => 'ပါပူရာနယူးဂီနီ',
 			'PH' => 'ဖိလစ်ပိုင်',
 			'PK' => 'ပါကစ္စတန်',
 			'PL' => 'ပိုလန်',
 			'PM' => 'စိန့်ပီအဲရီနှင့်မီကွီလွန်',
 			'PN' => 'ပစ်တ်ကိန်းကျွန်းစု',
 			'PR' => 'ပေါ်တူရီကို',
 			'PS' => 'ပါလက်စတိုင်း ပိုင်နက်',
 			'PS@alt=short' => 'ပါလက်စတိုင်း',
 			'PT' => 'ပေါ်တူဂီ',
 			'PW' => 'ပလောင်',
 			'PY' => 'ပါရာဂွေး',
 			'QA' => 'ကာတာ',
 			'QO' => 'သမုဒ္ဒရာဒေသအပြင်ထွက်နေသောဒေသများ',
 			'RE' => 'ရဲအူနီရွန်',
 			'RO' => 'ရိုမေးနီးယား',
 			'RS' => 'ဆားဘီးယား',
 			'RU' => 'ရုရှ',
 			'RW' => 'RW',
 			'SA' => 'ဆော်ဒီအာရေးဗီးယား',
 			'SB' => 'ဆော်လမွန်ကျွန်းစု',
 			'SC' => 'ဆေးရှလ်',
 			'SD' => 'SD',
 			'SE' => 'ဆွီဒင်',
 			'SG' => 'စင်္ကာပူ',
 			'SH' => 'စိန့်ဟဲလီနာ',
 			'SI' => 'စလိုဗေးနီးယား',
 			'SJ' => 'စဗိုလ်ဘတ်နှင့်ဂျန်မေရန်',
 			'SK' => 'စလိုဗေးကီးယား',
 			'SL' => 'ဆီအဲရာ လီအိုနီ',
 			'SM' => 'ဆော့န်မာရီနို',
 			'SN' => 'ဆီနီဂေါ',
 			'SO' => 'ဆိုမာလီယာ',
 			'SR' => 'ဆူရီနိမ်း',
 			'SS' => 'မြောက်ဆူဒန်',
 			'ST' => 'စိန့်တိုမီနှင့်ပရင်စီပ့်',
 			'SV' => 'အယ်လ်ဆာဗေးဒိုး',
 			'SX' => 'ဆင့်မာအာတင်',
 			'SY' => 'ဆီးရီးယား',
 			'SZ' => 'SZ',
 			'TA' => 'ထရစ်တန်ဒါကွန်ဟာ',
 			'TC' => 'တခ်စ်နှင့်ကာအီကိုစ်ကျွန်းစု',
 			'TD' => 'ချဒ်',
 			'TF' => 'ပြင်သစ် တောင်ပိုင်း ပိုင်နက်များ',
 			'TG' => 'တိုဂို',
 			'TH' => 'ထိုင်း',
 			'TJ' => 'တာဂျီကစ္စတန်',
 			'TK' => 'ထိုးခါလူ',
 			'TL' => 'အရှေ့တီမော',
 			'TM' => 'တာခ်မီန့စ်တန်',
 			'TN' => 'တူနီးရှား',
 			'TO' => 'တွန်ဂါ',
 			'TR' => 'တူရကီ',
 			'TT' => 'ထရိုင်နီဒတ်နှင့်တိုဘာဂို',
 			'TV' => 'ထူးဗလူ',
 			'TW' => 'ထိုင်ဝမ်',
 			'TZ' => 'တန်ဇန်းနီးယား',
 			'UA' => 'ယူကရိန်း',
 			'UG' => 'UG',
 			'UM' => 'ယူနိုက်တက်စတိတ် အပြင်ထွက် နေသည့် သေးငယ်သောကျွန်းများ',
 			'US' => 'ယူနိုက်တက်စတိတ်',
 			'US@alt=short' => 'ယူအက်စ်',
 			'UY' => 'ဥရုဂွေး',
 			'UZ' => 'ဥဘက်ကစ္စတန်',
 			'VA' => 'ဗာတီကန်စီတီး',
 			'VC' => 'စိန့်ဗင့်ဆင့်နှင့် သည်ဂရဲနာဒင်းစ်',
 			'VE' => 'ဗင်နီဇွဲလား',
 			'VG' => 'ဗြိတိသျှ ဗာဂျင်း ကျွန်းစု',
 			'VI' => 'ယူအက်စ် ဗာဂျင်း ကျွန်းစု',
 			'VN' => 'ဗီယက်နမ်',
 			'VU' => 'ဗာနုအာတူ',
 			'WF' => 'ဝေါလစ်နှင့်ဖူထူးနား',
 			'WS' => 'ဆာမိုအာ',
 			'XK' => 'ကိုဆိုဗို',
 			'YE' => 'ယီမင်',
 			'YT' => 'မေအိုတီ',
 			'ZA' => 'တောင်အာဖရိက',
 			'ZM' => 'ဇမ်ဘီယာ',
 			'ZW' => 'ဇင်ဘာဘွေ',
 			'ZZ' => 'မသိ သို့မဟုတ် မရှိ သော နေရာ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'ရှေးရိုးစဉ်လာ ဂျာမန် ရေးထုံး',
 			'1996' => '၁၉၉၆ ဂျာမန် ရေးထုံး',
 			'1606NICT' => 'အလယ်ပိုင်းနောက်ကျသောပြင်သစ်မှ ၁၆၀၆',
 			'1694ACAD' => '၁၆၉၄ACAD',
 			'AREVELA' => 'အရှေ့ပိုင်းအာမေးနီးယန်း',
 			'BAKU1926' => 'ပေါင်းစပ်ထားသော တူရကီ လက်တင်စကားလုံး',
 			'FONIPA' => 'IPA အသံထွက်',
 			'FONUPA' => 'UPA အသံထွက်',
 			'POSIX' => 'ကွန်ပျူတာ',
 			'REVISED' => 'ပြန်လည်စီစစ်ထားသော ရေးထုံး',
 			'SCOTLAND' => 'စကော့ စံ အင်္ဂလိပ်',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ပြက္ခဒိန်',
 			'collation' => 'စနစ်တကျစီသော',
 			'currency' => 'ငွေကြေး',
 			'hc' => 'နာရီစက်ဝန်း(၁၂ အပြိုင် ၂၄)',
 			'lb' => 'လိုင်းဖြတ်တောက်မှုပုံစံ',
 			'ms' => 'တိုင်းတာရေးစနစ်',
 			'numbers' => 'ဂဏန်းနံပါတ်',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ဗုဒ္ဓ ပြက္ခဒိန်},
 				'chinese' => q{တရုတ် ပြက္ခဒိန်},
 				'dangi' => q{ဒန်းဂိ ပြက္ခဒိန်},
 				'ethiopic' => q{အီသီယိုးပီးယား ပြက္ခဒိန်},
 				'gregorian' => q{နိုင်ငံတကာသုံး ပြက္ခဒိန်},
 				'hebrew' => q{ဟီဗရူး ပြက္ခဒိန်},
 				'indian' => q{အိန္ဒြိယ အမျိုးသား ပြက္ခဒိန်},
 				'islamic' => q{အစ္စလာမ် ပြက္ခဒိန်},
 				'iso8601' => q{ISO-8601 ပြက္ခဒိန်},
 				'japanese' => q{ဂျပန် ပြက္ခဒိန်},
 				'persian' => q{ပါရှား ပြက္ခဒိန်},
 				'roc' => q{မင်ဂုအို ပြက္ခဒိန်},
 			},
 			'collation' => {
 				'ducet' => q{ယူနီကုတ်အစဉ်လိုက်စီထားသော},
 				'phonebook' => q{ဖုန်းစာအုပ် အစီအစဉ်},
 				'search' => q{ယေဘုယျရှာခြင်း},
 				'standard' => q{ပုံမှန်စီသော},
 			},
 			'hc' => {
 				'h11' => q{၁၂ နာရီ စနစ် (၀–၁၁)},
 				'h12' => q{၁၂ နာရီစနစ် (၁–၁၂)},
 				'h23' => q{၂၄ နာရီ စနစ် (၀–၂၃)},
 				'h24' => q{၂၄ နာရီ စနစ်(၁–၂၄)},
 			},
 			'lb' => {
 				'loose' => q{လျော့ရဲသော လိုင်းဖြတ်တောင်မှုပုံစံ},
 				'normal' => q{ပုံမှန်လိုင်းဖြတ်တောက်မှုပုံစံ},
 				'strict' => q{တင်းကြပ်သောလိုင်းဖြတ်တောက်မှုပုံစံ},
 			},
 			'ms' => {
 				'metric' => q{မက်ထရစ်စနစ်},
 				'uksystem' => q{ဗြိတိသျှတိုင်းတာစနစ်},
 				'ussystem' => q{အမေရိကန်တိုင်းတာစနစ်},
 			},
 			'numbers' => {
 				'arab' => q{အာရပ်ဂဏန်းခြေ},
 				'arabext' => q{တိုးချဲ့အာရပ်ဂဏန်းခြေ},
 				'armn' => q{အာမေနီယန်ဂဏန်းခြေ},
 				'armnlow' => q{အာမေနီယန်ဂဏန်းခြေအသေး},
 				'beng' => q{ဘန်ဂါလီဂဏန်းခြေ},
 				'deva' => q{ဒီပါနာဂါရီဂဏန်းခြေ},
 				'ethi' => q{အီသီအိုပီးယားဂဏန်းခြေ},
 				'fullwide' => q{အနံအပြည့်နှင့်ဂဏန်းခြေ},
 				'geor' => q{နိုင်ငံတကာသုံးဂဏန်းခြေ},
 				'grek' => q{ဂရိဂဏန်းခြေ},
 				'greklow' => q{ဂရိဂဏန်းခြေအသေး},
 				'gujr' => q{ဂုဂျာရာတီဂဏန်းခြေ},
 				'guru' => q{ဂူမူခီဂဏန်းခြေ},
 				'hanidec' => q{တရုတ်ဆယ်လီစနစ်ဂဏန်းခြေ},
 				'hans' => q{ရိုးရှင်းသောတရုတ်ဂဏန်းခြေ},
 				'hansfin' => q{ရိုးရှင်းသောတရုတ်ဘဏ္ဏာရေးသုံးဂဏန်းခြေ},
 				'hant' => q{ရိုးရာတရုတ်ဂဏန်းခြေ},
 				'hantfin' => q{ရိုးရာတရုတ်ဘဏ္ဏာရေးသုံးဂဏန်းခြေ},
 				'hebr' => q{ဟေဗြဲဂဏန်းခြေ},
 				'jpan' => q{ဂျပန်ဂဏန်းခြေ},
 				'jpanfin' => q{ဂျပန်ဘဏ္ဏာရေးသုံးဂဏန်းခြေ},
 				'khmr' => q{ခမာဂဏန်းခြေ},
 				'knda' => q{ခန္နဒါဂဏန်းခြေ},
 				'laoo' => q{လာအိုဂဏန်းခြေ},
 				'latn' => q{အနောက်တိုင်းဂဏန်းခြေ},
 				'mlym' => q{မလာရာလမ်ဂဏန်းခြေ},
 				'mymr' => q{မြန်မာဂဏန်းခြေ},
 				'mymrshan' => q{ရှမ်းဂဏန်းခြေ},
 				'orya' => q{ဩရီရာဂဏန်းခြေ},
 				'roman' => q{ရောမဂဏန်းခြေ},
 				'romanlow' => q{ရောမဂဏန်းခြေအသေး},
 				'taml' => q{ရိုးရာတမီးလ်ဂဏန်းခြေ},
 				'tamldec' => q{တမီးလ်ဂဏန်းခြေ},
 				'telu' => q{တီရီဂုဂဏန်းခြေ},
 				'thai' => q{ထိုင်းဂဏန်းခြေ},
 				'tibt' => q{တိဘက်ဂဏန်းခြေ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{မက်ထရစ်စနစ်},
 			'UK' => q{ဗြိတိန်စနစ်},
 			'US' => q{အမေရိကန်စနစ်},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ဘာသာစကား - {0}',
 			'script' => 'စာ - {0}',
 			'region' => 'နယ်ပယ်ဒေသ - {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[ၐ ၑ ဨ ဢ ၒ ၓ ၔ ၕ ၖ ၗ ၘ ၙ])},
			index => ['က', 'ခ', 'ဂ', 'ဃ', 'င', 'စ', 'ဆ', 'ဇ', 'ဈ', 'ဉ', 'ည', 'ဋ', 'ဌ', 'ဍ', 'ဎ', 'ဏ', 'တ', 'ထ', 'ဒ', 'ဓ', 'န', 'ပ', 'ဖ', 'ဗ', 'ဘ', 'မ', 'ယ', 'ရ', 'လ', 'ဝ', 'သ', 'ဟ', 'ဠ', 'အ'],
			main => qr{(?^u:[က ခ ဂ ဃ င စ ဆ ဇ ဈ ဉ ည ဋ ဌ ဍ ဎ ဏ တ ထ ဒ ဓ န ပ ဖ ဗ ဘ မ ယ ရ လ ဝ သ ဟ ဠ အ ဣ ဤ ဥ ဦ ဧ ဩ ဪ ာ ါ ိ ီ ု ူ ေ ဲ ံ ဿ ျ ြ ွ ှ ္ ် ့ း])},
			punctuation => qr{(?^u:[၊ ။ ‘ ’ “ ”])},
		};
	},
EOT
: sub {
		return { index => ['က', 'ခ', 'ဂ', 'ဃ', 'င', 'စ', 'ဆ', 'ဇ', 'ဈ', 'ဉ', 'ည', 'ဋ', 'ဌ', 'ဍ', 'ဎ', 'ဏ', 'တ', 'ထ', 'ဒ', 'ဓ', 'န', 'ပ', 'ဖ', 'ဗ', 'ဘ', 'မ', 'ယ', 'ရ', 'လ', 'ဝ', 'သ', 'ဟ', 'ဠ', 'အ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(ဧက),
						'other' => q({0}ဧက),
					},
					'acre-foot' => {
						'name' => q(ဧက-ပေ),
						'other' => q({0} ဧက-ပေ),
					},
					'ampere' => {
						'name' => q(အမ်ပီယာ),
						'other' => q({0}အမ်ပီယာ),
					},
					'arc-minute' => {
						'name' => q(မိနစ်),
						'other' => q({0}မိနစ်),
					},
					'arc-second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0}စက္ကန့်),
					},
					'astronomical-unit' => {
						'name' => q(နက္ခတ္တဗေဒယူနစ်),
						'other' => q({0} နက္ခတ္တဗေဒယူနစ်),
					},
					'bit' => {
						'name' => q(ဘစ်),
						'other' => q({0}ဘစ်),
					},
					'byte' => {
						'name' => q(ဘိုက်),
						'other' => q({0}ဘိုက်),
					},
					'calorie' => {
						'name' => q(ကယ်လိုရီ),
						'other' => q({0} ကယ်လိုရီ),
					},
					'carat' => {
						'name' => q(ကရက်),
						'other' => q({0} ကရက်),
					},
					'celsius' => {
						'name' => q(စင်တီဂရိတ်),
						'other' => q({0}စင်တီဂရိတ်),
					},
					'centiliter' => {
						'name' => q(စင်တီလီတာ),
						'other' => q({0}စင်တီလီတာ),
					},
					'centimeter' => {
						'name' => q(စင်တီမီတာ),
						'other' => q({0} စင်တီမီတာ),
						'per' => q({0} တစ်စင်တီမီတာလျှင်),
					},
					'century' => {
						'name' => q(c),
						'other' => q({0} c),
					},
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					'cubic-centimeter' => {
						'name' => q(ကုဗစင်တီမီတာ),
						'other' => q({0}ကုဗစင်တီမီတာ),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'name' => q(ကုဗပေ),
						'other' => q({0} ကုဗပေ),
					},
					'cubic-inch' => {
						'name' => q(ကုဗလက်မ),
						'other' => q({0}ကုဗလက်မ),
					},
					'cubic-kilometer' => {
						'name' => q(ကုဗကီလိုမီတာ),
						'other' => q({0} ကုဗကီလိုမီတာ),
					},
					'cubic-meter' => {
						'name' => q(ကုဗမီတာ),
						'other' => q({0}ကုဗမီတာ),
						'per' => q(တစ်ကုဗစင်တီမီတာလျှင်),
					},
					'cubic-mile' => {
						'name' => q(ကုဗမိုင်),
						'other' => q({0}ကုဗမိုင်),
					},
					'cubic-yard' => {
						'name' => q(ကုဗကိုက်),
						'other' => q({0}ကုဗကိုက်),
					},
					'cup' => {
						'name' => q(ခွက်),
						'other' => q({0} ခွက်),
					},
					'cup-metric' => {
						'name' => q(မထ္ထရစ်ကပ်),
						'other' => q({0}မထ္ထရစ်ကပ်စ်),
					},
					'day' => {
						'name' => q(ရက်),
						'other' => q({0}ရက်),
						'per' => q({0}တစ်နေ့လျှင်),
					},
					'deciliter' => {
						'name' => q(ဒါစီလီတာ),
						'other' => q({0} ဒါစီလီတာ),
					},
					'decimeter' => {
						'name' => q(ဒါစီမီတာ),
						'other' => q({0} ဒါစီမီတာ),
					},
					'degree' => {
						'name' => q(ဒီဂရီ),
						'other' => q({0}ဒီဂရီ),
					},
					'fahrenheit' => {
						'name' => q(ဖာရင်ဟိုက်),
						'other' => q({0}ဖာရင်ဟိုက်),
					},
					'fluid-ounce' => {
						'name' => q(အရည်အောင်စ),
						'other' => q({0}အရည်အောင်စ),
					},
					'foodcalorie' => {
						'name' => q(ကယ်လိုရီ),
						'other' => q({0} ကယ်လိုရီ),
					},
					'foot' => {
						'name' => q(ပေ),
						'other' => q({0} ပေ),
						'per' => q({0}/ft),
					},
					'g-force' => {
						'name' => q(ဆွဲငင်အား),
						'other' => q({0} ဆွဲငင်အား),
					},
					'gallon' => {
						'name' => q(ဂါလန်),
						'other' => q({0}ဂါလန်),
						'per' => q({0}တစ်ဂါလံလျှင်),
					},
					'generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ဂီဂါဘစ်),
						'other' => q({0}ဂီဂါဘစ်),
					},
					'gigabyte' => {
						'name' => q(ဂီဂါဘိုက်),
						'other' => q({0}ဂီဂါဘိုက်),
					},
					'gigahertz' => {
						'name' => q(ဂီဂါဟတ်ဇ်),
						'other' => q({0}ဂီဂါဟတ်ဇ်),
					},
					'gigawatt' => {
						'name' => q(ဂီဂါဝပ်),
						'other' => q({0} ဂီဂါဝပ်),
					},
					'gram' => {
						'name' => q(ဂရမ်),
						'other' => q({0} ဂရမ်),
						'per' => q({0}/g),
					},
					'hectare' => {
						'name' => q(ဟက်တာ),
						'other' => q({0} ဟက်တာ),
					},
					'hectoliter' => {
						'name' => q(ဟက်တိုလီတာ),
						'other' => q({0}ဟက်တိုလီတာ),
					},
					'hectopascal' => {
						'name' => q(ဟက်တိုပါစကယ်),
						'other' => q({0}ဟက်တိုပါစကယ်),
					},
					'hertz' => {
						'name' => q(ဟတ်ဇ်),
						'other' => q({0}ဟတ်ဇ်),
					},
					'horsepower' => {
						'name' => q(မြင်းကောင်ရေအား),
						'other' => q({0} မြင်းကောင်ရေအား),
					},
					'hour' => {
						'name' => q(နာရီ),
						'other' => q({0}နာရီ),
						'per' => q(တစ်နာရီ {0}နှုန်း),
					},
					'inch' => {
						'name' => q(လက်မ),
						'other' => q({0} လက်မ),
						'per' => q({0}တစ်လက်မလျှင်),
					},
					'inch-hg' => {
						'name' => q(ပြဒါးလက်မ),
						'other' => q(ပြဒါး{0}လက်မ),
					},
					'joule' => {
						'name' => q(ဂျူးလ်),
						'other' => q({0} ဂျူးလ်),
					},
					'karat' => {
						'name' => q(ကရက်),
						'other' => q({0} ကရက်),
					},
					'kelvin' => {
						'name' => q(ကယ်လ်ဗင်),
						'other' => q({0}ကယ်လ်ဗင်),
					},
					'kilobit' => {
						'name' => q(ကီလိုဘစ်),
						'other' => q({0}ကီလိုဘစ်),
					},
					'kilobyte' => {
						'name' => q(ကီလိုဘိုက်),
						'other' => q({0}ကီလိုဘိုက်),
					},
					'kilocalorie' => {
						'name' => q(ကီလိုကယ်လိုရီ),
						'other' => q({0} ကီလိုကယ်လိုရီ),
					},
					'kilogram' => {
						'name' => q(ကီလိုဂရမ်),
						'other' => q({0}ကီလိုဂရမ်),
						'per' => q({0}/kg),
					},
					'kilohertz' => {
						'name' => q(ကီလိုဟတ်ဇ်),
						'other' => q({0}ကီလိုဟတ်ဇ်),
					},
					'kilojoule' => {
						'name' => q(ကီလိုဂျူးလ်),
						'other' => q({0} ကီလိုဂျူးလ်),
					},
					'kilometer' => {
						'name' => q(ကီလိုမီတာ),
						'other' => q({0} ကီလိုမီတာ),
						'per' => q({0}/km),
					},
					'kilometer-per-hour' => {
						'name' => q(ကီလိုမီတာ/နာရီ),
						'other' => q(တစ်နာရီလျှင်{0}ကီလိုမီတာနှုန်း),
					},
					'kilowatt' => {
						'name' => q(ကီလိုဝပ်),
						'other' => q({0}ကီလိုဝပ်),
					},
					'kilowatt-hour' => {
						'name' => q(ကီလိုဝပ်-နာရီ),
						'other' => q({0}ကီလိုဝပ်-နာရီ),
					},
					'knot' => {
						'name' => q(ရေမိုင်နော့),
						'other' => q({0}ရေမိုင်နော့များ),
					},
					'light-year' => {
						'name' => q(အလင်းနှစ်),
						'other' => q({0} အလင်းနှစ်),
					},
					'liter' => {
						'name' => q(လီတာ),
						'other' => q({0}လီတာ),
						'per' => q({0} တစ်လီတာလျှင်),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'name' => q(လီတာ/ကီလိုမီတာ),
						'other' => q(၁ကီလိုမီတာ {0}လီတာနှုန်း),
					},
					'lux' => {
						'name' => q(လတ်ခ်),
						'other' => q({0} လတ်ခ်),
					},
					'megabit' => {
						'name' => q(မီဂါဘစ်),
						'other' => q({0}မီဂါဘစ်),
					},
					'megabyte' => {
						'name' => q(မီဂါဘိုက်),
						'other' => q({0}မီဂါဘိုက်),
					},
					'megahertz' => {
						'name' => q(မက်ဂါဟတ်ဇ်),
						'other' => q({0}မက်ဂါဟတ်ဇ်),
					},
					'megaliter' => {
						'name' => q(မက်ဂါလီတာ),
						'other' => q({0}မက်ဂါလီတာ),
					},
					'megawatt' => {
						'name' => q(မီဂါဝပ်),
						'other' => q({0} မီဂါဝပ်),
					},
					'meter' => {
						'name' => q(မီတာ),
						'other' => q({0}မီတာ),
						'per' => q({0}တစ်မီတာလျှင်),
					},
					'meter-per-second' => {
						'name' => q(မီတာ/စက္ကန့်),
						'other' => q(တစ်စက္ကန့်လျှင်{0}မီတာနှုန်း),
					},
					'meter-per-second-squared' => {
						'name' => q(မီတာ/စက္ကန့်နှစ်ထပ်ကိန်း),
						'other' => q({0} မီတာ/စက္ကန့်နှစ်ထပ်ကိန်း),
					},
					'metric-ton' => {
						'name' => q(မက်ထရစ်တန်),
						'other' => q({0} မက်ထရစ်တန်),
					},
					'microgram' => {
						'name' => q(မိုက်ကရိုဂရမ်),
						'other' => q({0}မိုက်ကရိုဂရမ်),
					},
					'micrometer' => {
						'name' => q(မိုက်ခရိုမီတာ),
						'other' => q({0} မိုက်ခရိုမီတာ),
					},
					'microsecond' => {
						'name' => q(မိုက်ခရိုစက္ကန့်),
						'other' => q({0}မိုက်ခရိုစက္ကန့်),
					},
					'mile' => {
						'name' => q(မိုင်),
						'other' => q({0} မိုင်),
					},
					'mile-per-gallon' => {
						'name' => q(မိုင်/ဂါလန်),
						'other' => q(၁ ဂါလန် {0} မိုင်နှုန်း),
					},
					'mile-per-hour' => {
						'name' => q(မိုင်/နာရီ),
						'other' => q(တစ်နာရီလျှင်{0}မိုင်နှုန်း),
					},
					'mile-scandinavian' => {
						'name' => q(စကန်ဒီနေးဗီးရန်း မိုင်),
						'other' => q({0}စကန်ဒီနေးဗီးရန်း မိုင်များ),
					},
					'milliampere' => {
						'name' => q(မီလီအမ်ပီယာ),
						'other' => q({0}မီလီအမ်ပီယာ),
					},
					'millibar' => {
						'name' => q(မီလီဘား),
						'other' => q({0}မီလီဘား),
					},
					'milligram' => {
						'name' => q(မီလီဂရမ်),
						'other' => q({0} မီလီဂရမ်),
					},
					'milliliter' => {
						'name' => q(မီလီလီတာ),
						'other' => q({0}မီလီလီတာ),
					},
					'millimeter' => {
						'name' => q(မီလီမီတာ),
						'other' => q({0} မီလီမီတာ),
					},
					'millimeter-of-mercury' => {
						'name' => q(ပြဒါးမီလီမီတာ),
						'other' => q(ပြဒါး{0}မီလီမီတာ),
					},
					'millisecond' => {
						'name' => q(မီလီစက္ကန့်),
						'other' => q({0}မီလီစက္ကန့်),
					},
					'milliwatt' => {
						'name' => q(မီလီဝပ်),
						'other' => q({0} မီလီဝပ်),
					},
					'minute' => {
						'name' => q(မိနစ်),
						'other' => q({0} မိနစ်),
						'per' => q({0}မိနစ်လျှင်),
					},
					'month' => {
						'name' => q(လ),
						'other' => q({0}လ),
						'per' => q({0}တစ်လလျှင်),
					},
					'nanometer' => {
						'name' => q(နာနိုမီတာ),
						'other' => q({0} နာနိုမီတာ),
					},
					'nanosecond' => {
						'name' => q(နာနိုစက္ကန့်),
						'other' => q({0} နာနိုစက္ကန့်),
					},
					'nautical-mile' => {
						'name' => q(ရေမိုင်),
						'other' => q({0} ရေမိုင်),
					},
					'ohm' => {
						'name' => q(အုမ်း),
						'other' => q({0}အုမ်း),
					},
					'ounce' => {
						'name' => q(အောင်စ),
						'other' => q({0}အောင်စ),
						'per' => q({0}/oz),
					},
					'ounce-troy' => {
						'name' => q(ထရိုအောင်စ),
						'other' => q({0} ထရိုအောင်စ),
					},
					'parsec' => {
						'name' => q(ပါစက်ခ်),
						'other' => q({0} ပါစက်ခ်),
					},
					'per' => {
						'1' => q({0}လျှင်{1}နှုန်း),
					},
					'picometer' => {
						'name' => q(ပီကိုမီတာ),
						'other' => q({0} ပီကိုမီတာ),
					},
					'pint' => {
						'name' => q(ပိုင့်),
						'other' => q({0}ပိုင့်),
					},
					'pint-metric' => {
						'name' => q(မထ္ထရစ်ပို့င်),
						'other' => q({0} mpt),
					},
					'pound' => {
						'name' => q(ပေါင်),
						'other' => q({0}ပေါင်),
						'per' => q(တစ်ပေါင်လျှင်),
					},
					'pound-per-square-inch' => {
						'name' => q(ပေါင်/စတုရန်းလက်မ),
						'other' => q(၁စတုရန်းလက်မ {0}ပေါင်နှုန်း),
					},
					'quart' => {
						'name' => q(ကွတ်),
						'other' => q({0}ကွတ်),
					},
					'radian' => {
						'name' => q(ရေဒီအန်းစ်),
						'other' => q({0}ရေဒီအန်းစ်),
					},
					'revolution' => {
						'name' => q(rev),
						'other' => q({0} rev),
					},
					'second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0} စက္ကန့်),
						'per' => q(တစ်စက္ကန့် {0}နှုန်း),
					},
					'square-centimeter' => {
						'name' => q(စတုရန်းစင်တီမီတာ),
						'other' => q({0}စတုရန်းစင်တီမီတာ),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'name' => q(စတုရန်းပေ),
						'other' => q({0}စတုရန်းပေ),
					},
					'square-inch' => {
						'name' => q(စတုရန်းလက်မ),
						'other' => q({0}စတုရန်းလက်မ),
						'per' => q({0}တစ်စတုရန်းလက်မလျှင်),
					},
					'square-kilometer' => {
						'name' => q(စတုရန်းကီလိုမီတာ),
						'other' => q({0}စတုရန်းကီလိုမီတာ),
					},
					'square-meter' => {
						'name' => q(စတုရန်းမီတာ),
						'other' => q({0}စတုရန်းမီတာ),
					},
					'square-mile' => {
						'name' => q(စတုရန်းမိုင်),
						'other' => q({0}စတုရန်းမိုင်),
					},
					'square-yard' => {
						'name' => q(စတုရန်းကိုက်),
						'other' => q({0}စတုရန်းကိုက်),
					},
					'tablespoon' => {
						'name' => q(စားပွဲဇွန်း),
						'other' => q(စားပွဲဇွန်း{0}ဇွန်း),
					},
					'teaspoon' => {
						'name' => q(လက်ဖက်ရည်ဇွန်း),
						'other' => q(လက်ဖက်ရည်ဇွန်း{0}ဇွန်း),
					},
					'terabit' => {
						'name' => q(တီရာဘစ်),
						'other' => q({0}တီရာဘစ်),
					},
					'terabyte' => {
						'name' => q(တီရာဘိုက်),
						'other' => q({0}တီရာဘိုက်),
					},
					'ton' => {
						'name' => q(တန်),
						'other' => q({0}တန်),
					},
					'volt' => {
						'name' => q(ဗို့),
						'other' => q({0}ဗို့),
					},
					'watt' => {
						'name' => q(ဝပ်),
						'other' => q({0}ဝပ်),
					},
					'week' => {
						'name' => q(ပတ်),
						'other' => q({0}ပတ်),
						'per' => q({0}တစ်ပတ်လျှင်),
					},
					'yard' => {
						'name' => q(ကိုက်),
						'other' => q({0} ကိုက်),
					},
					'year' => {
						'name' => q(နှစ်),
						'other' => q({0}နှစ်),
						'per' => q({0}နှစ်လျှင်),
					},
				},
				'narrow' => {
					'acre' => {
						'other' => q({0} ac),
					},
					'arc-minute' => {
						'other' => q({0}′),
					},
					'arc-second' => {
						'other' => q({0}″),
					},
					'celsius' => {
						'name' => q(°C),
						'other' => q({0}°),
					},
					'centimeter' => {
						'name' => q(စင်တီမီတာ),
						'other' => q({0} cm),
					},
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					'cubic-kilometer' => {
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'other' => q({0} mi³),
					},
					'day' => {
						'name' => q(ရက်),
						'other' => q({0}ရက်),
					},
					'degree' => {
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'other' => q({0}°F),
					},
					'foot' => {
						'other' => q({0} '),
					},
					'g-force' => {
						'other' => q({0} G),
					},
					'gram' => {
						'name' => q(ဂရမ်),
						'other' => q({0} g),
					},
					'hectare' => {
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(နာရီ),
						'other' => q({0}နာရီ),
					},
					'inch' => {
						'other' => q({0} ″),
					},
					'inch-hg' => {
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'name' => q(ကီလိုဂရမ်),
						'other' => q({0} kg),
					},
					'kilometer' => {
						'name' => q(ကီလိုမီတာ),
						'other' => q({0} km),
					},
					'kilometer-per-hour' => {
						'name' => q(ကီလိုမီတာ/နာရီ),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'other' => q({0} kW),
					},
					'light-year' => {
						'other' => q({0} အလင်းနှစ်),
					},
					'liter' => {
						'name' => q(လီတာ),
						'other' => q({0} l),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'other' => q({0} L/100km),
					},
					'meter' => {
						'name' => q(မီတာ),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'other' => q({0} m/s),
					},
					'mile' => {
						'other' => q({0}မိုင်),
					},
					'mile-per-hour' => {
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'name' => q(မီလီမီတာ),
						'other' => q({0} mm),
					},
					'millisecond' => {
						'name' => q(မီလီစက္ကန့်),
						'other' => q({0} ms),
					},
					'minute' => {
						'name' => q(မိနစ်),
						'other' => q({0}မိနစ်),
					},
					'month' => {
						'name' => q(လ),
						'other' => q({0}လ),
					},
					'ounce' => {
						'other' => q({0} oz),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'other' => q({0} pm),
					},
					'pound' => {
						'other' => q({0} lb),
					},
					'second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0} s),
					},
					'square-foot' => {
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'other' => q({0} km²),
					},
					'square-meter' => {
						'other' => q({0} m²),
					},
					'square-mile' => {
						'other' => q({0} mi²),
					},
					'watt' => {
						'other' => q({0} W),
					},
					'week' => {
						'name' => q(ပတ်),
						'other' => q({0}ပတ်),
					},
					'yard' => {
						'other' => q({0} ကိုက်),
					},
					'year' => {
						'name' => q(နှစ်),
						'other' => q({0} y),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(ဧက),
						'other' => q({0} ac),
					},
					'acre-foot' => {
						'name' => q(ဧက-ပေ),
						'other' => q({0} ac ft),
					},
					'ampere' => {
						'name' => q(အမ်ပီယာ),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(မိနစ်),
						'other' => q({0}′),
					},
					'arc-second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'name' => q(နက္ခတ္တဗေဒယူနစ်),
						'other' => q({0} au),
					},
					'bit' => {
						'name' => q(ဘစ်),
						'other' => q({0}ဘစ်),
					},
					'byte' => {
						'name' => q(ဘိုက်),
						'other' => q({0}ဘိုက်),
					},
					'calorie' => {
						'name' => q(ကယ်လိုရီ),
						'other' => q({0} cal),
					},
					'carat' => {
						'name' => q(ကရက်),
						'other' => q({0} CD),
					},
					'celsius' => {
						'name' => q(°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(စင်တီလီတာ),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'name' => q(စင်တီမီတာ),
						'other' => q({0} cm),
						'per' => q({0}/cm),
					},
					'century' => {
						'name' => q(c),
						'other' => q({0} c),
					},
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					'cubic-centimeter' => {
						'name' => q(ကုဗစင်တီမီတာ),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'name' => q(ကုဗပေ),
						'other' => q({0} ကုဗပေ),
					},
					'cubic-inch' => {
						'name' => q(ကုဗလက်မ),
						'other' => q({0}ကုဗလက်မ),
					},
					'cubic-kilometer' => {
						'name' => q(ကုဗကီလိုမီတာ),
						'other' => q({0} km³),
					},
					'cubic-meter' => {
						'name' => q(ကုဗမီတာ),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					'cubic-mile' => {
						'name' => q(ကုဗမိုင်),
						'other' => q({0} mi³),
					},
					'cubic-yard' => {
						'name' => q(ကုဗကိုက်),
						'other' => q({0} yd³),
					},
					'cup' => {
						'name' => q(ခွက်),
						'other' => q({0} c),
					},
					'cup-metric' => {
						'name' => q(mcup),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(ရက်),
						'other' => q({0}ရက်),
						'per' => q({0}/d),
					},
					'deciliter' => {
						'name' => q(ဒါစီလီတာ),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'name' => q(ဒါစီမီတာ),
						'other' => q({0} dm),
					},
					'degree' => {
						'name' => q(ဒီဂရီ),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'name' => q(အရည်အောင်စ),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'name' => q(ကယ်လိုရီ),
						'other' => q({0} Cal),
					},
					'foot' => {
						'name' => q(ပေ),
						'other' => q({0} ပေ),
						'per' => q({0}/ft),
					},
					'g-force' => {
						'name' => q(ဆွဲငင်အား),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(ဂါလန်),
						'other' => q({0}ဂါလန်),
						'per' => q({0}/ဂါလံ),
					},
					'generic' => {
						'name' => q(°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ဂီဂါဘစ်),
						'other' => q({0}ဂီဂါဘစ်),
					},
					'gigabyte' => {
						'name' => q(ဂီဂါဘိုက်),
						'other' => q({0}ဂီဂါဘိုက်),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(ဂီဂါဝပ်),
						'other' => q({0} GW),
					},
					'gram' => {
						'name' => q(ဂရမ်),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					'hectare' => {
						'name' => q(ဟက်တာ),
						'other' => q({0} ha),
					},
					'hectoliter' => {
						'name' => q(ဟက်တိုလီတာ),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'name' => q(Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(နာရီ),
						'other' => q({0}နာရီ),
						'per' => q({0}/နာရီ),
					},
					'inch' => {
						'name' => q(လက်မ),
						'other' => q({0} လက်မ),
						'per' => q({0}/in),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(ဂျူးလ်),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(ကရက်),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'name' => q(K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(ကီလိုဘစ်),
						'other' => q({0}ကီလိုဘစ်),
					},
					'kilobyte' => {
						'name' => q(ကီလိုဘိုက်),
						'other' => q({0}ကီလိုဘိုက်),
					},
					'kilocalorie' => {
						'name' => q(ကီလိုကယ်လိုရီ),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'name' => q(ကီလိုဂရမ်),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(ကီလိုဂျူးလ်),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'name' => q(ကီလိုမီတာ),
						'other' => q({0} km),
						'per' => q({0}/km),
					},
					'kilometer-per-hour' => {
						'name' => q(ကီလိုမီတာ/နာရီ),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'name' => q(ကီလိုဝပ်),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'name' => q(ကီလိုဝပ်-နာရီ),
						'other' => q({0} kWh),
					},
					'knot' => {
						'name' => q(kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(အလင်းနှစ်),
						'other' => q({0} အလင်းနှစ်),
					},
					'liter' => {
						'name' => q(လီတာ),
						'other' => q({0} l),
						'per' => q({0}/l),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'name' => q(လီတာ/ကီလိုမီတာ),
						'other' => q({0} L/km),
					},
					'lux' => {
						'name' => q(လတ်ခ်),
						'other' => q({0} lx),
					},
					'megabit' => {
						'name' => q(မီဂါဘစ်),
						'other' => q({0}မီဂါဘစ်),
					},
					'megabyte' => {
						'name' => q(မီဂါဘိုက်),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(မက်ဂါလီတာ),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'name' => q(မီဂါဝပ်),
						'other' => q({0} MW),
					},
					'meter' => {
						'name' => q(မီတာ),
						'other' => q({0} m),
						'per' => q({0}/m),
					},
					'meter-per-second' => {
						'name' => q(မီတာ/စက္ကန့်),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(မီတာ/စက္ကန့်နှစ်ထပ်ကိန်း),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(t),
						'other' => q({0} t),
					},
					'microgram' => {
						'name' => q(µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(မိုက်ခရိုမီတာ),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(မိုက်ခရိုစက္ကန့်),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(မိုင်),
						'other' => q({0}မိုင်),
					},
					'mile-per-gallon' => {
						'name' => q(မိုင်/ဂါလန်),
						'other' => q({0} mpg),
					},
					'mile-per-hour' => {
						'name' => q(မိုင်/နာရီ),
						'other' => q({0} mi/h),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(မီလီဘား),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'name' => q(မီလီဂရမ်),
						'other' => q({0} mg),
					},
					'milliliter' => {
						'name' => q(မီလီလီတာ),
						'other' => q({0} mL),
					},
					'millimeter' => {
						'name' => q(မီလီမီတာ),
						'other' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'name' => q(mm Hg),
						'other' => q({0} mm Hg),
					},
					'millisecond' => {
						'name' => q(မီလီစက္ကန့်),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'name' => q(မီလီဝပ်),
						'other' => q({0} mW),
					},
					'minute' => {
						'name' => q(မိနစ်),
						'other' => q({0}မိနစ်),
						'per' => q({0}မိနစ်လျှင်),
					},
					'month' => {
						'name' => q(လ),
						'other' => q({0}လ),
						'per' => q({0}/လ),
					},
					'nanometer' => {
						'name' => q(နာနိုမီတာ),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'name' => q(နာနိုစက္ကန့်),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'name' => q(ရေမိုင်),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'name' => q(အုမ်း),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(အောင်စ),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					'ounce-troy' => {
						'name' => q(ထရိုအောင်စ),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'name' => q(ပါစက်ခ်),
						'other' => q({0} pc),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(ပီကိုမီတာ),
						'other' => q({0} pm),
					},
					'pint' => {
						'name' => q(ပိုင့်),
						'other' => q({0}ပိုင့်),
					},
					'pint-metric' => {
						'name' => q(mpt),
						'other' => q({0} mpt),
					},
					'pound' => {
						'name' => q(ပေါင်),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'name' => q(ပေါင်/စတုရန်းလက်မ),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(ကွတ်),
						'other' => q({0}ကွတ်),
					},
					'radian' => {
						'name' => q(ရေဒီအန်းစ်),
						'other' => q({0} rad),
					},
					'revolution' => {
						'name' => q(rev),
						'other' => q({0} rev),
					},
					'second' => {
						'name' => q(စက္ကန့်),
						'other' => q({0} s),
						'per' => q({0}/စက္ကန့်),
					},
					'square-centimeter' => {
						'name' => q(စတုရန်းစင်တီမီတာ),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'name' => q(စတုရန်းပေ),
						'other' => q({0} ft²),
					},
					'square-inch' => {
						'name' => q(စတုရန်းလက်မ),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'name' => q(စတုရန်းကီလိုမီတာ),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'name' => q(စတုရန်းမီတာ),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					'square-mile' => {
						'name' => q(စတုရန်းမိုင်),
						'other' => q({0} mi²),
					},
					'square-yard' => {
						'name' => q(စတုရန်းကိုက်),
						'other' => q({0} yd²),
					},
					'tablespoon' => {
						'name' => q(စားပွဲဇွန်း),
						'other' => q(စားပွဲဇွန်း{0}ဇွန်း),
					},
					'teaspoon' => {
						'name' => q(လက်ဖက်ရည်ဇွန်း),
						'other' => q({0} tsp),
					},
					'terabit' => {
						'name' => q(တီရာဘစ်),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(တီရာဘိုက်),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(တန်),
						'other' => q({0} tn),
					},
					'volt' => {
						'name' => q(ဗို့),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(ဝပ်),
						'other' => q({0} W),
					},
					'week' => {
						'name' => q(ပတ်),
						'other' => q({0}ပတ်),
						'per' => q({0}/w),
					},
					'yard' => {
						'name' => q(ကိုက်),
						'other' => q({0} ကိုက်),
					},
					'year' => {
						'name' => q(နှစ်),
						'other' => q({0} y),
						'per' => q({0}/y),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ဟုတ်တယ်|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:မဟုတ်ဘူး|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}၊ {1}),
				middle => q({0}၊ {1}),
				end => q({0}၊ နှင့်{1}),
				2 => q({0}နှင့်{1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'mymr',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'mymr',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> 'Int',
	init_arg	=> undef,
	default		=> 3,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(ဂဏန်းမဟုတ်သော),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
		'mymr' => {
			'list' => q(၊),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'other' => '0ထောင်',
				},
				'10000' => {
					'other' => '0သောင်း',
				},
				'100000' => {
					'other' => '0သိန်း',
				},
				'1000000' => {
					'other' => '0သန်း',
				},
				'10000000' => {
					'other' => '0ကုဋေ',
				},
				'100000000' => {
					'other' => '00ကုဋေ',
				},
				'1000000000' => {
					'other' => 'ကုဋေ000',
				},
				'10000000000' => {
					'other' => 'ကုဋေ0000',
				},
				'100000000000' => {
					'other' => '0000ကုဋေ',
				},
				'1000000000000' => {
					'other' => 'ကုဋေ0သိန်း',
				},
				'10000000000000' => {
					'other' => 'ကုဋေ0သန်း',
				},
				'100000000000000' => {
					'other' => '0ကောဋိ',
				},
				'standard' => {
					'' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'other' => '0ထောင်',
				},
				'10000' => {
					'other' => '0သောင်း',
				},
				'100000' => {
					'other' => '0သိန်း',
				},
				'1000000' => {
					'other' => '0သန်း',
				},
				'10000000' => {
					'other' => '0ကုဋေ',
				},
				'100000000' => {
					'other' => '00ကုဋေ',
				},
				'1000000000' => {
					'other' => '000ကုဋေ',
				},
				'10000000000' => {
					'other' => '0000ကုဋေ',
				},
				'100000000000' => {
					'other' => '00000ကုဋေ',
				},
				'1000000000000' => {
					'other' => '000000ကုဋေ',
				},
				'10000000000000' => {
					'other' => '0000000ကုဋေ',
				},
				'100000000000000' => {
					'other' => '0ကောဋိ',
				},
			},
			'short' => {
				'1000' => {
					'other' => '0ထောင်',
				},
				'10000' => {
					'other' => '0သောင်း',
				},
				'100000' => {
					'other' => '0သိန်း',
				},
				'1000000' => {
					'other' => '0သန်း',
				},
				'10000000' => {
					'other' => '0ကုဋေ',
				},
				'100000000' => {
					'other' => '00ကုဋေ',
				},
				'1000000000' => {
					'other' => 'ကုဋေ000',
				},
				'10000000000' => {
					'other' => 'ကုဋေ0000',
				},
				'100000000000' => {
					'other' => '0000ကုဋေ',
				},
				'1000000000000' => {
					'other' => 'ကုဋေ0သိန်း',
				},
				'10000000000000' => {
					'other' => 'ကုဋေ0သန်း',
				},
				'100000000000000' => {
					'other' => '0ကောဋိ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(အာရပ်ဒူဟမ်း),
				'other' => q(အာရပ်ဒူဟမ်း),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(အာဖဂန်အာဖဂါနီ),
				'other' => q(အာဖဂန်အာဖဂါနီ),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(အယ်လ်ဘီးနီးယားလီခ်),
				'other' => q(အယ်လ်ဘီးနီးယားလီခ်),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(အာမေးနီးယားဒရမ်း),
				'other' => q(အာမေးနီးယားဒရမ်း),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(နယ်သာလန် အန်တီလန် ဂင်းဒါး),
				'other' => q(နယ်သာလန် အန်တီလန် ဂင်းဒါး),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(အင်ဂိုလာ ကန်ဇာ),
				'other' => q(အင်ဂိုလာ ကန်ဇာ),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(အာဂျင်တီးနား ပီဆို \(၁၉၈၃–၁၉၈၅\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(အာဂျင်တီးနား ပီဆို),
				'other' => q(အာဂျင်တီးနား ပီဆို),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ဩစတြေးလျ ဒေါ်လာ),
				'other' => q(ဩစတြေးလျ ဒေါ်လာ),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(အရူဘန် ဂင်းဒါး),
				'other' => q(အရူဘန် ဂင်းဒါး),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(အဇာဘိုင်ဂျန်မာနတ်),
				'other' => q(အဇာဘိုင်ဂျန်မာနတ်),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(ဘော့စနီးယား နှင့် ဟာဇီဂိုဘီးနားမတ်က်),
				'other' => q(ဘော့စနီးယား နှင့် ဟာဇီဂိုဘီးနားမတ်က်),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(ဘာဘဒီယံဒေါ်လာ),
				'other' => q(ဘာဘဒီယံဒေါ်လာ),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(ဘင်္ဂလားဒေ့ရှ် တာကာ),
				'other' => q(ဘင်္ဂလားဒေ့ရှ် တာကာ),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ဘယ်လ်ဂျီယမ် ဖရန့်),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(ဘူဂေးရီးယားလက်ဖ်),
				'other' => q(ဘူဂေးရီးယားလက်ဖ်),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(ဘာရိန်းဒီနား),
				'other' => q(ဘာရိန်းဒီနား),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(ဘူရွန်ဒီ ဖရန့်),
				'other' => q(ဘူရွန်ဒီ ဖရန့်),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(ဘာမူဒါ ဒေါ်လာ),
				'other' => q(ဘာမူဒါ ဒေါ်လာ),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ဘရူနိုင်း ဒေါ်လာ),
				'other' => q(ဘရူနိုင်း ဒေါ်လာ),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(ဘိုလီဘီယံ ဘိုလီဘီအားနို),
				'other' => q(ဘိုလီဘီယံ ဘိုလီဘီအားနိုစ်),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(ဘိုလီးဘီးယား ပီဆို),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ဘရာဇီး ရီးယဲ),
				'other' => q(ဘရာဇီး ရီးယဲ),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(ဘဟားမား ဒေါ်လာ),
				'other' => q(ဘဟားမား ဒေါ်လာ),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ဘူတန်အံဂါလ်ထရန်),
				'other' => q(ဘူတန်အံဂါလ်ထရန်),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(ဗမာ ကျပ်),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(ဘော့စ်ဝါနာ ပုလ),
				'other' => q(ဘော့စ်ဝါနာ ပုလ),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(ဘီလာရုစ် ရူဘယ်အသစ် \(၁၉၉၄–၁၉၉၉\)),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(ဘီလာရုစ် ရူဘယ်),
				'other' => q(ဘီလာရုစ် ရူဘယ်),
			},
		},
		'BZD' => {
			symbol => 'ဒေါ်လာ',
			display_name => {
				'currency' => q(ဘေလီဇ် ဒေါ်လာ),
				'other' => q(ဘေလီဇ် ဒေါ်လာ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ကနေဒါ ဒေါ်လာ),
				'other' => q(ကနေဒါ ဒေါ်လာ),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(ကွန်ဂို ဖရန့်),
				'other' => q(ကွန်ဂို ဖရန့်),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(ဆွစ် ဖရန့်),
				'other' => q(ဆွစ် ဖရန့်),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ချီလီ ပီဆို),
				'other' => q(ချီလီ ပီဆို),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(တရုတ် ယွမ်),
				'other' => q(တရုတ် ယွမ်),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(ကိုလံဘီယာ ပီဆို),
				'other' => q(ကိုလံဘီယာ ပီဆို),
			},
		},
		'CRC' => {
			symbol => 'စီအာစီ',
			display_name => {
				'currency' => q(ကော့စ်တာရီကာ ခိုလုံး),
				'other' => q(ကော့စ်တာရီကာ ခိုလုံး),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(နိုင်ငံခြားငွေလဲလှယ်နိုင်သော ကျူးဘားပီဆိုငွေ),
				'other' => q(နိုင်ငံခြားငွေလဲလှယ်နိုင်သော ကျူးဘားပီဆိုငွေ),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ကျူးဘား ပီဆို),
				'other' => q(ကျူးဘား ပီဆို),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ခေ့ပ်ဗာဒူ အက်စ်ခူဒို),
				'other' => q(ခေ့ပ်ဗာဒူ အက်စ်ခူဒို),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(ဆိုက်ပရက်စ် ပေါင်),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(ချက်ခိုရိုနာ),
				'other' => q(ချက်ခိုရိုနာ),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ဂျာမဏီ မတ်),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(ဂျီဘူတီ ဖရန့်),
				'other' => q(ဂျီဘူတီ ဖရန့်),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ဒိန်းမတ်ခရိုဏာ),
				'other' => q(ဒိန်းမတ် ခရိုဏာ),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ဒိုမီနီကန် ပီဆို),
				'other' => q(ဒိုမီနီကန် ပီဆို),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(အဲလ်ဂျီရီယန် ဒီနာ),
				'other' => q(အဲလ်ဂျီရီယန် ဒီနာ),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(အီဂျစ် ပေါင်),
				'other' => q(အီဂျစ် ပေါင်),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(အီရီတရီအာနာ့ခ်ဖာ),
				'other' => q(အီရီတရီအာနာ့ခ်ဖာ),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(စပိန် ပယ်စေးတာ),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(အီသီယိုးပီးယားဘီးယာ),
				'other' => q(အီသီယိုးပီးယားဘီးယာ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ယူရို),
				'other' => q(ယူရို),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ဖီဂျီ ဒေါ်လာ),
				'other' => q(ဖီဂျီ ဒေါ်လာ),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ဖောက်ကလန် ကျွန်းစု ပေါင်),
				'other' => q(ဖောက်ကလန် ကျွန်းစု ပေါင်),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ပြင်သစ် ဖရန့်),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ဗြိတိသျှ ပေါင်),
				'other' => q(ဗြိတိသျှ ပေါင်),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(ဂျော်ဂျီယာလားရီ),
				'other' => q(ဂျော်ဂျီယာလားရီ),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ဂါနာ ဆဲဒီ),
				'other' => q(ဂါနာ ဆဲဒီ),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(ဂျီဘရော်လ်တာ ပေါင်),
				'other' => q(ဂျီဘရော်လ်တာ ပေါင်),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(ဂန်ဘီယာ ဒါလာစီ),
				'other' => q(ဂန်ဘီယာ ဒါလာစီ),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ဂီးနီ ဖရန့်),
				'other' => q(ဂီရာနာ ဖရန့်),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ဂွာတီမာလာ ခက်ဇော်လ်),
				'other' => q(ဂွာတီမာလာ ခက်ဇော်လ်),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ဂူရာနာ ဒေါ်လာ),
				'other' => q(ဂူရာနာ ဒေါ်လာ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ဟောင်ကောင် ဒေါ်လာ),
				'other' => q(ဟောင်ကောင် ဒေါ်လာ),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ဟွန်ဒူးရပ်စ် လန်းပီးရာ),
				'other' => q(ဟွန်ဒူးရပ်စ် လန်းပီးရာ),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ခရိုအေးရှားခူးနာ),
				'other' => q(ခရိုအေးရှားခူးနာ),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ဟေတီဂူးအော်ဒ်),
				'other' => q(ဟေတီဂူးအော်ဒ်),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ဟန်ဂေရီယံဖော်ရင့်တ်),
				'other' => q(ဟန်ဂေရီယံဖော်ရင့်တ်),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(အင်ဒိုနီးရှား ရူပီးယား),
				'other' => q(အင်ဒိုနီးရှား ရူပီးယား),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(အစ္စရေး ပေါင်),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(အစ္စရေးရှဲကလ်အသစ်),
				'other' => q(အစ္စရေးရှဲကလ်အသစ်),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(အိန္ဒိယ ရူပီး),
				'other' => q(အိန္ဒိယ ရူပီး),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(အီရပ်ဒီနား),
				'other' => q(အီရပ်ဒီနား),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(အီရန်ရီအော်လ်),
				'other' => q(အီရန်ရီအော်လ်),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(အိုက်စလန် ခရိုဏာ),
				'other' => q(အိုက်စလန် ခရိုဏာ),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ဂျမေကာ ဒေါ်လာ),
				'other' => q(ဂျမေကာ ဒေါ်လာ),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ဂျော်ဒန်ဒီနား),
				'other' => q(ဂျော်ဒန်ဒီနား),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ဂျပန်ယန်း),
				'other' => q(ဂျပန်ယန်း),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(ကင်ညာသျှီလင်),
				'other' => q(ကင်ညာသျှီလင်),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(ခရူဂစ်စတန်ဆော်မ်),
				'other' => q(ခရူဂစ်စတန်ဆော်မ်),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(ကမ္ဘောဒီးယား ရီးယဲ),
				'other' => q(ကမ္ဘောဒီးယား ရီးယဲ),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(ကိုမိုရိုစ် ဖရန့်),
				'other' => q(ကိုမိုရိုစ် ဖရန့်),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(မြောက်ကိုးရီးယား ဝမ်),
				'other' => q(မြောက်ကိုးရီးယား ဝမ်),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(တောင်ကိုးရီးယား ဝမ်),
				'other' => q(တောင်ကိုးရီးယား ဝမ်),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(ကူဝိတ်ဒီနာ),
				'other' => q(ကူဝိတ်ဒီနာ),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(ကေမန် ကျွန်းစု ဒေါ်လာ),
				'other' => q(ကေမန် ကျွန်းစု ဒေါ်လာ),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(ခရူဂစ်စတန်ထိန်ဂျီ),
				'other' => q(ခရူဂစ်စတန်ထိန်ဂျီ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(လာအိုခိပ်),
				'other' => q(လာအိုခိပ်),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(လက်ဘနွန် ပေါင်),
				'other' => q(လက်ဘနွန် ပေါင်),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(သီရိလင်္ကာ ရူပီး),
				'other' => q(သီရိလင်္ကာ ရူပီး),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(လိုင်ဘေးရီးယား ဒေါ်လာ),
				'other' => q(လိုင်ဘေးရီးယား ဒေါ်လာ),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(လစ်သူယေးနီးယားလီတားစ်),
				'other' => q(လစ်သူယေးနီးယားလီတားစ်),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(လတ်ဗီးယားလတ်),
				'other' => q(လတ်ဗီးယားလတ်),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(လီဗျာ ဒီနာ),
				'other' => q(လီဗျာ ဒီနာ),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(မိုရိုကို ဒရမ်),
				'other' => q(မိုရိုကို ဒရမ်),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(မောလ်ဒိုဗာလယ်အို),
				'other' => q(မောလ်ဒိုဗာလယ်အို),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(မလာဂစ်စီ အရီရရီ ငွေကြေး),
				'other' => q(မလာဂစ်စီ အရီရရီ ငွေကြေး),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(မာစီဒိုးနီးယားဒီနာ),
				'other' => q(မာစီဒိုးနီးယားဒီနာ),
			},
		},
		'MMK' => {
			symbol => 'K',
			display_name => {
				'currency' => q(မြန်မာကျပ်),
				'other' => q(မြန်မာကျပ်),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(မွန်ဂိုးလီးယားထူးဂရခ်),
				'other' => q(မွန်ဂိုးလီးယားထူးဂရခ်),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(မကာအိုပါတားကား),
				'other' => q(မကာအိုပါတားကား),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(မောရီတာနီအာအူဂီးယာ),
				'other' => q(မောရီတာနီအာအူဂီးယာ),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(မော်ရေရှားစ် ရူပီ),
				'other' => q(မော်ရေရှားစ် ရူပီ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(မော်လ်ဒိုက်ရူးဖီရာ),
				'other' => q(မော်လ်ဒိုက်ရူးဖီရာ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(မာလာဝီခွါးချာ),
				'other' => q(မာလာဝီခွါးချာ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(မက္ကဆီကို ပီဆို),
				'other' => q(မက္ကဆီကို ပီဆို),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(မလေးရှား ရင်းဂစ်),
				'other' => q(မလေးရှား ရင်းဂစ်),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(မိုဇန်ဘစ်မက်တီခယ်လ်),
				'other' => q(မိုဇန်ဘစ်မက်တီခယ်လ်),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(နမ်မီးဘီးယား ဒေါ်လာ),
				'other' => q(နမ်မီးဘီးယား ဒေါ်လာ),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(နိုင်ဂျီးရီးယားနိုင်းရာ),
				'other' => q(နိုင်ဂျီးရီးယားနိုင်းရာ),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(နီကာရာဂွာ ခိုးဒိုဘာ),
				'other' => q(နီကာရာဂွာ ခိုးဒိုဘာ),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(နော်ဝေ ခရိုဏာ),
				'other' => q(နော်ဝေ ခရိုဏာ),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(နီပေါ ရူပီး),
				'other' => q(နီပေါ ရူပီး),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(နယူးဇီလန် ဒေါ်လာ),
				'other' => q(နယူးဇီလန် ဒေါ်လာ),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(အိုမန်ရီအော်လ်),
				'other' => q(အိုမန်ရီအော်လ်),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(ပနားမား ဘလ်ဘိုးအာ),
				'other' => q(ပနားမား ဘလ်ဘိုးအာ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(ပီရူး နူအီဗိုဆိုးလ်),
				'other' => q(ပီရူး နူအီဗိုဆိုးလ်),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(ပါပူရာနယူးဂီနီခီးနာ),
				'other' => q(ပါပူရာနယူးဂီနီခီးနာ),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(ဖိလစ်ပိုင် ပီဆို),
				'other' => q(ဖိလစ်ပိုင် ပီဆို),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(ပါကစ္စတန် ရူပီး),
				'other' => q(ပါကစ္စတန် ရူပီး),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(ပိုလန် ဇ‌လော့တီ),
				'other' => q(ပိုလန် ဇ‌လော့တီ),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(ပါရာဂွေးဂွါးအ်နီး),
				'other' => q(ပါရာဂွေးဂွါးအ်နီး),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(ကာတာရီအော်လ်),
				'other' => q(ကာတာရီအော်လ်),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(ရိုမေးနီယားလယ်အို),
				'other' => q(ရိုမေးနီယားလယ်အို),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(ဆားဘီးယားဒယ်နား),
				'other' => q(ဆားဘီးယားဒယ်နား),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(ရုရှ ရူဘယ်),
				'other' => q(ရုရှ ရူဘယ်),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(ရုရှ ရူဘယ် \(၁၉၉၁–၁၉၉၈\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(ရဝန်ဒါ ဖရန့်),
				'other' => q(ရဝန်ဒါ ဖရန့်),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(ဆော်ဒီအာရေးဗီးယားရီယော်လ်),
				'other' => q(ဆော်ဒီအာရေးဗီးယားရီယော်လ်),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(ဆော်လမွန်ကျွန်းစု ဒေါ်လာ),
				'other' => q(ဆော်လမွန်ကျွန်းစု ဒေါ်လာ),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(ဆေးရှလ်ရူးပီး),
				'other' => q(ဆေးရှလ်ရူးပီး),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(ဆူဒန် ပေါင်),
				'other' => q(ဆူဒန် ပေါင်),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(ဆူဒန် ပေါင်အဟောင်း),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(ဆွီဒင် ခရိုဏာ),
				'other' => q(ဆွီဒင် ခရိုဏာ),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(စင်္ကာပူ ဒေါ်လာ),
				'other' => q(စင်္ကာပူ ဒေါ်လာ),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(စိန့်ဟဲလီနာ ပေါင်),
				'other' => q(စိန့်ဟဲလီနာ ပေါင်),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(ဆီအဲရာ လီအိုနီယန် လီအိုနီ),
				'other' => q(ဆီအဲရာ လီအိုနီယန် လီအိုနီ),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(ဆိုမာလီသျှီလင်),
				'other' => q(ဆိုမာလီသျှီလင်),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(ဆူရီနိမ်း ဒေါ်လာ),
				'other' => q(ဆူရီနိမ်း ဒေါ်လာ),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(တောင်ဆူဒန်ပေါင်),
				'other' => q(တောင်ဆူဒန်ပေါင်),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(စိန့်တိုမီနှင့်ပရင်စီပ့် ဒိုဘရာ),
				'other' => q(စိန့်တိုမီနှင့်ပရင်စီပ့် ဒိုဘရာ),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(ဆိုဗီယက် ရူဗယ်),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(ဆီးရီးယား ပေါင်),
				'other' => q(ဆီးရီးယား ပေါင်),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(စွာဇီလန်လီလန်းဂီနီ),
				'other' => q(စွာဇီလန်လီလန်းဂီနီ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(ထိုင်းဘတ်),
				'other' => q(ထိုင်းဘတ်),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(တာဂျီကစ္စတန်ဆိုမိုနီ),
				'other' => q(တာဂျီကစ္စတန်ဆိုမိုနီ),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(တာခ်မီန့စ်တန်မာနတ်),
				'other' => q(တာခ်မီန့စ်တန်မာနတ်),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(တူနီရှားဒီနာ),
				'other' => q(တူနီရှားဒီနာ),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(တွန်ဂါဗန်ဂါ),
				'other' => q(တွန်ဂါဗန်ဂါ),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(ရှေးဟောင်းတူရကီ လိုင်ရာ),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(တူရကီ လိုင်ရာ),
				'other' => q(တူရကီ လိုင်ရာ),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ထရိုင်နီဒတ်နှင့်တိုဘာဂိုဒေါ်လာ),
				'other' => q(တရီနာဒတ်နှင့်တိုဘာဂိုဒေါ်လာ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ထိုင်ဝမ် ဒေါ်လာအသစ်),
				'other' => q(ထိုင်ဝမ် ဒေါ်လာအသစ်),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(တန်ဇန်းနီးယားသျှီလင်),
				'other' => q(တန်ဇန်းနီးယားသျှီလင်),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ယူကရိန်း),
				'other' => q(ယ),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ယူဂန္ဓာသျှီလင်),
				'other' => q(ယူဂန္ဓာသျှီလင်),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(အမေရိကန် ဒေါ်လာ),
				'other' => q(အမေရိကန် ဒေါ်လာ),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(အမေရိကန် ဒေါ်လာ \(နောက်နေ့\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(အမေရိကန် ဒေါ်လာ \(တနေ့တည်း\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ဥရုဂွေးပီဆို),
				'other' => q(ဥရုဂွေးပီဆို),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ဥဘက်ကစ္စတန်ဆော်မ်),
				'other' => q(ဥဘက်ကစ္စတန်ဆော်မ်),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(ဗင်နီဇွဲလား ဘိုလီဗာ),
				'other' => q(ဗင်နီဇွဲလား ဘိုလီဗာ),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ဗီယက်နမ် ဒေါင်),
				'other' => q(ဗီယက်နမ် ဒေါင်),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(ဗာနုအာတူဗားထူ),
				'other' => q(ဗာနုအာတူဗားထူ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(စမိုအထားလာ),
				'other' => q(စမိုအထားလာ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ကင်မရွန်းဖရန့်),
				'other' => q(ကင်မရွန်းဖရန့်),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(ငွေ),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(ရွှေ),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(ဥရောပငွေကြေးစံနစ်),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(အရှေ့ကာရီဘီယံဒေါ်လာ),
				'other' => q(အရှေ့ကာရီဘီယံဒေါ်လာ),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(အထူးထုတ်ယူခွင့်),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(အိုင်ဗရီးကိုးစ်ဖရန့်),
				'other' => q(အိုင်ဗရီးကိုးစ်ဖရန့်),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP ဖရန့်),
				'other' => q(CFP ဖရန့်),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(ပလက်တီနမ်),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(စမ်းသပ် ငွေကြေး ကုဒ်),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(မသိသို့မဟုတ်မရှိသောငွေကြေး),
				'other' => q(မသိ သို့မဟုတ် မရှိသော ငွေကြေး),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(ယီမင်ရီအော်လ်),
				'other' => q(ယီမင်ရီအော်လ်),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(တောင်အဖရိက ရန်း),
				'other' => q(တောင်အဖရိက ရန်း),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ဇင်ဘာဘွေခွါးချာ),
				'other' => q(ဇင်ဘာဘွေခွါးချာ),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(ဇင်ဘာဘွေ ဒေါ်လာ),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ဇန်',
							'ဖေ',
							'မတ်',
							'ဧပြီ',
							'မေ',
							'ဇွန်',
							'ဇူ',
							'ဩ',
							'စက်',
							'အောက်',
							'နို',
							'ဒီ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ဇ',
							'ဖ',
							'မ',
							'ဧ',
							'မ',
							'ဇ',
							'ဇ',
							'ဩ',
							'စ',
							'အ',
							'န',
							'ဒ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ဇန်နဝါရီ',
							'ဖေဖော်ဝါရီ',
							'မတ်',
							'ဧပြီ',
							'မေ',
							'ဇွန်',
							'ဇူလိုင်',
							'ဩဂုတ်',
							'စက်တင်ဘာ',
							'အောက်တိုဘာ',
							'နိုဝင်ဘာ',
							'ဒီဇင်ဘာ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ဇန်',
							'ဖေ',
							'မတ်',
							'ဧပြီ',
							'မေ',
							'ဇွန်',
							'ဇူ',
							'ဩ',
							'စက်',
							'အောက်',
							'နို',
							'ဒီ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ဇ',
							'ဖ',
							'မ',
							'ဧ',
							'မ',
							'ဇ',
							'ဇ',
							'ဩ',
							'စ',
							'အ',
							'န',
							'ဒ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ဇန်နဝါရီ',
							'ဖေဖော်ဝါရီ',
							'မတ်',
							'ဧပြီ',
							'မေ',
							'ဇွန်',
							'ဇူလိုင်',
							'ဩဂုတ်',
							'စက်တင်ဘာ',
							'အောက်တိုဘာ',
							'နိုဝင်ဘာ',
							'ဒီဇင်ဘာ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
					narrow => {
						mon => 'တ',
						tue => 'အ',
						wed => 'ဗ',
						thu => 'က',
						fri => 'သ',
						sat => 'စ',
						sun => 'တ'
					},
					short => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
					wide => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
					narrow => {
						mon => 'တ',
						tue => 'အ',
						wed => 'ဗ',
						thu => 'က',
						fri => 'သ',
						sat => 'စ',
						sun => 'တ'
					},
					short => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
					wide => {
						mon => 'တနင်္လာ',
						tue => 'အင်္ဂါ',
						wed => 'ဗုဒ္ဓဟူး',
						thu => 'ကြာသပတေး',
						fri => 'သောကြာ',
						sat => 'စနေ',
						sun => 'တနင်္ဂနွေ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ပထမ သုံးလပတ်',
						1 => 'ဒုတိယ သုံးလပတ်',
						2 => 'တတိယ သုံးလပတ်',
						3 => 'စတုတ္ထ သုံးလပတ်'
					},
					narrow => {0 => 'ပ',
						1 => 'ဒု',
						2 => 'တ',
						3 => 'စ'
					},
					wide => {0 => 'ပထမ သုံးလပတ်',
						1 => 'ဒုတိယ သုံးလပတ်',
						2 => 'တတိယ သုံးလပတ်',
						3 => 'စတုတ္ထ သုံးလပတ်'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ပထမ သုံးလပတ်',
						1 => 'ဒုတိယ သုံးလပတ်',
						2 => 'တတိယ သုံးလပတ်',
						3 => 'စတုတ္ထ သုံးလပတ်'
					},
					narrow => {0 => 'ပ',
						1 => 'ဒု',
						2 => 'တ',
						3 => 'စ'
					},
					wide => {0 => 'ပထမ သုံးလပတ်',
						1 => 'ဒုတိယ သုံးလပတ်',
						2 => 'တတိယ သုံးလပတ်',
						3 => 'စတုတ္ထ သုံးလပတ်'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'morning1' if $time > 0
						&& $time < 1200;
					return 'afternoon1' if $time > 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'night1' if $time >= 1900
						&& $time < 2400;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'morning1' if $time > 0
						&& $time < 1200;
					return 'afternoon1' if $time > 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'night1' if $time >= 1900
						&& $time < 2400;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 0
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'evening1' if $time >= 1600
						&& $time < 1900;
					return 'night1' if $time >= 1900
						&& $time < 2400;
				}
				last SWITCH;
				}
		}
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'evening1' => q{ညနေခင်း၁},
					'afternoon1' => q{နေ့လည်ခင်း၁},
					'am' => q{နံနက်},
					'night1' => q{ည၁},
					'noon' => q{မွန်းတည့်},
					'midnight' => q{ညသန်းခေါင်ယံ},
					'morning1' => q{မနက်၁},
					'pm' => q{ညနေ},
				},
				'wide' => {
					'pm' => q{ညနေ},
					'morning1' => q{မနက်တွင်},
					'midnight' => q{ညသန်းခေါင်ယံ},
					'noon' => q{မွန်းတည့်},
					'night1' => q{ညတွင်},
					'am' => q{နံနက်},
					'evening1' => q{ညနေခင်းတွင်},
					'afternoon1' => q{နေ့လည်ခင်းတွင်},
				},
				'abbreviated' => {
					'afternoon1' => q{နေ့လည်ခင်းတွင်},
					'evening1' => q{ညနေခင်းတွင်},
					'am' => q{နံနက်},
					'midnight' => q{ညသန်းခေါင်ယံ},
					'night1' => q{ညတွင်},
					'noon' => q{မွန်းတည့်},
					'morning1' => q{မနက်တွင်},
					'pm' => q{ညနေ},
				},
			},
			'stand-alone' => {
				'wide' => {
					'evening1' => q{ညနေ},
					'afternoon1' => q{နေ့လည်},
					'am' => q{နံနက်},
					'morning1' => q{နံနက်},
					'midnight' => q{သန်းခေါင်ယံ},
					'noon' => q{မွန်းတည့်},
					'night1' => q{ည},
					'pm' => q{ညနေ},
				},
				'narrow' => {
					'evening1' => q{ညနေ},
					'afternoon1' => q{နေ့လည်},
					'am' => q{နံနက်},
					'morning1' => q{နံနက်},
					'midnight' => q{သန်းခေါင်ယံ},
					'night1' => q{ည},
					'noon' => q{မွန်းတည့်},
					'pm' => q{ညနေ},
				},
				'abbreviated' => {
					'evening1' => q{ညနေ},
					'afternoon1' => q{နေ့လည်},
					'am' => q{နံနက်},
					'morning1' => q{နံနက်},
					'noon' => q{မွန်းတည့်},
					'night1' => q{ည},
					'midnight' => q{သန်းခေါင်ယံ},
					'pm' => q{ညနေ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ဘီစီ',
				'1' => 'အေဒီ'
			},
			wide => {
				'0' => 'ခရစ်တော် မပေါ်မီကာလ',
				'1' => 'ခရစ်တော် ပေါ်ထွန်းပြီးကာလ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE၊ G dd MMMM y},
			'long' => q{G dd MMMM y},
			'medium' => q{G d MMM y},
			'short' => q{GGGGG dd-MM-yy},
		},
		'gregorian' => {
			'full' => q{EEEE၊ dd MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{dd-MM-yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}တွင်},
			'long' => q{{1} {0}တွင်},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1}မှာ {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			E => q{ccc},
			Ed => q{E၊ d},
			Gy => q{G y},
			GyMMM => q{G MMM y},
			GyMMMEd => q{E၊ G d MMM y},
			GyMMMd => q{G d MMM y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E၊ d/M},
			MMM => q{LLL},
			MMMEd => q{E၊ d MMM},
			MMMMEd => q{E၊ d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{G M/y},
			yyyyMEd => q{E၊ G d/M/y},
			yyyyMMM => q{G MMM y},
			yyyyMMMEd => q{E၊ G d MMM y},
			yyyyMMMM => q{G MMMM y},
			yyyyMMMd => q{G d MMM y},
			yyyyMd => q{GGGGG dd-MM-y},
			yyyyQQQ => q{G QQQ y},
			yyyyQQQQ => q{G QQQQ y},
		},
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E၊ d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G MMM y},
			GyMMMEd => q{E၊ G d MMM y},
			GyMMMd => q{G d MMM y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E၊ d/M},
			MMM => q{LLL},
			MMMEd => q{E၊ d MMM},
			MMMMEd => q{E၊ d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E၊ d-M-y},
			yMMM => q{MMM y},
			yMMMEd => q{E၊ d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{dd-MM-y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{EEEE၊ d/M – EEEE၊ d/M},
				d => q{EEEE၊ d/M – EEEE၊ d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{d MMM၊ EEEE – d MMM၊ EEEE},
				d => q{d MMM၊ EEEE – d MMM၊ EEEE},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{G M/y – M/y},
				y => q{G M/y – M/y},
			},
			yMEd => {
				M => q{EEEE၊ G d/M/y – EEEE၊ d/M/y},
				d => q{EEEE၊ G d/M/y – EEEE၊ d/M/y},
				y => q{EEEE၊ G d/M/y – EEEE၊ d/M/y},
			},
			yMMM => {
				M => q{G MMM y – MMM y},
				y => q{G MMM y – MMM y},
			},
			yMMMEd => {
				M => q{d MMM၊ EEEE – d MMM၊ y ၊ EEEE},
				d => q{d MMM၊ EEEE – d MMM၊ y ၊ EEEE},
				y => q{d MMM၊ EEEE – y၊ d MMM၊ y ၊EEEE},
			},
			yMMMM => {
				M => q{G MMMM–MMMM y},
				y => q{G MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{G d MMM – d MMM၊ y},
				d => q{G d–d MMM y},
				y => q{G d MMM y – d MMM y},
			},
			yMd => {
				M => q{G d/M/y – d/M/y},
				d => q{G d/M/y – d/M/y},
				y => q{G d/M/y – d/M/y},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{EEEE၊ d/M – EEEE၊ d/M},
				d => q{EEEE၊ d/M – EEEE၊ d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{d MMM၊ EEEE – d MMM၊ EEEE},
				d => q{d MMM၊ EEEE – d MMM၊ EEEE},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d MMM – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{EEEE၊ d/M/y – EEEE၊ d/M/y},
				d => q{EEEE၊ d/M/y – EEEE၊ d/M/y},
				y => q{EEEE၊ d/M/y – EEEE၊ d/M/y},
			},
			yMMM => {
				M => q{MMM y – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{d MMM၊ EEEE – d MMM၊ y၊ EEEE},
				d => q{d MMM၊ EEEE – d MMM၊ y၊ EEEE},
				y => q{d MMM၊ y၊ EEEE – d MMM၊ y၊ EEEE},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM၊ y},
				d => q{d–d MMM y},
				y => q{d MMM y– d MMM y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(ဂရင်းနစ်စံတော်ချိန်{0}),
		gmtZeroFormat => q(ဂရင်းနစ်စံတော်ချိန်),
		regionFormat => q({0}အချိန်),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (စံတော်ချိန်)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(အာဖဂန်နစ္စတန် အချိန်),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#အာဘီဂျွန်း#,
		},
		'Africa/Accra' => {
			exemplarCity => q#အက်ကရာ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#အားဒစ် အားဘဘာ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#အယ်လ်ဂျီးအားစ်#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#အားစ်မားရာ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ဘာမာကို#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ဘာန်ဂီး#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ဘန်ဂျုးလ်#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ဘီစာအို#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ဘလန်တိုင်းအာ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ဘရားဇာဗီးလ်#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ဘူဂျွန်ဘူးရာ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ကိုင်ရို#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ကာစာဘလန်ကာ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ဆီရူးတာ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ခေါ်နာခရီး#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ဒါကာ#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ဒါအက်စ်ဆာလမ်း#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ဂျီးဘူးတီ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ဒိုအူအာလာ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#အယ်လ်အာယွန်း#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ဖရီးတောင်းန်#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ဂါဘာရွန်းနီ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ဟာရားရဲယ်#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ဂျိုဟန်နက်စ်ဘခ်#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ဂျုဘာ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ခမ်ပါးလား#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ကာတိုအန်#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ခီဂါးလီ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ခင်ရှာစာ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#လာဂိုစ်#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#လီဗရာဗီးလ်#,
		},
		'Africa/Lome' => {
			exemplarCity => q#လိုမီ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#လူအန်ဒါ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#လူဘွန်းဘာရှီ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#လူစားခါး#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#မာလာဘို#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#မာပူးတို#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#မာဆူရူး#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ဘားဘာန်း#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#မော်ဂါဒီးသျုး#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#မွန်ရိုဗီအာ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#နိုင်ရိုဘီ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#အင်ဂျာမီနာ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ညာမဲယ်#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#နိုအာ့ခ်ရှော့တ်#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ဝါဂါဒူးဂူ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ပိုတို-နိုဗို#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ဆာအို တိုမီ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ထရီပိုလီ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#တူနီစ်#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ဗင်းဟူးခ်#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(အလယ်ပိုင်း အာဖရိက အချိန်),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(အရှေ့ပိုင်း အာဖရိက အချိန်),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(တောင်အာဖရိက အချိန်),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(အနောက်ပိုင်း အာဖရိက နွေရာသီ အချိန်),
				'generic' => q(အနောက်ပိုင်း အာဖရိက အချိန်),
				'standard' => q(အနောက်ပိုင်း အာဖရိက စံတော်ချိန်),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(အလာစကာနေ့ပိုင်းအချိန်),
				'generic' => q(အလာစကာအချိန်),
				'standard' => q(အလာစကာစံတော်ချိန်),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(အမေဇွန်နွေရာသီအချိန်),
				'generic' => q(အမေဇွန်အချိန်),
				'standard' => q(အမေဇွန်စံတော်ချိန်),
			},
		},
		'America/Adak' => {
			exemplarCity => q#အာဒခ်#,
		},
		'America/Anchorage' => {
			exemplarCity => q#အန်ကာရေ့ဂျ်#,
		},
		'America/Anguilla' => {
			exemplarCity => q#အန်ဂွီလာ#,
		},
		'America/Antigua' => {
			exemplarCity => q#အန်တီဂုအာ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#အာရာဂွာအီနာ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#လာ ရီအိုဂျာ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ရီအို ဂါလီဂိုစ်#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ဆာလ်တာ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#စော့တ ဂျုအန်#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#စော့န် လူအီးစ်#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#တူကူမန်#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ဥဆွာအီအာ#,
		},
		'America/Aruba' => {
			exemplarCity => q#အာရုဘာ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#အာဆူစီအွန်း#,
		},
		'America/Bahia' => {
			exemplarCity => q#ဘာဟီအာ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ဘာဟီအာ ဘန်ဒရက်စ်#,
		},
		'America/Barbados' => {
			exemplarCity => q#ဘာဘဒိုးစ်#,
		},
		'America/Belem' => {
			exemplarCity => q#ဘာလီန်#,
		},
		'America/Belize' => {
			exemplarCity => q#ဘီလီဇ်#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ဘလွန်ခ်-စာဘလွန်#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ဘိုအာဗီစ်တာ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ဘိုဂိုတာ#,
		},
		'America/Boise' => {
			exemplarCity => q#ဘိုအီဇီ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ဘရူနိုစ်အေရီစ်#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ကိန်းဘရီဂျ်ဘေး#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ကိမ်ပို ဂရန်ဒီ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ကန်ခန်#,
		},
		'America/Caracas' => {
			exemplarCity => q#ကာရာကာစ်#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ကာတာမာရ်ကာ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ခါရန်း#,
		},
		'America/Cayman' => {
			exemplarCity => q#ကေမန်#,
		},
		'America/Chicago' => {
			exemplarCity => q#ချီကာကို#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ချီဟူအာဟူအာ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#အာတီကိုကန်#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ကိုဒိုဘာ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ကိုစတာရီကာ#,
		},
		'America/Creston' => {
			exemplarCity => q#ကရစ်စတွန်#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ခူရာဘာ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ခူရာကာအို#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ဒန်မတ်ရှာန်#,
		},
		'America/Dawson' => {
			exemplarCity => q#ဒေါ်စွန်#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ဒေါ်စွန်ကရိခ်#,
		},
		'America/Denver' => {
			exemplarCity => q#ဒင်ဗာ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ဒေထရိုအ်#,
		},
		'America/Dominica' => {
			exemplarCity => q#ဒိုမီနီကာ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#အက်ဒ်မွန်တွန်#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#အီရူနီပီ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#အဲလ် ဆာဗီဒို#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ဖို့တ်တာလီဇာ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ဂလဲစ်ဘေး#,
		},
		'America/Godthab' => {
			exemplarCity => q#နုအုခ်#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ဂူးစ်ဘေး#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ဂရန်ဒ် တခ်#,
		},
		'America/Grenada' => {
			exemplarCity => q#ဂရီနာဒါ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ဂူအာဒီလူပ်#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ဂွာတီမာလာ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ဂွာရာကီးလ်#,
		},
		'America/Guyana' => {
			exemplarCity => q#ဂိုင်းရာနား#,
		},
		'America/Halifax' => {
			exemplarCity => q#ဟလီဖက်စ်#,
		},
		'America/Havana' => {
			exemplarCity => q#ဟာဗာနာ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ဟာမိုစ်စီလို#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#နို့ခ်စ် အင်ဒီအားနား#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#မာရန်ဂို အင်ဒီအားနား#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ပီတာဘာဂ်စ် အင်ဒီအားနား#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#တဲလ်စီးတီး အင်ဒီအားနား#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ဗီဗဲ အင်ဒီအားနား#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ဗင်ဆင့်စ် အင်ဒီအားနား#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ဝီနာမက်ခ် အင်ဒီအားနား#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#အင်ဒီယားနားပိုလစ်#,
		},
		'America/Inuvik' => {
			exemplarCity => q#အီနုဗီခ်#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#အီကာလူအီတ်#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ဂျာမေကာ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ဂျုဂျေ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ဂျုနိုအော#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#မွန်တီဆယ်လို ကင်တပ်ခ်ကီး#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ခရာလဲန်းဒီခ်#,
		},
		'America/La_Paz' => {
			exemplarCity => q#လာပါဇ်#,
		},
		'America/Lima' => {
			exemplarCity => q#လီမာ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#လော့စ်အိန်ဂျယ်လိစ်#,
		},
		'America/Louisville' => {
			exemplarCity => q#လူအီးစ်ဗီလ်#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#လိုအာပရင့်စ် ကွာတာ#,
		},
		'America/Maceio' => {
			exemplarCity => q#မာဆဲသြာ#,
		},
		'America/Managua' => {
			exemplarCity => q#မာနာဂူအာ#,
		},
		'America/Manaus' => {
			exemplarCity => q#မာနောက်စ်#,
		},
		'America/Marigot' => {
			exemplarCity => q#မာရီဂိုတ်#,
		},
		'America/Martinique' => {
			exemplarCity => q#မာတီနီဂ်#,
		},
		'America/Matamoros' => {
			exemplarCity => q#မာတာမိုရိုစ်#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#မာဇတ်လန်#,
		},
		'America/Mendoza' => {
			exemplarCity => q#မိန်ဒိုဇာ#,
		},
		'America/Menominee' => {
			exemplarCity => q#မီနိုမီနီး#,
		},
		'America/Merida' => {
			exemplarCity => q#မီရီဒါ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#မက်တ်လာကက်လာ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#မက်ခ်စီကိုစီတီး#,
		},
		'America/Miquelon' => {
			exemplarCity => q#မိခွီလွန်#,
		},
		'America/Moncton' => {
			exemplarCity => q#မွန်ခ်တွန်#,
		},
		'America/Monterrey' => {
			exemplarCity => q#မွန်တီရဲယ်လ်#,
		},
		'America/Montevideo' => {
			exemplarCity => q#မွန်တီဗီဒီအို#,
		},
		'America/Montserrat' => {
			exemplarCity => q#မွန့်(တ်)ဆေးရတ်#,
		},
		'America/Nassau' => {
			exemplarCity => q#နာ့ဆော်#,
		},
		'America/New_York' => {
			exemplarCity => q#နယူးယောက်#,
		},
		'America/Nipigon' => {
			exemplarCity => q#နီပီဂွန်#,
		},
		'America/Nome' => {
			exemplarCity => q#နိုမီ#,
		},
		'America/Noronha' => {
			exemplarCity => q#နိုရိုညာ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ဘီဥလာ မြောက်ဒါကိုတာ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#စင်တာ မြောက်ဒါကိုတာ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#နယူးစီလန် မြောက်ဒါကိုတာ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#အိုဂျီနာဂါ#,
		},
		'America/Panama' => {
			exemplarCity => q#ပါနားမား#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ဖန်ဂ်နသ်တံ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ပါရာမာရီဘို#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ဖီးနစ်#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ပို့တ်-အို-ပရင့်စ်#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ပို့တ် အော့ဖ် စပိန်#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ဖို့တ်တို ဗဲလ်လီအာ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ပိုတိုရီကို#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ရိမ်းနီး ရီဗာ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ရမ်ကင် အင်လက်#,
		},
		'America/Recife' => {
			exemplarCity => q#ရယ်စီ့ဖ်ဖာ#,
		},
		'America/Regina' => {
			exemplarCity => q#ရယ်ဂျီနာ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ရဲလ်ဆိုလု(တ်)#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ရီယို ဘရန်ကို#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ဆန်တာ အီးဇဘဲယ်လ်#,
		},
		'America/Santarem' => {
			exemplarCity => q#ဆန်တာရန်#,
		},
		'America/Santiago' => {
			exemplarCity => q#ဆန်တီအာဂို#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ဆန်တို ဒိုမီနီကာ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ဆာပိုလို#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#အို့တိုခိုတိုမစ်#,
		},
		'America/Sitka' => {
			exemplarCity => q#စစ်ကာ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#စိန့်ဘာသည်လီမိုင်#,
		},
		'America/St_Johns' => {
			exemplarCity => q#စိန့်ဂျွန်းစ်#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#စိန့်ကိစ်#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#စိန့်လူစီအာ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#စိန့်သောမားစ်#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#စိန့်ဗင်းဆင့်#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#စဝီ(ဘ်)ကာရင့်#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#တီဂူစီဂလ်ပါ#,
		},
		'America/Thule' => {
			exemplarCity => q#သုလီ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#သံဒါဘေး#,
		},
		'America/Tijuana' => {
			exemplarCity => q#တီဂျုအာနာ#,
		},
		'America/Toronto' => {
			exemplarCity => q#တိုရွန်တို#,
		},
		'America/Tortola' => {
			exemplarCity => q#တောတိုလာ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ဗင်ခူဘာ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ဝိုက်(တ်)ဟိုစ်#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ဝီနီဗက်ဂ်#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ရာကုတတ်#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ရဲလိုနိုင်ဖ်#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(အလယ်ပိုင်း အမေရိက နွေရာသီ အချိန်),
				'generic' => q(အလယ်ပိုင်း အမေရိက အချိန်),
				'standard' => q(အလယ်ပိုင်း အမေရိက စံတော်ချိန်),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(အရှေ့ပိုင်း အမေရိက နေ့ပိုင်း အချိန်),
				'generic' => q(အရှေ့ပိုင်း အမေရိက အချိန်),
				'standard' => q(အရှေ့ပိုင်း အမေရိက စံတော်ချိန်),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(အမေရိက တောင် နေ့ပိုင်း အချိန်),
				'generic' => q(အမေရိက တောင် အချိန်),
				'standard' => q(အမေရိက တောင် စံတော်ချိန်),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(ပစိဖိတ် နေ့ပိုင်း အချိန်),
				'generic' => q(ပစိဖိတ် အချိန်),
				'standard' => q(ပစိဖိတ် စံတော်ချိန်),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ကေစီ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ဒေးဗစ်#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ဒူးမော့တ် ဒါရ်ဗီးလ်#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#မခွါရီး#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#မော်စွန်#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#မက်မူဒိုး#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ပါလ်မာ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ရိုသီရာ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ရှိုးဝါ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ထရိုလ်#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ဗိုစ်တိုခ်#,
		},
		'Apia' => {
			long => {
				'daylight' => q(အပီယာနေ့ပိုင်းအချိန်),
				'generic' => q(အပီယာအချိန်),
				'standard' => q(အပီယာစံတော်ချိန်),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(အာရေဗျ နေ့ပိုင်း အချိန်),
				'generic' => q(အာရေဗျ အချိန်),
				'standard' => q(အာရေဗျ စံတော်ချိန်),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#လောင်ရီယားဘရံ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(အာဂျင်တီးနား နွေရာသီ အချိန်),
				'generic' => q(အာဂျင်တီးနား အချိန်),
				'standard' => q(အာဂျင်တီးနား စံတော်ချိန်),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(အနောက် အာဂျင်တီးနား နွေရာသီ အချိန်),
				'generic' => q(အနောက် အာဂျင်တီးနား အချိန်),
				'standard' => q(အနောက် အာဂျင်တီးနား စံတော်ချိန်),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(အာမေနီးယား နွေရာသီ အချိန်),
				'generic' => q(အာမေနီးယား အချိန်),
				'standard' => q(အာမေနီးယား စံတော်ချိန်),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#အာဒင်#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#အော်မာတီ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#အာမာန်း#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#အန်အာဒီအာ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#အက်တာဥု#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#အာခ်တူးဘီ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#အာရှ်ဂါဘာဒ်#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ဘက်ဂဒက်#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ဘာရိန်း#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ဘာခူး#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ဘန်ကောက်#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ဘေရု#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ဘီရှ်ခက်#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ဘရူနိုင်း#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ကိုလ်ကာတာ#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ချီတာ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ချွဲဘောဆန်#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ကိုလံဘို#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ဒါးမားစ်ကတ်စ်#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ဒက္ကာ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ဒစ်လီ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ဒူဘိုင်း#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ဒူရှောန်းဘာ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ဂါဇာ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ဟီဘရွန်#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ဟောင်ကောင်#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ဟိုးဗ်#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#အီရူခူတ်#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ဂျာကာတာ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ဂျာရာပူရာ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ဂျေရုစလန်#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ကာဘူလ်#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ခမ်ချာ့ခါ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ကာရာချီ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ခတ္တမန္ဒူ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ခန်ဒိုင်ဂါ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ခရာ့စ်နိုရာစ်#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ကွာလာလမ်ပူ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ကူချင်#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ကူဝိတ်#,
		},
		'Asia/Macau' => {
			exemplarCity => q#မာကာအို#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#မာဂါဒန်း#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#မခက်စ်ဆာ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#မနီလာ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#မတ်စ်ကက်တ်#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#နီခိုစီးအား#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#နိုဗိုခူဇ်နက်စ်#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#နိုဗိုစဲဘီအဲယ်စ်#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#အွမ်းစ်ခ်#,
		},
		'Asia/Oral' => {
			exemplarCity => q#အောရဲယ်#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ပနွမ်ဖင်#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ပွန်တီအားနာ့ခ်#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ပြုံယန်း#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ကာတာ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ခွီဇိုင်လိုဒါ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ရန်ကုန်#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ရီယားဒ်#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ဟိုချီမင်#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#စဲက်ခါလီးင်#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ဆမ်းမာခန်းဒ်#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ဆိုးလ်#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ရှန်ဟိုင်း#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#စင်္ဂပူ#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ဆရီနီကိုလူ့ဇ်#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ထိုင်ပေ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#တာရှ်ကဲန့်#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#တဘီးလီစီ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#တီရန်#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#တင်ဖူး#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#တိုကျို#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ဥလန်ဘာတော#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#အီရင်ချီး#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#အူးစ် နီရား#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ဗီအင်ချမ်#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ဗလာဒါဗိုစ်တိုခ်#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ယူခူးတ်စ်#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ရယ်ခါးတီရင်ဘားခ်#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ရဲယ်ရေဗန်း#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(အတ္ထလန်တစ် နေ့ပိုင်း အချိန်),
				'generic' => q(အတ္ထလန်တစ် အချိန်),
				'standard' => q(အတ္ထလန်တစ် စံတော်ချိန်),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#အာဇိုးစ်#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ဘာမူဒါ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ကာနာရီ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ကိတ်ဗာဒု#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ဖဲရို#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#မဒီးရာ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ရေးခဗခ့်#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#စောက်ဂျိုဂျီရာ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#စိန့်ဟီလီနာ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#စတန်လီ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#အန္ဒီလိတ်ဒ်#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ဘရစ္စဘိန်း#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ဘရိုကင်ဟီးလ်#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ကာရီ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ဒေါဝင်#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ယူးခလာ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ဟိုးဘားတ်#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#လင်းဒီမန်း#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#လော့ဒ် ဟောင်#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#မယ်လ်ဘွန်း#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ပါးသ်#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ဆစ်ဒနီ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(အလယ်ပိုင်း ဩစတြေးလျှား နေ့ပိုင်း အချိန်),
				'generic' => q(အလယ်ဩစတြေးလျှား အချိန်),
				'standard' => q(အလယ်ပိုင်း ဩစတြေးလျှား စံတော်ချိန်),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(အလယ်အနောက်ပိုင်း ဩစတြေးလျှား နေ့ပိုင်း အချိန်),
				'generic' => q(အလယ်အနောက်ပိုင်း ဩစတြေးလျှား အချိန်),
				'standard' => q(အလယ်အနောက်ပိုင်း ဩစတြေးလျှား စံတော်ချိန်),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(အရှေ့ပိုင်း ဩစတြေးလျှား နေ့ပိုင်း အချိန်),
				'generic' => q(အရှေ့ဩစတြေးလျှား အချိန်),
				'standard' => q(အရှေ့ပိုင်း ဩစတြေးလျှား စံတော်ချိန်),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(အနောက်ပိုင်း ဩစတြေးလျှား နေ့ပိုင်း အချိန်),
				'generic' => q(အနောက် ဩစတြေးလျှား အချိန်),
				'standard' => q(အနောက်ပိုင်း ဩစတြေးလျှား စံတော်ချိန်),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(အဇာဘိုင်ဂျန် နွေရာသီ အချိန်),
				'generic' => q(အဇာဘိုင်ဂျန် အချိန်),
				'standard' => q(အဇာဘိုင်ဂျန် စံတော်ချိန်),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(အာဇိုးစ်နွေရာသီအချိန်),
				'generic' => q(အာဇိုးစ်အချိန်),
				'standard' => q(အာဇိုးစ်စံတော်ချိန်),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(ဘင်္ဂလားဒေ့ရှ် နွေရာသီ အချိန်),
				'generic' => q(ဘင်္ဂလားဒေ့ရှ် အချိန်),
				'standard' => q(ဘင်္ဂလားဒေ့ရှ် စံတော်ချိန်),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ဘူတန် အချိန်),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(ဘိုလီးဘီးယား အချိန်),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ဘရာဇီး နွေရာသီ အချိန်),
				'generic' => q(ဘရာဇီး အချိန်),
				'standard' => q(ဘရာဇီး စံတော်ချိန်),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ဘရူနိုင်း စံတော်ချိန်),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(ခေ့ပ်ဗာဒူနွေရာသီအချိန်),
				'generic' => q(ခေ့ပ်ဗာဒူအချိန်),
				'standard' => q(ခေ့ပ်ဗာဒူစံတော်ချိန်),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(ချာမိုရိုအချိန်),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(ချားသမ်နေ့ပိုင်းအချိန်),
				'generic' => q(ချားသမ်အချိန်),
				'standard' => q(ချားသမ်စံတော်ချိန်),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(ချီလီ နွေရာသီ အချိန်),
				'generic' => q(ချီလီ အချိန်),
				'standard' => q(ချီလီ စံတော်ချိန်),
			},
		},
		'China' => {
			long => {
				'daylight' => q(တရုတ် နေ့ပိုင်း အချိန်),
				'generic' => q(တရုတ် အချိန်),
				'standard' => q(တရုတ် စံတော်ချိန်),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(ချွဲဘော်ဆန်းနွေရာသီအချိန်),
				'generic' => q(ချွဲဘော်ဆန်းအချိန်),
				'standard' => q(ချွဲဘော်ဆန်းစံတော်ချိန်),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ခရစ်စမတ်ကျွန်းအချိန်),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(ကိုးကိုးကျွန်းအချိန်),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(ကိုလံဘီယာ နွေရာသီ အချိန်),
				'generic' => q(ကိုလံဘီယာ အချိန်),
				'standard' => q(ကိုလံဘီယာ စံတော်ချိန်),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(ကွတ်က်ကျွန်းစုနွေရာသီအချိန်),
				'generic' => q(ကွတ်ခ်ကျွန်းစုအချိန်),
				'standard' => q(ကွတ်ခ်ကျွန်းစုစံတော်ချိန်),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(ကျူးဘား နေ့ပိုင်းအချိန်),
				'generic' => q(ကျူးဘား အချိန်),
				'standard' => q(ကျူးဘား စံတော်ချိန်),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ဒေးဗစ်အချိန်),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ဒူးမော့တ် ဒါရ်ဗီးလ်အချိန်),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(အရှေ့တီမော အချိန်),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(အီစတာကျွန်းနွေရာသီအချိန်),
				'generic' => q(အီစတာကျွန်းအချိန်),
				'standard' => q(အီစတာကျွန်းစံတော်ချိန်),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(အီကွေဒေါ အချိန်),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#အမည်မသိသောမြို့#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#အမ္စတာဒန်#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#အန်ဒိုရာ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#အေသင်#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ဘဲလ်ဂရိတ်#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ဘာလင်#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ဘရာတီးစ်လားဗာ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ဘရူဆဲလ်#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ဘူချာရက်စ်#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ဘူတာပက်စ်#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ဘူရှင်ဂျင်#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ချီရှီနားအူ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ကိုပါဟေဂန်#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ဒတ်ဘလင်#,
			long => {
				'daylight' => q(အိုင်းရစ်စံတော်ချိန်),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ဂျီဘရော်လ်တာ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ဂွန်းဇီ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ဟဲလ်စင်ကီ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#မန်းကျွန်း#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#အစ္စတန်ဘူလ်#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ဂျဲးအ်ဇီ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ခါလီနင်ဂရက်#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ခီးအက်ဖ်#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#လစ္စဘွန်#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#လူဘလီအားနား#,
		},
		'Europe/London' => {
			exemplarCity => q#လန်ဒန်#,
			long => {
				'daylight' => q(ဗြိတိန်နွေရာသီအချိန်),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#လူဇင်ဘာဂ်#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#မာဒရစ်#,
		},
		'Europe/Malta' => {
			exemplarCity => q#မော်လ်တာ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#မရီအာ ဟားမန်#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#မင်းစခ်#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#မိုနာကို#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#မော့စ်ကို#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#အော့စ်လို#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ပါရီစ်#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ဖို့တ်ဂိုရီစာ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ပါရာဂ်#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ရီဂါ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ရောမ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ဆာမားရာ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ဆန်မရီးနို#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ဆာရာဂျေဗို#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#စင်ဖာရိုးဖို#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#စကော့ပ်ရာ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ဆိုပီအာ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#စတော့ဟုမ်း#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ထားလင်#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#တီရာနီ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ဥဇ်ဂိုရို့တ်#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ဗာဒူးစ်#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ဗာတီကန်#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ဗီအင်နာ#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ဗီးလ်နီအိုးစ်#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ဗိုလ်ဂိုဂရက်#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ဝါဆော#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ဇာဂ်ဂရက်ဘ်#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ဇာဖိုရိုးစ်ဂျာ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ဇူရီချ်#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(ဥရောပ အလယ်ပိုင်း နွေရာသီ အချိန်),
				'generic' => q(ဥရောပအလယ်ပိုင်းအချိန်),
				'standard' => q(ဥရောပ အလယ်ပိုင်း စံတော်ချိန်),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(အရှေ့ဥရောပ နွေရာသီ အချိန်),
				'generic' => q(အရှေ့ဥရောပ အချိန်),
				'standard' => q(အရှေ့ဥရောပ စံတော်ချိန်),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(ထပ်တိုးအရှေ့ပိုင်းဥရောပအချိန်),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(အနောက်ပိုင်း ဥရောပ နွေရာသီ အချိန်),
				'generic' => q(အနောက်ပိုင်း ဥရောပ အချိန်),
				'standard' => q(အနောက်ပိုင်း ဥရောပ စံတော်ချိန်),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ဖောင်ကလန်ကျွန်းစု နွေရာသီ အချိန်),
				'generic' => q(ဖောင်ကလန်ကျွန်းစု အချိန်),
				'standard' => q(ဖောင်ကလန်ကျွန်းစု စံတော်ချိန်),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ဖီဂျီနွေရာသီအချိန်),
				'generic' => q(ဖီဂျီအချိန်),
				'standard' => q(ဖီဂျီစံတော်ချိန်),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ပြင်သစ် ဂီယာနာ အချိန်),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ပြင်သစ်တောင်ပိုင်းနင့်အန္တတစ်အချိန်),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ဂရင်းနစ် စံတော်ချိန်),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(ဂါလားပါဂိုးစ်အချိန်),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(ဂန်ဘီအာအချိန်),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(ဂျော်ဂျီယာ နွေရာသီ အချိန်),
				'generic' => q(ဂျော်ဂျီယာ အချိန်),
				'standard' => q(ဂျော်ဂျီယာ စံတော်ချိန်),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(ဂီလ်ဘတ်ကျွန်းစုအချိန်),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(အရှေ့ဂရင်းလန်း နွေရာသီ အချိန်),
				'generic' => q(အရှေ့ဂရင်းလန်း အချိန်),
				'standard' => q(အရှေ့ဂရင်းလန်း စံတော်ချိန်),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(အနောက် ဂရင်းလန်း နွေရာသီ အချိန်),
				'generic' => q(အနောက် ဂရင်းလန်း အချိန်),
				'standard' => q(အနောက် ဂရင်းလန်း စံတော်ချိန်),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(ပင်လယ်ဂွေ့ အချိန်),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(ဂိုင်ရာနားအချိန်),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ဟာဝိုင်အီ အာလူးရှန်နေ့ပိုင်းအချိန်),
				'generic' => q(ဟာဝိုင်အီ အာလူးရှန်အချိန်),
				'standard' => q(ဟာဝိုင်အီ အာလူးရှန်စံတော်ချိန်),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ဟောင်ကောင် နွေရာသီ အချိန်),
				'generic' => q(ဟောင်ကောင် အချိန်),
				'standard' => q(ဟောင်ကောင် စံတော်ချိန်),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ဟိုးဗ်နွေရာသီအချိန်),
				'generic' => q(ဟိုးဗ်အချိန်),
				'standard' => q(ဟိုးဗ်စံတော်ချိန်),
			},
		},
		'India' => {
			long => {
				'standard' => q(အိန္ဒြိယ စံတော်ချိန်),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#အန်တာနာနာရီးဘို#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ချာဂိုစ်#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ခရစ်စမတ်စ်#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ကိုကိုးစ်#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ကွန်မိုရို#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ခူဂါလန်#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#မာဟီ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#မောလ်ဒီးဖ်စ်#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#မောရီလျာ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#မာရော့တ်#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ရယ်ယူးနယွန်#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(အိန္ဒြိယ သမုဒ္ဒရာ အချိန်),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(အင်ဒိုချိုင်းနား အချိန်),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(အလယ်ပိုင်း အင်ဒိုနီးရှား အချိန်),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(အရှေ့ပိုင်း အင်ဒိုနီးရှား အချိန်),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(အနောက်ပိုင်း အင်ဒိုနီးရှား အချိန်),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(အီရန် နေ့ပိုင်း အချိန်),
				'generic' => q(အီရန် အချိန်),
				'standard' => q(အီရန် စံတော်ချိန်),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(အီရူခူတ်နွေရာသီအချိန်),
				'generic' => q(အီရူခူတ်အချိန်),
				'standard' => q(အီရူခူတ်စံတော်ချိန်),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(အစ္စရေး နေ့ပိုင်း အချိန်),
				'generic' => q(အစ္စရေး အချိန်),
				'standard' => q(အစ္စရေး စံတော်ချိန်),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(ဂျပန် နေ့ပိုင်း အချိန်),
				'generic' => q(ဂျပန် အချိန်),
				'standard' => q(ဂျပန် စံတော်ချိန်),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(အရှေ့ကာဇက်စတန် အချိန်),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(အနောက်ကာဇက်စတန်အချိန်),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(ကိုးရီးယား နေ့ပိုင်း အချိန်),
				'generic' => q(ကိုးရီးယား အချိန်),
				'standard' => q(ကိုးရီးယား စံတော်ချိန်),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(ခိုစ်ရိုင်အချိန်),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(ခရာ့စ်နိုရာစ်နွေရာသီအချိန်),
				'generic' => q(ခရာ့စ်နိုရာစ်အချိန်),
				'standard' => q(ခရာ့စ်နိုရာစ်စံတော်ချိန်),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(ခယ်ကစ်တန်အချိန်),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(သီရိလင်္ကာ အချိန်),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(လိုင်းကျွန်းစုအချိန်),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(လော့ဒ်ဟောင်နေ့ပိုင်းအချိန်),
				'generic' => q(လော့ဒ်ဟောင်အချိန်),
				'standard' => q(လော့ဒ်ဟောင်စံတော်ချိန်),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(မကာအို နွေရာသီ အချိန်),
				'generic' => q(မကာအို အချိန်),
				'standard' => q(မကာအို စံတော်ချိန်),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(မခွါရီးအချိန်),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(မာဂါဒန်းနွေရာသီအချိန်),
				'generic' => q(မာဂါဒန်းအချိန်),
				'standard' => q(မာဂါဒန်းစံတော်ချိန်),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(မလေးရှား အချိန်),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(မောလ်ဒိုင်းဗ်အချိန်),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(မာခေးအပ်စ်အချိန်),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(မာရယ်ကျွန်းစုအချိန်),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(မော်ရေရှားစ်နွေရာသီအချိန်),
				'generic' => q(မော်ရေရှားစ်အချိန်),
				'standard' => q(မော်ရေရှားစ်စံတော်ချိန်),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(မော်စွန်အချိန်),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(အနောက်တောင် မက္ကဆီကို နေ့ပိုင်းအချိန်),
				'generic' => q(အနောက်တောင် မက္ကဆီကို အချိန်),
				'standard' => q(အနောက်တောင် မက္ကဆီကို စံတော်ချိန်),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(မက္ကဆီကန် ပစိဖိတ် နေ့ပိုင်းအချိန်),
				'generic' => q(မက္ကဆီကန် ပစိဖိတ်အချိန်),
				'standard' => q(မက္ကဆီကန် ပစိဖိတ် စံတော်ချိန်),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(ဥလန်ဘာတောနွေရာသီအချိန်),
				'generic' => q(ဥလန်ဘာတောအချိန်),
				'standard' => q(ဥလန်ဘာတောစံတော်ချိန်),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(မော့စ်ကိုနွေရာသီ အချိန်),
				'generic' => q(မော့စ်ကို အချိန်),
				'standard' => q(မော့စ်ကိုစံတော်ချိန်),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(မြန်မာ အချိန်),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(နာဥူရူအချိန်),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(နီပေါ အချိန်),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(နယူးကာလီဒိုးနီးယားနွေရာသီအချိန်),
				'generic' => q(နယူးကာလီဒိုးနီးယားအချိန်),
				'standard' => q(နယူးကာလီဒိုးနီးယားစံတော်ချိန်),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(နယူးဇီလန် နေ့ပိုင်း အချိန်),
				'generic' => q(နယူးဇီလန် အချိန်),
				'standard' => q(နယူးဇီလန် စံတော်ချိန်),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(နယူးဖောင်လန် နေ့ပိုင်း အချိန်),
				'generic' => q(နယူးဖောင်လန် အချိန်),
				'standard' => q(နယူးဖောင်လန် စံတော်ချိန်),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(နီဦးအေအချိန်),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(နောဖော့ခ်ကျွန်းအချိန်),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ဖာနန်ဒိုးဒီနိုးရိုးညာနွေရာသီအချိန်),
				'generic' => q(ဖာနန်ဒိုးဒီနိုးရိုးညာအချိန်),
				'standard' => q(ဖာနန်ဒိုးဒီနိုးရိုးညာစံတော်ချိန်),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(နိုဗိုစဲဘီအဲယ်စ်နွေရာသီအချိန်),
				'generic' => q(နိုဗိုစဲဘီအဲယ်စ်အချိန်),
				'standard' => q(နိုဗိုစဲဘီအဲယ်စ်စံတော်ချိန်),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(အွမ်းစ်ခ်နွေရာသီအချိန်),
				'generic' => q(အွမ်းစ်ခ်အချိန်),
				'standard' => q(အွမ်းစ်ခ်စံတော်ချိန်),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#အားပီအား#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#အော့ကလန်#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ဘူဂန်ဗီးလီးယား#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ချားသမ်#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#အီစတာ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#အီဖာတီ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#အန်ဒါဘူရီ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ဖာခါအိုဖို#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ဖီဂျီ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ဖူနာဖူတီ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ဂါလာပါဂိုစ်#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ဂန်ဘီအာ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ဂွာဒါခယ်နယ်လ်#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ဂူအမ်#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ဟိုနိုလူလူ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ဂျွန်စတန်#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ခရစ့်မားစ်#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ခိုစ်ရိုင်#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ခွာဂျာလိန်#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#မူဂျုးရို#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#မာခေးအပ်စ်#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#မစ်ဒ်ဝေး#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#နာဥူရူ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#နီဦးအေ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#နော်ဖော့ခ်#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#နူမယ်အာ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ဖါငိုဖါငို#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ဖလောင်#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ပိကိန်း#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ဖိုနာဖဲအ်#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ဖို့တ် မိုရက်စ်ဘီ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ရာရိုတွန်းဂါ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ဆိုင်းပန်#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#တာဟီတီ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#တာရာဝါ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#တွန်ဂါတာပု#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ချုခ်#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ဝက်ခ်#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ဝေါလီစ်#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(ပါကစ္စတန် နွေရာသီ အချိန်),
				'generic' => q(ပါကစ္စတန် အချိန်),
				'standard' => q(ပါကစ္စတန် စံတော်ချိန်),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(ဖလောင်အချိန်),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(ပါပူရာနယူးဂီနီ အချိန်),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(ပါရာဂွေး နွေရာသီ အချိန်),
				'generic' => q(ပါရာဂွေး အချိန်),
				'standard' => q(ပါရာဂွေး စံတော်ချိန်),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(ပီရူး နွေရာသီ အချိန်),
				'generic' => q(ပီရူး အချိန်),
				'standard' => q(ပီရူး စံတော်ချိန်),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ဖိလစ်ပိုင် နွေရာသီ အချိန်),
				'generic' => q(ဖိလစ်ပိုင် အချိန်),
				'standard' => q(ဖိလစ်ပိုင် စံတော်ချိန်),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ဖီးနစ်ကျွန်းစုအချိန်),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(စိန့်ပီအဲနှင့်မီခွီလွန်နေ့ပိုင်းအချိန်),
				'generic' => q(စိန့်ပီအဲနှင့်မီခွီလွန်အချိန်),
				'standard' => q(စိန့်ပီအဲနှင့်မီခွီလွန်စံတော်ချိန်),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(ပိကိန်းအချိန်),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(ဖိုနာဖဲအ်အချိန်),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(ရဲအူနီရွန်အချိန်),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(ရိုသီရာအချိန်),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(စဲက်ခါလီးင်နွေရာသီအချိန်),
				'generic' => q(စဲက်ခါလီင်းအချိန်),
				'standard' => q(စဲက်ခါလီင်းစံတော်ချိန်),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(ဆာမိုအာနေ့အချိန်),
				'generic' => q(ဆာမိုအာအချိန်),
				'standard' => q(ဆာမိုအာစံတော်ချိန်),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(ဆေးရှလ်အချိန်),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(စင်္ကာပူ စံတော်ချိန်),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(ဆိုလိုမွန်ကျွန်းစုအချိန်),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(တောင်ဂျော်ဂျီယာ အချိန်),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(စူးရီနာမ်အချိန်),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(ရှိုဝါအချိန်),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(တာဟီတီအချိန်),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(တိုင်ပေနေ့ပိုင်းအချိန်),
				'generic' => q(တိုင်ပေအချိန်),
				'standard' => q(တိုင်ပေစံတော်ချိန်),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(တာဂျီကစ္စတန်အချိန်),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(တိုကီလာဥ အချိန်),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(တွန်ဂါနွေရာသီအချိန်),
				'generic' => q(တွန်ဂါအချိန်),
				'standard' => q(တွန်ဂါစံတော်ချိန်),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ချုခ်အချိန်),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(တာခ်မီန့စ်တန်နွေရာသီအချိန်),
				'generic' => q(တာခ်မီန့စ်တန်အချိန်),
				'standard' => q(တာခ်မီန့စ်တန်စံတော်ချိန်),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ထူဗာလူအချိန်),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ဥရုဂွေး နွေရာသီ အချိန်),
				'generic' => q(ဥရုဂွေး အချိန်),
				'standard' => q(ဥရုဂွေး စံတော်ချိန်),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ဥဘက်ကစ္စတန် နွေရာသီ အချိန်),
				'generic' => q(ဥဘက်ကစ္စတန် အချိန်),
				'standard' => q(ဥဘက်ကစ္စတန် စံတော်ချိန်),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(ဗာနုအာတူနွေရာသီအချိန်),
				'generic' => q(ဗာနုအာတူအချိန်),
				'standard' => q(ဗာနုအာတူစံတော်ချိန်),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(ဗင်နီဇွဲလား အချိန်),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ဗလာဒါဗိုစ်တိုခ်နွေရာသီအချိန်),
				'generic' => q(ဗလာဒါဗိုစ်တိုခ်အချိန်),
				'standard' => q(ဗလာဒါဗိုစ်တိုခ်စံတော်ချိန်),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(ဗိုလ်ဂိုဂရက်နွေရာသီအချိန်),
				'generic' => q(ဗိုလ်ဂိုဂရက်အချိန်),
				'standard' => q(ဗိုလ်ဂိုဂရက်စံတော်ချိန်),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ဗိုစ်တိုခ်အချိန်),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ဝိတ်ခ်ကျွန်းအချိန်),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(ဝေါလီစ်နှင့်),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(ယူခူးတ်စ်နွေရာသီအချိန်),
				'generic' => q(ယူခူးတ်စ်အချိန်),
				'standard' => q(ယူခူးတ်စ်စံတော်ချိန်),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ရယ်ခါးတီရင်ဘာခ်နွေရာသီအချိန်),
				'generic' => q(ရယ်ခါးတီရင်ဘားခ်အချိန်),
				'standard' => q(ရယ်ခါးတီရင်ဘားခ်စံတော်ချိန်),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
