# -*- perl -*-
# t/06distance.t - Test Geo::SpaceManager distance
use Test::More tests => 2049;
use Geo::SpaceManager;
use blib;
use strict;
use warnings;

use Test::Number::Delta relative => 1e-6;
my $sm = Geo::SpaceManager->new([0, 0, 5, 5]);
delta_ok( $sm->distance( [0,0], [3,4] ), 5 );

delta_ok( $sm->distance( [0,0,1,1], [0,0,1,1] ), 0 );
delta_ok( $sm->distance( [0,0], [0,0,1,1] ), 0 );
delta_ok( $sm->distance( [0,0,1,1], [0,0] ), 0 );
delta_ok( $sm->distance( [0,0], [0,0] ), 0 );
delta_ok( $sm->distance( [0,0,1,1], [0,0,1,1] ), 0 );
delta_ok( $sm->distance( [0,0], [0,0,1,1] ), 0 );
delta_ok( $sm->distance( [0,0,1,1], [0,0] ), 0 );
delta_ok( $sm->distance( [0,0], [0,0] ), 0 );
delta_ok( $sm->distance( [0,0,1,1], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [0,0], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [0,0,1,1], [0,1] ), 1 );
delta_ok( $sm->distance( [0,0], [0,1] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [0,0,1,1] ), 1 );
delta_ok( $sm->distance( [0,1], [0,0,1,1] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [0,0] ), 1 );
delta_ok( $sm->distance( [0,1], [0,0] ), 1 );
delta_ok( $sm->distance( [0,0,1,1], [0,2,1,3] ), 2 );
delta_ok( $sm->distance( [0,0], [0,2,1,3] ), 2 );
delta_ok( $sm->distance( [0,0,1,1], [0,2] ), 2 );
delta_ok( $sm->distance( [0,0], [0,2] ), 2 );
delta_ok( $sm->distance( [0,2,1,3], [0,0,1,1] ), 2 );
delta_ok( $sm->distance( [0,2], [0,0,1,1] ), 2 );
delta_ok( $sm->distance( [0,2,1,3], [0,0] ), 2 );
delta_ok( $sm->distance( [0,2], [0,0] ), 2 );
delta_ok( $sm->distance( [0,0,1,1], [0,3,1,4] ), 3 );
delta_ok( $sm->distance( [0,0], [0,3,1,4] ), 3 );
delta_ok( $sm->distance( [0,0,1,1], [0,3] ), 3 );
delta_ok( $sm->distance( [0,0], [0,3] ), 3 );
delta_ok( $sm->distance( [0,3,1,4], [0,0,1,1] ), 3 );
delta_ok( $sm->distance( [0,3], [0,0,1,1] ), 3 );
delta_ok( $sm->distance( [0,3,1,4], [0,0] ), 3 );
delta_ok( $sm->distance( [0,3], [0,0] ), 3 );
delta_ok( $sm->distance( [0,0,1,1], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [0,0], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [0,0,1,1], [1,0] ), 1 );
delta_ok( $sm->distance( [0,0], [1,0] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [0,0,1,1] ), 1 );
delta_ok( $sm->distance( [1,0], [0,0,1,1] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [0,0] ), 1 );
delta_ok( $sm->distance( [1,0], [0,0] ), 1 );
delta_ok( $sm->distance( [0,0,1,1], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,0], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,0,1,1], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,0], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [0,0,1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [0,0,1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [0,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [0,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,0,1,1], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0,1,1], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [0,0,1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [0,0,1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [0,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [0,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0,1,1], [1,3,2,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0], [1,3,2,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0,1,1], [1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0], [1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3,2,4], [0,0,1,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3], [0,0,1,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3,2,4], [0,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3], [0,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0,1,1], [2,0,3,1] ), 2 );
delta_ok( $sm->distance( [0,0], [2,0,3,1] ), 2 );
delta_ok( $sm->distance( [0,0,1,1], [2,0] ), 2 );
delta_ok( $sm->distance( [0,0], [2,0] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [0,0,1,1] ), 2 );
delta_ok( $sm->distance( [2,0], [0,0,1,1] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [0,0] ), 2 );
delta_ok( $sm->distance( [2,0], [0,0] ), 2 );
delta_ok( $sm->distance( [0,0,1,1], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0,1,1], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [0,0,1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [0,0,1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [0,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [0,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0,1,1], [2,2,3,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,0], [2,2,3,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,0,1,1], [2,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,0], [2,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,2,3,3], [0,0,1,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,2], [0,0,1,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,2,3,3], [0,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,2], [0,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,0,1,1], [2,3,3,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0], [2,3,3,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0,1,1], [2,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0], [2,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,3,3,4], [0,0,1,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,3], [0,0,1,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,3,3,4], [0,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,3], [0,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0,1,1], [3,0,4,1] ), 3 );
delta_ok( $sm->distance( [0,0], [3,0,4,1] ), 3 );
delta_ok( $sm->distance( [0,0,1,1], [3,0] ), 3 );
delta_ok( $sm->distance( [0,0], [3,0] ), 3 );
delta_ok( $sm->distance( [3,0,4,1], [0,0,1,1] ), 3 );
delta_ok( $sm->distance( [3,0], [0,0,1,1] ), 3 );
delta_ok( $sm->distance( [3,0,4,1], [0,0] ), 3 );
delta_ok( $sm->distance( [3,0], [0,0] ), 3 );
delta_ok( $sm->distance( [0,0,1,1], [3,1,4,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0], [3,1,4,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0,1,1], [3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0], [3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1,4,2], [0,0,1,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1], [0,0,1,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1,4,2], [0,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1], [0,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0,1,1], [3,2,4,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0], [3,2,4,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0,1,1], [3,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0], [3,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,2,4,3], [0,0,1,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,2], [0,0,1,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,2,4,3], [0,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,2], [0,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0,1,1], [3,3,4,4] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,0], [3,3,4,4] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,0,1,1], [3,3] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,0], [3,3] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,3,4,4], [0,0,1,1] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,3], [0,0,1,1] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,3,4,4], [0,0] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,3], [0,0] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,1,1,2], [0,0,1,1] ), 1 );
delta_ok( $sm->distance( [0,1], [0,0,1,1] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [0,0] ), 1 );
delta_ok( $sm->distance( [0,1], [0,0] ), 1 );
delta_ok( $sm->distance( [0,0,1,1], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [0,0], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [0,0,1,1], [0,1] ), 1 );
delta_ok( $sm->distance( [0,0], [0,1] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [0,1,1,2] ), 0 );
delta_ok( $sm->distance( [0,1], [0,1,1,2] ), 0 );
delta_ok( $sm->distance( [0,1,1,2], [0,1] ), 0 );
delta_ok( $sm->distance( [0,1], [0,1] ), 0 );
delta_ok( $sm->distance( [0,1,1,2], [0,1,1,2] ), 0 );
delta_ok( $sm->distance( [0,1], [0,1,1,2] ), 0 );
delta_ok( $sm->distance( [0,1,1,2], [0,1] ), 0 );
delta_ok( $sm->distance( [0,1], [0,1] ), 0 );
delta_ok( $sm->distance( [0,1,1,2], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [0,1], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [0,2] ), 1 );
delta_ok( $sm->distance( [0,1], [0,2] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [0,2], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [0,1] ), 1 );
delta_ok( $sm->distance( [0,2], [0,1] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [0,3,1,4] ), 2 );
delta_ok( $sm->distance( [0,1], [0,3,1,4] ), 2 );
delta_ok( $sm->distance( [0,1,1,2], [0,3] ), 2 );
delta_ok( $sm->distance( [0,1], [0,3] ), 2 );
delta_ok( $sm->distance( [0,3,1,4], [0,1,1,2] ), 2 );
delta_ok( $sm->distance( [0,3], [0,1,1,2] ), 2 );
delta_ok( $sm->distance( [0,3,1,4], [0,1] ), 2 );
delta_ok( $sm->distance( [0,3], [0,1] ), 2 );
delta_ok( $sm->distance( [0,1,1,2], [1,0,2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1], [1,0,2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1,1,2], [1,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1], [1,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0,2,1], [0,1,1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0], [0,1,1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0,2,1], [0,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0], [0,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1,1,2], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [0,1], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [1,1] ), 1 );
delta_ok( $sm->distance( [0,1], [1,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [1,1], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [0,1] ), 1 );
delta_ok( $sm->distance( [1,1], [0,1] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1,1,2], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [0,1,1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [0,1,1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [0,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [0,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1,1,2], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,1,3,2] ), 2 );
delta_ok( $sm->distance( [0,1], [2,1,3,2] ), 2 );
delta_ok( $sm->distance( [0,1,1,2], [2,1] ), 2 );
delta_ok( $sm->distance( [0,1], [2,1] ), 2 );
delta_ok( $sm->distance( [2,1,3,2], [0,1,1,2] ), 2 );
delta_ok( $sm->distance( [2,1], [0,1,1,2] ), 2 );
delta_ok( $sm->distance( [2,1,3,2], [0,1] ), 2 );
delta_ok( $sm->distance( [2,1], [0,1] ), 2 );
delta_ok( $sm->distance( [0,1,1,2], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,3,3,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,1], [2,3,3,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,1,1,2], [2,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,1], [2,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,3,3,4], [0,1,1,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,3], [0,1,1,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,3,3,4], [0,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,3], [0,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,1,1,2], [3,0,4,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1], [3,0,4,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1,1,2], [3,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1], [3,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0,4,1], [0,1,1,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0], [0,1,1,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0,4,1], [0,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0], [0,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1,1,2], [3,1,4,2] ), 3 );
delta_ok( $sm->distance( [0,1], [3,1,4,2] ), 3 );
delta_ok( $sm->distance( [0,1,1,2], [3,1] ), 3 );
delta_ok( $sm->distance( [0,1], [3,1] ), 3 );
delta_ok( $sm->distance( [3,1,4,2], [0,1,1,2] ), 3 );
delta_ok( $sm->distance( [3,1], [0,1,1,2] ), 3 );
delta_ok( $sm->distance( [3,1,4,2], [0,1] ), 3 );
delta_ok( $sm->distance( [3,1], [0,1] ), 3 );
delta_ok( $sm->distance( [0,1,1,2], [3,2,4,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1], [3,2,4,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1,1,2], [3,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1], [3,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2,4,3], [0,1,1,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2], [0,1,1,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2,4,3], [0,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2], [0,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1,1,2], [3,3,4,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,1], [3,3,4,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,1,1,2], [3,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,1], [3,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3,4,4], [0,1,1,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3], [0,1,1,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3,4,4], [0,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3], [0,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2,1,3], [0,0,1,1] ), 2 );
delta_ok( $sm->distance( [0,2], [0,0,1,1] ), 2 );
delta_ok( $sm->distance( [0,2,1,3], [0,0] ), 2 );
delta_ok( $sm->distance( [0,2], [0,0] ), 2 );
delta_ok( $sm->distance( [0,0,1,1], [0,2,1,3] ), 2 );
delta_ok( $sm->distance( [0,0], [0,2,1,3] ), 2 );
delta_ok( $sm->distance( [0,0,1,1], [0,2] ), 2 );
delta_ok( $sm->distance( [0,0], [0,2] ), 2 );
delta_ok( $sm->distance( [0,2,1,3], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [0,2], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [0,1] ), 1 );
delta_ok( $sm->distance( [0,2], [0,1] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [0,1], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [0,2] ), 1 );
delta_ok( $sm->distance( [0,1], [0,2] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [0,2,1,3] ), 0 );
delta_ok( $sm->distance( [0,2], [0,2,1,3] ), 0 );
delta_ok( $sm->distance( [0,2,1,3], [0,2] ), 0 );
delta_ok( $sm->distance( [0,2], [0,2] ), 0 );
delta_ok( $sm->distance( [0,2,1,3], [0,2,1,3] ), 0 );
delta_ok( $sm->distance( [0,2], [0,2,1,3] ), 0 );
delta_ok( $sm->distance( [0,2,1,3], [0,2] ), 0 );
delta_ok( $sm->distance( [0,2], [0,2] ), 0 );
delta_ok( $sm->distance( [0,2,1,3], [0,3,1,4] ), 1 );
delta_ok( $sm->distance( [0,2], [0,3,1,4] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [0,3] ), 1 );
delta_ok( $sm->distance( [0,2], [0,3] ), 1 );
delta_ok( $sm->distance( [0,3,1,4], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [0,3], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [0,3,1,4], [0,2] ), 1 );
delta_ok( $sm->distance( [0,3], [0,2] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2,1,3], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [0,2,1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [0,2,1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [0,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [0,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2,1,3], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [0,2], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [1,2] ), 1 );
delta_ok( $sm->distance( [0,2], [1,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [1,2], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [0,2] ), 1 );
delta_ok( $sm->distance( [1,2], [0,2] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [1,3,2,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2], [1,3,2,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2,1,3], [1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2], [1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3,2,4], [0,2,1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3], [0,2,1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3,2,4], [0,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3], [0,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2,1,3], [2,0,3,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,2], [2,0,3,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,2,1,3], [2,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,2], [2,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,0,3,1], [0,2,1,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,0], [0,2,1,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,0,3,1], [0,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,0], [0,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,2,1,3], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [2,2,3,3] ), 2 );
delta_ok( $sm->distance( [0,2], [2,2,3,3] ), 2 );
delta_ok( $sm->distance( [0,2,1,3], [2,2] ), 2 );
delta_ok( $sm->distance( [0,2], [2,2] ), 2 );
delta_ok( $sm->distance( [2,2,3,3], [0,2,1,3] ), 2 );
delta_ok( $sm->distance( [2,2], [0,2,1,3] ), 2 );
delta_ok( $sm->distance( [2,2,3,3], [0,2] ), 2 );
delta_ok( $sm->distance( [2,2], [0,2] ), 2 );
delta_ok( $sm->distance( [0,2,1,3], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [3,0,4,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2], [3,0,4,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2,1,3], [3,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2], [3,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0,4,1], [0,2,1,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0], [0,2,1,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0,4,1], [0,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0], [0,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2,1,3], [3,1,4,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2], [3,1,4,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2,1,3], [3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2], [3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1,4,2], [0,2,1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1], [0,2,1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1,4,2], [0,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1], [0,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2,1,3], [3,2,4,3] ), 3 );
delta_ok( $sm->distance( [0,2], [3,2,4,3] ), 3 );
delta_ok( $sm->distance( [0,2,1,3], [3,2] ), 3 );
delta_ok( $sm->distance( [0,2], [3,2] ), 3 );
delta_ok( $sm->distance( [3,2,4,3], [0,2,1,3] ), 3 );
delta_ok( $sm->distance( [3,2], [0,2,1,3] ), 3 );
delta_ok( $sm->distance( [3,2,4,3], [0,2] ), 3 );
delta_ok( $sm->distance( [3,2], [0,2] ), 3 );
delta_ok( $sm->distance( [0,2,1,3], [3,3,4,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2], [3,3,4,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2,1,3], [3,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2], [3,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3,4,4], [0,2,1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3], [0,2,1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3,4,4], [0,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3], [0,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [0,0,1,1] ), 3 );
delta_ok( $sm->distance( [0,3], [0,0,1,1] ), 3 );
delta_ok( $sm->distance( [0,3,1,4], [0,0] ), 3 );
delta_ok( $sm->distance( [0,3], [0,0] ), 3 );
delta_ok( $sm->distance( [0,0,1,1], [0,3,1,4] ), 3 );
delta_ok( $sm->distance( [0,0], [0,3,1,4] ), 3 );
delta_ok( $sm->distance( [0,0,1,1], [0,3] ), 3 );
delta_ok( $sm->distance( [0,0], [0,3] ), 3 );
delta_ok( $sm->distance( [0,3,1,4], [0,1,1,2] ), 2 );
delta_ok( $sm->distance( [0,3], [0,1,1,2] ), 2 );
delta_ok( $sm->distance( [0,3,1,4], [0,1] ), 2 );
delta_ok( $sm->distance( [0,3], [0,1] ), 2 );
delta_ok( $sm->distance( [0,1,1,2], [0,3,1,4] ), 2 );
delta_ok( $sm->distance( [0,1], [0,3,1,4] ), 2 );
delta_ok( $sm->distance( [0,1,1,2], [0,3] ), 2 );
delta_ok( $sm->distance( [0,1], [0,3] ), 2 );
delta_ok( $sm->distance( [0,3,1,4], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [0,3], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [0,3,1,4], [0,2] ), 1 );
delta_ok( $sm->distance( [0,3], [0,2] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [0,3,1,4] ), 1 );
delta_ok( $sm->distance( [0,2], [0,3,1,4] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [0,3] ), 1 );
delta_ok( $sm->distance( [0,2], [0,3] ), 1 );
delta_ok( $sm->distance( [0,3,1,4], [0,3,1,4] ), 0 );
delta_ok( $sm->distance( [0,3], [0,3,1,4] ), 0 );
delta_ok( $sm->distance( [0,3,1,4], [0,3] ), 0 );
delta_ok( $sm->distance( [0,3], [0,3] ), 0 );
delta_ok( $sm->distance( [0,3,1,4], [0,3,1,4] ), 0 );
delta_ok( $sm->distance( [0,3], [0,3,1,4] ), 0 );
delta_ok( $sm->distance( [0,3,1,4], [0,3] ), 0 );
delta_ok( $sm->distance( [0,3], [0,3] ), 0 );
delta_ok( $sm->distance( [0,3,1,4], [1,0,2,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3], [1,0,2,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [1,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3], [1,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0,2,1], [0,3,1,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0], [0,3,1,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0,2,1], [0,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0], [0,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3,1,4], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [0,3,1,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [0,3,1,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [0,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [0,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3,1,4], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,3], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,3,1,4], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,3], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [0,3,1,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [0,3,1,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [0,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [0,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,3,1,4], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [0,3], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [0,3,1,4], [1,3] ), 1 );
delta_ok( $sm->distance( [0,3], [1,3] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [0,3,1,4] ), 1 );
delta_ok( $sm->distance( [1,3], [0,3,1,4] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [0,3] ), 1 );
delta_ok( $sm->distance( [1,3], [0,3] ), 1 );
delta_ok( $sm->distance( [0,3,1,4], [2,0,3,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3], [2,0,3,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3,1,4], [2,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3], [2,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,0,3,1], [0,3,1,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,0], [0,3,1,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,0,3,1], [0,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,0], [0,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3,1,4], [2,1,3,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,3], [2,1,3,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,3,1,4], [2,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,3], [2,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,1,3,2], [0,3,1,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,1], [0,3,1,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,1,3,2], [0,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,1], [0,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,3,1,4], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3,1,4], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [0,3,1,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [0,3,1,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [0,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [0,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3,1,4], [2,3,3,4] ), 2 );
delta_ok( $sm->distance( [0,3], [2,3,3,4] ), 2 );
delta_ok( $sm->distance( [0,3,1,4], [2,3] ), 2 );
delta_ok( $sm->distance( [0,3], [2,3] ), 2 );
delta_ok( $sm->distance( [2,3,3,4], [0,3,1,4] ), 2 );
delta_ok( $sm->distance( [2,3], [0,3,1,4] ), 2 );
delta_ok( $sm->distance( [2,3,3,4], [0,3] ), 2 );
delta_ok( $sm->distance( [2,3], [0,3] ), 2 );
delta_ok( $sm->distance( [0,3,1,4], [3,0,4,1] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,3], [3,0,4,1] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,3,1,4], [3,0] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,3], [3,0] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,0,4,1], [0,3,1,4] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,0], [0,3,1,4] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,0,4,1], [0,3] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,0], [0,3] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,3,1,4], [3,1,4,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3], [3,1,4,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3,1,4], [3,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3], [3,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,1,4,2], [0,3,1,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,1], [0,3,1,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,1,4,2], [0,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,1], [0,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3,1,4], [3,2,4,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3], [3,2,4,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [3,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3], [3,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2,4,3], [0,3,1,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2], [0,3,1,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2,4,3], [0,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2], [0,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [3,3,4,4] ), 3 );
delta_ok( $sm->distance( [0,3], [3,3,4,4] ), 3 );
delta_ok( $sm->distance( [0,3,1,4], [3,3] ), 3 );
delta_ok( $sm->distance( [0,3], [3,3] ), 3 );
delta_ok( $sm->distance( [3,3,4,4], [0,3,1,4] ), 3 );
delta_ok( $sm->distance( [3,3], [0,3,1,4] ), 3 );
delta_ok( $sm->distance( [3,3,4,4], [0,3] ), 3 );
delta_ok( $sm->distance( [3,3], [0,3] ), 3 );
delta_ok( $sm->distance( [1,0,2,1], [0,0,1,1] ), 1 );
delta_ok( $sm->distance( [1,0], [0,0,1,1] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [0,0] ), 1 );
delta_ok( $sm->distance( [1,0], [0,0] ), 1 );
delta_ok( $sm->distance( [0,0,1,1], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [0,0], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [0,0,1,1], [1,0] ), 1 );
delta_ok( $sm->distance( [0,0], [1,0] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [0,1,1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0], [0,1,1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0,2,1], [0,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0], [0,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1,1,2], [1,0,2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1], [1,0,2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1,1,2], [1,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1], [1,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0,2,1], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [0,3,1,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0], [0,3,1,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0,2,1], [0,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0], [0,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [1,0,2,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3], [1,0,2,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [1,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3], [1,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0,2,1], [1,0,2,1] ), 0 );
delta_ok( $sm->distance( [1,0], [1,0,2,1] ), 0 );
delta_ok( $sm->distance( [1,0,2,1], [1,0] ), 0 );
delta_ok( $sm->distance( [1,0], [1,0] ), 0 );
delta_ok( $sm->distance( [1,0,2,1], [1,0,2,1] ), 0 );
delta_ok( $sm->distance( [1,0], [1,0,2,1] ), 0 );
delta_ok( $sm->distance( [1,0,2,1], [1,0] ), 0 );
delta_ok( $sm->distance( [1,0], [1,0] ), 0 );
delta_ok( $sm->distance( [1,0,2,1], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [1,0], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [1,1] ), 1 );
delta_ok( $sm->distance( [1,0], [1,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [1,1], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [1,0] ), 1 );
delta_ok( $sm->distance( [1,1], [1,0] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [1,2,2,3] ), 2 );
delta_ok( $sm->distance( [1,0], [1,2,2,3] ), 2 );
delta_ok( $sm->distance( [1,0,2,1], [1,2] ), 2 );
delta_ok( $sm->distance( [1,0], [1,2] ), 2 );
delta_ok( $sm->distance( [1,2,2,3], [1,0,2,1] ), 2 );
delta_ok( $sm->distance( [1,2], [1,0,2,1] ), 2 );
delta_ok( $sm->distance( [1,2,2,3], [1,0] ), 2 );
delta_ok( $sm->distance( [1,2], [1,0] ), 2 );
delta_ok( $sm->distance( [1,0,2,1], [1,3,2,4] ), 3 );
delta_ok( $sm->distance( [1,0], [1,3,2,4] ), 3 );
delta_ok( $sm->distance( [1,0,2,1], [1,3] ), 3 );
delta_ok( $sm->distance( [1,0], [1,3] ), 3 );
delta_ok( $sm->distance( [1,3,2,4], [1,0,2,1] ), 3 );
delta_ok( $sm->distance( [1,3], [1,0,2,1] ), 3 );
delta_ok( $sm->distance( [1,3,2,4], [1,0] ), 3 );
delta_ok( $sm->distance( [1,3], [1,0] ), 3 );
delta_ok( $sm->distance( [1,0,2,1], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [1,0], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [2,0] ), 1 );
delta_ok( $sm->distance( [1,0], [2,0] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [2,0], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [1,0] ), 1 );
delta_ok( $sm->distance( [2,0], [1,0] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0,2,1], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [1,0,2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [1,0,2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [1,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [1,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0,2,1], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [2,3,3,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0], [2,3,3,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0,2,1], [2,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0], [2,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3,3,4], [1,0,2,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3], [1,0,2,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3,3,4], [1,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3], [1,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0,2,1], [3,0,4,1] ), 2 );
delta_ok( $sm->distance( [1,0], [3,0,4,1] ), 2 );
delta_ok( $sm->distance( [1,0,2,1], [3,0] ), 2 );
delta_ok( $sm->distance( [1,0], [3,0] ), 2 );
delta_ok( $sm->distance( [3,0,4,1], [1,0,2,1] ), 2 );
delta_ok( $sm->distance( [3,0], [1,0,2,1] ), 2 );
delta_ok( $sm->distance( [3,0,4,1], [1,0] ), 2 );
delta_ok( $sm->distance( [3,0], [1,0] ), 2 );
delta_ok( $sm->distance( [1,0,2,1], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [3,2,4,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,0], [3,2,4,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,0,2,1], [3,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,0], [3,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,2,4,3], [1,0,2,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,2], [1,0,2,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,2,4,3], [1,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,2], [1,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,0,2,1], [3,3,4,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,0], [3,3,4,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,0,2,1], [3,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,0], [3,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3,4,4], [1,0,2,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3], [1,0,2,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3,4,4], [1,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3], [1,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,1,2,2], [0,0,1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [0,0,1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [0,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [0,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,0,1,1], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,0], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,0,1,1], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,0], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [1,1], [0,1,1,2] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [0,1] ), 1 );
delta_ok( $sm->distance( [1,1], [0,1] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [0,1], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [0,1,1,2], [1,1] ), 1 );
delta_ok( $sm->distance( [0,1], [1,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [0,2,1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [0,2,1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [0,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [0,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2,1,3], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2,1,3], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [0,3,1,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [0,3,1,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [0,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [0,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3,1,4], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3,1,4], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [1,1], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [1,0] ), 1 );
delta_ok( $sm->distance( [1,1], [1,0] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [1,0], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [1,1] ), 1 );
delta_ok( $sm->distance( [1,0], [1,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [1,1,2,2] ), 0 );
delta_ok( $sm->distance( [1,1], [1,1,2,2] ), 0 );
delta_ok( $sm->distance( [1,1,2,2], [1,1] ), 0 );
delta_ok( $sm->distance( [1,1], [1,1] ), 0 );
delta_ok( $sm->distance( [1,1,2,2], [1,1,2,2] ), 0 );
delta_ok( $sm->distance( [1,1], [1,1,2,2] ), 0 );
delta_ok( $sm->distance( [1,1,2,2], [1,1] ), 0 );
delta_ok( $sm->distance( [1,1], [1,1] ), 0 );
delta_ok( $sm->distance( [1,1,2,2], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [1,1], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [1,2] ), 1 );
delta_ok( $sm->distance( [1,1], [1,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [1,2], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [1,1] ), 1 );
delta_ok( $sm->distance( [1,2], [1,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [1,3,2,4] ), 2 );
delta_ok( $sm->distance( [1,1], [1,3,2,4] ), 2 );
delta_ok( $sm->distance( [1,1,2,2], [1,3] ), 2 );
delta_ok( $sm->distance( [1,1], [1,3] ), 2 );
delta_ok( $sm->distance( [1,3,2,4], [1,1,2,2] ), 2 );
delta_ok( $sm->distance( [1,3], [1,1,2,2] ), 2 );
delta_ok( $sm->distance( [1,3,2,4], [1,1] ), 2 );
delta_ok( $sm->distance( [1,3], [1,1] ), 2 );
delta_ok( $sm->distance( [1,1,2,2], [2,0,3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [2,0,3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [2,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [2,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0,3,1], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0,3,1], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [1,1], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [2,1] ), 1 );
delta_ok( $sm->distance( [1,1], [2,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [2,1], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [1,1] ), 1 );
delta_ok( $sm->distance( [2,1], [1,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,0,4,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [3,0,4,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [3,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0,4,1], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0,4,1], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,1,4,2] ), 2 );
delta_ok( $sm->distance( [1,1], [3,1,4,2] ), 2 );
delta_ok( $sm->distance( [1,1,2,2], [3,1] ), 2 );
delta_ok( $sm->distance( [1,1], [3,1] ), 2 );
delta_ok( $sm->distance( [3,1,4,2], [1,1,2,2] ), 2 );
delta_ok( $sm->distance( [3,1], [1,1,2,2] ), 2 );
delta_ok( $sm->distance( [3,1,4,2], [1,1] ), 2 );
delta_ok( $sm->distance( [3,1], [1,1] ), 2 );
delta_ok( $sm->distance( [1,1,2,2], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,3,4,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,1], [3,3,4,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,1,2,2], [3,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,1], [3,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,3,4,4], [1,1,2,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,3], [1,1,2,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,3,4,4], [1,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,3], [1,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2,2,3], [0,0,1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [0,0,1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [0,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [0,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0,1,1], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0,1,1], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [0,1,1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [0,1,1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [0,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [0,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1,1,2], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1,1,2], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,1], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [1,2], [0,2,1,3] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [0,2] ), 1 );
delta_ok( $sm->distance( [1,2], [0,2] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [0,2], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [0,2,1,3], [1,2] ), 1 );
delta_ok( $sm->distance( [0,2], [1,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [0,3,1,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [0,3,1,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [0,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [0,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,3,1,4], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,3], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,3,1,4], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,3], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [1,0,2,1] ), 2 );
delta_ok( $sm->distance( [1,2], [1,0,2,1] ), 2 );
delta_ok( $sm->distance( [1,2,2,3], [1,0] ), 2 );
delta_ok( $sm->distance( [1,2], [1,0] ), 2 );
delta_ok( $sm->distance( [1,0,2,1], [1,2,2,3] ), 2 );
delta_ok( $sm->distance( [1,0], [1,2,2,3] ), 2 );
delta_ok( $sm->distance( [1,0,2,1], [1,2] ), 2 );
delta_ok( $sm->distance( [1,0], [1,2] ), 2 );
delta_ok( $sm->distance( [1,2,2,3], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [1,2], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [1,1] ), 1 );
delta_ok( $sm->distance( [1,2], [1,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [1,1], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [1,2] ), 1 );
delta_ok( $sm->distance( [1,1], [1,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [1,2,2,3] ), 0 );
delta_ok( $sm->distance( [1,2], [1,2,2,3] ), 0 );
delta_ok( $sm->distance( [1,2,2,3], [1,2] ), 0 );
delta_ok( $sm->distance( [1,2], [1,2] ), 0 );
delta_ok( $sm->distance( [1,2,2,3], [1,2,2,3] ), 0 );
delta_ok( $sm->distance( [1,2], [1,2,2,3] ), 0 );
delta_ok( $sm->distance( [1,2,2,3], [1,2] ), 0 );
delta_ok( $sm->distance( [1,2], [1,2] ), 0 );
delta_ok( $sm->distance( [1,2,2,3], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [1,2], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [1,3] ), 1 );
delta_ok( $sm->distance( [1,2], [1,3] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [1,3], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [1,2] ), 1 );
delta_ok( $sm->distance( [1,3], [1,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [1,2], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [2,2] ), 1 );
delta_ok( $sm->distance( [1,2], [2,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [2,2], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [1,2] ), 1 );
delta_ok( $sm->distance( [2,2], [1,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [2,3,3,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [2,3,3,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [3,0,4,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2], [3,0,4,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2,2,3], [3,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2], [3,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,0,4,1], [1,2,2,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,0], [1,2,2,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,0,4,1], [1,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,0], [1,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2,2,3], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [3,2,4,3] ), 2 );
delta_ok( $sm->distance( [1,2], [3,2,4,3] ), 2 );
delta_ok( $sm->distance( [1,2,2,3], [3,2] ), 2 );
delta_ok( $sm->distance( [1,2], [3,2] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [1,2,2,3] ), 2 );
delta_ok( $sm->distance( [3,2], [1,2,2,3] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [1,2] ), 2 );
delta_ok( $sm->distance( [3,2], [1,2] ), 2 );
delta_ok( $sm->distance( [1,2,2,3], [3,3,4,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [3,3,4,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3,4,4], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3,4,4], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [0,0,1,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3], [0,0,1,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3,2,4], [0,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3], [0,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0,1,1], [1,3,2,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0], [1,3,2,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0,1,1], [1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0], [1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3,2,4], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [0,2,1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3], [0,2,1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3,2,4], [0,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3], [0,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2,1,3], [1,3,2,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2], [1,3,2,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2,1,3], [1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [0,2], [1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3,2,4], [0,3,1,4] ), 1 );
delta_ok( $sm->distance( [1,3], [0,3,1,4] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [0,3] ), 1 );
delta_ok( $sm->distance( [1,3], [0,3] ), 1 );
delta_ok( $sm->distance( [0,3,1,4], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [0,3], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [0,3,1,4], [1,3] ), 1 );
delta_ok( $sm->distance( [0,3], [1,3] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [1,0,2,1] ), 3 );
delta_ok( $sm->distance( [1,3], [1,0,2,1] ), 3 );
delta_ok( $sm->distance( [1,3,2,4], [1,0] ), 3 );
delta_ok( $sm->distance( [1,3], [1,0] ), 3 );
delta_ok( $sm->distance( [1,0,2,1], [1,3,2,4] ), 3 );
delta_ok( $sm->distance( [1,0], [1,3,2,4] ), 3 );
delta_ok( $sm->distance( [1,0,2,1], [1,3] ), 3 );
delta_ok( $sm->distance( [1,0], [1,3] ), 3 );
delta_ok( $sm->distance( [1,3,2,4], [1,1,2,2] ), 2 );
delta_ok( $sm->distance( [1,3], [1,1,2,2] ), 2 );
delta_ok( $sm->distance( [1,3,2,4], [1,1] ), 2 );
delta_ok( $sm->distance( [1,3], [1,1] ), 2 );
delta_ok( $sm->distance( [1,1,2,2], [1,3,2,4] ), 2 );
delta_ok( $sm->distance( [1,1], [1,3,2,4] ), 2 );
delta_ok( $sm->distance( [1,1,2,2], [1,3] ), 2 );
delta_ok( $sm->distance( [1,1], [1,3] ), 2 );
delta_ok( $sm->distance( [1,3,2,4], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [1,3], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [1,2] ), 1 );
delta_ok( $sm->distance( [1,3], [1,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [1,2], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [1,3] ), 1 );
delta_ok( $sm->distance( [1,2], [1,3] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [1,3,2,4] ), 0 );
delta_ok( $sm->distance( [1,3], [1,3,2,4] ), 0 );
delta_ok( $sm->distance( [1,3,2,4], [1,3] ), 0 );
delta_ok( $sm->distance( [1,3], [1,3] ), 0 );
delta_ok( $sm->distance( [1,3,2,4], [1,3,2,4] ), 0 );
delta_ok( $sm->distance( [1,3], [1,3,2,4] ), 0 );
delta_ok( $sm->distance( [1,3,2,4], [1,3] ), 0 );
delta_ok( $sm->distance( [1,3], [1,3] ), 0 );
delta_ok( $sm->distance( [1,3,2,4], [2,0,3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3], [2,0,3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3,2,4], [2,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3], [2,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0,3,1], [1,3,2,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0], [1,3,2,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0,3,1], [1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0], [1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3,2,4], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3,2,4], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [1,3,2,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [1,3,2,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3,2,4], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [1,3], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [2,3] ), 1 );
delta_ok( $sm->distance( [1,3], [2,3] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [2,3], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [1,3] ), 1 );
delta_ok( $sm->distance( [2,3], [1,3] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [3,0,4,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,3], [3,0,4,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,3,2,4], [3,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,3], [3,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0,4,1], [1,3,2,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0], [1,3,2,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0,4,1], [1,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0], [1,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,3,2,4], [3,1,4,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,3], [3,1,4,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,3,2,4], [3,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,3], [3,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,1,4,2], [1,3,2,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,1], [1,3,2,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,1,4,2], [1,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,1], [1,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,3,2,4], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [3,3,4,4] ), 2 );
delta_ok( $sm->distance( [1,3], [3,3,4,4] ), 2 );
delta_ok( $sm->distance( [1,3,2,4], [3,3] ), 2 );
delta_ok( $sm->distance( [1,3], [3,3] ), 2 );
delta_ok( $sm->distance( [3,3,4,4], [1,3,2,4] ), 2 );
delta_ok( $sm->distance( [3,3], [1,3,2,4] ), 2 );
delta_ok( $sm->distance( [3,3,4,4], [1,3] ), 2 );
delta_ok( $sm->distance( [3,3], [1,3] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [0,0,1,1] ), 2 );
delta_ok( $sm->distance( [2,0], [0,0,1,1] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [0,0] ), 2 );
delta_ok( $sm->distance( [2,0], [0,0] ), 2 );
delta_ok( $sm->distance( [0,0,1,1], [2,0,3,1] ), 2 );
delta_ok( $sm->distance( [0,0], [2,0,3,1] ), 2 );
delta_ok( $sm->distance( [0,0,1,1], [2,0] ), 2 );
delta_ok( $sm->distance( [0,0], [2,0] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [0,2,1,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,0], [0,2,1,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,0,3,1], [0,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,0], [0,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,2,1,3], [2,0,3,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,2], [2,0,3,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,2,1,3], [2,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,2], [2,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,0,3,1], [0,3,1,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,0], [0,3,1,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,0,3,1], [0,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,0], [0,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3,1,4], [2,0,3,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3], [2,0,3,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3,1,4], [2,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3], [2,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,0,3,1], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [2,0], [1,0,2,1] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [1,0] ), 1 );
delta_ok( $sm->distance( [2,0], [1,0] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [1,0], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [1,0,2,1], [2,0] ), 1 );
delta_ok( $sm->distance( [1,0], [2,0] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0,3,1], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [2,0,3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [2,0,3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [2,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [2,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0,3,1], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [1,3,2,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0], [1,3,2,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0,3,1], [1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0], [1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3,2,4], [2,0,3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3], [2,0,3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3,2,4], [2,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,3], [2,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0,3,1], [2,0,3,1] ), 0 );
delta_ok( $sm->distance( [2,0], [2,0,3,1] ), 0 );
delta_ok( $sm->distance( [2,0,3,1], [2,0] ), 0 );
delta_ok( $sm->distance( [2,0], [2,0] ), 0 );
delta_ok( $sm->distance( [2,0,3,1], [2,0,3,1] ), 0 );
delta_ok( $sm->distance( [2,0], [2,0,3,1] ), 0 );
delta_ok( $sm->distance( [2,0,3,1], [2,0] ), 0 );
delta_ok( $sm->distance( [2,0], [2,0] ), 0 );
delta_ok( $sm->distance( [2,0,3,1], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [2,0], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [2,1] ), 1 );
delta_ok( $sm->distance( [2,0], [2,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [2,1], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [2,0] ), 1 );
delta_ok( $sm->distance( [2,1], [2,0] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [2,2,3,3] ), 2 );
delta_ok( $sm->distance( [2,0], [2,2,3,3] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [2,2] ), 2 );
delta_ok( $sm->distance( [2,0], [2,2] ), 2 );
delta_ok( $sm->distance( [2,2,3,3], [2,0,3,1] ), 2 );
delta_ok( $sm->distance( [2,2], [2,0,3,1] ), 2 );
delta_ok( $sm->distance( [2,2,3,3], [2,0] ), 2 );
delta_ok( $sm->distance( [2,2], [2,0] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [2,3,3,4] ), 3 );
delta_ok( $sm->distance( [2,0], [2,3,3,4] ), 3 );
delta_ok( $sm->distance( [2,0,3,1], [2,3] ), 3 );
delta_ok( $sm->distance( [2,0], [2,3] ), 3 );
delta_ok( $sm->distance( [2,3,3,4], [2,0,3,1] ), 3 );
delta_ok( $sm->distance( [2,3], [2,0,3,1] ), 3 );
delta_ok( $sm->distance( [2,3,3,4], [2,0] ), 3 );
delta_ok( $sm->distance( [2,3], [2,0] ), 3 );
delta_ok( $sm->distance( [2,0,3,1], [3,0,4,1] ), 1 );
delta_ok( $sm->distance( [2,0], [3,0,4,1] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [3,0] ), 1 );
delta_ok( $sm->distance( [2,0], [3,0] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [3,0], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [2,0] ), 1 );
delta_ok( $sm->distance( [3,0], [2,0] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [3,1,4,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0], [3,1,4,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0,3,1], [3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0], [3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1,4,2], [2,0,3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1], [2,0,3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1,4,2], [2,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1], [2,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0,3,1], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [3,3,4,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0], [3,3,4,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0,3,1], [3,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0], [3,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3,4,4], [2,0,3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3], [2,0,3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3,4,4], [2,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3], [2,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,1,3,2], [0,0,1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [0,0,1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [0,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [0,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0,1,1], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0,1,1], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,0], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [0,1,1,2] ), 2 );
delta_ok( $sm->distance( [2,1], [0,1,1,2] ), 2 );
delta_ok( $sm->distance( [2,1,3,2], [0,1] ), 2 );
delta_ok( $sm->distance( [2,1], [0,1] ), 2 );
delta_ok( $sm->distance( [0,1,1,2], [2,1,3,2] ), 2 );
delta_ok( $sm->distance( [0,1], [2,1,3,2] ), 2 );
delta_ok( $sm->distance( [0,1,1,2], [2,1] ), 2 );
delta_ok( $sm->distance( [0,1], [2,1] ), 2 );
delta_ok( $sm->distance( [2,1,3,2], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [0,3,1,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,1], [0,3,1,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,1,3,2], [0,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,1], [0,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,3,1,4], [2,1,3,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,3], [2,1,3,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,3,1,4], [2,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,3], [2,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,1,3,2], [1,0,2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [1,0,2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [1,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [1,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0,2,1], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0,2,1], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,0], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [2,1], [1,1,2,2] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [1,1] ), 1 );
delta_ok( $sm->distance( [2,1], [1,1] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [1,1], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [1,1,2,2], [2,1] ), 1 );
delta_ok( $sm->distance( [1,1], [2,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [2,1], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [2,0] ), 1 );
delta_ok( $sm->distance( [2,1], [2,0] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [2,0], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [2,1] ), 1 );
delta_ok( $sm->distance( [2,0], [2,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [2,1,3,2] ), 0 );
delta_ok( $sm->distance( [2,1], [2,1,3,2] ), 0 );
delta_ok( $sm->distance( [2,1,3,2], [2,1] ), 0 );
delta_ok( $sm->distance( [2,1], [2,1] ), 0 );
delta_ok( $sm->distance( [2,1,3,2], [2,1,3,2] ), 0 );
delta_ok( $sm->distance( [2,1], [2,1,3,2] ), 0 );
delta_ok( $sm->distance( [2,1,3,2], [2,1] ), 0 );
delta_ok( $sm->distance( [2,1], [2,1] ), 0 );
delta_ok( $sm->distance( [2,1,3,2], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [2,1], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [2,2] ), 1 );
delta_ok( $sm->distance( [2,1], [2,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [2,2], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [2,1] ), 1 );
delta_ok( $sm->distance( [2,2], [2,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [2,3,3,4] ), 2 );
delta_ok( $sm->distance( [2,1], [2,3,3,4] ), 2 );
delta_ok( $sm->distance( [2,1,3,2], [2,3] ), 2 );
delta_ok( $sm->distance( [2,1], [2,3] ), 2 );
delta_ok( $sm->distance( [2,3,3,4], [2,1,3,2] ), 2 );
delta_ok( $sm->distance( [2,3], [2,1,3,2] ), 2 );
delta_ok( $sm->distance( [2,3,3,4], [2,1] ), 2 );
delta_ok( $sm->distance( [2,3], [2,1] ), 2 );
delta_ok( $sm->distance( [2,1,3,2], [3,0,4,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [3,0,4,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [3,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [3,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,0,4,1], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,0], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,0,4,1], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,0], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [2,1], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [3,1] ), 1 );
delta_ok( $sm->distance( [2,1], [3,1] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [3,1], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [2,1] ), 1 );
delta_ok( $sm->distance( [3,1], [2,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [3,2,4,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [3,2,4,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2,4,3], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2,4,3], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [3,3,4,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [3,3,4,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3,4,4], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3,4,4], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [0,0,1,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,2], [0,0,1,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,2,3,3], [0,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,2], [0,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,0,1,1], [2,2,3,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,0], [2,2,3,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,0,1,1], [2,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,0], [2,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,2,3,3], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [0,1,1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [0,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1,1,2], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,1], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [0,2,1,3] ), 2 );
delta_ok( $sm->distance( [2,2], [0,2,1,3] ), 2 );
delta_ok( $sm->distance( [2,2,3,3], [0,2] ), 2 );
delta_ok( $sm->distance( [2,2], [0,2] ), 2 );
delta_ok( $sm->distance( [0,2,1,3], [2,2,3,3] ), 2 );
delta_ok( $sm->distance( [0,2], [2,2,3,3] ), 2 );
delta_ok( $sm->distance( [0,2,1,3], [2,2] ), 2 );
delta_ok( $sm->distance( [0,2], [2,2] ), 2 );
delta_ok( $sm->distance( [2,2,3,3], [0,3,1,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [0,3,1,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [0,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [0,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3,1,4], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3,1,4], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,3], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [1,1,2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [1,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1,2,2], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,1], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [2,2], [1,2,2,3] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [1,2] ), 1 );
delta_ok( $sm->distance( [2,2], [1,2] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [1,2], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [1,2,2,3], [2,2] ), 1 );
delta_ok( $sm->distance( [1,2], [2,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [1,3,2,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [1,3,2,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [1,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3,2,4], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3,2,4], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,3], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [2,0,3,1] ), 2 );
delta_ok( $sm->distance( [2,2], [2,0,3,1] ), 2 );
delta_ok( $sm->distance( [2,2,3,3], [2,0] ), 2 );
delta_ok( $sm->distance( [2,2], [2,0] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [2,2,3,3] ), 2 );
delta_ok( $sm->distance( [2,0], [2,2,3,3] ), 2 );
delta_ok( $sm->distance( [2,0,3,1], [2,2] ), 2 );
delta_ok( $sm->distance( [2,0], [2,2] ), 2 );
delta_ok( $sm->distance( [2,2,3,3], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [2,2], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [2,1] ), 1 );
delta_ok( $sm->distance( [2,2], [2,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [2,1], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [2,2] ), 1 );
delta_ok( $sm->distance( [2,1], [2,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [2,2,3,3] ), 0 );
delta_ok( $sm->distance( [2,2], [2,2,3,3] ), 0 );
delta_ok( $sm->distance( [2,2,3,3], [2,2] ), 0 );
delta_ok( $sm->distance( [2,2], [2,2] ), 0 );
delta_ok( $sm->distance( [2,2,3,3], [2,2,3,3] ), 0 );
delta_ok( $sm->distance( [2,2], [2,2,3,3] ), 0 );
delta_ok( $sm->distance( [2,2,3,3], [2,2] ), 0 );
delta_ok( $sm->distance( [2,2], [2,2] ), 0 );
delta_ok( $sm->distance( [2,2,3,3], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [2,2], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [2,3] ), 1 );
delta_ok( $sm->distance( [2,2], [2,3] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [2,3], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [2,2] ), 1 );
delta_ok( $sm->distance( [2,3], [2,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [3,0,4,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [3,0,4,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [3,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [3,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0,4,1], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0,4,1], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [3,1,4,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [3,1,4,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1,4,2], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1,4,2], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [2,2], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [3,2] ), 1 );
delta_ok( $sm->distance( [2,2], [3,2] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [3,2], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [2,2] ), 1 );
delta_ok( $sm->distance( [3,2], [2,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [3,3,4,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [3,3,4,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,3,4,4], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,3], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,3,4,4], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,3], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [0,0,1,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,3], [0,0,1,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,3,3,4], [0,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,3], [0,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0,1,1], [2,3,3,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0], [2,3,3,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0,1,1], [2,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0], [2,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [2,3,3,4], [0,1,1,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,3], [0,1,1,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,3,3,4], [0,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,3], [0,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,1,1,2], [2,3,3,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,1], [2,3,3,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,1,1,2], [2,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [0,1], [2,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [2,3,3,4], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [0,2,1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [0,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2,1,3], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [0,2], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [0,3,1,4] ), 2 );
delta_ok( $sm->distance( [2,3], [0,3,1,4] ), 2 );
delta_ok( $sm->distance( [2,3,3,4], [0,3] ), 2 );
delta_ok( $sm->distance( [2,3], [0,3] ), 2 );
delta_ok( $sm->distance( [0,3,1,4], [2,3,3,4] ), 2 );
delta_ok( $sm->distance( [0,3], [2,3,3,4] ), 2 );
delta_ok( $sm->distance( [0,3,1,4], [2,3] ), 2 );
delta_ok( $sm->distance( [0,3], [2,3] ), 2 );
delta_ok( $sm->distance( [2,3,3,4], [1,0,2,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3], [1,0,2,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3,3,4], [1,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3], [1,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0,2,1], [2,3,3,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0], [2,3,3,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0,2,1], [2,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [1,0], [2,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3,3,4], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3], [1,2,2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3], [1,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [2,3,3,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [2,3,3,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2,2,3], [2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [1,2], [2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [2,3], [1,3,2,4] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [1,3] ), 1 );
delta_ok( $sm->distance( [2,3], [1,3] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [1,3], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [1,3,2,4], [2,3] ), 1 );
delta_ok( $sm->distance( [1,3], [2,3] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [2,0,3,1] ), 3 );
delta_ok( $sm->distance( [2,3], [2,0,3,1] ), 3 );
delta_ok( $sm->distance( [2,3,3,4], [2,0] ), 3 );
delta_ok( $sm->distance( [2,3], [2,0] ), 3 );
delta_ok( $sm->distance( [2,0,3,1], [2,3,3,4] ), 3 );
delta_ok( $sm->distance( [2,0], [2,3,3,4] ), 3 );
delta_ok( $sm->distance( [2,0,3,1], [2,3] ), 3 );
delta_ok( $sm->distance( [2,0], [2,3] ), 3 );
delta_ok( $sm->distance( [2,3,3,4], [2,1,3,2] ), 2 );
delta_ok( $sm->distance( [2,3], [2,1,3,2] ), 2 );
delta_ok( $sm->distance( [2,3,3,4], [2,1] ), 2 );
delta_ok( $sm->distance( [2,3], [2,1] ), 2 );
delta_ok( $sm->distance( [2,1,3,2], [2,3,3,4] ), 2 );
delta_ok( $sm->distance( [2,1], [2,3,3,4] ), 2 );
delta_ok( $sm->distance( [2,1,3,2], [2,3] ), 2 );
delta_ok( $sm->distance( [2,1], [2,3] ), 2 );
delta_ok( $sm->distance( [2,3,3,4], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [2,3], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [2,2] ), 1 );
delta_ok( $sm->distance( [2,3], [2,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [2,2], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [2,3] ), 1 );
delta_ok( $sm->distance( [2,2], [2,3] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [2,3,3,4] ), 0 );
delta_ok( $sm->distance( [2,3], [2,3,3,4] ), 0 );
delta_ok( $sm->distance( [2,3,3,4], [2,3] ), 0 );
delta_ok( $sm->distance( [2,3], [2,3] ), 0 );
delta_ok( $sm->distance( [2,3,3,4], [2,3,3,4] ), 0 );
delta_ok( $sm->distance( [2,3], [2,3,3,4] ), 0 );
delta_ok( $sm->distance( [2,3,3,4], [2,3] ), 0 );
delta_ok( $sm->distance( [2,3], [2,3] ), 0 );
delta_ok( $sm->distance( [2,3,3,4], [3,0,4,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3], [3,0,4,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3,3,4], [3,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3], [3,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0,4,1], [2,3,3,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0], [2,3,3,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0,4,1], [2,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0], [2,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3,3,4], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [3,2,4,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3], [3,2,4,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3], [3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2,4,3], [2,3,3,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2], [2,3,3,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2,4,3], [2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2], [2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [3,3,4,4] ), 1 );
delta_ok( $sm->distance( [2,3], [3,3,4,4] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [3,3] ), 1 );
delta_ok( $sm->distance( [2,3], [3,3] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [3,3], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [2,3] ), 1 );
delta_ok( $sm->distance( [3,3], [2,3] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [0,0,1,1] ), 3 );
delta_ok( $sm->distance( [3,0], [0,0,1,1] ), 3 );
delta_ok( $sm->distance( [3,0,4,1], [0,0] ), 3 );
delta_ok( $sm->distance( [3,0], [0,0] ), 3 );
delta_ok( $sm->distance( [0,0,1,1], [3,0,4,1] ), 3 );
delta_ok( $sm->distance( [0,0], [3,0,4,1] ), 3 );
delta_ok( $sm->distance( [0,0,1,1], [3,0] ), 3 );
delta_ok( $sm->distance( [0,0], [3,0] ), 3 );
delta_ok( $sm->distance( [3,0,4,1], [0,1,1,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0], [0,1,1,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0,4,1], [0,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0], [0,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1,1,2], [3,0,4,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1], [3,0,4,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1,1,2], [3,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1], [3,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0,4,1], [0,2,1,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0], [0,2,1,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0,4,1], [0,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0], [0,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2,1,3], [3,0,4,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2], [3,0,4,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2,1,3], [3,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,2], [3,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0,4,1], [0,3,1,4] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,0], [0,3,1,4] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,0,4,1], [0,3] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,0], [0,3] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,3,1,4], [3,0,4,1] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,3], [3,0,4,1] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,3,1,4], [3,0] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,3], [3,0] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,0,4,1], [1,0,2,1] ), 2 );
delta_ok( $sm->distance( [3,0], [1,0,2,1] ), 2 );
delta_ok( $sm->distance( [3,0,4,1], [1,0] ), 2 );
delta_ok( $sm->distance( [3,0], [1,0] ), 2 );
delta_ok( $sm->distance( [1,0,2,1], [3,0,4,1] ), 2 );
delta_ok( $sm->distance( [1,0], [3,0,4,1] ), 2 );
delta_ok( $sm->distance( [1,0,2,1], [3,0] ), 2 );
delta_ok( $sm->distance( [1,0], [3,0] ), 2 );
delta_ok( $sm->distance( [3,0,4,1], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0,4,1], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,0,4,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [3,0,4,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [3,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0,4,1], [1,2,2,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,0], [1,2,2,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,0,4,1], [1,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,0], [1,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2,2,3], [3,0,4,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2], [3,0,4,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2,2,3], [3,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,2], [3,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,0,4,1], [1,3,2,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0], [1,3,2,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0,4,1], [1,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0], [1,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,3,2,4], [3,0,4,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,3], [3,0,4,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,3,2,4], [3,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,3], [3,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,0,4,1], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [3,0], [2,0,3,1] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [2,0] ), 1 );
delta_ok( $sm->distance( [3,0], [2,0] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [3,0,4,1] ), 1 );
delta_ok( $sm->distance( [2,0], [3,0,4,1] ), 1 );
delta_ok( $sm->distance( [2,0,3,1], [3,0] ), 1 );
delta_ok( $sm->distance( [2,0], [3,0] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,0], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,0,4,1], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,0], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [3,0,4,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [3,0,4,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [3,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [3,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,0,4,1], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0], [2,2,3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0,4,1], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0], [2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [3,0,4,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [3,0,4,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2,3,3], [3,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,2], [3,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,0,4,1], [2,3,3,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0], [2,3,3,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0,4,1], [2,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0], [2,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3,3,4], [3,0,4,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3], [3,0,4,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3,3,4], [3,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,3], [3,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,0,4,1], [3,0,4,1] ), 0 );
delta_ok( $sm->distance( [3,0], [3,0,4,1] ), 0 );
delta_ok( $sm->distance( [3,0,4,1], [3,0] ), 0 );
delta_ok( $sm->distance( [3,0], [3,0] ), 0 );
delta_ok( $sm->distance( [3,0,4,1], [3,0,4,1] ), 0 );
delta_ok( $sm->distance( [3,0], [3,0,4,1] ), 0 );
delta_ok( $sm->distance( [3,0,4,1], [3,0] ), 0 );
delta_ok( $sm->distance( [3,0], [3,0] ), 0 );
delta_ok( $sm->distance( [3,0,4,1], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [3,0], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [3,1] ), 1 );
delta_ok( $sm->distance( [3,0], [3,1] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [3,0,4,1] ), 1 );
delta_ok( $sm->distance( [3,1], [3,0,4,1] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [3,0] ), 1 );
delta_ok( $sm->distance( [3,1], [3,0] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [3,2,4,3] ), 2 );
delta_ok( $sm->distance( [3,0], [3,2,4,3] ), 2 );
delta_ok( $sm->distance( [3,0,4,1], [3,2] ), 2 );
delta_ok( $sm->distance( [3,0], [3,2] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [3,0,4,1] ), 2 );
delta_ok( $sm->distance( [3,2], [3,0,4,1] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [3,0] ), 2 );
delta_ok( $sm->distance( [3,2], [3,0] ), 2 );
delta_ok( $sm->distance( [3,0,4,1], [3,3,4,4] ), 3 );
delta_ok( $sm->distance( [3,0], [3,3,4,4] ), 3 );
delta_ok( $sm->distance( [3,0,4,1], [3,3] ), 3 );
delta_ok( $sm->distance( [3,0], [3,3] ), 3 );
delta_ok( $sm->distance( [3,3,4,4], [3,0,4,1] ), 3 );
delta_ok( $sm->distance( [3,3], [3,0,4,1] ), 3 );
delta_ok( $sm->distance( [3,3,4,4], [3,0] ), 3 );
delta_ok( $sm->distance( [3,3], [3,0] ), 3 );
delta_ok( $sm->distance( [3,1,4,2], [0,0,1,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1], [0,0,1,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1,4,2], [0,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1], [0,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0,1,1], [3,1,4,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0], [3,1,4,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0,1,1], [3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,0], [3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1,4,2], [0,1,1,2] ), 3 );
delta_ok( $sm->distance( [3,1], [0,1,1,2] ), 3 );
delta_ok( $sm->distance( [3,1,4,2], [0,1] ), 3 );
delta_ok( $sm->distance( [3,1], [0,1] ), 3 );
delta_ok( $sm->distance( [0,1,1,2], [3,1,4,2] ), 3 );
delta_ok( $sm->distance( [0,1], [3,1,4,2] ), 3 );
delta_ok( $sm->distance( [0,1,1,2], [3,1] ), 3 );
delta_ok( $sm->distance( [0,1], [3,1] ), 3 );
delta_ok( $sm->distance( [3,1,4,2], [0,2,1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1], [0,2,1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1,4,2], [0,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1], [0,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2,1,3], [3,1,4,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2], [3,1,4,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2,1,3], [3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2], [3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,1,4,2], [0,3,1,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,1], [0,3,1,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,1,4,2], [0,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,1], [0,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3,1,4], [3,1,4,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3], [3,1,4,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3,1,4], [3,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,3], [3,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,1,4,2], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [1,0,2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [1,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0,2,1], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,0], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [1,1,2,2] ), 2 );
delta_ok( $sm->distance( [3,1], [1,1,2,2] ), 2 );
delta_ok( $sm->distance( [3,1,4,2], [1,1] ), 2 );
delta_ok( $sm->distance( [3,1], [1,1] ), 2 );
delta_ok( $sm->distance( [1,1,2,2], [3,1,4,2] ), 2 );
delta_ok( $sm->distance( [1,1], [3,1,4,2] ), 2 );
delta_ok( $sm->distance( [1,1,2,2], [3,1] ), 2 );
delta_ok( $sm->distance( [1,1], [3,1] ), 2 );
delta_ok( $sm->distance( [3,1,4,2], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [1,3,2,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,1], [1,3,2,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,1,4,2], [1,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,1], [1,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,3,2,4], [3,1,4,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,3], [3,1,4,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,3,2,4], [3,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,3], [3,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,1,4,2], [2,0,3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1], [2,0,3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1,4,2], [2,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1], [2,0] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0,3,1], [3,1,4,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0], [3,1,4,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0,3,1], [3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,0], [3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1,4,2], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [3,1], [2,1,3,2] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [2,1] ), 1 );
delta_ok( $sm->distance( [3,1], [2,1] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [2,1], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [2,1,3,2], [3,1] ), 1 );
delta_ok( $sm->distance( [2,1], [3,1] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1,4,2], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [3,1,4,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [3,1,4,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [3,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,1,4,2], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [2,3,3,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1], [2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [3,1,4,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3,3,4], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,3], [3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,1,4,2], [3,0,4,1] ), 1 );
delta_ok( $sm->distance( [3,1], [3,0,4,1] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [3,0] ), 1 );
delta_ok( $sm->distance( [3,1], [3,0] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [3,0], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [3,0,4,1], [3,1] ), 1 );
delta_ok( $sm->distance( [3,0], [3,1] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [3,1,4,2] ), 0 );
delta_ok( $sm->distance( [3,1], [3,1,4,2] ), 0 );
delta_ok( $sm->distance( [3,1,4,2], [3,1] ), 0 );
delta_ok( $sm->distance( [3,1], [3,1] ), 0 );
delta_ok( $sm->distance( [3,1,4,2], [3,1,4,2] ), 0 );
delta_ok( $sm->distance( [3,1], [3,1,4,2] ), 0 );
delta_ok( $sm->distance( [3,1,4,2], [3,1] ), 0 );
delta_ok( $sm->distance( [3,1], [3,1] ), 0 );
delta_ok( $sm->distance( [3,1,4,2], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [3,1], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [3,2] ), 1 );
delta_ok( $sm->distance( [3,1], [3,2] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [3,2], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [3,1] ), 1 );
delta_ok( $sm->distance( [3,2], [3,1] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [3,3,4,4] ), 2 );
delta_ok( $sm->distance( [3,1], [3,3,4,4] ), 2 );
delta_ok( $sm->distance( [3,1,4,2], [3,3] ), 2 );
delta_ok( $sm->distance( [3,1], [3,3] ), 2 );
delta_ok( $sm->distance( [3,3,4,4], [3,1,4,2] ), 2 );
delta_ok( $sm->distance( [3,3], [3,1,4,2] ), 2 );
delta_ok( $sm->distance( [3,3,4,4], [3,1] ), 2 );
delta_ok( $sm->distance( [3,3], [3,1] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [0,0,1,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,2], [0,0,1,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,2,4,3], [0,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,2], [0,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0,1,1], [3,2,4,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0], [3,2,4,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0,1,1], [3,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,0], [3,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,2,4,3], [0,1,1,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2], [0,1,1,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2,4,3], [0,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2], [0,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1,1,2], [3,2,4,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1], [3,2,4,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1,1,2], [3,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,1], [3,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2,4,3], [0,2,1,3] ), 3 );
delta_ok( $sm->distance( [3,2], [0,2,1,3] ), 3 );
delta_ok( $sm->distance( [3,2,4,3], [0,2] ), 3 );
delta_ok( $sm->distance( [3,2], [0,2] ), 3 );
delta_ok( $sm->distance( [0,2,1,3], [3,2,4,3] ), 3 );
delta_ok( $sm->distance( [0,2], [3,2,4,3] ), 3 );
delta_ok( $sm->distance( [0,2,1,3], [3,2] ), 3 );
delta_ok( $sm->distance( [0,2], [3,2] ), 3 );
delta_ok( $sm->distance( [3,2,4,3], [0,3,1,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2], [0,3,1,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2,4,3], [0,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2], [0,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [3,2,4,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3], [3,2,4,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3,1,4], [3,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,3], [3,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,2,4,3], [1,0,2,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,2], [1,0,2,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,2,4,3], [1,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,2], [1,0] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,0,2,1], [3,2,4,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,0], [3,2,4,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,0,2,1], [3,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,0], [3,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,2,4,3], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [1,1,2,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [1,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1,2,2], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,1], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [1,2,2,3] ), 2 );
delta_ok( $sm->distance( [3,2], [1,2,2,3] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [1,2] ), 2 );
delta_ok( $sm->distance( [3,2], [1,2] ), 2 );
delta_ok( $sm->distance( [1,2,2,3], [3,2,4,3] ), 2 );
delta_ok( $sm->distance( [1,2], [3,2,4,3] ), 2 );
delta_ok( $sm->distance( [1,2,2,3], [3,2] ), 2 );
delta_ok( $sm->distance( [1,2], [3,2] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [1,3,2,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [1,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3,2,4], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,3], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [2,0,3,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2], [2,0] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [3,2,4,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0,3,1], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,0], [3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,2,4,3], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2], [2,1,3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2,4,3], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2], [2,1] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [3,2,4,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [3,2,4,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1,3,2], [3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,1], [3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2,4,3], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [3,2], [2,2,3,3] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [2,2] ), 1 );
delta_ok( $sm->distance( [3,2], [2,2] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [2,2], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [2,2,3,3], [3,2] ), 1 );
delta_ok( $sm->distance( [2,2], [3,2] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [2,3,3,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2], [2,3,3,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2,4,3], [2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2], [2,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [3,2,4,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3], [3,2,4,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3,3,4], [3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,3], [3,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,2,4,3], [3,0,4,1] ), 2 );
delta_ok( $sm->distance( [3,2], [3,0,4,1] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [3,0] ), 2 );
delta_ok( $sm->distance( [3,2], [3,0] ), 2 );
delta_ok( $sm->distance( [3,0,4,1], [3,2,4,3] ), 2 );
delta_ok( $sm->distance( [3,0], [3,2,4,3] ), 2 );
delta_ok( $sm->distance( [3,0,4,1], [3,2] ), 2 );
delta_ok( $sm->distance( [3,0], [3,2] ), 2 );
delta_ok( $sm->distance( [3,2,4,3], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [3,2], [3,1,4,2] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [3,1] ), 1 );
delta_ok( $sm->distance( [3,2], [3,1] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [3,1], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [3,1,4,2], [3,2] ), 1 );
delta_ok( $sm->distance( [3,1], [3,2] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [3,2,4,3] ), 0 );
delta_ok( $sm->distance( [3,2], [3,2,4,3] ), 0 );
delta_ok( $sm->distance( [3,2,4,3], [3,2] ), 0 );
delta_ok( $sm->distance( [3,2], [3,2] ), 0 );
delta_ok( $sm->distance( [3,2,4,3], [3,2,4,3] ), 0 );
delta_ok( $sm->distance( [3,2], [3,2,4,3] ), 0 );
delta_ok( $sm->distance( [3,2,4,3], [3,2] ), 0 );
delta_ok( $sm->distance( [3,2], [3,2] ), 0 );
delta_ok( $sm->distance( [3,2,4,3], [3,3,4,4] ), 1 );
delta_ok( $sm->distance( [3,2], [3,3,4,4] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [3,3] ), 1 );
delta_ok( $sm->distance( [3,2], [3,3] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [3,3], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [3,2] ), 1 );
delta_ok( $sm->distance( [3,3], [3,2] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [0,0,1,1] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,3], [0,0,1,1] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,3,4,4], [0,0] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,3], [0,0] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,0,1,1], [3,3,4,4] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,0], [3,3,4,4] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,0,1,1], [3,3] ), 4.24264068711928 );
delta_ok( $sm->distance( [0,0], [3,3] ), 4.24264068711928 );
delta_ok( $sm->distance( [3,3,4,4], [0,1,1,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3], [0,1,1,2] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3,4,4], [0,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3], [0,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,1,1,2], [3,3,4,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,1], [3,3,4,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,1,1,2], [3,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [0,1], [3,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3,4,4], [0,2,1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3], [0,2,1,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3,4,4], [0,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3], [0,2] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2,1,3], [3,3,4,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2], [3,3,4,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2,1,3], [3,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [0,2], [3,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3,4,4], [0,3,1,4] ), 3 );
delta_ok( $sm->distance( [3,3], [0,3,1,4] ), 3 );
delta_ok( $sm->distance( [3,3,4,4], [0,3] ), 3 );
delta_ok( $sm->distance( [3,3], [0,3] ), 3 );
delta_ok( $sm->distance( [0,3,1,4], [3,3,4,4] ), 3 );
delta_ok( $sm->distance( [0,3], [3,3,4,4] ), 3 );
delta_ok( $sm->distance( [0,3,1,4], [3,3] ), 3 );
delta_ok( $sm->distance( [0,3], [3,3] ), 3 );
delta_ok( $sm->distance( [3,3,4,4], [1,0,2,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3], [1,0,2,1] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3,4,4], [1,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3], [1,0] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,0,2,1], [3,3,4,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,0], [3,3,4,4] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,0,2,1], [3,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [1,0], [3,3] ), 3.60555127546399 );
delta_ok( $sm->distance( [3,3,4,4], [1,1,2,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,3], [1,1,2,2] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,3,4,4], [1,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,3], [1,1] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,1,2,2], [3,3,4,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,1], [3,3,4,4] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,1,2,2], [3,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [1,1], [3,3] ), 2.82842712474619 );
delta_ok( $sm->distance( [3,3,4,4], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3], [1,2,2,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3,4,4], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3], [1,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [3,3,4,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [3,3,4,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2,2,3], [3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [1,2], [3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3,4,4], [1,3,2,4] ), 2 );
delta_ok( $sm->distance( [3,3], [1,3,2,4] ), 2 );
delta_ok( $sm->distance( [3,3,4,4], [1,3] ), 2 );
delta_ok( $sm->distance( [3,3], [1,3] ), 2 );
delta_ok( $sm->distance( [1,3,2,4], [3,3,4,4] ), 2 );
delta_ok( $sm->distance( [1,3], [3,3,4,4] ), 2 );
delta_ok( $sm->distance( [1,3,2,4], [3,3] ), 2 );
delta_ok( $sm->distance( [1,3], [3,3] ), 2 );
delta_ok( $sm->distance( [3,3,4,4], [2,0,3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3], [2,0,3,1] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3,4,4], [2,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3], [2,0] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0,3,1], [3,3,4,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0], [3,3,4,4] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0,3,1], [3,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [2,0], [3,3] ), 3.16227766016838 );
delta_ok( $sm->distance( [3,3,4,4], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3], [2,1,3,2] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3,4,4], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3], [2,1] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [3,3,4,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [3,3,4,4] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1,3,2], [3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [2,1], [3,3] ), 2.23606797749979 );
delta_ok( $sm->distance( [3,3,4,4], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,3], [2,2,3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,3,4,4], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,3], [2,2] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [3,3,4,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [3,3,4,4] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2,3,3], [3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [2,2], [3,3] ), 1.4142135623731 );
delta_ok( $sm->distance( [3,3,4,4], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [3,3], [2,3,3,4] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [2,3] ), 1 );
delta_ok( $sm->distance( [3,3], [2,3] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [3,3,4,4] ), 1 );
delta_ok( $sm->distance( [2,3], [3,3,4,4] ), 1 );
delta_ok( $sm->distance( [2,3,3,4], [3,3] ), 1 );
delta_ok( $sm->distance( [2,3], [3,3] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [3,0,4,1] ), 3 );
delta_ok( $sm->distance( [3,3], [3,0,4,1] ), 3 );
delta_ok( $sm->distance( [3,3,4,4], [3,0] ), 3 );
delta_ok( $sm->distance( [3,3], [3,0] ), 3 );
delta_ok( $sm->distance( [3,0,4,1], [3,3,4,4] ), 3 );
delta_ok( $sm->distance( [3,0], [3,3,4,4] ), 3 );
delta_ok( $sm->distance( [3,0,4,1], [3,3] ), 3 );
delta_ok( $sm->distance( [3,0], [3,3] ), 3 );
delta_ok( $sm->distance( [3,3,4,4], [3,1,4,2] ), 2 );
delta_ok( $sm->distance( [3,3], [3,1,4,2] ), 2 );
delta_ok( $sm->distance( [3,3,4,4], [3,1] ), 2 );
delta_ok( $sm->distance( [3,3], [3,1] ), 2 );
delta_ok( $sm->distance( [3,1,4,2], [3,3,4,4] ), 2 );
delta_ok( $sm->distance( [3,1], [3,3,4,4] ), 2 );
delta_ok( $sm->distance( [3,1,4,2], [3,3] ), 2 );
delta_ok( $sm->distance( [3,1], [3,3] ), 2 );
delta_ok( $sm->distance( [3,3,4,4], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [3,3], [3,2,4,3] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [3,2] ), 1 );
delta_ok( $sm->distance( [3,3], [3,2] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [3,3,4,4] ), 1 );
delta_ok( $sm->distance( [3,2], [3,3,4,4] ), 1 );
delta_ok( $sm->distance( [3,2,4,3], [3,3] ), 1 );
delta_ok( $sm->distance( [3,2], [3,3] ), 1 );
delta_ok( $sm->distance( [3,3,4,4], [3,3,4,4] ), 0 );
delta_ok( $sm->distance( [3,3], [3,3,4,4] ), 0 );
delta_ok( $sm->distance( [3,3,4,4], [3,3] ), 0 );
delta_ok( $sm->distance( [3,3], [3,3] ), 0 );
delta_ok( $sm->distance( [3,3,4,4], [3,3,4,4] ), 0 );
delta_ok( $sm->distance( [3,3], [3,3,4,4] ), 0 );
delta_ok( $sm->distance( [3,3,4,4], [3,3] ), 0 );
delta_ok( $sm->distance( [3,3], [3,3] ), 0 );
