#!/usr/local/bin/perl
# Test Geo::Ellipsoid bearing
use Test::More tests => 325;
use Test::Number::Delta relative => 1e-6;
use Geo::Ellipsoid;
#use blib;
use strict;
use warnings;
my $e = Geo::Ellipsoid->new(units=>'degrees');
my $r;
$r = $e->bearing(-88.000000,0.000000,-88.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,0.000000,-88.000000,90.000000);
delta_within( $r, 134.982543210783, 0.1 );

$r = $e->bearing(-88.000000,0.000000,-88.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,0.000000,-88.000000,270.000000);
delta_within( $r, 225.017456789217, 0.1 );

$r = $e->bearing(-88.000000,0.000000,-88.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,0.000000,0.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,0.000000,0.000000,90.000000);
delta_within( $r, 90.0105511254972, 0.1 );

$r = $e->bearing(-88.000000,0.000000,0.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,0.000000,0.000000,270.000000);
delta_within( $r, 269.989448874503, 0.1 );

$r = $e->bearing(-88.000000,0.000000,0.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,0.000000,88.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,0.000000,88.000000,90.000000);
delta_within( $r, 45.0249253505323, 0.1 );

$r = $e->bearing(-88.000000,0.000000,88.000000,180.000000);
delta_within( $r, 89.9894489641495, 0.1 );

$r = $e->bearing(-88.000000,0.000000,88.000000,270.000000);
delta_within( $r, 314.975074649468, 0.1 );

$r = $e->bearing(-88.000000,0.000000,88.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,90.000000,-88.000000,0.000000);
delta_within( $r, 225.017456789217, 0.1 );

$r = $e->bearing(-88.000000,90.000000,-88.000000,90.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,90.000000,-88.000000,180.000000);
delta_within( $r, 134.982543210783, 0.1 );

$r = $e->bearing(-88.000000,90.000000,-88.000000,270.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,90.000000,-88.000000,360.000000);
delta_within( $r, 225.017456789217, 0.1 );

$r = $e->bearing(-88.000000,90.000000,0.000000,0.000000);
delta_within( $r, 269.989448874503, 0.1 );

$r = $e->bearing(-88.000000,90.000000,0.000000,90.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,90.000000,0.000000,180.000000);
delta_within( $r, 90.0105511254972, 0.1 );

$r = $e->bearing(-88.000000,90.000000,0.000000,270.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,90.000000,0.000000,360.000000);
delta_within( $r, 269.989448874503, 0.1 );

$r = $e->bearing(-88.000000,90.000000,88.000000,0.000000);
delta_within( $r, 314.975074649468, 0.1 );

$r = $e->bearing(-88.000000,90.000000,88.000000,90.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,90.000000,88.000000,180.000000);
delta_within( $r, 45.0249253505323, 0.1 );

$r = $e->bearing(-88.000000,90.000000,88.000000,270.000000);
delta_within( $r, 89.9894489641495, 0.1 );

$r = $e->bearing(-88.000000,90.000000,88.000000,360.000000);
delta_within( $r, 314.975074649468, 0.1 );

$r = $e->bearing(-88.000000,180.000000,-88.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,180.000000,-88.000000,90.000000);
delta_within( $r, 225.017456789217, 0.1 );

$r = $e->bearing(-88.000000,180.000000,-88.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,180.000000,-88.000000,270.000000);
delta_within( $r, 134.982543210783, 0.1 );

$r = $e->bearing(-88.000000,180.000000,-88.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,180.000000,0.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,180.000000,0.000000,90.000000);
delta_within( $r, 269.989448874503, 0.1 );

$r = $e->bearing(-88.000000,180.000000,0.000000,180.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,180.000000,0.000000,270.000000);
delta_within( $r, 90.0105511254972, 0.1 );

$r = $e->bearing(-88.000000,180.000000,0.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,180.000000,88.000000,0.000000);
delta_within( $r, 270.010551035851, 0.1 );

$r = $e->bearing(-88.000000,180.000000,88.000000,90.000000);
delta_within( $r, 314.975074649468, 0.1 );

$r = $e->bearing(-88.000000,180.000000,88.000000,180.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,180.000000,88.000000,270.000000);
delta_within( $r, 45.0249253505323, 0.1 );

$r = $e->bearing(-88.000000,180.000000,88.000000,360.000000);
delta_within( $r, 270.010551035851, 0.1 );

$r = $e->bearing(-88.000000,270.000000,-88.000000,0.000000);
delta_within( $r, 134.982543210783, 0.1 );

$r = $e->bearing(-88.000000,270.000000,-88.000000,90.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,270.000000,-88.000000,180.000000);
delta_within( $r, 225.017456789217, 0.1 );

$r = $e->bearing(-88.000000,270.000000,-88.000000,270.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,270.000000,-88.000000,360.000000);
delta_within( $r, 134.982543210783, 0.1 );

$r = $e->bearing(-88.000000,270.000000,0.000000,0.000000);
delta_within( $r, 90.0105511254972, 0.1 );

$r = $e->bearing(-88.000000,270.000000,0.000000,90.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,270.000000,0.000000,180.000000);
delta_within( $r, 269.989448874503, 0.1 );

$r = $e->bearing(-88.000000,270.000000,0.000000,270.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,270.000000,0.000000,360.000000);
delta_within( $r, 90.0105511254972, 0.1 );

$r = $e->bearing(-88.000000,270.000000,88.000000,0.000000);
delta_within( $r, 45.0249253505323, 0.1 );

$r = $e->bearing(-88.000000,270.000000,88.000000,90.000000);
delta_within( $r, 270.010551035851, 0.1 );

$r = $e->bearing(-88.000000,270.000000,88.000000,180.000000);
delta_within( $r, 314.975074649468, 0.1 );

$r = $e->bearing(-88.000000,270.000000,88.000000,270.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,270.000000,88.000000,360.000000);
delta_within( $r, 45.0249253505323, 0.1 );

$r = $e->bearing(-88.000000,360.000000,-88.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,360.000000,-88.000000,90.000000);
delta_within( $r, 134.982543210783, 0.1 );

$r = $e->bearing(-88.000000,360.000000,-88.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,360.000000,-88.000000,270.000000);
delta_within( $r, 225.017456789217, 0.1 );

$r = $e->bearing(-88.000000,360.000000,-88.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,360.000000,0.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,360.000000,0.000000,90.000000);
delta_within( $r, 90.0105511254972, 0.1 );

$r = $e->bearing(-88.000000,360.000000,0.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(-88.000000,360.000000,0.000000,270.000000);
delta_within( $r, 269.989448874503, 0.1 );

$r = $e->bearing(-88.000000,360.000000,0.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,360.000000,88.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-88.000000,360.000000,88.000000,90.000000);
delta_within( $r, 45.0249253505323, 0.1 );

$r = $e->bearing(-88.000000,360.000000,88.000000,180.000000);
delta_within( $r, 89.9894489641495, 0.1 );

$r = $e->bearing(-88.000000,360.000000,88.000000,270.000000);
delta_within( $r, 314.975074649468, 0.1 );

$r = $e->bearing(-88.000000,360.000000,88.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,0.000000,-88.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,0.000000,-88.000000,90.000000);
delta_within( $r, 177.993277345998, 0.1 );

$r = $e->bearing(0.000000,0.000000,-88.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,0.000000,-88.000000,270.000000);
delta_within( $r, 182.006722654002, 0.1 );

$r = $e->bearing(0.000000,0.000000,-88.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,0.000000,0.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,0.000000,0.000000,90.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,0.000000,0.000000,180.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,0.000000,0.000000,270.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,0.000000,0.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,0.000000,88.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,0.000000,88.000000,90.000000);
delta_within( $r, 2.0067226540021, 0.1 );

$r = $e->bearing(0.000000,0.000000,88.000000,180.000000);
delta_within( $r, 2.45853187196776e-16, 0.1 );

$r = $e->bearing(0.000000,0.000000,88.000000,270.000000);
delta_within( $r, 357.993277345998, 0.1 );

$r = $e->bearing(0.000000,0.000000,88.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,90.000000,-88.000000,0.000000);
delta_within( $r, 182.006722654002, 0.1 );

$r = $e->bearing(0.000000,90.000000,-88.000000,90.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,90.000000,-88.000000,180.000000);
delta_within( $r, 177.993277345998, 0.1 );

$r = $e->bearing(0.000000,90.000000,-88.000000,270.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,90.000000,-88.000000,360.000000);
delta_within( $r, 182.006722654002, 0.1 );

$r = $e->bearing(0.000000,90.000000,0.000000,0.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,90.000000,0.000000,90.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,90.000000,0.000000,180.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,90.000000,0.000000,270.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,90.000000,0.000000,360.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,90.000000,88.000000,0.000000);
delta_within( $r, 357.993277345998, 0.1 );

$r = $e->bearing(0.000000,90.000000,88.000000,90.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,90.000000,88.000000,180.000000);
delta_within( $r, 2.0067226540021, 0.1 );

$r = $e->bearing(0.000000,90.000000,88.000000,270.000000);
delta_within( $r, 2.45853187196776e-16, 0.1 );

$r = $e->bearing(0.000000,90.000000,88.000000,360.000000);
delta_within( $r, 357.993277345998, 0.1 );

$r = $e->bearing(0.000000,180.000000,-88.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,180.000000,-88.000000,90.000000);
delta_within( $r, 182.006722654002, 0.1 );

$r = $e->bearing(0.000000,180.000000,-88.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,180.000000,-88.000000,270.000000);
delta_within( $r, 177.993277345998, 0.1 );

$r = $e->bearing(0.000000,180.000000,-88.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,180.000000,0.000000,0.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,180.000000,0.000000,90.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,180.000000,0.000000,180.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,180.000000,0.000000,270.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,180.000000,0.000000,360.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,180.000000,88.000000,0.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(0.000000,180.000000,88.000000,90.000000);
delta_within( $r, 357.993277345998, 0.1 );

$r = $e->bearing(0.000000,180.000000,88.000000,180.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,180.000000,88.000000,270.000000);
delta_within( $r, 2.0067226540021, 0.1 );

$r = $e->bearing(0.000000,180.000000,88.000000,360.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(0.000000,270.000000,-88.000000,0.000000);
delta_within( $r, 177.993277345998, 0.1 );

$r = $e->bearing(0.000000,270.000000,-88.000000,90.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,270.000000,-88.000000,180.000000);
delta_within( $r, 182.006722654002, 0.1 );

$r = $e->bearing(0.000000,270.000000,-88.000000,270.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,270.000000,-88.000000,360.000000);
delta_within( $r, 177.993277345998, 0.1 );

$r = $e->bearing(0.000000,270.000000,0.000000,0.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,270.000000,0.000000,90.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,270.000000,0.000000,180.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,270.000000,0.000000,270.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,270.000000,0.000000,360.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,270.000000,88.000000,0.000000);
delta_within( $r, 2.0067226540021, 0.1 );

$r = $e->bearing(0.000000,270.000000,88.000000,90.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(0.000000,270.000000,88.000000,180.000000);
delta_within( $r, 357.993277345998, 0.1 );

$r = $e->bearing(0.000000,270.000000,88.000000,270.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,270.000000,88.000000,360.000000);
delta_within( $r, 2.0067226540021, 0.1 );

$r = $e->bearing(0.000000,360.000000,-88.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,360.000000,-88.000000,90.000000);
delta_within( $r, 177.993277345998, 0.1 );

$r = $e->bearing(0.000000,360.000000,-88.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,360.000000,-88.000000,270.000000);
delta_within( $r, 182.006722654002, 0.1 );

$r = $e->bearing(0.000000,360.000000,-88.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(0.000000,360.000000,0.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,360.000000,0.000000,90.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,360.000000,0.000000,180.000000);
delta_within( $r, 90, 0.1 );

$r = $e->bearing(0.000000,360.000000,0.000000,270.000000);
delta_within( $r, 270, 0.1 );

$r = $e->bearing(0.000000,360.000000,0.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,360.000000,88.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(0.000000,360.000000,88.000000,90.000000);
delta_within( $r, 2.0067226540021, 0.1 );

$r = $e->bearing(0.000000,360.000000,88.000000,180.000000);
delta_within( $r, 2.45853187196776e-16, 0.1 );

$r = $e->bearing(0.000000,360.000000,88.000000,270.000000);
delta_within( $r, 357.993277345998, 0.1 );

$r = $e->bearing(0.000000,360.000000,88.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(88.000000,0.000000,-88.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,0.000000,-88.000000,90.000000);
delta_within( $r, 134.975074649469, 0.1 );

$r = $e->bearing(88.000000,0.000000,-88.000000,180.000000);
delta_within( $r, 90.0105510419506, 0.1 );

$r = $e->bearing(88.000000,0.000000,-88.000000,270.000000);
delta_within( $r, 225.024925350531, 0.1 );

$r = $e->bearing(88.000000,0.000000,-88.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,0.000000,0.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,0.000000,0.000000,90.000000);
delta_within( $r, 89.9894488745028, 0.1 );

$r = $e->bearing(88.000000,0.000000,0.000000,180.000000);
delta_within( $r, 7.02101510964053e-15, 0.1 );

$r = $e->bearing(88.000000,0.000000,0.000000,270.000000);
delta_within( $r, 270.010551125497, 0.1 );

$r = $e->bearing(88.000000,0.000000,0.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,0.000000,88.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(88.000000,0.000000,88.000000,90.000000);
delta_within( $r, 45.0174567892171, 0.1 );

$r = $e->bearing(88.000000,0.000000,88.000000,180.000000);
delta_within( $r, 3.51050755482026e-15, 0.1 );

$r = $e->bearing(88.000000,0.000000,88.000000,270.000000);
delta_within( $r, 314.982543210783, 0.1 );

$r = $e->bearing(88.000000,0.000000,88.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(88.000000,90.000000,-88.000000,0.000000);
delta_within( $r, 225.024925350531, 0.1 );

$r = $e->bearing(88.000000,90.000000,-88.000000,90.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,90.000000,-88.000000,180.000000);
delta_within( $r, 134.975074649469, 0.1 );

$r = $e->bearing(88.000000,90.000000,-88.000000,270.000000);
delta_within( $r, 90.0105510419506, 0.1 );

$r = $e->bearing(88.000000,90.000000,-88.000000,360.000000);
delta_within( $r, 225.024925350531, 0.1 );

$r = $e->bearing(88.000000,90.000000,0.000000,0.000000);
delta_within( $r, 270.010551125497, 0.1 );

$r = $e->bearing(88.000000,90.000000,0.000000,90.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,90.000000,0.000000,180.000000);
delta_within( $r, 89.9894488745028, 0.1 );

$r = $e->bearing(88.000000,90.000000,0.000000,270.000000);
delta_within( $r, 7.02101510964053e-15, 0.1 );

$r = $e->bearing(88.000000,90.000000,0.000000,360.000000);
delta_within( $r, 270.010551125497, 0.1 );

$r = $e->bearing(88.000000,90.000000,88.000000,0.000000);
delta_within( $r, 314.982543210783, 0.1 );

$r = $e->bearing(88.000000,90.000000,88.000000,90.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(88.000000,90.000000,88.000000,180.000000);
delta_within( $r, 45.0174567892171, 0.1 );

$r = $e->bearing(88.000000,90.000000,88.000000,270.000000);
delta_within( $r, 3.51050755482026e-15, 0.1 );

$r = $e->bearing(88.000000,90.000000,88.000000,360.000000);
delta_within( $r, 314.982543210783, 0.1 );

$r = $e->bearing(88.000000,180.000000,-88.000000,0.000000);
delta_within( $r, 269.989448958049, 0.1 );

$r = $e->bearing(88.000000,180.000000,-88.000000,90.000000);
delta_within( $r, 225.024925350531, 0.1 );

$r = $e->bearing(88.000000,180.000000,-88.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,180.000000,-88.000000,270.000000);
delta_within( $r, 134.975074649469, 0.1 );

$r = $e->bearing(88.000000,180.000000,-88.000000,360.000000);
delta_within( $r, 269.989448958049, 0.1 );

$r = $e->bearing(88.000000,180.000000,0.000000,0.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(88.000000,180.000000,0.000000,90.000000);
delta_within( $r, 270.010551125497, 0.1 );

$r = $e->bearing(88.000000,180.000000,0.000000,180.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,180.000000,0.000000,270.000000);
delta_within( $r, 89.9894488745028, 0.1 );

$r = $e->bearing(88.000000,180.000000,0.000000,360.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(88.000000,180.000000,88.000000,0.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(88.000000,180.000000,88.000000,90.000000);
delta_within( $r, 314.982543210783, 0.1 );

$r = $e->bearing(88.000000,180.000000,88.000000,180.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(88.000000,180.000000,88.000000,270.000000);
delta_within( $r, 45.0174567892171, 0.1 );

$r = $e->bearing(88.000000,180.000000,88.000000,360.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(88.000000,270.000000,-88.000000,0.000000);
delta_within( $r, 134.975074649469, 0.1 );

$r = $e->bearing(88.000000,270.000000,-88.000000,90.000000);
delta_within( $r, 269.989448958049, 0.1 );

$r = $e->bearing(88.000000,270.000000,-88.000000,180.000000);
delta_within( $r, 225.024925350531, 0.1 );

$r = $e->bearing(88.000000,270.000000,-88.000000,270.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,270.000000,-88.000000,360.000000);
delta_within( $r, 134.975074649469, 0.1 );

$r = $e->bearing(88.000000,270.000000,0.000000,0.000000);
delta_within( $r, 89.9894488745028, 0.1 );

$r = $e->bearing(88.000000,270.000000,0.000000,90.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(88.000000,270.000000,0.000000,180.000000);
delta_within( $r, 270.010551125497, 0.1 );

$r = $e->bearing(88.000000,270.000000,0.000000,270.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,270.000000,0.000000,360.000000);
delta_within( $r, 89.9894488745028, 0.1 );

$r = $e->bearing(88.000000,270.000000,88.000000,0.000000);
delta_within( $r, 45.0174567892171, 0.1 );

$r = $e->bearing(88.000000,270.000000,88.000000,90.000000);
delta_within( $r, 360, 0.1 );

$r = $e->bearing(88.000000,270.000000,88.000000,180.000000);
delta_within( $r, 314.982543210783, 0.1 );

$r = $e->bearing(88.000000,270.000000,88.000000,270.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(88.000000,270.000000,88.000000,360.000000);
delta_within( $r, 45.0174567892171, 0.1 );

$r = $e->bearing(88.000000,360.000000,-88.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,360.000000,-88.000000,90.000000);
delta_within( $r, 134.975074649469, 0.1 );

$r = $e->bearing(88.000000,360.000000,-88.000000,180.000000);
delta_within( $r, 90.0105510419506, 0.1 );

$r = $e->bearing(88.000000,360.000000,-88.000000,270.000000);
delta_within( $r, 225.024925350531, 0.1 );

$r = $e->bearing(88.000000,360.000000,-88.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,360.000000,0.000000,0.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,360.000000,0.000000,90.000000);
delta_within( $r, 89.9894488745028, 0.1 );

$r = $e->bearing(88.000000,360.000000,0.000000,180.000000);
delta_within( $r, 7.02101510964053e-15, 0.1 );

$r = $e->bearing(88.000000,360.000000,0.000000,270.000000);
delta_within( $r, 270.010551125497, 0.1 );

$r = $e->bearing(88.000000,360.000000,0.000000,360.000000);
delta_within( $r, 180, 0.1 );

$r = $e->bearing(88.000000,360.000000,88.000000,0.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(88.000000,360.000000,88.000000,90.000000);
delta_within( $r, 45.0174567892171, 0.1 );

$r = $e->bearing(88.000000,360.000000,88.000000,180.000000);
delta_within( $r, 3.51050755482026e-15, 0.1 );

$r = $e->bearing(88.000000,360.000000,88.000000,270.000000);
delta_within( $r, 314.982543210783, 0.1 );

$r = $e->bearing(88.000000,360.000000,88.000000,360.000000);
delta_within( $r, 0, 0.1 );

$r = $e->bearing(-59.250954,269.964713,-72.653102,313.367482);
delta_within( $r, 145.807183897007, 0.1 );

$r = $e->bearing(13.914631,282.887733,34.594948,132.755857);
delta_within( $r, 330.521014479537, 0.1 );

$r = $e->bearing(67.302734,268.234235,-9.711736,127.342153);
delta_within( $r, 315.949585157661, 0.1 );

$r = $e->bearing(41.853534,93.679920,-19.027121,279.644382);
delta_within( $r, 345.867417827748, 0.1 );

$r = $e->bearing(62.106325,207.283752,38.796947,29.881529);
delta_within( $r, 357.940290178621, 0.1 );

$r = $e->bearing(-7.951477,39.580853,8.141044,140.647165);
delta_within( $r, 83.3694852077113, 0.1 );

$r = $e->bearing(12.345376,345.263922,66.189437,58.748224);
delta_within( $r, 24.0792614529845, 0.1 );

$r = $e->bearing(-40.408393,93.729994,76.337054,156.932149);
delta_within( $r, 14.6491112773242, 0.1 );

$r = $e->bearing(52.102956,45.942126,-75.202977,338.631126);
delta_within( $r, 199.375826068533, 0.1 );

$r = $e->bearing(-85.396513,55.515935,-21.207163,55.705212);
delta_within( $r, 0.196078864827955, 0.1 );

$r = $e->bearing(5.280015,315.665457,-12.489941,95.006241);
delta_within( $r, 103.063869140361, 0.1 );

$r = $e->bearing(-33.552990,277.233007,-70.669641,277.575212);
delta_within( $r, 179.81166128575, 0.1 );

$r = $e->bearing(36.935201,78.710277,47.122919,148.216696);
delta_within( $r, 55.2546487624413, 0.1 );

$r = $e->bearing(26.788828,334.784252,0.435342,247.478645);
delta_within( $r, 269.294136252976, 0.1 );

$r = $e->bearing(-11.503629,218.988327,13.780554,227.743816);
delta_within( $r, 19.3030417865741, 0.1 );

$r = $e->bearing(-6.583383,227.607764,-65.106912,345.874110);
delta_within( $r, 158.095644337348, 0.1 );

$r = $e->bearing(-64.012500,160.805906,-31.574797,342.930268);
delta_within( $r, 181.816238742162, 0.1 );

$r = $e->bearing(-25.526896,143.354960,-71.769322,343.830865);
delta_within( $r, 186.359108096574, 0.1 );

$r = $e->bearing(87.231051,207.349229,65.864472,53.955321);
delta_within( $r, 335.89478311193, 0.1 );

$r = $e->bearing(73.647077,234.450903,-78.505046,343.799779);
delta_within( $r, 138.470627465375, 0.1 );

$r = $e->bearing(83.927298,282.795619,54.929667,205.651325);
delta_within( $r, 265.872981243315, 0.1 );

$r = $e->bearing(-39.134570,346.518379,14.305871,157.269106);
delta_within( $r, 159.547962585096, 0.1 );

$r = $e->bearing(-22.421489,332.426739,-84.834112,276.789592);
delta_within( $r, 184.728808991295, 0.1 );

$r = $e->bearing(40.159219,212.748966,-13.340063,231.171501);
delta_within( $r, 158.175498015147, 0.1 );

$r = $e->bearing(44.417291,24.846678,-80.406909,278.752912);
delta_within( $r, 193.423303283225, 0.1 );

$r = $e->bearing(36.630627,43.655923,-35.381356,26.822827);
delta_within( $r, 194.310930108401, 0.1 );

$r = $e->bearing(33.814762,131.384200,41.299938,70.051002);
delta_within( $r, 297.787048077164, 0.1 );

$r = $e->bearing(-62.173407,58.245260,59.801920,198.337306);
delta_within( $r, 79.2486443226493, 0.1 );

$r = $e->bearing(-32.914255,189.985094,-12.020048,76.924247);
delta_within( $r, 246.831695320588, 0.1 );

$r = $e->bearing(41.328831,0.492949,15.516809,171.877678);
delta_within( $r, 9.82343903459999, 0.1 );

$r = $e->bearing(79.174434,274.377083,-67.007887,5.320166);
delta_within( $r, 113.023314868677, 0.1 );

$r = $e->bearing(-0.001195,304.117753,63.386740,32.763058);
delta_within( $r, 26.6851858232811, 0.1 );

$r = $e->bearing(64.395482,284.016319,14.125715,35.816077);
delta_within( $r, 64.3739009193045, 0.1 );

$r = $e->bearing(59.070193,268.990763,73.506884,184.371272);
delta_within( $r, 328.961281221905, 0.1 );

$r = $e->bearing(69.221855,346.301076,11.971944,170.600523);
delta_within( $r, 355.751468077615, 0.1 );

$r = $e->bearing(-14.839766,234.124251,68.436283,210.936486);
delta_within( $r, 351.606656042937, 0.1 );

$r = $e->bearing(-49.947821,359.764786,-61.347691,250.415053);
delta_within( $r, 213.403699356942, 0.1 );

$r = $e->bearing(36.275284,355.034035,26.747567,235.757036);
delta_within( $r, 308.639765874013, 0.1 );

$r = $e->bearing(61.956727,245.437140,84.626689,119.397052);
delta_within( $r, 351.65750926209, 0.1 );

$r = $e->bearing(54.014791,57.371114,65.390242,216.992405);
delta_within( $r, 9.68247630799929, 0.1 );

$r = $e->bearing(-14.407400,353.288548,66.401439,167.053343);
delta_within( $r, 3.15449768180515, 0.1 );

$r = $e->bearing(-45.568153,304.069875,61.783688,265.142366);
delta_within( $r, 341.269891095459, 0.1 );

$r = $e->bearing(-66.204938,171.649788,51.180657,179.133361);
delta_within( $r, 5.29566779855937, 0.1 );

$r = $e->bearing(12.387314,159.861758,-83.658835,119.465377);
delta_within( $r, 184.155656363213, 0.1 );

$r = $e->bearing(-13.206616,209.725263,-74.148669,242.959763);
delta_within( $r, 170.353445666905, 0.1 );

$r = $e->bearing(15.738507,84.854820,44.036265,345.007357);
delta_within( $r, 314.715347842656, 0.1 );

$r = $e->bearing(65.565980,26.794838,7.165798,137.813405);
delta_within( $r, 67.8288494339768, 0.1 );

$r = $e->bearing(-89.667751,257.981187,-80.341572,7.576067);
delta_within( $r, 111.412561084939, 0.1 );

$r = $e->bearing(46.541007,226.425777,77.582559,197.258652);
delta_within( $r, 348.904313788907, 0.1 );

$r = $e->bearing(-15.473927,141.465980,-54.435715,110.910346);
delta_within( $r, 204.55244483009, 0.1 );

$r = $e->bearing(-52.334998,219.992892,-23.050833,57.834091);
delta_within( $r, 196.782623609282, 0.1 );

$r = $e->bearing(-7.159774,289.072816,-56.983265,258.457540);
delta_within( $r, 199.827765033574, 0.1 );

$r = $e->bearing(-4.196435,51.031553,24.058567,87.322753);
delta_within( $r, 49.7486802346727, 0.1 );

$r = $e->bearing(-67.652957,313.732597,-71.386156,271.586522);
delta_within( $r, 236.570545587037, 0.1 );

$r = $e->bearing(-21.495536,200.424780,-75.917093,135.855002);
delta_within( $r, 194.311258008672, 0.1 );

$r = $e->bearing(22.533161,284.263825,-14.155207,296.727744);
delta_within( $r, 160.319619331935, 0.1 );

$r = $e->bearing(9.344977,262.152203,-2.013487,94.386354);
delta_within( $r, 301.280977492309, 0.1 );

$r = $e->bearing(-0.376040,176.244258,-1.529740,305.845852);
delta_within( $r, 92.3053960336399, 0.1 );

$r = $e->bearing(75.401673,130.305234,8.242361,217.631502);
delta_within( $r, 90.4283129978699, 0.1 );

$r = $e->bearing(19.738510,158.695298,37.209780,77.814439);
delta_within( $r, 303.758653003421, 0.1 );

$r = $e->bearing(47.822247,110.299360,51.524056,32.324924);
delta_within( $r, 305.213399480694, 0.1 );

$r = $e->bearing(71.747223,336.092025,84.128794,222.676574);
delta_within( $r, 344.990118049247, 0.1 );

$r = $e->bearing(-77.954568,40.691029,23.517948,26.717480);
delta_within( $r, 346.909626753627, 0.1 );

$r = $e->bearing(10.333298,84.313406,20.153222,336.438821);
delta_within( $r, 293.631078491433, 0.1 );

$r = $e->bearing(12.906411,206.733155,-6.402276,43.507509);
delta_within( $r, 290.484053424289, 0.1 );

$r = $e->bearing(-47.487015,359.498721,10.299597,310.960507);
delta_within( $r, 309.030794173151, 0.1 );

$r = $e->bearing(-38.318437,262.779852,57.826419,175.943954);
delta_within( $r, 321.965422803505, 0.1 );

$r = $e->bearing(16.748547,40.377857,-61.506088,251.664078);
delta_within( $r, 198.877947586411, 0.1 );

$r = $e->bearing(17.067788,317.877537,-12.401527,75.628131);
delta_within( $r, 94.6410681675227, 0.1 );

$r = $e->bearing(-57.208230,247.494628,-50.737489,95.206424);
delta_within( $r, 198.282553928874, 0.1 );

$r = $e->bearing(-49.841955,177.356139,-41.792872,160.579825);
delta_within( $r, 298.192353794927, 0.1 );

$r = $e->bearing(-47.475272,106.843903,27.113505,269.915143);
delta_within( $r, 141.330331590807, 0.1 );

$r = $e->bearing(34.666165,152.960690,46.720069,143.422437);
delta_within( $r, 331.966491256946, 0.1 );

$r = $e->bearing(-22.681576,230.794842,6.087350,323.707746);
delta_within( $r, 85.6124557620008, 0.1 );

$r = $e->bearing(27.970395,335.040139,-88.231065,62.080991);
delta_within( $r, 177.996374969782, 0.1 );

$r = $e->bearing(25.808871,275.774114,31.740387,277.375893);
delta_within( $r, 13.0036905703685, 0.1 );

$r = $e->bearing(45.986532,322.536805,-50.794083,229.175856);
delta_within( $r, 231.095927511179, 0.1 );

$r = $e->bearing(17.494026,224.034545,-24.264719,25.530801);
delta_within( $r, 114.891614096584, 0.1 );

$r = $e->bearing(-44.552076,129.996443,-2.946633,181.334105);
delta_within( $r, 62.9368894921487, 0.1 );

$r = $e->bearing(-37.816059,85.936197,29.247477,323.170028);
delta_within( $r, 277.292118433932, 0.1 );

$r = $e->bearing(30.861009,15.545439,60.769966,205.929510);
delta_within( $r, 354.945642250603, 0.1 );

$r = $e->bearing(-56.909608,9.518430,-4.443063,202.739897);
delta_within( $r, 194.878179938224, 0.1 );

$r = $e->bearing(-59.778517,219.758248,25.579668,110.301202);
delta_within( $r, 266.97512519361, 0.1 );

$r = $e->bearing(82.221120,275.743098,24.479559,24.731901);
delta_within( $r, 67.8705664181698, 0.1 );

$r = $e->bearing(-66.482427,272.564728,-3.542695,257.290127);
delta_within( $r, 342.92920862191, 0.1 );

$r = $e->bearing(-69.252209,230.640539,-18.297118,254.265464);
delta_within( $r, 28.4950436143867, 0.1 );

$r = $e->bearing(51.113328,253.823581,-41.662645,280.971459);
delta_within( $r, 159.890235897413, 0.1 );

$r = $e->bearing(-65.854390,99.691638,-75.374219,76.773535);
delta_within( $r, 208.194315130181, 0.1 );

$r = $e->bearing(-54.703787,222.914699,19.210089,197.750208);
delta_within( $r, 335.578747361564, 0.1 );

$r = $e->bearing(12.156497,45.130760,-77.037944,317.821511);
delta_within( $r, 193.247843652939, 0.1 );

$r = $e->bearing(-62.410271,203.679753,-33.008089,120.526333);
delta_within( $r, 258.811414426142, 0.1 );

$r = $e->bearing(-52.993406,243.455936,-82.847048,15.254084);
delta_within( $r, 172.027630031312, 0.1 );

$r = $e->bearing(56.873155,23.266927,37.404405,147.424699);
delta_within( $r, 42.9372936985338, 0.1 );

$r = $e->bearing(69.812806,338.284240,-89.456181,126.278650);
delta_within( $r, 179.145845593927, 0.1 );

$r = $e->bearing(78.916953,356.912286,-25.430764,351.624329);
delta_within( $r, 184.935388116887, 0.1 );

$r = $e->bearing(-85.258035,122.791865,62.315250,157.757983);
delta_within( $r, 30.4847453729585, 0.1 );

$r = $e->bearing(36.633751,205.416787,-71.376286,65.110415);
delta_within( $r, 198.382311253332, 0.1 );

$r = $e->bearing(-46.759865,246.329948,87.319232,184.898940);
delta_within( $r, 356.638663871267, 0.1 );

$r = $e->bearing(72.161234,168.054555,-4.615513,146.711647);
delta_within( $r, 201.805365983594, 0.1 );

$r = $e->bearing(46.528455,41.408793,-63.744034,251.688039);
delta_within( $r, 213.214104634411, 0.1 );

