#!/usr/local/bin/perl
# Test Geo::Ellipsoid at
use Test::More tests => 200;
use Test::Number::Delta relative => 1e-6;
use Geo::Ellipsoid;
#use blib;
use strict;
use warnings;
my $e = Geo::Ellipsoid->new(units=>'degrees');
my( $lat, $lon );
($lat, $lon) = $e->at(-38.369163,190.874558,663.027183,53.574472);
delta_ok( $lat, -38.3656166574816 );
delta_ok( $lon, 190.880662670944 );

($lat, $lon) = $e->at(-14.608137,30.094655,6390.954467,5.838786);
delta_ok( $lat, -14.5506757312195 );
delta_ok( $lon, 30.1006878108632 );

($lat, $lon) = $e->at(-41.623677,208.834416,1610.051073,95.264953);
delta_ok( $lat, -41.6250052190667 );
delta_ok( $lon, 208.853654884741 );

($lat, $lon) = $e->at(-67.726400,52.964864,873.162562,51.679717);
delta_ok( $lat, -67.7215448715301 );
delta_ok( $lon, 52.9810494838024 );

($lat, $lon) = $e->at(-5.158991,259.931626,4773.871059,200.977967);
delta_ok( $lat, -5.19929911015095 );
delta_ok( $lon, 259.916209822012 );

($lat, $lon) = $e->at(-0.582762,29.118576,2946.165884,106.326170);
delta_ok( $lat, -0.590251306822998 );
delta_ok( $lon, 29.1439759994689 );

($lat, $lon) = $e->at(-26.934636,30.474042,991.354098,72.872537);
delta_ok( $lat, -26.9320006429191 );
delta_ok( $lon, 30.4835810246334 );

($lat, $lon) = $e->at(-62.773742,62.342057,8353.955232,297.642864);
delta_ok( $lat, -62.7388932579132 );
delta_ok( $lon, 62.1973057315549 );

($lat, $lon) = $e->at(68.057252,192.858027,4711.422894,252.341167);
delta_ok( $lat, 68.0444035490458 );
delta_ok( $lon, 192.750473587804 );

($lat, $lon) = $e->at(1.348841,276.378914,9829.506468,166.918436);
delta_ok( $lat, 1.26225340172343 );
delta_ok( $lon, 276.398904775364 );

($lat, $lon) = $e->at(27.335146,320.699240,8536.611848,271.060094);
delta_ok( $lat, 27.3365447901331 );
delta_ok( $lon, 320.612989777828 );

($lat, $lon) = $e->at(34.623205,31.357288,7988.594185,134.837127);
delta_ok( $lat, 34.5724140545367 );
delta_ok( $lon, 31.4190231012299 );

($lat, $lon) = $e->at(-6.856999,130.887597,7763.221087,214.956451);
delta_ok( $lat, -6.9145310137216 );
delta_ok( $lon, 130.847349224089 );

($lat, $lon) = $e->at(-70.754141,43.777574,5605.534780,236.246900);
delta_ok( $lat, -70.7820124418518 );
delta_ok( $lon, 43.6507601360196 );

($lat, $lon) = $e->at(-69.865357,188.114494,8437.219491,56.767387);
delta_ok( $lat, -69.8238139675757 );
delta_ok( $lon, 188.29775963402 );

($lat, $lon) = $e->at(-79.523730,324.065787,2171.798854,67.387309);
delta_ok( $lat, -79.5162359949417 );
delta_ok( $lon, 324.164444728711 );

($lat, $lon) = $e->at(74.606774,294.646962,7101.250686,211.655252);
delta_ok( $lat, 74.5525814841857 );
delta_ok( $lon, 294.521662695936 );

($lat, $lon) = $e->at(28.972667,278.549276,2327.886028,78.654517);
delta_ok( $lat, 28.9767972109024 );
delta_ok( $lon, 278.572694719835 );

($lat, $lon) = $e->at(-20.359063,296.599967,1628.799157,220.382033);
delta_ok( $lat, -20.3702696544291 );
delta_ok( $lon, 296.589859316515 );

($lat, $lon) = $e->at(-60.365048,156.813021,10.808349,186.644917);
delta_ok( $lat, -60.3651441594277 );
delta_ok( $lon, 156.812997908757 );

($lat, $lon) = $e->at(-6.203945,247.684632,324.776721,145.835257);
delta_ok( $lat, -6.20637500756407 );
delta_ok( $lon, 247.686280489375 );

($lat, $lon) = $e->at(0.611947,100.746342,9973.981611,131.132873);
delta_ok( $lat, 0.552610910166273 );
delta_ok( $lon, 100.813828549171 );

($lat, $lon) = $e->at(-20.725615,342.386744,817.492741,221.236681);
delta_ok( $lat, -20.7311674916703 );
delta_ok( $lon, 342.381570767838 );

($lat, $lon) = $e->at(46.911457,128.191393,9713.277037,65.802158);
delta_ok( $lat, 46.9472109419575 );
delta_ok( $lon, 128.307769547943 );

($lat, $lon) = $e->at(-11.235004,282.756437,1175.174596,192.154112);
delta_ok( $lat, -11.2453901777651 );
delta_ok( $lon, 282.754171348951 );

($lat, $lon) = $e->at(-41.167125,221.956378,7772.438867,65.964741);
delta_ok( $lat, -41.1385887169887 );
delta_ok( $lon, 222.040925759322 );

($lat, $lon) = $e->at(-1.549886,336.466532,3150.908018,129.475800);
delta_ok( $lat, -1.56800166865749 );
delta_ok( $lon, 336.48838856866 );

($lat, $lon) = $e->at(-63.776699,134.057987,8903.026576,322.164617);
delta_ok( $lat, -63.7135798907929 );
delta_ok( $lon, 133.947510160673 );

($lat, $lon) = $e->at(77.940951,38.523563,1493.070064,336.795873);
delta_ok( $lat, 77.9532419255972 );
delta_ok( $lon, 38.4983240629325 );

($lat, $lon) = $e->at(45.339403,315.409130,2618.493509,45.478452);
delta_ok( $lat, 45.3559203918089 );
delta_ok( $lon, 315.432955775136 );

($lat, $lon) = $e->at(6.190847,124.992089,3854.030593,133.198367);
delta_ok( $lat, 6.16698993482198 );
delta_ok( $lon, 125.017473198902 );

($lat, $lon) = $e->at(-4.121498,262.769582,9308.966888,178.488881);
delta_ok( $lat, -4.20565178483873 );
delta_ok( $lon, 262.771793465594 );

($lat, $lon) = $e->at(-4.285155,344.319438,2988.101263,161.216474);
delta_ok( $lat, -4.31073788511618 );
delta_ok( $lon, 344.328105973954 );

($lat, $lon) = $e->at(51.523602,137.628739,7272.747263,125.320332);
delta_ok( $lat, 51.4857783969847 );
delta_ok( $lon, 137.714167388511 );

($lat, $lon) = $e->at(25.726049,310.324628,6650.414158,289.782664);
delta_ok( $lat, 25.7463533347378 );
delta_ok( $lon, 310.262255281203 );

($lat, $lon) = $e->at(68.128342,115.791221,4772.498578,204.791356);
delta_ok( $lat, 68.0894895788843 );
delta_ok( $lon, 115.743184646016 );

($lat, $lon) = $e->at(-11.919645,340.641713,891.615326,153.274434);
delta_ok( $lat, -11.9268441615804 );
delta_ok( $lon, 340.645393779515 );

($lat, $lon) = $e->at(-30.550903,251.787663,3538.553197,192.651457);
delta_ok( $lat, -30.5820467190063 );
delta_ok( $lon, 251.77958340328 );

($lat, $lon) = $e->at(-61.797586,265.384439,9288.961574,50.299469);
delta_ok( $lat, -61.7442754682939 );
delta_ok( $lon, 265.51970230048 );

($lat, $lon) = $e->at(71.112709,8.834545,4018.709300,72.034521);
delta_ok( $lat, 71.1237884898954 );
delta_ok( $lon, 8.94037141746074 );

($lat, $lon) = $e->at(-63.553064,13.025588,4062.612060,159.653083);
delta_ok( $lat, -63.5872326276018 );
delta_ok( $lon, 13.054037420021 );

($lat, $lon) = $e->at(29.289568,92.918510,8113.351247,35.674974);
delta_ok( $lat, 29.3490208963841 );
delta_ok( $lon, 92.9672340946055 );

($lat, $lon) = $e->at(23.630668,183.960989,4996.609275,55.919867);
delta_ok( $lat, 23.6559427295591 );
delta_ok( $lon, 184.001554318971 );

($lat, $lon) = $e->at(21.323022,38.682180,2136.676569,319.096878);
delta_ok( $lat, 21.3376068588209 );
delta_ok( $lon, 38.6686929767105 );

($lat, $lon) = $e->at(77.751666,6.954744,8617.247199,43.480525);
delta_ok( $lat, 77.807558788711 );
delta_ok( $lon, 7.20615011733365 );

($lat, $lon) = $e->at(-58.652658,205.140021,1309.266436,310.900238);
delta_ok( $lat, -58.6449608105584 );
delta_ok( $lon, 205.122978574438 );

($lat, $lon) = $e->at(7.193705,159.638737,3177.227490,155.223944);
delta_ok( $lat, 7.16761967835365 );
delta_ok( $lon, 159.650791084088 );

($lat, $lon) = $e->at(74.707726,290.854396,7214.189514,304.432840);
delta_ok( $lat, 74.744181624024 );
delta_ok( $lon, 290.651891561225 );

($lat, $lon) = $e->at(68.994921,41.466113,4652.207721,141.053623);
delta_ok( $lat, 68.9624691494274 );
delta_ok( $lon, 41.5390782800586 );

($lat, $lon) = $e->at(-19.222949,91.053479,1338.282294,224.550018);
delta_ok( $lat, -19.2315645979902 );
delta_ok( $lon, 91.0445501139712 );

($lat, $lon) = $e->at(19.041053,175.994927,5177.048787,281.316611);
delta_ok( $lat, 19.0502245946021 );
delta_ok( $lon, 175.946699498326 );

($lat, $lon) = $e->at(-35.454628,153.274308,1072.202082,83.828810);
delta_ok( $lat, -35.4535887262639 );
delta_ok( $lon, 153.286050580698 );

($lat, $lon) = $e->at(64.324875,209.104753,8132.271740,281.572223);
delta_ok( $lat, 64.3394159635432 );
delta_ok( $lon, 208.939932681833 );

($lat, $lon) = $e->at(33.139375,123.465763,9357.301964,74.517011);
delta_ok( $lat, 33.1618601109725 );
delta_ok( $lon, 123.562433957867 );

($lat, $lon) = $e->at(35.694667,300.725605,3436.937434,117.656799);
delta_ok( $lat, 35.6802840942484 );
delta_ok( $lon, 300.75923369164 );

($lat, $lon) = $e->at(-25.789728,191.087862,5544.330184,5.661707);
delta_ok( $lat, -25.7399260442884 );
delta_ok( $lon, 191.093313592838 );

($lat, $lon) = $e->at(-7.204161,179.885067,2512.365469,183.789892);
delta_ok( $lat, -7.22682901108637 );
delta_ok( $lon, 179.883563144484 );

($lat, $lon) = $e->at(-41.090138,219.595320,2968.409513,329.275936);
delta_ok( $lat, -41.0671591825444 );
delta_ok( $lon, 219.577276687536 );

($lat, $lon) = $e->at(11.191046,106.356107,4851.812086,51.506296);
delta_ok( $lat, 11.2183452049473 );
delta_ok( $lon, 106.390879919224 );

($lat, $lon) = $e->at(22.955732,47.794852,8246.705286,185.066176);
delta_ok( $lat, 22.8815557299606 );
delta_ok( $lon, 47.7877547716615 );

($lat, $lon) = $e->at(-15.074589,56.914619,7164.429748,173.487403);
delta_ok( $lat, -15.1389196660857 );
delta_ok( $lon, 56.9221791309893 );

($lat, $lon) = $e->at(35.067827,307.917302,8369.643934,170.157432);
delta_ok( $lat, 34.9934941967748 );
delta_ok( $lon, 307.932973187805 );

($lat, $lon) = $e->at(66.084685,30.192264,1657.534288,243.904448);
delta_ok( $lat, 66.0781430272163 );
delta_ok( $lon, 30.1593794067063 );

($lat, $lon) = $e->at(42.839865,327.847225,4283.496948,308.416746);
delta_ok( $lat, 42.8638173053356 );
delta_ok( $lon, 327.806155932558 );

($lat, $lon) = $e->at(-23.824528,241.336801,2179.408647,175.675228);
delta_ok( $lat, -23.8441499994289 );
delta_ok( $lon, 241.338413904748 );

($lat, $lon) = $e->at(-48.109675,147.804097,3851.598342,313.390029);
delta_ok( $lat, -48.0858733128973 );
delta_ok( $lon, 147.766528156689 );

($lat, $lon) = $e->at(-17.562152,276.168590,5665.575297,135.075003);
delta_ok( $lat, -17.5983930208439 );
delta_ok( $lon, 276.206284342329 );

($lat, $lon) = $e->at(64.918979,305.870922,2833.416804,309.531171);
delta_ok( $lat, 64.93514807142 );
delta_ok( $lon, 305.824710582963 );

($lat, $lon) = $e->at(75.481994,274.248595,1614.672640,65.431283);
delta_ok( $lat, 75.4880029055827 );
delta_ok( $lon, 274.301072964264 );

($lat, $lon) = $e->at(3.076206,112.117539,9835.156864,258.316434);
delta_ok( $lat, 3.05819117659608 );
delta_ok( $lon, 112.03089587221 );

($lat, $lon) = $e->at(12.921677,151.249684,4165.773730,74.171323);
delta_ok( $lat, 12.9319448741801 );
delta_ok( $lon, 151.286617723767 );

($lat, $lon) = $e->at(72.833548,317.667505,62.516492,29.001224);
delta_ok( $lat, 72.8340378772457 );
delta_ok( $lon, 317.668425118621 );

($lat, $lon) = $e->at(-33.041308,313.249683,9757.188845,231.280178);
delta_ok( $lat, -33.0963123185816 );
delta_ok( $lon, 313.168134096478 );

($lat, $lon) = $e->at(-12.674750,312.909013,3145.681733,358.190380);
delta_ok( $lat, -12.6463295522276 );
delta_ok( $lon, 312.908098770026 );

($lat, $lon) = $e->at(-67.846380,99.041109,8317.496525,12.266233);
delta_ok( $lat, -67.7735027510781 );
delta_ok( $lon, 99.0829538757829 );

($lat, $lon) = $e->at(41.911754,138.151813,2308.592027,18.057173);
delta_ok( $lat, 41.931514275859 );
delta_ok( $lon, 138.160440601835 );

($lat, $lon) = $e->at(-27.100512,351.279156,7472.750836,215.020221);
delta_ok( $lat, -27.1557353506091 );
delta_ok( $lon, 351.235890988004 );

($lat, $lon) = $e->at(19.497371,220.383733,5718.963068,119.960301);
delta_ok( $lat, 19.4715643857237 );
delta_ok( $lon, 220.430924356231 );

($lat, $lon) = $e->at(18.396198,143.265994,7349.515732,7.492742);
delta_ok( $lat, 18.462030603882 );
delta_ok( $lon, 143.275067859029 );

($lat, $lon) = $e->at(-18.084386,221.381908,5982.507117,338.372199);
delta_ok( $lat, -18.0341383666805 );
delta_ok( $lon, 221.361083689563 );

($lat, $lon) = $e->at(46.204817,295.396070,8211.580529,221.904425);
delta_ok( $lat, 46.1498123310365 );
delta_ok( $lon, 295.325077737085 );

($lat, $lon) = $e->at(-30.523088,295.285416,434.243851,69.446059);
delta_ok( $lat, -30.5217130438922 );
delta_ok( $lon, 295.289652469157 );

($lat, $lon) = $e->at(13.742087,63.763606,4388.913613,181.241894);
delta_ok( $lat, 13.7024269689802 );
delta_ok( $lon, 63.7627262988153 );

($lat, $lon) = $e->at(1.554684,167.837560,3131.747930,59.213013);
delta_ok( $lat, 1.569180590976 );
delta_ok( $lon, 167.861737784577 );

($lat, $lon) = $e->at(40.356751,153.160097,5740.614634,305.081769);
delta_ok( $lat, 40.3864504304803 );
delta_ok( $lon, 153.104771159051 );

($lat, $lon) = $e->at(46.867006,44.857631,9269.632604,208.315002);
delta_ok( $lat, 46.7935841133503 );
delta_ok( $lon, 44.8000433688771 );

($lat, $lon) = $e->at(-9.089458,237.666143,2239.328571,14.324009);
delta_ok( $lat, -9.06984018685933 );
delta_ok( $lon, 237.671182904242 );

($lat, $lon) = $e->at(-27.107665,34.103508,4111.521802,243.342905);
delta_ok( $lat, -27.1243073483826 );
delta_ok( $lon, 34.0664465612593 );

($lat, $lon) = $e->at(5.067958,24.268528,8172.788174,38.204963);
delta_ok( $lat, 5.12603197726551 );
delta_ok( $lon, 24.3141162471053 );

($lat, $lon) = $e->at(-30.360974,322.538048,1475.216259,59.263577);
delta_ok( $lat, -30.3541720736128 );
delta_ok( $lon, 322.551236568074 );

($lat, $lon) = $e->at(54.780139,8.410011,9928.854395,201.999534);
delta_ok( $lat, 54.6974261720386 );
delta_ok( $lon, 8.35232427150873 );

($lat, $lon) = $e->at(13.769616,110.113762,1308.712391,343.083492);
delta_ok( $lat, 13.7809330917703 );
delta_ok( $lon, 110.110240703272 );

($lat, $lon) = $e->at(-64.270514,45.105873,5363.627587,140.110968);
delta_ok( $lat, -64.3074130400441 );
delta_ok( $lon, 45.1769508481269 );

($lat, $lon) = $e->at(-45.137898,141.541847,1959.185717,345.810769);
delta_ok( $lat, -45.1208065938123 );
delta_ok( $lon, 141.535743596221 );

($lat, $lon) = $e->at(6.782845,255.237805,3347.905328,296.785788);
delta_ok( $lat, 6.79648733577206 );
delta_ok( $lon, 255.21076894319 );

($lat, $lon) = $e->at(6.371687,279.113190,364.003776,337.941402);
delta_ok( $lat, 6.37473803790467 );
delta_ok( $lon, 279.111954845525 );

($lat, $lon) = $e->at(44.782374,163.862303,9245.465886,45.480517);
delta_ok( $lat, 44.8406766505379 );
delta_ok( $lon, 163.945679242348 );

($lat, $lon) = $e->at(-70.362274,322.490547,2582.286613,323.109595);
delta_ok( $lat, -70.3437578191682 );
delta_ok( $lon, 322.449273778159 );

($lat, $lon) = $e->at(-19.715571,5.847281,5797.359451,217.945830);
delta_ok( $lat, -19.7568659277096 );
delta_ok( $lon, 5.81326755286758 );

($lat, $lon) = $e->at(-69.938162,165.492639,7837.486006,155.206150);
delta_ok( $lat, -70.001917924038 );
delta_ok( $lon, 165.578716457449 );

