#ifndef LAYER_H
#define LAYER_H

#include <stdio.h>

#include <arch/neuron.h>
#include <utils/real.h>

class neuron;

class layer_node {
    public:
        neuron *my_neuron;
        layer_node *next;
        layer_node *last;
        layer_node *above;
        layer_node *below;

        layer_node(layer_node *previous, char name[255], int number);
};

class layer {
    private:
        layer_node *head;

        int  cols;
        int  rows;
        char name[255];
        layer_node *current_node;
        real *output;
        real *input;
        real *delta;
        real *weighted_delta_from_above;

    public:
        int size;

                layer(char n[20], int number);
                layer(char n[20], int number, real bias_v);

        char   *query_name();
        void    set_matrix_size(int r, int c);
        void    set_transfer_function(int type);
        void    dendrites_touch(layer *l);
        void    start_foreach();
        neuron *query_current_neuron();
        void    next_neuron();
        int     has_a_neuron();
        void    set_input(real *inputs);
        real *query_output();
        real *query_input();
        real *query_delta();
        real *weighted_sums_of_deltas_from_above();
        void    set_delta(real *d);

        void reinitialize_weights_with(real max, real min);

        void    save_weights(FILE *F);
        void restore_weights(FILE *F);
};

#endif
