#include <arch/neuron.h>
#include <arch/layer.h>
#include <utils/real.h>

class kohonen {
    private:
        int num_outputs;
        real error;
        real alpha;
        layer *input;
        layer *output;

        real    D(neuron *n);
        void    go_left_and_right_to_radius(neuron *n, int radius);
        void    update_weights_for_single_neuron(neuron *n);
        void    update_weights_linearly(neuron *n, int radius);
        void    update_weights_rectangularly(neuron *n, int radius);
        neuron *train();

    public:
                kohonen(real _alpha, int inputs, int outputs);
        void    set_matrix_size(int rows, int cols);
        void    set_input(real *inputs);
        real *query_output();
        int   query_max_output();

        void linear_train(int radius);
        void rectangular_train(int radius);
        real update_learning_rate();
        real update_learning_rate(real gamma);

        void    save_net(char *filename);
        void restore_net(char *filename);
};
