#include "d_grid_w.h"
#include <stdlib.h>
#include <curses.h>

grid_w_display *disp;

void cleanup() {
    delete disp;
    printf("\n");
}

#define xsize 10
#define ysize 10

void main() {
    char c;
    atexit(*cleanup);
    disp = new grid_w_display(xsize, ysize);

    int x  = (int)(xsize/2);
    int y  = (int)(ysize/2);

    double goophy = 7;

    disp->show_str("Use vi keys: h,j,l,k to move.");

    disp->set_start( x, y);
    disp->set_finish(4, 4);
    disp->show_state(x, y);

    while('q' != (c = getch())) {
        switch(c) {
            case 'h': x = (--x<0)       ? 0       : x; break;
            case 'l': x = (++x>xsize-1) ? xsize-1 : x; break;
            case 'k': y = (--y<0)       ? 0       : y; break;
            case 'j': y = (++y>ysize-1) ? ysize-1 : y; break;
            case 'w':
                disp->start_new_episode();
                disp->set_start( x, y);
                disp->set_finish(4, 4);
        }
        goophy *= goophy;
        disp->show_str("hi man!");
        disp->show_num(goophy);
        disp->show_epsilon(1);
        disp->show_wall_hit(1);
        disp->show_state(x, y);
        if(x==4 && y==4) break;
    }

    disp->show_str("Finished.  Boy, you're pretty good at this.");
    exit(0);
}
