#include <time.h>
#include "d_grid_w.h"

void grid_w_display::show_epsilon(int yn) {
    escroller->show_str((yn) ? "e":" ");
}

void grid_w_display::show_wall_hit(int yn) {
    wscroller->show_str((yn) ? "h":" ");
}

void grid_w_display::start_new_episode() {
    map->wipe(100);
    cx = -1; cy = -1; sx = -1; sy = -1; fx = -1; fy = -1;
}

void grid_w_display::set_start(int x, int y) {
    sx = x;
    sy = y;
    map->show_chr('S', y, x);
}

void grid_w_display::set_finish(int x, int y) {
    fx = x;
    fy = y;
    map->show_chr('F', y, x);
}

void grid_w_display::show_state(int x, int y) {
    int num = (time(0)%6)+1;
    chtype c = '.' | COLOR_PAIR(num) | A_BOLD;
    chtype C = '*' | COLOR_PAIR(num) | A_BOLD;

    if(cx >= 0 && cy >= 0) {
             if(cx == sx && cy == sy) map->show_chr('S', cy, cx);
        else if(cx == fx && cy == fy) map->show_chr('F', cy, cx);
        else                          map->show_chr(c,   cy, cx);
    }
    map->show_chr(C, y, x);
    cx = x; 
    cy = y;
    map->done_chr();
}

void grid_w_display::show_str(const char *s) {
    messages->show_str(s);
    if(f) fprintf(f, "%s\n", s);
}

void grid_w_display::show_num(double r) {
    if(r<1000) {
        sprintf(msg, "%11.7f", r);
    } else {
        sprintf(msg, "%11g", r);
    }
    nscroller->show_str(msg);
}

grid_w_display::grid_w_display(int x, int y) {
    WINDOW *screen = initscr();
    noecho();
    curs_set(0);

    start_color(); 
    int bg = (use_default_colors() == OK) ? -1 : COLOR_BLACK;

    init_pair(1, COLOR_RED,     bg); init_pair(2, COLOR_CYAN,    bg);
    init_pair(3, COLOR_MAGENTA, bg); init_pair(4, COLOR_BLUE,    bg);
    init_pair(5, COLOR_GREEN,   bg); init_pair(6, COLOR_YELLOW,  bg);

    f = fopen("grid_w.cvs", "w");

    messages = new bwin(screen, 5, COLS, LINES-5, 0);

    int esw  =  1;
    int nsw  = 12;
    escroller = new nwin(screen, LINES-5, esw, 0, COLS-esw  );
    wscroller = new nwin(screen, LINES-5, esw, 0, COLS-esw*2);
    nscroller = new nwin(screen, LINES-5, nsw, 0,          0);

    int m = (COLS      - (x+(esw*2)-nsw))/2;  // Centering
    int n = ((LINES-7) - (y            ))/2;  // two touple

    map      = new bwin(screen, y+2, x+2, n, m);
    cx = -1; cy = -1; sx = -1; sy = -1; fx = -1; fy = -1;
}

grid_w_display::~grid_w_display() {
    delete messages;
    if(f) fclose(f);
    endwin();
}
