%{
#include "io.h"
#include <utils/real.h>
#include "y.tab.h"
#include<string.h>

    int lineno = 1;
%}

%%

\n             { lineno++; }
[ \t]          {;}
[/][/].*       {;}

[0-9]+\.[0-9]+ { yylval.dval = atof(yytext); return REAL; }
[0-9]+         { yylval.ival = atoi(yytext); return INT;  }
,              { return Comma;        }
[.]            { return OFF;          }
[#]            { return ON;           }
[{]            { return MatrixStart;  }
[}]            { return MatrixEnd;    }
[[]            { return VectorStart;  }
[]]            { return VectorEnd;    }

%%

int yyerror(char *s) {
    fprintf(stderr, "\n::::============ %s\n", s);
    jerror_show(lineno, yytext);
    jnuke();
    exit(1);
}
