#include <arch/neuron.h>
#include <arch/layer.h>
#include <arch/hidden_layers.h>

hidden_node::hidden_node(hidden_node *l, int l_num, int n_num, int xfer_t) {
    char name[40];
    next = 0;
    last = l;

    sprintf(name, "hidden_%i", l_num);
    my_layer = new layer(name, n_num);
    my_layer->set_transfer_function(xfer_t);
}

hidden_node::hidden_node(hidden_node *l, int l_num, int n_num, int xfer_t,
                         real bias) {
    char name[40];
    next = 0;
    last = l;

    sprintf(name, "hidden_%i", l_num);
    my_layer = new layer(name, n_num, bias);
    my_layer->set_transfer_function(xfer_t);
}

hidden_layers::hidden_layers(int number_of, int *neurons_in, int xfer_type) {
    hidden_node *temp;
    head = new hidden_node(0, 1, neurons_in[0], xfer_type);

    temp = head;
    for(int i=1; i<number_of; i++) {
        temp->next = new hidden_node(temp, i+1, neurons_in[i], xfer_type);
        temp->my_layer->dendrites_touch(temp->next->my_layer);
        temp = temp->next;
    }
    tail = temp;
}

hidden_layers::hidden_layers(int number_of, int *neurons_in, int xfer_type, 
                             real bias) {
    hidden_node *temp;
    head = new hidden_node(0, 1, neurons_in[0], xfer_type, bias);

    temp = head;
    for(int i=1; i<number_of; i++) {
        temp->next = new hidden_node(temp, i+1, neurons_in[i], xfer_type, bias);
        temp->my_layer->dendrites_touch(temp->next->my_layer);
        temp = temp->next;
    }
    tail = temp;
}

void hidden_layers::start_foreach() {
    current_node = head;
}

layer *hidden_layers::query_current_layer() {
    return current_node->my_layer;
}

void hidden_layers::next_layer() {
    current_node = current_node->next;
}

int hidden_layers::has_a_layer() {
    return (current_node) ? 1:0;
}

layer *hidden_layers::query_head_layer() {
    return head->my_layer;
}

layer *hidden_layers::query_tail_layer() {
    return tail->my_layer;
}

void hidden_layers::reinitialize_weights_with(real max, real min) {
    start_foreach();
    while(has_a_layer()) {
        current_node->my_layer->reinitialize_weights_with(max, min);
        next_layer();
    }
}

void hidden_layers::set_transfer_function(int type) {
    start_foreach();
    while(has_a_layer()) {
        current_node->my_layer->set_transfer_function(type);
        next_layer();
    }
}

void hidden_layers::save_weights(FILE *F) {
    start_foreach();
    while(has_a_layer()) {
        current_node->my_layer->save_weights(F);
        next_layer();
    }
}

void hidden_layers::restore_weights(FILE *F) {
    start_foreach();
    while(has_a_layer()) {
        current_node->my_layer->restore_weights(F);
        next_layer();
    }
}
