package TunTap;

use 5.010001;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use TunTap ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
		IFF_TUN 
		IFF_TAP
		IFF_NO_PI
		TUN_READQ_SIZE

		TUN_TUN_DEV
		TUN_TAP_DEV 
		TUN_TYPE_MASK
					   
		TUN_FASYN
		TUN_NOCHECKSUM	
		TUN_NO_PI
		TUN_ONE_QUEUE
		TUN_PERSIST 	
		TUN_VNET_HDR 	

		tun_alloc
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

our $VERSION = '0.02';

require XSLoader;
XSLoader::load('TunTap', $VERSION);

# Preloaded methods go here.
#
use constant IFF_TUN   => 0x0001;
use constant IFF_TAP   => 0x0002;
use constant IFF_NO_PI => 0x1000;


# Read queue size 
use constant TUN_READQ_SIZE	=> 500;

# TUN device flags
use constant TUN_TUN_DEV =>	0x0001;
use constant TUN_TAP_DEV =>	0x0002;
use constant TUN_TYPE_MASK =>   0x000f;

use constant TUN_FASYNC	=> 0x0010;
use constant TUN_NOCHECKSUM	 => 0x0020;
use constant TUN_NO_PI	=> 0x0040;
use constant TUN_ONE_QUEUE =>	0x0080;
use constant TUN_PERSIST 	=> 0x0100;
use constant TUN_VNET_HDR 	=> 0x0200;

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

TunTap - Perl extension for Tun/Tap interface

=head1 SYNOPSIS

  use TunTap qw/:all/;
  use AnyEvent;
  use AnyEvent::Handle;

  my $fd = tun_alloc("tap0", IFF_NO_PI | IFF_TAP);
  open my $fh, "+<&=", $fd or die $!;

  my $tap_hdl; 
  $tap_hdl = AnyEvent::Handle->new(fh => $fh, 
	  on_error => sub { 
	  	  print "TAP error: $!"; 
		  $_[0]->destroy;
	  },
  );

  AE::cv->wait;

=head1 DESCRIPTION

Perl module to open Tun/Tap interface.

=head2 EXPORT

None by default.



=head1 SEE ALSO

Tun/Tap interface tutorial:
http://backreference.org/2010/03/26/tuntap-interface-tutorial/

=head1 AUTHOR

Jeff Zhang, E<lt>zhang491226@gmail.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2016 by Jeff Zhang

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.22.1 or,
at your option, any later version of Perl 5 you may have available.


=cut
