# This Makefile.PL for re-engine-GNU was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.35.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.010000;
use ExtUtils::MakeMaker;

use File::Spec;

my %WriteMakefileArgs = (
  "ABSTRACT" => "GNU Regular Expression Engine",
  "AUTHOR" => "Jean-Damien Durand <jeandamiendurand\@free.fr>",
  "BUILD_REQUIRES" => {
    "Capture::Tiny" => 0,
    "Config::AutoConf" => "0.311",
    "File::Spec" => 0,
    "File::Temp" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "re-engine-GNU",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.010000",
  "NAME" => "re::engine::GNU",
  "PREREQ_PM" => {
    "XSLoader" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "File::Temp" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => 0,
    "Thread" => 0,
    "blib" => "1.01"
  },
  "VERSION" => "0.021",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    OBJECT => 'GNU$(OBJ_EXT)',
    DEFINE => '-DNDEBUG -DNEED_newSVpvn_flags',
    INC => '-I'.File::Spec->curdir,
    clean => { FILES => "config_autoconf.h config_autoconf.log config_REGEXP.h config_REGEXP_wrapped.h config_REGEXP_wrapped.log" },
);

my %FallbackPrereqs = (
  "Capture::Tiny" => 0,
  "Config::AutoConf" => "0.311",
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "File::Temp" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Test::More" => 0,
  "Thread" => 0,
  "XSLoader" => 0,
  "blib" => "1.01",
  "strict" => 0,
  "warnings" => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.019
use Config;
if (! $Config{usethreads}) {
  foreach (qw/PREREQ_PM BUILD_REQUIRES TEST_REQUIRES/) {
    delete($WriteMakefileArgs{$_}{Thread}) if (exists($WriteMakefileArgs{$_}));
    delete($FallbackPrereqs{$_}{Thread})   if (exists($FallbackPrereqs{$_}));
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

package MY;
sub postamble {
    my $self = shift;
    my $config_autoconf = File::Spec->catfile('etc', 'config_autoconf.pl');
    my $config_REGEXP = File::Spec->catfile('etc', 'config_REGEXP.pl');
    return $self->SUPER::postamble . "\nconfig_autoconf.h:\n\t\$(PERLRUN) $config_autoconf\n\nconfig_REGEXP.h:\n\t\$(PERLRUN) $config_REGEXP\n\nGNU\$(OBJ_EXT): config_autoconf.h config_REGEXP.h\n";
}
