package MarpaX::Languages::M4;

our $VERSION = '0.007'; # VERSION

our $AUTHORITY = 'cpan:JDDPAUSE'; # AUTHORITY

# ABSTRACT: M4 implementation in Perl


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

MarpaX::Languages::M4 - M4 implementation in Perl

=head1 VERSION

version 0.007

=head1 SYNOPSIS

     use POSIX qw/EXIT_SUCCESS/;
     use MarpaX::Languages::M4::Impl::Default;
     use Log::Any;
     use Log::Any::Adapter;
     use Log::Any::Adapter::Callback;

     Log::Any::Adapter->set('Callback', min_level => 'trace', logging_cb => \&_logging_cb);

     my $impl = MarpaX::Languages::M4::Impl::Default->new_with_options();
     $impl->impl_parse('debugmode(`V\')m4wrap(`test\')');
     print "Value: " . $impl->impl_value . "\n";
     print "Rc: " . $impl->impl_rc . "\n";

     sub _logging_cb {
         my ($method, $self, $format, @params) = @_;
         printf STDERR  "$format\n", @args;
     }

=head1 DESCRIPTION

This package is an implementation of M4, using Marpa::R2 and Moops.

=head1 SEE ALSO

L<Marpa::R2>, L<Moops>, <M4 POSIX|http://pubs.opengroup.org/onlinepubs/9699919799/utilities/m4.html>, <M4 GNU|https://www.gnu.org/software/m4/manual/m4.html>

=for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Bugs / Feature Requests

Please report any bugs or feature requests through the issue tracker
at L<https://rt.cpan.org/Public/Dist/Display.html?Name=MarpaX-Languages-M4>.
You will be notified automatically of any progress on your issue.

=head2 Source Code

This is open source software.  The code repository is available for
public review and contribution under the terms of the license.

L<https://github.com/jddurand/marpax-languages-m4>

  git clone git://github.com/jddurand/marpax-languages-m4.git

=head1 AUTHOR

Jean-Damien Durand <jeandamiendurand@free.fr>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Jean-Damien Durand.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
