INCLUDE (ExternalProject)

SET (_PCRE2_CMAKE_ARGS
  "-DCMAKE_INSTALL_PREFIX:PATH=${3RDPARTY_OUTPUT_PATH}"
  "-DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}"
  -DBUILD_SHARED_LIBS=N
  -DPCRE2_BUILD_PCRE2_8=Y
  -DPCRE2_BUILD_PCRE2_16=N
  -DPCRE2_BUILD_PCRE2_32=N
  -DPCRE2_BUILD_PCRE2GREP=N
  -DPCRE2_SUPPORT_JIT=Y
  -DPCRE2_BUILD_TESTS=N)
IF (MSVC)
  LIST (APPEND _PCRE2_CMAKE_ARGS "${_PCRE2_CMAKE_OPTIONS} -DPCRE_STATIC_RUNTIME=1")
ENDIF ()

EXTERNALPROJECT_ADD(pcre2
  URL "${PROJECT_SOURCE_DIR}/3rdparty/tar/pcre2-10.23.tar.gz"
  UPDATE_COMMAND "${CMAKE_COMMAND}" -E copy "${PROJECT_SOURCE_DIR}/3rdparty/tar/pcre2-10.23/CMakeLists_fixed.txt" "${CMAKE_CURRENT_BINARY_DIR}/pcre2/src/pcre2/CMakeLists.txt"
  PREFIX "${CMAKE_CURRENT_BINARY_DIR}/pcre2"
  CMAKE_ARGS ${_PCRE2_CMAKE_ARGS}
  )
SET (PCRE2_INCLUDE_DIR "${3RDPARTY_OUTPUT_PATH}/include")
IF (WIN32 AND (CMAKE_BUILD_TYPE MATCHES Debug))
  SET (PCRE2_LINK_FLAGS  "${3RDPARTY_OUTPUT_PATH}/lib/${CMAKE_STATIC_LIBRARY_PREFIX}pcre2-8d${CMAKE_STATIC_LIBRARY_SUFFIX}")
ELSE (WIN32 AND (CMAKE_BUILD_TYPE MATCHES Debug))
  SET (PCRE2_LINK_FLAGS  "${3RDPARTY_OUTPUT_PATH}/lib/${CMAKE_STATIC_LIBRARY_PREFIX}pcre2-8${CMAKE_STATIC_LIBRARY_SUFFIX}")
ENDIF (WIN32 AND (CMAKE_BUILD_TYPE MATCHES Debug))
SET (PCRE2_LIBRARIES   "${PCRE2_LINK_FLAGS}")
MESSAGE(STATUS "-----------------------------------------")
MESSAGE(STATUS "Setup PCRE2:")
MESSAGE(STATUS "")
MESSAGE(STATUS "        INCLUDE_DIR: ${PCRE2_INCLUDE_DIR}")
MESSAGE(STATUS "         LINK_FLAGS: ${PCRE2_LINK_FLAGS}")
MESSAGE(STATUS "          LIBRARIES: ${PCRE2_LIBRARIES}")
MESSAGE(STATUS "-----------------------------------------")
SET (PCRE2_INCLUDE_DIRS "${PCRE2_INCLUDE_DIR}")
#
# For linkage in static mode
#
ADD_DEFINITIONS(-DPCRE2_EXP_DECL=extern)

SET (PCRE2_FOUND FALSE)
MARK_AS_ADVANCED (
  PCRE2_FOUND
  PCRE2_INCLUDE_DIRS
  PCRE2_LIBRARIES
  )
