/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.typecache;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;

public class TypesCache {
    private static final TypesCache INSTANCE = new TypesCache();
    private static final List<String> TYPE_CACHE = new CopyOnWriteArrayList<String>();

    private TypesCache() {
    }

    public static TypesCache getInstance() {
        return INSTANCE;
    }

    public int cacheType(String typeRegex) {
        TYPE_CACHE.add(typeRegex);
        return 0;
    }

    public boolean isTypeCacheEmpty() {
        return TYPE_CACHE.isEmpty();
    }

    public boolean isTypeAllowed(Class<?> typeToCheck) {
        String typeFullName = typeToCheck.getName();
        for (String typeRegex : TYPE_CACHE) {
            if (!Pattern.matches(typeRegex, typeFullName)) continue;
            return true;
        }
        return false;
    }

    public String[] getCachedTypes() {
        return TYPE_CACHE.toArray(new String[0]);
    }

    public void clearCache() {
        TYPE_CACHE.clear();
    }
}

