/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.generator.IOptimizedTransmitter;
import com.javonet.core.generator.TransmitterOptimizer;
import com.javonet.core.handler.Handler;
import com.javonet.core.interpreter.Interpreter;
import com.javonet.sdk.internal.AbstractArrayContext;
import com.javonet.sdk.internal.AbstractEnumContext;
import com.javonet.sdk.internal.AbstractInstanceContext;
import com.javonet.sdk.internal.AbstractInvocationContext;
import com.javonet.sdk.internal.AbstractStaticContext;
import com.javonet.sdk.internal.InvocationContextIterator;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import com.javonet.utils.exceptions.ExceptionThrower;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class InvocationContext
implements AbstractInvocationContext,
AbstractInstanceContext,
AbstractStaticContext,
AbstractArrayContext,
AbstractEnumContext,
Iterable<InvocationContext> {
    private final Interpreter interpreter;
    private final RuntimeName runtimeName;
    private final ConnectionType connectionType;
    private Command currentCommand;
    private boolean isExecuted;
    private TcpConnectionData tcpConnectionData;
    private Object resultValue;

    protected Command getCurrentCommand() {
        return this.currentCommand;
    }

    protected InvocationContext(RuntimeName runtime, ConnectionType connectionType, TcpConnectionData tcpConnectionData, Command command) {
        this.runtimeName = runtime;
        this.connectionType = connectionType;
        this.tcpConnectionData = tcpConnectionData;
        this.currentCommand = command;
        this.isExecuted = false;
        this.interpreter = new Interpreter();
    }

    public InvocationContext(RuntimeName runtime, ConnectionType connectionType, TcpConnectionData tcpConnectionData, Command command, boolean isExecuted) {
        this.runtimeName = runtime;
        this.connectionType = connectionType;
        this.tcpConnectionData = tcpConnectionData;
        this.currentCommand = command;
        this.isExecuted = isExecuted;
        this.interpreter = new Interpreter();
    }

    @Override
    @NotNull
    public Iterator<InvocationContext> iterator() {
        if (this.currentCommand.getCommandType() != CommandType.REFERENCE) {
            throw new RuntimeException("Object is not iterable");
        }
        return new InvocationContextIterator(this);
    }

    public Command getCommand() {
        return this.currentCommand;
    }

    public InvocationContext execute(boolean toOptimize) {
        if (toOptimize) {
            Handler handler = new Handler();
            Integer commandHashCode = this.currentCommand.hashCode();
            if (!IOptimizedTransmitter.optimizedClasses.containsKey(commandHashCode)) {
                TransmitterOptimizer.optimize(this.currentCommand, handler, this.interpreter, this.connectionType, this.tcpConnectionData);
            }
            Object[] arg = ((Command)this.currentCommand.getPayload()[2]).getPayload();
            this.resultValue = ((IOptimizedTransmitter)IOptimizedTransmitter.optimizedClasses.get(commandHashCode)).execute(arg);
            this.isExecuted = true;
            return this;
        }
        return this.execute();
    }

    @Override
    public InvocationContext execute() {
        Command responseCommand = this.interpreter.execute(this.currentCommand, this.connectionType, this.tcpConnectionData);
        if (responseCommand.getCommandType() == CommandType.EXCEPTION) {
            ExceptionThrower.throwException(responseCommand);
        }
        if (responseCommand.getCommandType() == CommandType.CREATE_INSTANCE) {
            this.currentCommand = responseCommand;
            this.isExecuted = true;
            return this;
        }
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, responseCommand, true);
    }

    @Override
    public InvocationContext invokeStaticMethod(String methodName, Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_STATIC_METHOD, this.createArgsArray(methodName, arguments));
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getInstanceField(String fieldName) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_INSTANCE_FIELD, fieldName);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setInstanceField(String fieldName, Object value) {
        Command localCommand = new Command(this.runtimeName, CommandType.SET_INSTANCE_FIELD, fieldName, value);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext invokeInstanceMethod(String methodName, Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_INSTANCE_METHOD, this.createArgsArray(methodName, arguments));
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext createInstance(Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.CREATE_INSTANCE, arguments);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getStaticField(String fieldName) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_STATIC_FIELD, fieldName);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setStaticField(String fieldName, Object value) {
        Command localCommand = new Command(this.runtimeName, CommandType.SET_STATIC_FIELD, fieldName, value);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getIndex(Object ... indexes) {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_ITEM, indexes);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getSize() {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_SIZE, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getRank() {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_RANK, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setIndex(Object indexes, Object value) {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_SET_ITEM, indexes, value);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext invokeGenericStaticMethod(String methodName, Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_GENERIC_STATIC_METHOD, this.createArgsArray(methodName, args));
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext invokeGenericMethod(String methodName, Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_GENERIC_METHOD, this.createArgsArray(methodName, args));
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getEnumName() {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_ENUM_NAME, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getEnumValue() {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_ENUM_VALUE, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getRefValue() {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_REF_VALUE, new Object[0]);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
    }

    public Object getValue() {
        this.resultValue = this.currentCommand.getPayload()[0];
        return this.resultValue;
    }

    public Object[] retrieveArray(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.RETRIEVE_ARRAY, args);
        InvocationContext localInvCtx = new InvocationContext(this.runtimeName, this.connectionType, this.tcpConnectionData, this.buildCommand(localCommand));
        InvocationContext arrayInvCtx = localInvCtx.execute();
        Object[] responseArray = (Object[])Array.newInstance(arrayInvCtx.currentCommand.getPayload()[0].getClass(), localInvCtx.currentCommand.getPayload().length);
        responseArray = (Object[])arrayInvCtx.currentCommand.getPayload().clone();
        return responseArray;
    }

    private Command buildCommand(Command command) {
        for (int i = 0; i < command.getPayload().length; ++i) {
            command.setPayload(this.encapsulatePayloadItem(command.getPayload()[i]), i);
        }
        return command.prependArgumentToPayload(this.currentCommand);
    }

    private Command encapsulatePayloadItem(Object payloadItem) {
        if (payloadItem instanceof Command) {
            for (int i = 0; i < ((Command)payloadItem).getPayload().length; ++i) {
                ((Command)payloadItem).setPayload(this.encapsulatePayloadItem(((Command)payloadItem).getPayload()[i]), i);
            }
            return (Command)payloadItem;
        }
        if (payloadItem instanceof InvocationContext) {
            return ((InvocationContext)payloadItem).getCurrentCommand();
        }
        if (payloadItem.getClass().isArray()) {
            Object[] objectArray = new Object[((Object[])payloadItem).length];
            for (int i = 0; i < ((Object[])payloadItem).length; ++i) {
                objectArray[i] = this.encapsulatePayloadItem(((Object[])payloadItem)[i]);
            }
            return new Command(this.runtimeName, CommandType.ARRAY, objectArray);
        }
        return new Command(this.runtimeName, CommandType.VALUE, payloadItem);
    }

    private Object[] createArgsArray(Object arg1, Object ... args) {
        Object[] argsArray = Arrays.copyOf(new Object[]{arg1}, args.length + 1);
        System.arraycopy(args, 0, argsArray, 1, args.length);
        return argsArray;
    }
}

