/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk;

import com.javonet.core.runtime.IEmbeddedRuntime;
import com.javonet.core.transmitter.Transmitter;
import com.javonet.sdk.RuntimeContext;
import com.javonet.sdk.internal.AbstractRuntimeFactory;
import com.javonet.utils.BinariesUnloader;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import java.io.IOException;

public class RuntimeFactory
implements AbstractRuntimeFactory {
    private final ConnectionType connectionType;
    private final TcpConnectionData tcpConnectionData;

    public RuntimeFactory(ConnectionType connectionType, TcpConnectionData tcpConnectionData) {
        this.connectionType = connectionType;
        this.tcpConnectionData = tcpConnectionData;
    }

    @Override
    public RuntimeContext clr() {
        return RuntimeContext.getInstance(RuntimeName.Clr, this.connectionType, this.tcpConnectionData);
    }

    @Override
    public RuntimeContext jvm() {
        return RuntimeContext.getInstance(RuntimeName.Jvm, this.connectionType, this.tcpConnectionData);
    }

    @Override
    public RuntimeContext netcore() {
        return RuntimeContext.getInstance(RuntimeName.Netcore, this.connectionType, this.tcpConnectionData);
    }

    @Override
    public RuntimeContext perl() {
        return RuntimeContext.getInstance(RuntimeName.Perl, this.connectionType, this.tcpConnectionData);
    }

    @Override
    public RuntimeContext ruby() {
        return RuntimeContext.getInstance(RuntimeName.Ruby, this.connectionType, this.tcpConnectionData);
    }

    @Override
    public RuntimeContext nodejs() {
        return RuntimeContext.getInstance(RuntimeName.Nodejs, this.connectionType, this.tcpConnectionData);
    }

    @Override
    public RuntimeContext python() {
        return RuntimeContext.getInstance(RuntimeName.Python, this.connectionType, this.tcpConnectionData);
    }

    public RuntimeContext setEmbeddedRuntime(IEmbeddedRuntime runtime, String path) throws IOException {
        BinariesUnloader.extractBinariesFromJar(runtime.getRuntimeLib());
        byte[] bytes = runtime.getRuntimeBytes();
        Transmitter.deployRuntime(bytes, path, (byte)runtime.getRuntimeVersion());
        Transmitter.setEmbeddedRuntime((byte)runtime.getRuntimeLib().ordinal(), (byte)runtime.getRuntimeVersion(), path);
        return RuntimeContext.getInstance(runtime.getRuntimeLib(), this.connectionType, this.tcpConnectionData);
    }
}

