/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.internal;

import com.javonet.core.generator.IOptimizedTransmitter;
import com.javonet.core.generator.TransmitterOptimizer;
import com.javonet.core.handler.Handler;
import com.javonet.core.interpreter.Interpreter;
import com.javonet.sdk.internal.AbstractInstanceContext;
import com.javonet.sdk.internal.AbstractInvocationContext;
import com.javonet.sdk.internal.AbstractStaticContext;
import com.javonet.sdk.internal.InvocationContextIterator;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.ConnectionType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.TcpConnectionData;
import com.javonet.utils.exceptions.ExceptionThrower;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Optional;

public class InvocationContext
implements AbstractInvocationContext,
AbstractInstanceContext,
AbstractStaticContext,
Iterable<InvocationContext> {
    private final Interpreter interpreter;
    private Handler handler;
    private final RuntimeName runtimeName;
    private final ConnectionType connectionType;
    private Command currentCommand;
    private Command responseCommand;
    private boolean isExecuted;
    private Optional<TcpConnectionData> tcpAddress;
    private Object resultValue;

    public InvocationContext(RuntimeName runtime, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress, Command command) {
        this.runtimeName = runtime;
        this.connectionType = connectionType;
        this.tcpAddress = tcpAddress;
        this.currentCommand = command;
        this.responseCommand = null;
        this.isExecuted = false;
        this.interpreter = new Interpreter();
    }

    public InvocationContext(RuntimeName runtime, ConnectionType connectionType, Optional<TcpConnectionData> tcpAddress, Command command, boolean isExecuted) {
        this.runtimeName = runtime;
        this.connectionType = connectionType;
        this.tcpAddress = tcpAddress;
        this.currentCommand = command;
        this.responseCommand = null;
        this.isExecuted = isExecuted;
        this.interpreter = new Interpreter();
    }

    @Override
    public Iterator<InvocationContext> iterator() {
        if (this.currentCommand.getCommandType() != CommandType.REFERENCE) {
            throw new RuntimeException("Object is not iterable");
        }
        return new InvocationContextIterator(this);
    }

    public InvocationContext execute(boolean toOptimize) {
        if (toOptimize) {
            this.handler = new Handler();
            Integer commandHashCode = this.currentCommand.hashCode();
            if (!IOptimizedTransmitter.optimizedClasses.containsKey(commandHashCode)) {
                TransmitterOptimizer.optimize(this.currentCommand, this.handler, this.interpreter, this.connectionType, this.tcpAddress);
            }
            Object[] arg = ((Command)this.currentCommand.getPayload()[2]).getPayload();
            this.resultValue = ((IOptimizedTransmitter)IOptimizedTransmitter.optimizedClasses.get(commandHashCode)).execute(arg);
            this.isExecuted = true;
            return this;
        }
        return this.execute();
    }

    @Override
    public InvocationContext execute() {
        this.responseCommand = this.interpreter.execute(this.currentCommand, this.connectionType, this.tcpAddress);
        if (this.responseCommand.getCommandType() == CommandType.EXCEPTION) {
            ExceptionThrower.throwException(this.responseCommand);
        }
        if (this.responseCommand.getCommandType() == CommandType.CREATE_INSTANCE) {
            this.currentCommand = this.responseCommand;
            this.isExecuted = true;
            return this;
        }
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.responseCommand, true);
    }

    @Override
    public InvocationContext invokeStaticMethod(Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_STATIC_METHOD, arguments);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getInstanceField(Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_INSTANCE_FIELD, arguments);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext invokeInstanceMethod(Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.INVOKE_INSTANCE_METHOD, arguments);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext createInstance(Object ... arguments) {
        Command localCommand = new Command(this.runtimeName, CommandType.CREATE_INSTANCE, arguments);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getStaticField(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.GET_STATIC_FIELD, args);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setStaticField(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.SET_STATIC_FIELD, args);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getIndex(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_ITEM, args);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getSize(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_SIZE, args);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext getRank(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_GET_RANK, args);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    @Override
    public InvocationContext setIndex(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.ARRAY_SET_ITEM, args);
        return new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
    }

    public Object getValue() {
        this.resultValue = this.currentCommand.getPayload()[0];
        return this.resultValue;
    }

    public Object[] retrieveArray(Object ... args) {
        Command localCommand = new Command(this.runtimeName, CommandType.RETRIEVE_ARRAY, args);
        InvocationContext localInvCtx = new InvocationContext(this.runtimeName, this.connectionType, this.tcpAddress, this.buildCommand(localCommand));
        localInvCtx.execute();
        Object[] responseArray = (Object[])Array.newInstance(localInvCtx.responseCommand.getPayload()[0].getClass(), localInvCtx.responseCommand.getPayload().length);
        responseArray = (Object[])localInvCtx.responseCommand.getPayload().clone();
        return responseArray;
    }

    private Command buildCommand(Command command) {
        for (int i = 0; i < command.getPayload().length; ++i) {
            command.setPayload(this.encapsulatePayloadItem(command.getPayload()[i]), i);
        }
        return command.prependArgumentToPayload(this.currentCommand);
    }

    private Command encapsulatePayloadItem(Object payloadItem) {
        if (payloadItem instanceof InvocationContext) {
            return new Command(this.runtimeName, CommandType.VALUE, new Object[]{((InvocationContext)payloadItem).currentCommand});
        }
        if (payloadItem.getClass().isArray()) {
            Object[] objectArray = new Object[((Object[])payloadItem).length];
            for (int i = 0; i < ((Object[])payloadItem).length; ++i) {
                objectArray[i] = this.encapsulatePayloadItem(((Object[])payloadItem)[i]);
            }
            return new Command(this.runtimeName, CommandType.ARRAY, objectArray);
        }
        return new Command(this.runtimeName, CommandType.VALUE, new Object[]{payloadItem});
    }

    public Command getCommand() {
        return this.currentCommand;
    }
}

