#!/usr/bin/perl

# Test WSSE authentication
use strict;
use warnings;
use English qw( -no_match_vars );
use Test::More tests => 8;
use Test::WWW::Mechanize::CGIApp;
use Digest::SHA1 qw( sha1 );
use MIME::Base64 qw( encode_base64 );
use lib 't/lib';
use Test::WSSE;

my $mech = Test::WWW::Mechanize::CGIApp->new;
$mech->app(
    sub {
            my $app = Test::WSSE->new(PARAMS => {});
            $app->run();
        }
);

$mech->add_header('Authorization', 'WSSE profile="UsernameToken"');
$mech->add_header('X-WSSE', make_header('secret', 'terces'));

$mech->get( 'http://localhost?noconfig=1',);
$mech->title_like( qr/Must call wsse_config first./, 'noconfig' );

$mech->get( 'http://localhost?nolog=1' );
is( $mech->status, 200, 'nolog ok' );

ok( ! -f 'log', 'log file not created' );

$mech->get( 'http://localhost?&boguspassword=1&nolog=1' );
is( $mech->status, 403, 'no password and no logging' );

$mech->get( 'http://localhost' );
is( $mech->status, 200, 'default ok' );

ok( -f 'log', 'log file created' );

$mech->add_header('X-WSSE', make_header('secret', undef));
$mech->get( 'http://localhost' );
is( $mech->status, 403, 'no password' );

$mech->add_header('X-WSSE', 'Username="secret"');
$mech->get( 'http://localhost' );
is( $mech->status, 400, 'malformed x-wsse header' );

# cleanup
END {

    if ( -f 'log' ) {
        unlink 'log';
    }
}


sub make_header {
 my ($username, $password) = @_;

    my $nonce = sha1(sha1(time() . {} . rand() . $PID));
    my $nonce_enc = encode_base64($nonce, q{});
    my ( $sec, $min, $hour, $mday, $mon, $year ) = gmtime();
    $mon++;
    $year += 1900;
    my $now = sprintf(
        '%04s-%02s-%02sT%02s:%02s:%02sZ',
        $year, $mon, $mday, $hour, $min, $sec,
    );
    my $digest = encode_base64(sha1($nonce . $now . ($password || q{})), 
        q{});

    return  sprintf
 qq(UsernameToken Username="%s", PasswordDigest="%s", Nonce="%s", Created="%s"),
    $username || q{}, $digest, $nonce_enc, $now;
}
