#############################################################
# This file was automatically generated on 2020-11-02.      #
#                                                           #
# Perl Bindings Version 2.1.28                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletRS232V2 - Communicates with RS232 devices

=cut

package Tinkerforge::BrickletRS232V2;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a RS232 Bricklet 2.0.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 2108;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a RS232 Bricklet 2.0.

=cut

use constant DEVICE_DISPLAY_NAME => 'RS232 Bricklet 2.0';

=item CALLBACK_READ_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_READ_LOW_LEVEL callback.

=cut

use constant CALLBACK_READ_LOW_LEVEL => 12;

=item CALLBACK_ERROR_COUNT

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ERROR_COUNT callback.

=cut

use constant CALLBACK_ERROR_COUNT => 13;

=item CALLBACK_FRAME_READABLE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_READABLE callback.

=cut

use constant CALLBACK_FRAME_READABLE => 16;

=item CALLBACK_READ

This constant is used with the register_callback() subroutine to specify
the CALLBACK_READ callback.

=cut

use constant CALLBACK_READ => -12;

=item FUNCTION_WRITE_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_LOW_LEVEL => 1;

=item FUNCTION_READ_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_LOW_LEVEL => 2;

=item FUNCTION_ENABLE_READ_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_READ_CALLBACK => 3;

=item FUNCTION_DISABLE_READ_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_READ_CALLBACK => 4;

=item FUNCTION_IS_READ_CALLBACK_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_READ_CALLBACK_ENABLED => 5;

=item FUNCTION_SET_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CONFIGURATION => 6;

=item FUNCTION_GET_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CONFIGURATION => 7;

=item FUNCTION_SET_BUFFER_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BUFFER_CONFIG => 8;

=item FUNCTION_GET_BUFFER_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BUFFER_CONFIG => 9;

=item FUNCTION_GET_BUFFER_STATUS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BUFFER_STATUS => 10;

=item FUNCTION_GET_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ERROR_COUNT => 11;

=item FUNCTION_SET_FRAME_READABLE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_FRAME_READABLE_CALLBACK_CONFIGURATION => 14;

=item FUNCTION_GET_FRAME_READABLE_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FRAME_READABLE_CALLBACK_CONFIGURATION => 15;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant PARITY_NONE => 0;
use constant PARITY_ODD => 1;
use constant PARITY_EVEN => 2;
use constant STOPBITS_1 => 1;
use constant STOPBITS_2 => 2;
use constant WORDLENGTH_5 => 5;
use constant WORDLENGTH_6 => 6;
use constant WORDLENGTH_7 => 7;
use constant WORDLENGTH_8 => 8;
use constant FLOWCONTROL_OFF => 0;
use constant FLOWCONTROL_SOFTWARE => 1;
use constant FLOWCONTROL_HARDWARE => 2;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 1], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_WRITE_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_READ_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_READ_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_DISABLE_READ_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_IS_READ_CALLBACK_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BUFFER_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_BUFFER_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BUFFER_STATUS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_FRAME_READABLE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_FRAME_READABLE_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_READ_LOW_LEVEL} = shared_clone([72, 'S S a60']);
	$self->{callback_formats}->{&CALLBACK_ERROR_COUNT} = shared_clone([16, 'L L']);
	$self->{callback_formats}->{&CALLBACK_FRAME_READABLE} = shared_clone([10, 'S']);

	$self->{high_level_callbacks}->{&CALLBACK_READ} = shared_clone([shared_clone({stream_length => 0, stream_chunk_offset => 1, stream_chunk_data => 2}), shared_clone(['stream_length', 'stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);

	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item write_low_level()

Writes characters to the RS232 interface. The characters can be binary data,
ASCII or similar is not necessary.

The return value is the number of characters that were written.

See :func:`Set Configuration` for configuration possibilities
regarding baud rate, parity and so on.

=cut

sub write_low_level
{
	my ($self, $message_length, $message_chunk_offset, $message_chunk_data) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_WRITE_LOW_LEVEL, [$message_length, $message_chunk_offset, $message_chunk_data], 'S S a60', 9, 'C');
}

=item read_low_level()

Returns up to *length* characters from receive buffer.

Instead of polling with this function, you can also use
callbacks. But note that this function will return available
data only when the read callback is disabled.
See :func:`Enable Read Callback` and :cb:`Read` callback.

=cut

sub read_low_level
{
	my ($self, $length) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_LOW_LEVEL, [$length], 'S', 72, 'S S a60');
}

=item enable_read_callback()

Enables the :cb:`Read` callback. This will disable the :cb:`Frame Readable` callback.

By default the callback is disabled.

=cut

sub enable_read_callback
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ENABLE_READ_CALLBACK, [], '', 0, '');
}

=item disable_read_callback()

Disables the :cb:`Read` callback.

By default the callback is disabled.

=cut

sub disable_read_callback
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DISABLE_READ_CALLBACK, [], '', 0, '');
}

=item is_read_callback_enabled()

Returns *true* if the :cb:`Read` callback is enabled,
*false* otherwise.

=cut

sub is_read_callback_enabled
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_READ_CALLBACK_ENABLED, [], '', 9, '?');
}

=item set_configuration()

Sets the configuration for the RS232 communication.

=cut

sub set_configuration
{
	my ($self, $baudrate, $parity, $stopbits, $wordlength, $flowcontrol) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CONFIGURATION, [$baudrate, $parity, $stopbits, $wordlength, $flowcontrol], 'L C C C C', 0, '');
}

=item get_configuration()

Returns the configuration as set by :func:`Set Configuration`.

=cut

sub get_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CONFIGURATION, [], '', 16, 'L C C C C');
}

=item set_buffer_config()

Sets the send and receive buffer size in byte. In total the buffers have to be
10240 byte (10KiB) in size, the minimum buffer size is 1024 byte (1KiB) for each.

The current buffer content is lost if this function is called.

The send buffer holds data that is given by :func:`Write` and
can not be written yet. The receive buffer holds data that is
received through RS232 but could not yet be send to the
user, either by :func:`Read` or through :cb:`Read` callback.

=cut

sub set_buffer_config
{
	my ($self, $send_buffer_size, $receive_buffer_size) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_BUFFER_CONFIG, [$send_buffer_size, $receive_buffer_size], 'S S', 0, '');
}

=item get_buffer_config()

Returns the buffer configuration as set by :func:`Set Buffer Config`.

=cut

sub get_buffer_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BUFFER_CONFIG, [], '', 12, 'S S');
}

=item get_buffer_status()

Returns the currently used bytes for the send and received buffer.

See :func:`Set Buffer Config` for buffer size configuration.

=cut

sub get_buffer_status
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BUFFER_STATUS, [], '', 12, 'S S');
}

=item get_error_count()

Returns the current number of overrun and parity errors.

=cut

sub get_error_count
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ERROR_COUNT, [], '', 16, 'L L');
}

=item set_frame_readable_callback_configuration()

Configures the :cb:`Frame Readable` callback. The frame size is the number of bytes, that have to be readable to trigger the callback.
A frame size of 0 disables the callback. A frame size greater than 0 enables the callback and disables the :cb:`Read` callback.

By default the callback is disabled.

.. versionadded:: 2.0.3$nbsp;(Plugin)

=cut

sub set_frame_readable_callback_configuration
{
	my ($self, $frame_size) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_FRAME_READABLE_CALLBACK_CONFIGURATION, [$frame_size], 'S', 0, '');
}

=item get_frame_readable_callback_configuration()

Returns the callback configuration as set by :func:`Set Frame Readable Callback Configuration`.

.. versionadded:: 2.0.3$nbsp;(Plugin)

=cut

sub get_frame_readable_callback_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_FRAME_READABLE_CALLBACK_CONFIGURATION, [], '', 10, 'S');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 24, 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 9, 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 9, 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', 0, '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 9, 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 9, 'C');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', 0, '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 12, 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
A Bricklet connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always at
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=item write()

Writes characters to the RS232 interface. The characters can be binary data,
ASCII or similar is not necessary.

The return value is the number of characters that were written.

See :func:`Set Configuration` for configuration possibilities
regarding baud rate, parity and so on.

=cut

sub write
{
    my ($self, $message) = @_;

    if(scalar(@{$message}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Message can be at most 65535 items long'));
    }

    my $ret = undef;
    my $message_length = scalar(@{$message});
    my $message_chunk_offset = 0;
    my $message_written = 0;

    if($message_length == 0)
    {
        my $message_chunk_data = ['\0'] x 60;

        $ret = $self->write_low_level($message_length, $message_chunk_offset, $message_chunk_data);
        $message_written = $ret;
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($message_chunk_offset < $message_length)
        {
            my $message_chunk_data = [];
            my $message_chunk_length = $message_length - $message_chunk_offset;

            if($message_chunk_length > 60)
            {
                $message_chunk_length = 60;
            }

            for(my $i = 0; $i < $message_chunk_length; $i++)
            {
                push(@{$message_chunk_data}, @{$message}[$message_chunk_offset + $i]);
            }

            if(scalar(@{$message_chunk_data}) < 60)
            {
                push(@{$message_chunk_data}, ('\0') x (60 - scalar(@{$message_chunk_data})));
            }

            $ret = $self->write_low_level($message_length, $message_chunk_offset, $message_chunk_data);
            $message_written += $ret;

            if($ret < 60)
            {
                last; # either last chunk or short write
            }

            $message_chunk_offset += 60;
        }
    }

    return $message_written;
}

=item read()

Returns up to *length* characters from receive buffer.

Instead of polling with this function, you can also use
callbacks. But note that this function will return available
data only when the read callback is disabled.
See :func:`Enable Read Callback` and :cb:`Read` callback.

=cut

sub read
{
    my ($self, $length) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->read_low_level($length);
    my $message_length = $ret[0];
    my $message_chunk_offset = $ret[1];
    my $message_out_of_sync = $message_chunk_offset != 0;
    my $message_data = $ret[2];

    while(!$message_out_of_sync && scalar(@{$message_data}) < $message_length)
    {
        @ret = $self->read_low_level($length);
        $message_length = $ret[0];
        $message_chunk_offset = $ret[1];
        $message_out_of_sync = $message_chunk_offset != scalar(@{$message_data});
        push(@{$message_data}, @{$ret[2]});
    }

    if($message_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($message_chunk_offset + 60 < $message_length)
        {
            @ret = $self->read_low_level($length);
            $message_length = $ret[0];
            $message_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Message stream is out-of-sync'));
    }

    splice(@{$message_data}, $message_length);

    return $message_data;
}

=back
=cut

1;
