#############################################################
# This file was automatically generated on 2020-04-07.      #
#                                                           #
# Perl Bindings Version 2.1.26                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletColor - Measures color (RGB value), illuminance and color temperature

=cut

package Tinkerforge::BrickletColor;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Color Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 243;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Color Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'Color Bricklet';

=item CALLBACK_COLOR

This constant is used with the register_callback() subroutine to specify
the CALLBACK_COLOR callback.

=cut

use constant CALLBACK_COLOR => 8;

=item CALLBACK_COLOR_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_COLOR_REACHED callback.

=cut

use constant CALLBACK_COLOR_REACHED => 9;

=item CALLBACK_ILLUMINANCE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ILLUMINANCE callback.

=cut

use constant CALLBACK_ILLUMINANCE => 21;

=item CALLBACK_COLOR_TEMPERATURE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_COLOR_TEMPERATURE callback.

=cut

use constant CALLBACK_COLOR_TEMPERATURE => 22;

=item FUNCTION_GET_COLOR

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COLOR => 1;

=item FUNCTION_SET_COLOR_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COLOR_CALLBACK_PERIOD => 2;

=item FUNCTION_GET_COLOR_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COLOR_CALLBACK_PERIOD => 3;

=item FUNCTION_SET_COLOR_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COLOR_CALLBACK_THRESHOLD => 4;

=item FUNCTION_GET_COLOR_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COLOR_CALLBACK_THRESHOLD => 5;

=item FUNCTION_SET_DEBOUNCE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DEBOUNCE_PERIOD => 6;

=item FUNCTION_GET_DEBOUNCE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DEBOUNCE_PERIOD => 7;

=item FUNCTION_LIGHT_ON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_LIGHT_ON => 10;

=item FUNCTION_LIGHT_OFF

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_LIGHT_OFF => 11;

=item FUNCTION_IS_LIGHT_ON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_LIGHT_ON => 12;

=item FUNCTION_SET_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CONFIG => 13;

=item FUNCTION_GET_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CONFIG => 14;

=item FUNCTION_GET_ILLUMINANCE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ILLUMINANCE => 15;

=item FUNCTION_GET_COLOR_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COLOR_TEMPERATURE => 16;

=item FUNCTION_SET_ILLUMINANCE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ILLUMINANCE_CALLBACK_PERIOD => 17;

=item FUNCTION_GET_ILLUMINANCE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ILLUMINANCE_CALLBACK_PERIOD => 18;

=item FUNCTION_SET_COLOR_TEMPERATURE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COLOR_TEMPERATURE_CALLBACK_PERIOD => 19;

=item FUNCTION_GET_COLOR_TEMPERATURE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COLOR_TEMPERATURE_CALLBACK_PERIOD => 20;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant THRESHOLD_OPTION_OFF => 'x';
use constant THRESHOLD_OPTION_OUTSIDE => 'o';
use constant THRESHOLD_OPTION_INSIDE => 'i';
use constant THRESHOLD_OPTION_SMALLER => '<';
use constant THRESHOLD_OPTION_GREATER => '>';
use constant LIGHT_ON => 0;
use constant LIGHT_OFF => 1;
use constant GAIN_1X => 0;
use constant GAIN_4X => 1;
use constant GAIN_16X => 2;
use constant GAIN_60X => 3;
use constant INTEGRATION_TIME_2MS => 0;
use constant INTEGRATION_TIME_24MS => 1;
use constant INTEGRATION_TIME_101MS => 2;
use constant INTEGRATION_TIME_154MS => 3;
use constant INTEGRATION_TIME_700MS => 4;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_GET_COLOR} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COLOR_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_COLOR_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COLOR_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_COLOR_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_DEBOUNCE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_DEBOUNCE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_LIGHT_ON} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_LIGHT_OFF} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_IS_LIGHT_ON} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ILLUMINANCE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_COLOR_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ILLUMINANCE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ILLUMINANCE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COLOR_TEMPERATURE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_COLOR_TEMPERATURE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_COLOR} = shared_clone([16, 'S S S S']);
	$self->{callback_formats}->{&CALLBACK_COLOR_REACHED} = shared_clone([16, 'S S S S']);
	$self->{callback_formats}->{&CALLBACK_ILLUMINANCE} = shared_clone([12, 'L']);
	$self->{callback_formats}->{&CALLBACK_COLOR_TEMPERATURE} = shared_clone([10, 'S']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item get_color()

Returns the measured color of the sensor.

The red (r), green (g), blue (b) and clear (c) colors are measured
with four different photodiodes that are responsive at different
wavelengths:

.. image:: /Images/Bricklets/bricklet_color_wavelength_chart_600.jpg
   :scale: 100 %
   :alt: Chart Responsivity / Wavelength
   :align: center
   :target: ../../_images/Bricklets/bricklet_color_wavelength_chart_600.jpg

If you want to get the color periodically, it is recommended
to use the :cb:`Color` callback and set the period with
:func:`Set Color Callback Period`.

=cut

sub get_color
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_COLOR, [], '', 16, 'S S S S');
}

=item set_color_callback_period()

Sets the period with which the :cb:`Color` callback is triggered
periodically. A value of 0 turns the callback off.

The :cb:`Color` callback is only triggered if the color has changed since the
last triggering.

=cut

sub set_color_callback_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_COLOR_CALLBACK_PERIOD, [$period], 'L', 0, '');
}

=item get_color_callback_period()

Returns the period as set by :func:`Set Color Callback Period`.

=cut

sub get_color_callback_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_COLOR_CALLBACK_PERIOD, [], '', 12, 'L');
}

=item set_color_callback_threshold()

Sets the thresholds for the :cb:`Color Reached` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Callback is turned off"
 "'o'",    "Callback is triggered when the temperature is *outside* the min and max values"
 "'i'",    "Callback is triggered when the temperature is *inside* the min and max values"
 "'<'",    "Callback is triggered when the temperature is smaller than the min value (max is ignored)"
 "'>'",    "Callback is triggered when the temperature is greater than the min value (max is ignored)"

=cut

sub set_color_callback_threshold
{
	my ($self, $option, $min_r, $max_r, $min_g, $max_g, $min_b, $max_b, $min_c, $max_c) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_COLOR_CALLBACK_THRESHOLD, [$option, $min_r, $max_r, $min_g, $max_g, $min_b, $max_b, $min_c, $max_c], 'a S S S S S S S S', 0, '');
}

=item get_color_callback_threshold()

Returns the threshold as set by :func:`Set Color Callback Threshold`.

=cut

sub get_color_callback_threshold
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_COLOR_CALLBACK_THRESHOLD, [], '', 25, 'a S S S S S S S S');
}

=item set_debounce_period()

Sets the period with which the threshold callback

* :cb:`Color Reached`

is triggered, if the threshold

* :func:`Set Color Callback Threshold`

keeps being reached.

=cut

sub set_debounce_period
{
	my ($self, $debounce) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DEBOUNCE_PERIOD, [$debounce], 'L', 0, '');
}

=item get_debounce_period()

Returns the debounce period as set by :func:`Set Debounce Period`.

=cut

sub get_debounce_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DEBOUNCE_PERIOD, [], '', 12, 'L');
}

=item light_on()

Turns the LED on.

=cut

sub light_on
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_LIGHT_ON, [], '', 0, '');
}

=item light_off()

Turns the LED off.

=cut

sub light_off
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_LIGHT_OFF, [], '', 0, '');
}

=item is_light_on()

Returns the state of the LED. Possible values are:

* 0: On
* 1: Off

=cut

sub is_light_on
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_LIGHT_ON, [], '', 9, 'C');
}

=item set_config()

Sets the configuration of the sensor. Gain and integration time
can be configured in this way.

For configuring the gain:

* 0: 1x Gain
* 1: 4x Gain
* 2: 16x Gain
* 3: 60x Gain

For configuring the integration time:

* 0: 2.4ms
* 1: 24ms
* 2: 101ms
* 3: 154ms
* 4: 700ms

Increasing the gain enables the sensor to detect a
color from a higher distance.

The integration time provides a trade-off between conversion time
and accuracy. With a longer integration time the values read will
be more accurate but it will take longer time to get the conversion
results.

=cut

sub set_config
{
	my ($self, $gain, $integration_time) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CONFIG, [$gain, $integration_time], 'C C', 0, '');
}

=item get_config()

Returns the configuration as set by :func:`Set Config`.

=cut

sub get_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CONFIG, [], '', 10, 'C C');
}

=item get_illuminance()

Returns the illuminance affected by the gain and integration time as
set by :func:`Set Config`. To get the illuminance in Lux apply this formula::

 lux = illuminance * 700 / gain / integration_time

To get a correct illuminance measurement make sure that the color
values themselves are not saturated. The color value (R, G or B)
is saturated if it is equal to the maximum value of 65535.
In that case you have to reduce the gain, see :func:`Set Config`.

=cut

sub get_illuminance
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ILLUMINANCE, [], '', 12, 'L');
}

=item get_color_temperature()

Returns the color temperature.

To get a correct color temperature measurement make sure that the color
values themselves are not saturated. The color value (R, G or B)
is saturated if it is equal to the maximum value of 65535.
In that case you have to reduce the gain, see :func:`Set Config`.

=cut

sub get_color_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_COLOR_TEMPERATURE, [], '', 10, 'S');
}

=item set_illuminance_callback_period()

Sets the period with which the :cb:`Illuminance` callback is triggered
periodically. A value of 0 turns the callback off.

The :cb:`Illuminance` callback is only triggered if the illuminance has changed
since the last triggering.

=cut

sub set_illuminance_callback_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ILLUMINANCE_CALLBACK_PERIOD, [$period], 'L', 0, '');
}

=item get_illuminance_callback_period()

Returns the period as set by :func:`Set Illuminance Callback Period`.

=cut

sub get_illuminance_callback_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ILLUMINANCE_CALLBACK_PERIOD, [], '', 12, 'L');
}

=item set_color_temperature_callback_period()

Sets the period with which the :cb:`Color Temperature` callback is
triggered periodically. A value of 0 turns the callback off.

The :cb:`Color Temperature` callback is only triggered if the color temperature
has changed since the last triggering.

=cut

sub set_color_temperature_callback_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_COLOR_TEMPERATURE_CALLBACK_PERIOD, [$period], 'L', 0, '');
}

=item get_color_temperature_callback_period()

Returns the period as set by :func:`Set Color Temperature Callback Period`.

=cut

sub get_color_temperature_callback_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_COLOR_TEMPERATURE_CALLBACK_PERIOD, [], '', 12, 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
The Raspberry Pi HAT (Zero) Brick is always at position 'i' and the Bricklet
connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always as
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
