#############################################################
# This file was automatically generated on 2019-01-29.      #
#                                                           #
# Perl Bindings Version 2.1.21                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletLEDStripV2 - Controls up to 2048 RGB(W) LEDs

=cut

package Tinkerforge::BrickletLEDStripV2;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a LED Strip Bricklet 2.0.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 2103;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a LED Strip Bricklet 2.0.

=cut

use constant DEVICE_DISPLAY_NAME => 'LED Strip Bricklet 2.0';

=item CALLBACK_FRAME_STARTED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_FRAME_STARTED callback.

=cut

use constant CALLBACK_FRAME_STARTED => 6;

=item FUNCTION_SET_LED_VALUES_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_LED_VALUES_LOW_LEVEL => 1;

=item FUNCTION_GET_LED_VALUES_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_LED_VALUES_LOW_LEVEL => 2;

=item FUNCTION_SET_FRAME_DURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_FRAME_DURATION => 3;

=item FUNCTION_GET_FRAME_DURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FRAME_DURATION => 4;

=item FUNCTION_GET_SUPPLY_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SUPPLY_VOLTAGE => 5;

=item FUNCTION_SET_CLOCK_FREQUENCY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CLOCK_FREQUENCY => 7;

=item FUNCTION_GET_CLOCK_FREQUENCY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CLOCK_FREQUENCY => 8;

=item FUNCTION_SET_CHIP_TYPE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CHIP_TYPE => 9;

=item FUNCTION_GET_CHIP_TYPE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TYPE => 10;

=item FUNCTION_SET_CHANNEL_MAPPING

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CHANNEL_MAPPING => 11;

=item FUNCTION_GET_CHANNEL_MAPPING

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHANNEL_MAPPING => 12;

=item FUNCTION_SET_FRAME_STARTED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_FRAME_STARTED_CALLBACK_CONFIGURATION => 13;

=item FUNCTION_GET_FRAME_STARTED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_FRAME_STARTED_CALLBACK_CONFIGURATION => 14;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant CHIP_TYPE_WS2801 => 2801;
use constant CHIP_TYPE_WS2811 => 2811;
use constant CHIP_TYPE_WS2812 => 2812;
use constant CHIP_TYPE_LPD8806 => 8806;
use constant CHIP_TYPE_APA102 => 102;
use constant CHANNEL_MAPPING_RGB => 6;
use constant CHANNEL_MAPPING_RBG => 9;
use constant CHANNEL_MAPPING_BRG => 33;
use constant CHANNEL_MAPPING_BGR => 36;
use constant CHANNEL_MAPPING_GRB => 18;
use constant CHANNEL_MAPPING_GBR => 24;
use constant CHANNEL_MAPPING_RGBW => 27;
use constant CHANNEL_MAPPING_RGWB => 30;
use constant CHANNEL_MAPPING_RBGW => 39;
use constant CHANNEL_MAPPING_RBWG => 45;
use constant CHANNEL_MAPPING_RWGB => 54;
use constant CHANNEL_MAPPING_RWBG => 57;
use constant CHANNEL_MAPPING_GRWB => 78;
use constant CHANNEL_MAPPING_GRBW => 75;
use constant CHANNEL_MAPPING_GBWR => 108;
use constant CHANNEL_MAPPING_GBRW => 99;
use constant CHANNEL_MAPPING_GWBR => 120;
use constant CHANNEL_MAPPING_GWRB => 114;
use constant CHANNEL_MAPPING_BRGW => 135;
use constant CHANNEL_MAPPING_BRWG => 141;
use constant CHANNEL_MAPPING_BGRW => 147;
use constant CHANNEL_MAPPING_BGWR => 156;
use constant CHANNEL_MAPPING_BWRG => 177;
use constant CHANNEL_MAPPING_BWGR => 180;
use constant CHANNEL_MAPPING_WRBG => 201;
use constant CHANNEL_MAPPING_WRGB => 198;
use constant CHANNEL_MAPPING_WGBR => 216;
use constant CHANNEL_MAPPING_WGRB => 210;
use constant CHANNEL_MAPPING_WBGR => 228;
use constant CHANNEL_MAPPING_WBRG => 225;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_SET_LED_VALUES_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_LED_VALUES_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_FRAME_DURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_FRAME_DURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SUPPLY_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CLOCK_FREQUENCY} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CLOCK_FREQUENCY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CHIP_TYPE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TYPE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CHANNEL_MAPPING} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CHANNEL_MAPPING} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_FRAME_STARTED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_FRAME_STARTED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_FRAME_STARTED} = 'S';



	bless($self, $class);

	return $self;
}


=item set_led_values_low_level()

Sets the RGB(W) values for the LEDs starting from *index*.
You can set at most 2048 RGB values or 1536 RGBW values.

To make the colors show correctly you need to configure the chip type
(see :func:`Set Chip Type`) and a channel mapping (see :func:`Set Channel Mapping`)
according to the connected LEDs.

If the channel mapping has 3 colors, you need to give the data in the sequence
RGBRGBRGB... if the channel mapping has 4 colors you need to give data in the
sequence RGBWRGBWRGBW...

The data is double buffered and the colors will be transfered to the
LEDs when the next frame duration ends (see :func:`Set Frame Duration`).

Generic approach:

* Set the frame duration to a value that represents the number of frames per
  second you want to achieve.
* Set all of the LED colors for one frame.
* Wait for the :cb:`Frame Started` callback.
* Set all of the LED colors for next frame.
* Wait for the :cb:`Frame Started` callback.
* And so on.

This approach ensures that you can change the LED colors with a fixed frame rate.

=cut

sub set_led_values_low_level
{
	my ($self, $index, $value_length, $value_chunk_offset, $value_chunk_data) = @_;

	$self->_send_request(&FUNCTION_SET_LED_VALUES_LOW_LEVEL, [$index, $value_length, $value_chunk_offset, $value_chunk_data], 'S S S C58', '');
}

=item get_led_values_low_level()

Returns the RGB(W) values as set by :func:`Set LED Values`.

=cut

sub get_led_values_low_level
{
	my ($self, $index, $length) = @_;

	return $self->_send_request(&FUNCTION_GET_LED_VALUES_LOW_LEVEL, [$index, $length], 'S S', 'S S C60');
}

=item set_frame_duration()

Sets the frame duration in ms.

Example: If you want to achieve 20 frames per second, you should
set the frame duration to 50ms (50ms * 20 = 1 second).

For an explanation of the general approach see :func:`Set LED Values`.

Default value: 100ms (10 frames per second).

=cut

sub set_frame_duration
{
	my ($self, $duration) = @_;

	$self->_send_request(&FUNCTION_SET_FRAME_DURATION, [$duration], 'S', '');
}

=item get_frame_duration()

Returns the frame duration in ms as set by :func:`Set Frame Duration`.

=cut

sub get_frame_duration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_FRAME_DURATION, [], '', 'S');
}

=item get_supply_voltage()

Returns the current supply voltage of the LEDs. The voltage is given in mV.

=cut

sub get_supply_voltage
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SUPPLY_VOLTAGE, [], '', 'S');
}

=item set_clock_frequency()

Sets the frequency of the clock in Hz. The range is 10000Hz (10kHz) up to
2000000Hz (2MHz).

The Bricklet will choose the nearest achievable frequency, which may
be off by a few Hz. You can get the exact frequency that is used by
calling :func:`Get Clock Frequency`.

If you have problems with flickering LEDs, they may be bits flipping. You
can fix this by either making the connection between the LEDs and the
Bricklet shorter or by reducing the frequency.

With a decreasing frequency your maximum frames per second will decrease
too.

The default value is 1.66MHz.

=cut

sub set_clock_frequency
{
	my ($self, $frequency) = @_;

	$self->_send_request(&FUNCTION_SET_CLOCK_FREQUENCY, [$frequency], 'L', '');
}

=item get_clock_frequency()

Returns the currently used clock frequency as set by :func:`Set Clock Frequency`.

=cut

sub get_clock_frequency
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CLOCK_FREQUENCY, [], '', 'L');
}

=item set_chip_type()

Sets the type of the LED driver chip. We currently support the chips

* WS2801,
* WS2811,
* WS2812 / SK6812 / NeoPixel RGB,
* SK6812RGBW / NeoPixel RGBW (Chip Type = WS2812),
* LPD8806 and
* APA102 / DotStar.

The default value is WS2801 (2801).

=cut

sub set_chip_type
{
	my ($self, $chip) = @_;

	$self->_send_request(&FUNCTION_SET_CHIP_TYPE, [$chip], 'S', '');
}

=item get_chip_type()

Returns the currently used chip type as set by :func:`Set Chip Type`.

=cut

sub get_chip_type
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TYPE, [], '', 'S');
}

=item set_channel_mapping()

Sets the channel mapping for the connected LEDs.

If the mapping has 4 colors, the function :func:`Set LED Values` expects 4
values per pixel and if the mapping has 3 colors it expects 3 values per pixel.

The function always expects the order RGB(W). The connected LED driver chips
might have their 3 or 4 channels in a different order. For example, the WS2801
chips typically use BGR order, then WS2812 chips typically use GRB order and
the APA102 chips typically use WBGR order.

The APA102 chips are special. They have three 8-bit channels for RGB
and an additional 5-bit channel for the overall brightness of the RGB LED
making them 4-channel chips. Internally the brightness channel is the first
channel, therefore one of the Wxyz channel mappings should be used. Then
the W channel controls the brightness.

The default value is BGR (36).

=cut

sub set_channel_mapping
{
	my ($self, $mapping) = @_;

	$self->_send_request(&FUNCTION_SET_CHANNEL_MAPPING, [$mapping], 'C', '');
}

=item get_channel_mapping()

Returns the currently used channel mapping as set by :func:`Set Channel Mapping`.

=cut

sub get_channel_mapping
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHANNEL_MAPPING, [], '', 'C');
}

=item set_frame_started_callback_configuration()

Enables/disables the :cb:`Frame Started` callback.

By default the callback is enabled.

=cut

sub set_frame_started_callback_configuration
{
	my ($self, $enable) = @_;

	$self->_send_request(&FUNCTION_SET_FRAME_STARTED_CALLBACK_CONFIGURATION, [$enable], '?', '');
}

=item get_frame_started_callback_configuration()

Returns the configuration as set by
:func:`Set Frame Started Callback Configuration`.

=cut

sub get_frame_started_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_FRAME_STARTED_CALLBACK_CONFIGURATION, [], '', '?');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=item set_led_values()

Sets the RGB(W) values for the LEDs starting from *index*.
You can set at most 2048 RGB values or 1536 RGBW values.

To make the colors show correctly you need to configure the chip type
(see :func:`Set Chip Type`) and a channel mapping (see :func:`Set Channel Mapping`)
according to the connected LEDs.

If the channel mapping has 3 colors, you need to give the data in the sequence
RGBRGBRGB... if the channel mapping has 4 colors you need to give data in the
sequence RGBWRGBWRGBW...

The data is double buffered and the colors will be transfered to the
LEDs when the next frame duration ends (see :func:`Set Frame Duration`).

Generic approach:

* Set the frame duration to a value that represents the number of frames per
  second you want to achieve.
* Set all of the LED colors for one frame.
* Wait for the :cb:`Frame Started` callback.
* Set all of the LED colors for next frame.
* Wait for the :cb:`Frame Started` callback.
* And so on.

This approach ensures that you can change the LED colors with a fixed frame rate.

=cut

sub set_led_values
{
    my ($self, $index, $value) = @_;

    if(scalar(@{$value}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Value can be at most 65535 items long'));
    }

    my $value_length = scalar(@{$value});
    my $value_chunk_offset = 0;

    if($value_length == 0)
    {
        my $value_chunk_data = [0] x 58;

        $self->set_led_values_low_level($index, $value_length, $value_chunk_offset, $value_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($value_chunk_offset < $value_length)
        {
            my $value_chunk_data = [];
            my $value_chunk_length = $value_length - $value_chunk_offset;

            if($value_chunk_length > 58) {
                $value_chunk_length = 58;
            }

            for(my $i = 0; $i < $value_chunk_length; $i++) {
                push(@{$value_chunk_data}, @{$value}[$value_chunk_offset + $i]);
            }

            if(scalar(@{$value_chunk_data}) < 58)
            {
                push(@{$value_chunk_data}, (0) x (58 - scalar(@{$value_chunk_data})));
            }

            $self->set_led_values_low_level($index, $value_length, $value_chunk_offset, $value_chunk_data);
            $value_chunk_offset += 58;
        }
    }
}

=item get_led_values()

Returns the RGB(W) values as set by :func:`Set LED Values`.

=cut

sub get_led_values
{
    my ($self, $index, $length) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->get_led_values_low_level($index, $length);
    my $value_length = $ret[0];
    my $value_chunk_offset = $ret[1];
    my $value_out_of_sync = $value_chunk_offset != 0;
    my $value_data = $ret[2];

    while(!$value_out_of_sync && scalar(@{$value_data}) < $value_length)
    {
        @ret = $self->get_led_values_low_level($index, $length);
        $value_length = $ret[0];
        $value_chunk_offset = $ret[1];
        $value_out_of_sync = $value_chunk_offset != scalar(@{$value_data});
        push(@{$value_data}, @{$ret[2]});
    }

    if($value_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($value_chunk_offset + 60 < $value_length)
        {
            @ret = $self->get_led_values_low_level($index, $length);
            $value_length = $ret[0];
            $value_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Value stream is out-of-sync'));
    }

    splice(@{$value_data}, $value_length);

    return $value_data;
}

=back
=cut

1;
