#############################################################
# This file was automatically generated on 2018-11-28.      #
#                                                           #
# Perl Bindings Version 2.1.20                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletOutdoorWeather - 433MHz receiver for outdoor weather station

=cut

package Tinkerforge::BrickletOutdoorWeather;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Outdoor Weather Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 288;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Outdoor Weather Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'Outdoor Weather Bricklet';

=item CALLBACK_STATION_DATA

This constant is used with the register_callback() subroutine to specify
the CALLBACK_STATION_DATA callback.

=cut

use constant CALLBACK_STATION_DATA => 9;

=item CALLBACK_SENSOR_DATA

This constant is used with the register_callback() subroutine to specify
the CALLBACK_SENSOR_DATA callback.

=cut

use constant CALLBACK_SENSOR_DATA => 10;

=item FUNCTION_GET_STATION_IDENTIFIERS_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATION_IDENTIFIERS_LOW_LEVEL => 1;

=item FUNCTION_GET_SENSOR_IDENTIFIERS_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SENSOR_IDENTIFIERS_LOW_LEVEL => 2;

=item FUNCTION_GET_STATION_DATA

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATION_DATA => 3;

=item FUNCTION_GET_SENSOR_DATA

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SENSOR_DATA => 4;

=item FUNCTION_SET_STATION_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATION_CALLBACK_CONFIGURATION => 5;

=item FUNCTION_GET_STATION_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATION_CALLBACK_CONFIGURATION => 6;

=item FUNCTION_SET_SENSOR_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SENSOR_CALLBACK_CONFIGURATION => 7;

=item FUNCTION_GET_SENSOR_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SENSOR_CALLBACK_CONFIGURATION => 8;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant WIND_DIRECTION_N => 0;
use constant WIND_DIRECTION_NNE => 1;
use constant WIND_DIRECTION_NE => 2;
use constant WIND_DIRECTION_ENE => 3;
use constant WIND_DIRECTION_E => 4;
use constant WIND_DIRECTION_ESE => 5;
use constant WIND_DIRECTION_SE => 6;
use constant WIND_DIRECTION_SSE => 7;
use constant WIND_DIRECTION_S => 8;
use constant WIND_DIRECTION_SSW => 9;
use constant WIND_DIRECTION_SW => 10;
use constant WIND_DIRECTION_WSW => 11;
use constant WIND_DIRECTION_W => 12;
use constant WIND_DIRECTION_WNW => 13;
use constant WIND_DIRECTION_NW => 14;
use constant WIND_DIRECTION_NNW => 15;
use constant WIND_DIRECTION_ERROR => 255;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_GET_STATION_IDENTIFIERS_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SENSOR_IDENTIFIERS_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_STATION_DATA} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SENSOR_DATA} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATION_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_STATION_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SENSOR_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SENSOR_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_STATION_DATA} = 'C s C L L L C ?';
	$self->{callback_formats}->{&CALLBACK_SENSOR_DATA} = 'C s C';



	bless($self, $class);

	return $self;
}


=item get_station_identifiers_low_level()

Returns the identifiers (number between 0 and 255) of all `stations
<https://www.tinkerforge.com/en/shop/accessories/sensors/outdoor-weather-station-ws-6147.html>`__
that have been seen since the startup of the Bricklet.

Each station gives itself a random identifier on first startup.

=cut

sub get_station_identifiers_low_level
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATION_IDENTIFIERS_LOW_LEVEL, [], '', 'S S C60');
}

=item get_sensor_identifiers_low_level()

Returns the identifiers (number between 0 and 255) of all `sensors
<https://www.tinkerforge.com/en/shop/accessories/sensors/temperature-humidity-sensor-th-6148.html>`__
that have been seen since the startup of the Bricklet.

Each sensor gives itself a random identifier on first startup.

=cut

sub get_sensor_identifiers_low_level
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SENSOR_IDENTIFIERS_LOW_LEVEL, [], '', 'S S C60');
}

=item get_station_data()

Returns the last received data for a station with the given identifier.
Call :func:`Get Station Identifiers` for a list of all available identifiers.

The return values are:

* Temperature in °C/10,
* Humidity in %RH,
* Wind Speed in m/10s,
* Gust Speed in m/10s,
* Rain Fall in mm/10,
* Wind Direction (N, NNE, NE, ENE, E, ESE, SE, SSE, S, SSW, SW, WSW, W, WNW, NW, NNW),
* Battery Low (true or false) and
* Last Change (time in seconds since the reception of this data).

=cut

sub get_station_data
{
	my ($self, $identifier) = @_;

	return $self->_send_request(&FUNCTION_GET_STATION_DATA, [$identifier], 'C', 's C L L L C ? S');
}

=item get_sensor_data()

Returns the last measured data for a sensor with the given identifier.
Call :func:`Get Sensor Identifiers` for a list of all available identifiers.

The return values are:

* Temperature in °C/10,
* Humidity in %RH and
* Last Change (time in seconds since the last reception of data).

=cut

sub get_sensor_data
{
	my ($self, $identifier) = @_;

	return $self->_send_request(&FUNCTION_GET_SENSOR_DATA, [$identifier], 'C', 's C S');
}

=item set_station_callback_configuration()

Turns callback for station data on or off. Default is off.

=cut

sub set_station_callback_configuration
{
	my ($self, $enable_callback) = @_;

	$self->_send_request(&FUNCTION_SET_STATION_CALLBACK_CONFIGURATION, [$enable_callback], '?', '');
}

=item get_station_callback_configuration()

Returns the configuration as set by :func:`Set Station Callback Configuration`.

=cut

sub get_station_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATION_CALLBACK_CONFIGURATION, [], '', '?');
}

=item set_sensor_callback_configuration()

Turns callback for sensor data on or off. Default is off.

=cut

sub set_sensor_callback_configuration
{
	my ($self, $enable_callback) = @_;

	$self->_send_request(&FUNCTION_SET_SENSOR_CALLBACK_CONFIGURATION, [$enable_callback], '?', '');
}

=item get_sensor_callback_configuration()

Returns the configuration as set by :func:`Set Sensor Callback Configuration`.

=cut

sub get_sensor_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SENSOR_CALLBACK_CONFIGURATION, [], '', '?');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=item get_station_identifiers()

Returns the identifiers (number between 0 and 255) of all `stations
<https://www.tinkerforge.com/en/shop/accessories/sensors/outdoor-weather-station-ws-6147.html>`__
that have been seen since the startup of the Bricklet.

Each station gives itself a random identifier on first startup.

=cut

sub get_station_identifiers
{
    my ($self) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->get_station_identifiers_low_level();
    my $identifiers_length = $ret[0];
    my $identifiers_chunk_offset = $ret[1];
    my $identifiers_out_of_sync = $identifiers_chunk_offset != 0;
    my $identifiers_data = $ret[2];

    while(!$identifiers_out_of_sync && scalar(@{$identifiers_data}) < $identifiers_length)
    {
        @ret = $self->get_station_identifiers_low_level();
        $identifiers_length = $ret[0];
        $identifiers_chunk_offset = $ret[1];
        $identifiers_out_of_sync = $identifiers_chunk_offset != scalar(@{$identifiers_data});
        push(@{$identifiers_data}, @{$ret[2]});
    }

    if($identifiers_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($identifiers_chunk_offset + 60 < $identifiers_length)
        {
            @ret = $self->get_station_identifiers_low_level();
            $identifiers_length = $ret[0];
            $identifiers_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Identifiers stream is out-of-sync'));
    }

    splice(@{$identifiers_data}, $identifiers_length);

    return $identifiers_data;
}

=item get_sensor_identifiers()

Returns the identifiers (number between 0 and 255) of all `sensors
<https://www.tinkerforge.com/en/shop/accessories/sensors/temperature-humidity-sensor-th-6148.html>`__
that have been seen since the startup of the Bricklet.

Each sensor gives itself a random identifier on first startup.

=cut

sub get_sensor_identifiers
{
    my ($self) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->get_sensor_identifiers_low_level();
    my $identifiers_length = $ret[0];
    my $identifiers_chunk_offset = $ret[1];
    my $identifiers_out_of_sync = $identifiers_chunk_offset != 0;
    my $identifiers_data = $ret[2];

    while(!$identifiers_out_of_sync && scalar(@{$identifiers_data}) < $identifiers_length)
    {
        @ret = $self->get_sensor_identifiers_low_level();
        $identifiers_length = $ret[0];
        $identifiers_chunk_offset = $ret[1];
        $identifiers_out_of_sync = $identifiers_chunk_offset != scalar(@{$identifiers_data});
        push(@{$identifiers_data}, @{$ret[2]});
    }

    if($identifiers_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($identifiers_chunk_offset + 60 < $identifiers_length)
        {
            @ret = $self->get_sensor_identifiers_low_level();
            $identifiers_length = $ret[0];
            $identifiers_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Identifiers stream is out-of-sync'));
    }

    splice(@{$identifiers_data}, $identifiers_length);

    return $identifiers_data;
}

=back
=cut

1;
