#############################################################
# This file was automatically generated on 2018-09-28.      #
#                                                           #
# Perl Bindings Version 2.1.18                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletRS485 - Communicates with RS485/Modbus devices with full- or half-duplex

=cut

package Tinkerforge::BrickletRS485;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a RS485 Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 277;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a RS485 Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'RS485 Bricklet';

=item CALLBACK_READ_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_READ_LOW_LEVEL callback.

=cut

use constant CALLBACK_READ_LOW_LEVEL => 41;

=item CALLBACK_ERROR_COUNT

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ERROR_COUNT callback.

=cut

use constant CALLBACK_ERROR_COUNT => 42;

=item CALLBACK_MODBUS_SLAVE_READ_COILS_REQUEST

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_READ_COILS_REQUEST callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_READ_COILS_REQUEST => 43;

=item CALLBACK_MODBUS_MASTER_READ_COILS_RESPONSE_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_READ_COILS_RESPONSE_LOW_LEVEL callback.

=cut

use constant CALLBACK_MODBUS_MASTER_READ_COILS_RESPONSE_LOW_LEVEL => 44;

=item CALLBACK_MODBUS_SLAVE_READ_HOLDING_REGISTERS_REQUEST

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_READ_HOLDING_REGISTERS_REQUEST callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_READ_HOLDING_REGISTERS_REQUEST => 45;

=item CALLBACK_MODBUS_MASTER_READ_HOLDING_REGISTERS_RESPONSE_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_READ_HOLDING_REGISTERS_RESPONSE_LOW_LEVEL callback.

=cut

use constant CALLBACK_MODBUS_MASTER_READ_HOLDING_REGISTERS_RESPONSE_LOW_LEVEL => 46;

=item CALLBACK_MODBUS_SLAVE_WRITE_SINGLE_COIL_REQUEST

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_WRITE_SINGLE_COIL_REQUEST callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_WRITE_SINGLE_COIL_REQUEST => 47;

=item CALLBACK_MODBUS_MASTER_WRITE_SINGLE_COIL_RESPONSE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_WRITE_SINGLE_COIL_RESPONSE callback.

=cut

use constant CALLBACK_MODBUS_MASTER_WRITE_SINGLE_COIL_RESPONSE => 48;

=item CALLBACK_MODBUS_SLAVE_WRITE_SINGLE_REGISTER_REQUEST

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_WRITE_SINGLE_REGISTER_REQUEST callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_WRITE_SINGLE_REGISTER_REQUEST => 49;

=item CALLBACK_MODBUS_MASTER_WRITE_SINGLE_REGISTER_RESPONSE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_WRITE_SINGLE_REGISTER_RESPONSE callback.

=cut

use constant CALLBACK_MODBUS_MASTER_WRITE_SINGLE_REGISTER_RESPONSE => 50;

=item CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_COILS_REQUEST_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_COILS_REQUEST_LOW_LEVEL callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_COILS_REQUEST_LOW_LEVEL => 51;

=item CALLBACK_MODBUS_MASTER_WRITE_MULTIPLE_COILS_RESPONSE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_WRITE_MULTIPLE_COILS_RESPONSE callback.

=cut

use constant CALLBACK_MODBUS_MASTER_WRITE_MULTIPLE_COILS_RESPONSE => 52;

=item CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_REGISTERS_REQUEST_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_REGISTERS_REQUEST_LOW_LEVEL callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_REGISTERS_REQUEST_LOW_LEVEL => 53;

=item CALLBACK_MODBUS_MASTER_WRITE_MULTIPLE_REGISTERS_RESPONSE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_WRITE_MULTIPLE_REGISTERS_RESPONSE callback.

=cut

use constant CALLBACK_MODBUS_MASTER_WRITE_MULTIPLE_REGISTERS_RESPONSE => 54;

=item CALLBACK_MODBUS_SLAVE_READ_DISCRETE_INPUTS_REQUEST

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_READ_DISCRETE_INPUTS_REQUEST callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_READ_DISCRETE_INPUTS_REQUEST => 55;

=item CALLBACK_MODBUS_MASTER_READ_DISCRETE_INPUTS_RESPONSE_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_READ_DISCRETE_INPUTS_RESPONSE_LOW_LEVEL callback.

=cut

use constant CALLBACK_MODBUS_MASTER_READ_DISCRETE_INPUTS_RESPONSE_LOW_LEVEL => 56;

=item CALLBACK_MODBUS_SLAVE_READ_INPUT_REGISTERS_REQUEST

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_READ_INPUT_REGISTERS_REQUEST callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_READ_INPUT_REGISTERS_REQUEST => 57;

=item CALLBACK_MODBUS_MASTER_READ_INPUT_REGISTERS_RESPONSE_LOW_LEVEL

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_READ_INPUT_REGISTERS_RESPONSE_LOW_LEVEL callback.

=cut

use constant CALLBACK_MODBUS_MASTER_READ_INPUT_REGISTERS_RESPONSE_LOW_LEVEL => 58;

=item CALLBACK_READ

This constant is used with the register_callback() subroutine to specify
the CALLBACK_READ callback.

=cut

use constant CALLBACK_READ => -41;

=item CALLBACK_MODBUS_MASTER_READ_COILS_RESPONSE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_READ_COILS_RESPONSE callback.

=cut

use constant CALLBACK_MODBUS_MASTER_READ_COILS_RESPONSE => -44;

=item CALLBACK_MODBUS_MASTER_READ_HOLDING_REGISTERS_RESPONSE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_READ_HOLDING_REGISTERS_RESPONSE callback.

=cut

use constant CALLBACK_MODBUS_MASTER_READ_HOLDING_REGISTERS_RESPONSE => -46;

=item CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_COILS_REQUEST

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_COILS_REQUEST callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_COILS_REQUEST => -51;

=item CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_REGISTERS_REQUEST

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_REGISTERS_REQUEST callback.

=cut

use constant CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_REGISTERS_REQUEST => -53;

=item CALLBACK_MODBUS_MASTER_READ_DISCRETE_INPUTS_RESPONSE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_READ_DISCRETE_INPUTS_RESPONSE callback.

=cut

use constant CALLBACK_MODBUS_MASTER_READ_DISCRETE_INPUTS_RESPONSE => -56;

=item CALLBACK_MODBUS_MASTER_READ_INPUT_REGISTERS_RESPONSE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MODBUS_MASTER_READ_INPUT_REGISTERS_RESPONSE callback.

=cut

use constant CALLBACK_MODBUS_MASTER_READ_INPUT_REGISTERS_RESPONSE => -58;

=item FUNCTION_WRITE_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_LOW_LEVEL => 1;

=item FUNCTION_READ_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_LOW_LEVEL => 2;

=item FUNCTION_ENABLE_READ_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_READ_CALLBACK => 3;

=item FUNCTION_DISABLE_READ_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_READ_CALLBACK => 4;

=item FUNCTION_IS_READ_CALLBACK_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_READ_CALLBACK_ENABLED => 5;

=item FUNCTION_SET_RS485_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_RS485_CONFIGURATION => 6;

=item FUNCTION_GET_RS485_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_RS485_CONFIGURATION => 7;

=item FUNCTION_SET_MODBUS_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MODBUS_CONFIGURATION => 8;

=item FUNCTION_GET_MODBUS_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MODBUS_CONFIGURATION => 9;

=item FUNCTION_SET_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MODE => 10;

=item FUNCTION_GET_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MODE => 11;

=item FUNCTION_SET_COMMUNICATION_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COMMUNICATION_LED_CONFIG => 12;

=item FUNCTION_GET_COMMUNICATION_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COMMUNICATION_LED_CONFIG => 13;

=item FUNCTION_SET_ERROR_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ERROR_LED_CONFIG => 14;

=item FUNCTION_GET_ERROR_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ERROR_LED_CONFIG => 15;

=item FUNCTION_SET_BUFFER_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BUFFER_CONFIG => 16;

=item FUNCTION_GET_BUFFER_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BUFFER_CONFIG => 17;

=item FUNCTION_GET_BUFFER_STATUS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BUFFER_STATUS => 18;

=item FUNCTION_ENABLE_ERROR_COUNT_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_ERROR_COUNT_CALLBACK => 19;

=item FUNCTION_DISABLE_ERROR_COUNT_CALLBACK

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_ERROR_COUNT_CALLBACK => 20;

=item FUNCTION_IS_ERROR_COUNT_CALLBACK_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_ERROR_COUNT_CALLBACK_ENABLED => 21;

=item FUNCTION_GET_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ERROR_COUNT => 22;

=item FUNCTION_GET_MODBUS_COMMON_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MODBUS_COMMON_ERROR_COUNT => 23;

=item FUNCTION_MODBUS_SLAVE_REPORT_EXCEPTION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_REPORT_EXCEPTION => 24;

=item FUNCTION_MODBUS_SLAVE_ANSWER_READ_COILS_REQUEST_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_ANSWER_READ_COILS_REQUEST_LOW_LEVEL => 25;

=item FUNCTION_MODBUS_MASTER_READ_COILS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_MASTER_READ_COILS => 26;

=item FUNCTION_MODBUS_SLAVE_ANSWER_READ_HOLDING_REGISTERS_REQUEST_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_ANSWER_READ_HOLDING_REGISTERS_REQUEST_LOW_LEVEL => 27;

=item FUNCTION_MODBUS_MASTER_READ_HOLDING_REGISTERS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_MASTER_READ_HOLDING_REGISTERS => 28;

=item FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_SINGLE_COIL_REQUEST

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_SINGLE_COIL_REQUEST => 29;

=item FUNCTION_MODBUS_MASTER_WRITE_SINGLE_COIL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_MASTER_WRITE_SINGLE_COIL => 30;

=item FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_SINGLE_REGISTER_REQUEST

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_SINGLE_REGISTER_REQUEST => 31;

=item FUNCTION_MODBUS_MASTER_WRITE_SINGLE_REGISTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_MASTER_WRITE_SINGLE_REGISTER => 32;

=item FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_MULTIPLE_COILS_REQUEST

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_MULTIPLE_COILS_REQUEST => 33;

=item FUNCTION_MODBUS_MASTER_WRITE_MULTIPLE_COILS_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_MASTER_WRITE_MULTIPLE_COILS_LOW_LEVEL => 34;

=item FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_MULTIPLE_REGISTERS_REQUEST

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_MULTIPLE_REGISTERS_REQUEST => 35;

=item FUNCTION_MODBUS_MASTER_WRITE_MULTIPLE_REGISTERS_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_MASTER_WRITE_MULTIPLE_REGISTERS_LOW_LEVEL => 36;

=item FUNCTION_MODBUS_SLAVE_ANSWER_READ_DISCRETE_INPUTS_REQUEST_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_ANSWER_READ_DISCRETE_INPUTS_REQUEST_LOW_LEVEL => 37;

=item FUNCTION_MODBUS_MASTER_READ_DISCRETE_INPUTS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_MASTER_READ_DISCRETE_INPUTS => 38;

=item FUNCTION_MODBUS_SLAVE_ANSWER_READ_INPUT_REGISTERS_REQUEST_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_SLAVE_ANSWER_READ_INPUT_REGISTERS_REQUEST_LOW_LEVEL => 39;

=item FUNCTION_MODBUS_MASTER_READ_INPUT_REGISTERS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_MODBUS_MASTER_READ_INPUT_REGISTERS => 40;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant PARITY_NONE => 0;
use constant PARITY_ODD => 1;
use constant PARITY_EVEN => 2;
use constant STOPBITS_1 => 1;
use constant STOPBITS_2 => 2;
use constant WORDLENGTH_5 => 5;
use constant WORDLENGTH_6 => 6;
use constant WORDLENGTH_7 => 7;
use constant WORDLENGTH_8 => 8;
use constant DUPLEX_HALF => 0;
use constant DUPLEX_FULL => 1;
use constant MODE_RS485 => 0;
use constant MODE_MODBUS_MASTER_RTU => 1;
use constant MODE_MODBUS_SLAVE_RTU => 2;
use constant COMMUNICATION_LED_CONFIG_OFF => 0;
use constant COMMUNICATION_LED_CONFIG_ON => 1;
use constant COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION => 3;
use constant ERROR_LED_CONFIG_OFF => 0;
use constant ERROR_LED_CONFIG_ON => 1;
use constant ERROR_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant ERROR_LED_CONFIG_SHOW_ERROR => 3;
use constant EXCEPTION_CODE_TIMEOUT => -1;
use constant EXCEPTION_CODE_SUCCESS => 0;
use constant EXCEPTION_CODE_ILLEGAL_FUNCTION => 1;
use constant EXCEPTION_CODE_ILLEGAL_DATA_ADDRESS => 2;
use constant EXCEPTION_CODE_ILLEGAL_DATA_VALUE => 3;
use constant EXCEPTION_CODE_SLAVE_DEVICE_FAILURE => 4;
use constant EXCEPTION_CODE_ACKNOWLEDGE => 5;
use constant EXCEPTION_CODE_SLAVE_DEVICE_BUSY => 6;
use constant EXCEPTION_CODE_MEMORY_PARITY_ERROR => 8;
use constant EXCEPTION_CODE_GATEWAY_PATH_UNAVAILABLE => 10;
use constant EXCEPTION_CODE_GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND => 11;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_WRITE_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_READ_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_READ_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_DISABLE_READ_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_IS_READ_CALLBACK_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_RS485_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_RS485_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MODBUS_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_MODBUS_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COMMUNICATION_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_COMMUNICATION_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ERROR_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ERROR_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BUFFER_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_BUFFER_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BUFFER_STATUS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_ERROR_COUNT_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_DISABLE_ERROR_COUNT_CALLBACK} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_IS_ERROR_COUNT_CALLBACK_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_MODBUS_COMMON_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_REPORT_EXCEPTION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_ANSWER_READ_COILS_REQUEST_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_MASTER_READ_COILS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_ANSWER_READ_HOLDING_REGISTERS_REQUEST_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_MASTER_READ_HOLDING_REGISTERS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_SINGLE_COIL_REQUEST} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_MODBUS_MASTER_WRITE_SINGLE_COIL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_SINGLE_REGISTER_REQUEST} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_MODBUS_MASTER_WRITE_SINGLE_REGISTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_MULTIPLE_COILS_REQUEST} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_MODBUS_MASTER_WRITE_MULTIPLE_COILS_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_MULTIPLE_REGISTERS_REQUEST} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_MODBUS_MASTER_WRITE_MULTIPLE_REGISTERS_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_ANSWER_READ_DISCRETE_INPUTS_REQUEST_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_MASTER_READ_DISCRETE_INPUTS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_SLAVE_ANSWER_READ_INPUT_REGISTERS_REQUEST_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_MODBUS_MASTER_READ_INPUT_REGISTERS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_READ_LOW_LEVEL} = 'S S a60';
	$self->{callback_formats}->{&CALLBACK_ERROR_COUNT} = 'L L';
	$self->{callback_formats}->{&CALLBACK_MODBUS_SLAVE_READ_COILS_REQUEST} = 'C L S';
	$self->{callback_formats}->{&CALLBACK_MODBUS_MASTER_READ_COILS_RESPONSE_LOW_LEVEL} = 'C c S S ?464';
	$self->{callback_formats}->{&CALLBACK_MODBUS_SLAVE_READ_HOLDING_REGISTERS_REQUEST} = 'C L S';
	$self->{callback_formats}->{&CALLBACK_MODBUS_MASTER_READ_HOLDING_REGISTERS_RESPONSE_LOW_LEVEL} = 'C c S S S29';
	$self->{callback_formats}->{&CALLBACK_MODBUS_SLAVE_WRITE_SINGLE_COIL_REQUEST} = 'C L ?';
	$self->{callback_formats}->{&CALLBACK_MODBUS_MASTER_WRITE_SINGLE_COIL_RESPONSE} = 'C c';
	$self->{callback_formats}->{&CALLBACK_MODBUS_SLAVE_WRITE_SINGLE_REGISTER_REQUEST} = 'C L S';
	$self->{callback_formats}->{&CALLBACK_MODBUS_MASTER_WRITE_SINGLE_REGISTER_RESPONSE} = 'C c';
	$self->{callback_formats}->{&CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_COILS_REQUEST_LOW_LEVEL} = 'C L S S ?440';
	$self->{callback_formats}->{&CALLBACK_MODBUS_MASTER_WRITE_MULTIPLE_COILS_RESPONSE} = 'C c';
	$self->{callback_formats}->{&CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_REGISTERS_REQUEST_LOW_LEVEL} = 'C L S S S27';
	$self->{callback_formats}->{&CALLBACK_MODBUS_MASTER_WRITE_MULTIPLE_REGISTERS_RESPONSE} = 'C c';
	$self->{callback_formats}->{&CALLBACK_MODBUS_SLAVE_READ_DISCRETE_INPUTS_REQUEST} = 'C L S';
	$self->{callback_formats}->{&CALLBACK_MODBUS_MASTER_READ_DISCRETE_INPUTS_RESPONSE_LOW_LEVEL} = 'C c S S ?464';
	$self->{callback_formats}->{&CALLBACK_MODBUS_SLAVE_READ_INPUT_REGISTERS_REQUEST} = 'C L S';
	$self->{callback_formats}->{&CALLBACK_MODBUS_MASTER_READ_INPUT_REGISTERS_RESPONSE_LOW_LEVEL} = 'C c S S S29';

	$self->{high_level_callbacks}->{&CALLBACK_READ} = shared_clone([shared_clone({stream_length => 0, stream_chunk_offset => 1, stream_chunk_data => 2}), shared_clone(['stream_length', 'stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);
	$self->{high_level_callbacks}->{&CALLBACK_MODBUS_MASTER_READ_COILS_RESPONSE} = shared_clone([shared_clone({stream_length => 2, stream_chunk_offset => 3, stream_chunk_data => 4}), shared_clone([undef, undef, 'stream_length', 'stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);
	$self->{high_level_callbacks}->{&CALLBACK_MODBUS_MASTER_READ_HOLDING_REGISTERS_RESPONSE} = shared_clone([shared_clone({stream_length => 2, stream_chunk_offset => 3, stream_chunk_data => 4}), shared_clone([undef, undef, 'stream_length', 'stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);
	$self->{high_level_callbacks}->{&CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_COILS_REQUEST} = shared_clone([shared_clone({stream_length => 2, stream_chunk_offset => 3, stream_chunk_data => 4}), shared_clone([undef, undef, 'stream_length', 'stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);
	$self->{high_level_callbacks}->{&CALLBACK_MODBUS_SLAVE_WRITE_MULTIPLE_REGISTERS_REQUEST} = shared_clone([shared_clone({stream_length => 2, stream_chunk_offset => 3, stream_chunk_data => 4}), shared_clone([undef, undef, 'stream_length', 'stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);
	$self->{high_level_callbacks}->{&CALLBACK_MODBUS_MASTER_READ_DISCRETE_INPUTS_RESPONSE} = shared_clone([shared_clone({stream_length => 2, stream_chunk_offset => 3, stream_chunk_data => 4}), shared_clone([undef, undef, 'stream_length', 'stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);
	$self->{high_level_callbacks}->{&CALLBACK_MODBUS_MASTER_READ_INPUT_REGISTERS_RESPONSE} = shared_clone([shared_clone({stream_length => 2, stream_chunk_offset => 3, stream_chunk_data => 4}), shared_clone([undef, undef, 'stream_length', 'stream_chunk_offset', 'stream_chunk_data']), shared_clone({fixed_length => undef, single_chunk => 0}), undef]);

	bless($self, $class);

	return $self;
}


=item write_low_level()

Writes characters to the RS485 interface. The characters can be binary data,
ASCII or similar is not necessary.

The return value is the number of characters that were written.

See :func:`Set RS485 Configuration` for configuration possibilities
regarding baudrate, parity and so on.

=cut

sub write_low_level
{
	my ($self, $message_length, $message_chunk_offset, $message_chunk_data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_LOW_LEVEL, [$message_length, $message_chunk_offset, $message_chunk_data], 'S S a60', 'C');
}

=item read_low_level()

Returns up to *length* characters from receive buffer.

Instead of polling with this function, you can also use
callbacks. But note that this function will return available
data only when the read callback is disabled.
See :func:`Enable Read Callback` and :cb:`Read` callback.

=cut

sub read_low_level
{
	my ($self, $length) = @_;

	return $self->_send_request(&FUNCTION_READ_LOW_LEVEL, [$length], 'S', 'S S a60');
}

=item enable_read_callback()

Enables the :cb:`Read` callback.

By default the callback is disabled.

=cut

sub enable_read_callback
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_ENABLE_READ_CALLBACK, [], '', '');
}

=item disable_read_callback()

Disables the :cb:`Read` callback.

By default the callback is disabled.

=cut

sub disable_read_callback
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_DISABLE_READ_CALLBACK, [], '', '');
}

=item is_read_callback_enabled()

Returns *true* if the :cb:`Read` callback is enabled,
*false* otherwise.

=cut

sub is_read_callback_enabled
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_IS_READ_CALLBACK_ENABLED, [], '', '?');
}

=item set_rs485_configuration()

Sets the configuration for the RS485 communication. Available options:

* Baudrate between 100 and 2000000 baud.
* Parity of none, odd or even.
* Stopbits can be 1 or 2.
* Word length of 5 to 8.
* Half- or Full-Duplex.

The default is: 115200 baud, parity none, 1 stop bit, word length 8, half duplex.

=cut

sub set_rs485_configuration
{
	my ($self, $baudrate, $parity, $stopbits, $wordlength, $duplex) = @_;

	$self->_send_request(&FUNCTION_SET_RS485_CONFIGURATION, [$baudrate, $parity, $stopbits, $wordlength, $duplex], 'L C C C C', '');
}

=item get_rs485_configuration()

Returns the configuration as set by :func:`Set RS485 Configuration`.

=cut

sub get_rs485_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_RS485_CONFIGURATION, [], '', 'L C C C C');
}

=item set_modbus_configuration()

Sets the configuration for the RS485 Modbus communication. Available options:

* Slave Address: Address to be used as the Modbus slave address in Modbus slave mode. Valid Modbus slave address range is 1 to 247.
* Master Request Timeout: Specifies how long the master should wait for a response from a slave in milliseconds when in Modbus master mode.

The default is: Slave Address = 1 and Master Request Timeout = 1000 milliseconds (1 second).

=cut

sub set_modbus_configuration
{
	my ($self, $slave_address, $master_request_timeout) = @_;

	$self->_send_request(&FUNCTION_SET_MODBUS_CONFIGURATION, [$slave_address, $master_request_timeout], 'C L', '');
}

=item get_modbus_configuration()

Returns the configuration as set by :func:`Set Modbus Configuration`.

=cut

sub get_modbus_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_MODBUS_CONFIGURATION, [], '', 'C L');
}

=item set_mode()

Sets the mode of the Bricklet in which it operates. Available options are

* RS485,
* Modbus Master RTU and
* Modbus Slave RTU.

The default is: RS485 mode.

=cut

sub set_mode
{
	my ($self, $mode) = @_;

	$self->_send_request(&FUNCTION_SET_MODE, [$mode], 'C', '');
}

=item get_mode()

Returns the configuration as set by :func:`Set Mode`.

=cut

sub get_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_MODE, [], '', 'C');
}

=item set_communication_led_config()

Sets the communication LED configuration. By default the LED shows RS485
communication traffic by flickering.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is off.

=cut

sub set_communication_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_COMMUNICATION_LED_CONFIG, [$config], 'C', '');
}

=item get_communication_led_config()

Returns the configuration as set by :func:`Set Communication LED Config`

=cut

sub get_communication_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_COMMUNICATION_LED_CONFIG, [], '', 'C');
}

=item set_error_led_config()

Sets the error LED configuration.

By default the error LED turns on if there is any error (see :cb:`Error Count`
callback). If you call this function with the SHOW ERROR option again, the LED
will turn off until the next error occurs.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is off.

=cut

sub set_error_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_ERROR_LED_CONFIG, [$config], 'C', '');
}

=item get_error_led_config()

Returns the configuration as set by :func:`Set Error LED Config`.

=cut

sub get_error_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ERROR_LED_CONFIG, [], '', 'C');
}

=item set_buffer_config()

Sets the send and receive buffer size in byte. In sum there is
10240 byte (10kb) buffer available and the minimum buffer size
is 1024 byte (1kb) for both.

The current buffer content is lost if this function is called.

The send buffer holds data that was given by :func:`Write` and
could not be written yet. The receive buffer holds data that is
received through RS485 but could not yet be send to the
user, either by :func:`Read` or through :cb:`Read` callback.

The default configuration is 5120 byte (5kb) per buffer.

=cut

sub set_buffer_config
{
	my ($self, $send_buffer_size, $receive_buffer_size) = @_;

	$self->_send_request(&FUNCTION_SET_BUFFER_CONFIG, [$send_buffer_size, $receive_buffer_size], 'S S', '');
}

=item get_buffer_config()

Returns the buffer configuration as set by :func:`Set Buffer Config`.

=cut

sub get_buffer_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BUFFER_CONFIG, [], '', 'S S');
}

=item get_buffer_status()

Returns the currently used bytes for the send and received buffer.

See :func:`Set Buffer Config` for buffer size configuration.

=cut

sub get_buffer_status
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BUFFER_STATUS, [], '', 'S S');
}

=item enable_error_count_callback()

Enables the :cb:`Error Count` callback.

By default the callback is disabled.

=cut

sub enable_error_count_callback
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_ENABLE_ERROR_COUNT_CALLBACK, [], '', '');
}

=item disable_error_count_callback()

Disables the :cb:`Error Count` callback.

By default the callback is disabled.

=cut

sub disable_error_count_callback
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_DISABLE_ERROR_COUNT_CALLBACK, [], '', '');
}

=item is_error_count_callback_enabled()

Returns *true* if the :cb:`Error Count` callback is enabled,
*false* otherwise.

=cut

sub is_error_count_callback_enabled
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_IS_ERROR_COUNT_CALLBACK_ENABLED, [], '', '?');
}

=item get_error_count()

Returns the current number of overrun and parity errors.

=cut

sub get_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ERROR_COUNT, [], '', 'L L');
}

=item get_modbus_common_error_count()

Returns the current number of errors occurred in Modbus mode.

* Timeout Error Count: Number of timeouts occurred.
* Checksum Error Count: Number of failures due to Modbus frame CRC16 checksum mismatch.
* Frame Too Big Error Count: Number of times frames were rejected because they exceeded maximum Modbus frame size which is 256 bytes.
* Illegal Function Error Count: Number of errors when an unimplemented or illegal function is requested. This corresponds to Modbus exception code 1.
* Illegal Data Address Error Count: Number of errors due to invalid data address. This corresponds to Modbus exception code 2.
* Illegal Data Value Error Count: Number of errors due to invalid data value. This corresponds to Modbus exception code 3.
* Slave Device Failure Error Count: Number of errors occurred on the slave device which were unrecoverable. This corresponds to Modbus exception code 4.

=cut

sub get_modbus_common_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_MODBUS_COMMON_ERROR_COUNT, [], '', 'L L L L L L L');
}

=item modbus_slave_report_exception()

In Modbus slave mode this function can be used to report a Modbus exception for
a Modbus master request.

* Request ID: Request ID of the request received by the slave.
* Exception Code: Modbus exception code to report to the Modbus master.

=cut

sub modbus_slave_report_exception
{
	my ($self, $request_id, $exception_code) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_REPORT_EXCEPTION, [$request_id, $exception_code], 'C c', '');
}

=item modbus_slave_answer_read_coils_request_low_level()

In Modbus slave mode this function can be used to answer a master request to
read coils.

* Request ID: Request ID of the corresponding request that is being answered.
* Coils: Data that is to be sent to the Modbus master for the corresponding request.

This function must be called from the :cb:`Modbus Slave Read Coils Request` callback
with the Request ID as provided by the argument of the callback.

=cut

sub modbus_slave_answer_read_coils_request_low_level
{
	my ($self, $request_id, $coils_length, $coils_chunk_offset, $coils_chunk_data) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_ANSWER_READ_COILS_REQUEST_LOW_LEVEL, [$request_id, $coils_length, $coils_chunk_offset, $coils_chunk_data], 'C S S ?472', '');
}

=item modbus_master_read_coils()

In Modbus master mode this function can be used to read coils from a slave. This
function creates a Modbus function code 1 request.

* Slave Address: Address of the target Modbus slave.
* Starting Address: Starting address of the read.
* Count: Number of coils to read.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Read Coils Response`
callback. In this callback the Request ID provided by the callback argument must be
matched with the Request ID returned from this function to verify that the callback
is indeed for a particular request.

=cut

sub modbus_master_read_coils
{
	my ($self, $slave_address, $starting_address, $count) = @_;

	return $self->_send_request(&FUNCTION_MODBUS_MASTER_READ_COILS, [$slave_address, $starting_address, $count], 'C L S', 'C');
}

=item modbus_slave_answer_read_holding_registers_request_low_level()

In Modbus slave mode this function can be used to answer a master request to
read holding registers.

* Request ID: Request ID of the corresponding request that is being answered.
* Holding Registers: Data that is to be sent to the Modbus master for the corresponding request.

This function must be called from the :cb:`Modbus Slave Read Holding Registers Request`
callback with the Request ID as provided by the argument of the callback.

=cut

sub modbus_slave_answer_read_holding_registers_request_low_level
{
	my ($self, $request_id, $holding_registers_length, $holding_registers_chunk_offset, $holding_registers_chunk_data) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_ANSWER_READ_HOLDING_REGISTERS_REQUEST_LOW_LEVEL, [$request_id, $holding_registers_length, $holding_registers_chunk_offset, $holding_registers_chunk_data], 'C S S S29', '');
}

=item modbus_master_read_holding_registers()

In Modbus master mode this function can be used to read holding registers from a slave.
This function creates a Modbus function code 3 request.

* Slave Address: Address of the target Modbus slave.
* Starting Address: Starting address of the read.
* Count: Number of holding registers to read.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Read Holding Registers Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_read_holding_registers
{
	my ($self, $slave_address, $starting_address, $count) = @_;

	return $self->_send_request(&FUNCTION_MODBUS_MASTER_READ_HOLDING_REGISTERS, [$slave_address, $starting_address, $count], 'C L S', 'C');
}

=item modbus_slave_answer_write_single_coil_request()

In Modbus slave mode this function can be used to answer a master request to
write a single coil.

* Request ID: Request ID of the corresponding request that is being answered.

This function must be called from the :cb:`Modbus Slave Write Single Coil Request`
callback with the Request ID as provided by the arguments of the callback.

=cut

sub modbus_slave_answer_write_single_coil_request
{
	my ($self, $request_id) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_SINGLE_COIL_REQUEST, [$request_id], 'C', '');
}

=item modbus_master_write_single_coil()

In Modbus master mode this function can be used to write a single coil of a slave.
This function creates a Modbus function code 5 request.

* Slave Address: Address of the target Modbus slave.
* Coil Address: Address of the coil.
* Coil Value: Value to be written.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Write Single Coil Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_write_single_coil
{
	my ($self, $slave_address, $coil_address, $coil_value) = @_;

	return $self->_send_request(&FUNCTION_MODBUS_MASTER_WRITE_SINGLE_COIL, [$slave_address, $coil_address, $coil_value], 'C L ?', 'C');
}

=item modbus_slave_answer_write_single_register_request()

In Modbus slave mode this function can be used to answer a master request to
write a single register.

* Request ID: Request ID of the corresponding request that is being answered.

This function must be called from the :cb:`Modbus Slave Write Single Register Request`
callback with the Request ID, Register Address and Register Value as provided by
the arguments of the callback.

=cut

sub modbus_slave_answer_write_single_register_request
{
	my ($self, $request_id) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_SINGLE_REGISTER_REQUEST, [$request_id], 'C', '');
}

=item modbus_master_write_single_register()

In Modbus master mode this function can be used to write a single register of a
slave. This function creates a Modbus function code 6 request.

* Slave Address: Address of the target Modbus slave.
* Register Address: Address of the register.
* Register Value: Value to be written.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Write Single Register Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_write_single_register
{
	my ($self, $slave_address, $register_address, $register_value) = @_;

	return $self->_send_request(&FUNCTION_MODBUS_MASTER_WRITE_SINGLE_REGISTER, [$slave_address, $register_address, $register_value], 'C L S', 'C');
}

=item modbus_slave_answer_write_multiple_coils_request()

In Modbus slave mode this function can be used to answer a master request to
write multiple coils.

* Request ID: Request ID of the corresponding request that is being answered.

This function must be called from the :cb:`Modbus Slave Write Multiple Coils Request`
callback with the Request ID of the callback.

=cut

sub modbus_slave_answer_write_multiple_coils_request
{
	my ($self, $request_id) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_MULTIPLE_COILS_REQUEST, [$request_id], 'C', '');
}

=item modbus_master_write_multiple_coils_low_level()

In Modbus master mode this function can be used to write multiple coils of a slave.
This function creates a Modbus function code 15 request.

* Slave Address: Address of the target Modbus slave.
* Starting Address: Starting address of the write.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Write Multiple Coils Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_write_multiple_coils_low_level
{
	my ($self, $slave_address, $starting_address, $coils_length, $coils_chunk_offset, $coils_chunk_data) = @_;

	return $self->_send_request(&FUNCTION_MODBUS_MASTER_WRITE_MULTIPLE_COILS_LOW_LEVEL, [$slave_address, $starting_address, $coils_length, $coils_chunk_offset, $coils_chunk_data], 'C L S S ?440', 'C');
}

=item modbus_slave_answer_write_multiple_registers_request()

In Modbus slave mode this function can be used to answer a master request to
write multiple registers.

* Request ID: Request ID of the corresponding request that is being answered.

This function must be called from the :cb:`Modbus Slave Write Multiple Registers Request`
callback with the Request ID of the callback.

=cut

sub modbus_slave_answer_write_multiple_registers_request
{
	my ($self, $request_id) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_ANSWER_WRITE_MULTIPLE_REGISTERS_REQUEST, [$request_id], 'C', '');
}

=item modbus_master_write_multiple_registers_low_level()

In Modbus master mode this function can be used to write multiple registers of a slave.
This function creates a Modbus function code 16 request.

* Slave Address: Address of the target Modbus slave.
* Starting Address: Starting Address of the write.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Write Multiple Registers Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_write_multiple_registers_low_level
{
	my ($self, $slave_address, $starting_address, $registers_length, $registers_chunk_offset, $registers_chunk_data) = @_;

	return $self->_send_request(&FUNCTION_MODBUS_MASTER_WRITE_MULTIPLE_REGISTERS_LOW_LEVEL, [$slave_address, $starting_address, $registers_length, $registers_chunk_offset, $registers_chunk_data], 'C L S S S27', 'C');
}

=item modbus_slave_answer_read_discrete_inputs_request_low_level()

In Modbus slave mode this function can be used to answer a master request to
read discrete inputs.

* Request ID: Request ID of the corresponding request that is being answered.
* Discrete Inputs: Data that is to be sent to the Modbus master for the corresponding request.

This function must be called from the :cb:`Modbus Slave Read Discrete Inputs Request`
callback with the Request ID as provided by the argument of the callback.

=cut

sub modbus_slave_answer_read_discrete_inputs_request_low_level
{
	my ($self, $request_id, $discrete_inputs_length, $discrete_inputs_chunk_offset, $discrete_inputs_chunk_data) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_ANSWER_READ_DISCRETE_INPUTS_REQUEST_LOW_LEVEL, [$request_id, $discrete_inputs_length, $discrete_inputs_chunk_offset, $discrete_inputs_chunk_data], 'C S S ?472', '');
}

=item modbus_master_read_discrete_inputs()

In Modbus master mode this function can be used to read discrete inputs from a slave.
This function creates a Modbus function code 2 request.

* Slave Address: Address of the target Modbus slave.
* Starting Address: Starting address of the read.
* Count: Number of discrete inputs to read.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Read Discrete Inputs Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_read_discrete_inputs
{
	my ($self, $slave_address, $starting_address, $count) = @_;

	return $self->_send_request(&FUNCTION_MODBUS_MASTER_READ_DISCRETE_INPUTS, [$slave_address, $starting_address, $count], 'C L S', 'C');
}

=item modbus_slave_answer_read_input_registers_request_low_level()

In Modbus slave mode this function can be used to answer a master request to
read input registers.

* Request ID: Request ID of the corresponding request that is being answered.
* Input Registers: Data that is to be sent to the Modbus master for the corresponding request.

This function must be called from the :cb:`Modbus Slave Read Input Registers Request` callback
with the Request ID as provided by the argument of the callback.

=cut

sub modbus_slave_answer_read_input_registers_request_low_level
{
	my ($self, $request_id, $input_registers_length, $input_registers_chunk_offset, $input_registers_chunk_data) = @_;

	$self->_send_request(&FUNCTION_MODBUS_SLAVE_ANSWER_READ_INPUT_REGISTERS_REQUEST_LOW_LEVEL, [$request_id, $input_registers_length, $input_registers_chunk_offset, $input_registers_chunk_data], 'C S S S29', '');
}

=item modbus_master_read_input_registers()

In Modbus master mode this function can be used to read input registers from a slave.
This function creates a Modbus function code 4 request.

* Slave Address: Address of the target Modbus slave.
* Starting Address: Starting address of the read.
* Count: Number of input registers to read.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Read Input Registers Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_read_input_registers
{
	my ($self, $slave_address, $starting_address, $count) = @_;

	return $self->_send_request(&FUNCTION_MODBUS_MASTER_READ_INPUT_REGISTERS, [$slave_address, $starting_address, $count], 'C L S', 'C');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=item write()

Writes characters to the RS485 interface. The characters can be binary data,
ASCII or similar is not necessary.

The return value is the number of characters that were written.

See :func:`Set RS485 Configuration` for configuration possibilities
regarding baudrate, parity and so on.

=cut

sub write
{
    my ($self, $message) = @_;

    if(scalar(@{$message}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Message can be at most 65535 items long'));
    }

    my $ret = undef;
    my $message_length = scalar(@{$message});
    my $message_chunk_offset = 0;
    my $message_written = 0;

    if($message_length == 0)
    {
        my $message_chunk_data = ['\0'] x 60;

        $ret = $self->write_low_level($message_length, $message_chunk_offset, $message_chunk_data);
        $message_written = $ret;
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($message_chunk_offset < $message_length)
        {
            my $message_chunk_data = [];
            my $message_chunk_length = $message_length - $message_chunk_offset;

            if($message_chunk_length > 60)
            {
                $message_chunk_length = 60;
            }

            for(my $i = 0; $i < $message_chunk_length; $i++)
            {
                push(@{$message_chunk_data}, @{$message}[$message_chunk_offset + $i]);
            }

            if(scalar(@{$message_chunk_data}) < 60)
            {
                push(@{$message_chunk_data}, ('\0') x (60 - scalar(@{$message_chunk_data})));
            }

            $ret = $self->write_low_level($message_length, $message_chunk_offset, $message_chunk_data);
            $message_written += $ret;

            if($ret < 60)
            {
                last; # either last chunk or short write
            }

            $message_chunk_offset += 60;
        }
    }

    return $message_written;
}

=item read()

Returns up to *length* characters from receive buffer.

Instead of polling with this function, you can also use
callbacks. But note that this function will return available
data only when the read callback is disabled.
See :func:`Enable Read Callback` and :cb:`Read` callback.

=cut

sub read
{
    my ($self, $length) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->read_low_level($length);
    my $message_length = $ret[0];
    my $message_chunk_offset = $ret[1];
    my $message_out_of_sync = $message_chunk_offset != 0;
    my $message_data = $ret[2];

    while(!$message_out_of_sync && scalar(@{$message_data}) < $message_length)
    {
        @ret = $self->read_low_level($length);
        $message_length = $ret[0];
        $message_chunk_offset = $ret[1];
        $message_out_of_sync = $message_chunk_offset != scalar(@{$message_data});
        push(@{$message_data}, @{$ret[2]});
    }

    if($message_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($message_chunk_offset + 60 < $message_length)
        {
            @ret = $self->read_low_level($length);
            $message_length = $ret[0];
            $message_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Message stream is out-of-sync'));
    }

    splice(@{$message_data}, $message_length);

    return $message_data;
}

=item modbus_slave_answer_read_coils_request()

In Modbus slave mode this function can be used to answer a master request to
read coils.

* Request ID: Request ID of the corresponding request that is being answered.
* Coils: Data that is to be sent to the Modbus master for the corresponding request.

This function must be called from the :cb:`Modbus Slave Read Coils Request` callback
with the Request ID as provided by the argument of the callback.

=cut

sub modbus_slave_answer_read_coils_request
{
    my ($self, $request_id, $coils) = @_;

    if(scalar(@{$coils}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Coils can be at most 65535 items long'));
    }

    my $coils_length = scalar(@{$coils});
    my $coils_chunk_offset = 0;

    if($coils_length == 0)
    {
        my $coils_chunk_data = [0] x 472;

        $self->modbus_slave_answer_read_coils_request_low_level($request_id, $coils_length, $coils_chunk_offset, $coils_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($coils_chunk_offset < $coils_length)
        {
            my $coils_chunk_data = [];
            my $coils_chunk_length = $coils_length - $coils_chunk_offset;

            if($coils_chunk_length > 472) {
                $coils_chunk_length = 472;
            }

            for(my $i = 0; $i < $coils_chunk_length; $i++) {
                push(@{$coils_chunk_data}, @{$coils}[$coils_chunk_offset + $i]);
            }

            if(scalar(@{$coils_chunk_data}) < 472)
            {
                push(@{$coils_chunk_data}, (0) x (472 - scalar(@{$coils_chunk_data})));
            }

            $self->modbus_slave_answer_read_coils_request_low_level($request_id, $coils_length, $coils_chunk_offset, $coils_chunk_data);
            $coils_chunk_offset += 472;
        }
    }
}

=item modbus_slave_answer_read_holding_registers_request()

In Modbus slave mode this function can be used to answer a master request to
read holding registers.

* Request ID: Request ID of the corresponding request that is being answered.
* Holding Registers: Data that is to be sent to the Modbus master for the corresponding request.

This function must be called from the :cb:`Modbus Slave Read Holding Registers Request`
callback with the Request ID as provided by the argument of the callback.

=cut

sub modbus_slave_answer_read_holding_registers_request
{
    my ($self, $request_id, $holding_registers) = @_;

    if(scalar(@{$holding_registers}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Holding Registers can be at most 65535 items long'));
    }

    my $holding_registers_length = scalar(@{$holding_registers});
    my $holding_registers_chunk_offset = 0;

    if($holding_registers_length == 0)
    {
        my $holding_registers_chunk_data = [0] x 29;

        $self->modbus_slave_answer_read_holding_registers_request_low_level($request_id, $holding_registers_length, $holding_registers_chunk_offset, $holding_registers_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($holding_registers_chunk_offset < $holding_registers_length)
        {
            my $holding_registers_chunk_data = [];
            my $holding_registers_chunk_length = $holding_registers_length - $holding_registers_chunk_offset;

            if($holding_registers_chunk_length > 29) {
                $holding_registers_chunk_length = 29;
            }

            for(my $i = 0; $i < $holding_registers_chunk_length; $i++) {
                push(@{$holding_registers_chunk_data}, @{$holding_registers}[$holding_registers_chunk_offset + $i]);
            }

            if(scalar(@{$holding_registers_chunk_data}) < 29)
            {
                push(@{$holding_registers_chunk_data}, (0) x (29 - scalar(@{$holding_registers_chunk_data})));
            }

            $self->modbus_slave_answer_read_holding_registers_request_low_level($request_id, $holding_registers_length, $holding_registers_chunk_offset, $holding_registers_chunk_data);
            $holding_registers_chunk_offset += 29;
        }
    }
}

=item modbus_master_write_multiple_coils()

In Modbus master mode this function can be used to write multiple coils of a slave.
This function creates a Modbus function code 15 request.

* Slave Address: Address of the target Modbus slave.
* Starting Address: Starting address of the write.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Write Multiple Coils Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_write_multiple_coils
{
    my ($self, $slave_address, $starting_address, $coils) = @_;

    if(scalar(@{$coils}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Coils can be at most 65535 items long'));
    }

    my $ret = undef;
    my $coils_length = scalar(@{$coils});
    my $coils_chunk_offset = 0;

    if($coils_length == 0)
    {
        my $coils_chunk_data = [0] x 440;

        $ret = $self->modbus_master_write_multiple_coils_low_level($slave_address, $starting_address, $coils_length, $coils_chunk_offset, $coils_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($coils_chunk_offset < $coils_length)
        {
            my $coils_chunk_data = [];
            my $coils_chunk_length = $coils_length - $coils_chunk_offset;

            if($coils_chunk_length > 440) {
                $coils_chunk_length = 440;
            }

            for(my $i = 0; $i < $coils_chunk_length; $i++) {
                push(@{$coils_chunk_data}, @{$coils}[$coils_chunk_offset + $i]);
            }

            if(scalar(@{$coils_chunk_data}) < 440)
            {
                push(@{$coils_chunk_data}, (0) x (440 - scalar(@{$coils_chunk_data})));
            }

            $ret = $self->modbus_master_write_multiple_coils_low_level($slave_address, $starting_address, $coils_length, $coils_chunk_offset, $coils_chunk_data);
            $coils_chunk_offset += 440;
        }
    }

    return $ret;
}

=item modbus_master_write_multiple_registers()

In Modbus master mode this function can be used to write multiple registers of a slave.
This function creates a Modbus function code 16 request.

* Slave Address: Address of the target Modbus slave.
* Starting Address: Starting Address of the write.

Upon success the function will return a non-zero request ID which will represent
the current request initiated by the Modbus master. In case of failure the returned
request ID will be 0.

When successful this function will also invoke the :cb:`Modbus Master Write Multiple Registers Response`
callback. In this callback the Request ID provided by the callback argument must be matched
with the Request ID returned from this function to verify that the callback is indeed for a
particular request.

=cut

sub modbus_master_write_multiple_registers
{
    my ($self, $slave_address, $starting_address, $registers) = @_;

    if(scalar(@{$registers}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Registers can be at most 65535 items long'));
    }

    my $ret = undef;
    my $registers_length = scalar(@{$registers});
    my $registers_chunk_offset = 0;

    if($registers_length == 0)
    {
        my $registers_chunk_data = [0] x 27;

        $ret = $self->modbus_master_write_multiple_registers_low_level($slave_address, $starting_address, $registers_length, $registers_chunk_offset, $registers_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($registers_chunk_offset < $registers_length)
        {
            my $registers_chunk_data = [];
            my $registers_chunk_length = $registers_length - $registers_chunk_offset;

            if($registers_chunk_length > 27) {
                $registers_chunk_length = 27;
            }

            for(my $i = 0; $i < $registers_chunk_length; $i++) {
                push(@{$registers_chunk_data}, @{$registers}[$registers_chunk_offset + $i]);
            }

            if(scalar(@{$registers_chunk_data}) < 27)
            {
                push(@{$registers_chunk_data}, (0) x (27 - scalar(@{$registers_chunk_data})));
            }

            $ret = $self->modbus_master_write_multiple_registers_low_level($slave_address, $starting_address, $registers_length, $registers_chunk_offset, $registers_chunk_data);
            $registers_chunk_offset += 27;
        }
    }

    return $ret;
}

=item modbus_slave_answer_read_discrete_inputs_request()

In Modbus slave mode this function can be used to answer a master request to
read discrete inputs.

* Request ID: Request ID of the corresponding request that is being answered.
* Discrete Inputs: Data that is to be sent to the Modbus master for the corresponding request.

This function must be called from the :cb:`Modbus Slave Read Discrete Inputs Request`
callback with the Request ID as provided by the argument of the callback.

=cut

sub modbus_slave_answer_read_discrete_inputs_request
{
    my ($self, $request_id, $discrete_inputs) = @_;

    if(scalar(@{$discrete_inputs}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Discrete Inputs can be at most 65535 items long'));
    }

    my $discrete_inputs_length = scalar(@{$discrete_inputs});
    my $discrete_inputs_chunk_offset = 0;

    if($discrete_inputs_length == 0)
    {
        my $discrete_inputs_chunk_data = [0] x 472;

        $self->modbus_slave_answer_read_discrete_inputs_request_low_level($request_id, $discrete_inputs_length, $discrete_inputs_chunk_offset, $discrete_inputs_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($discrete_inputs_chunk_offset < $discrete_inputs_length)
        {
            my $discrete_inputs_chunk_data = [];
            my $discrete_inputs_chunk_length = $discrete_inputs_length - $discrete_inputs_chunk_offset;

            if($discrete_inputs_chunk_length > 472) {
                $discrete_inputs_chunk_length = 472;
            }

            for(my $i = 0; $i < $discrete_inputs_chunk_length; $i++) {
                push(@{$discrete_inputs_chunk_data}, @{$discrete_inputs}[$discrete_inputs_chunk_offset + $i]);
            }

            if(scalar(@{$discrete_inputs_chunk_data}) < 472)
            {
                push(@{$discrete_inputs_chunk_data}, (0) x (472 - scalar(@{$discrete_inputs_chunk_data})));
            }

            $self->modbus_slave_answer_read_discrete_inputs_request_low_level($request_id, $discrete_inputs_length, $discrete_inputs_chunk_offset, $discrete_inputs_chunk_data);
            $discrete_inputs_chunk_offset += 472;
        }
    }
}

=item modbus_slave_answer_read_input_registers_request()

In Modbus slave mode this function can be used to answer a master request to
read input registers.

* Request ID: Request ID of the corresponding request that is being answered.
* Input Registers: Data that is to be sent to the Modbus master for the corresponding request.

This function must be called from the :cb:`Modbus Slave Read Input Registers Request` callback
with the Request ID as provided by the argument of the callback.

=cut

sub modbus_slave_answer_read_input_registers_request
{
    my ($self, $request_id, $input_registers) = @_;

    if(scalar(@{$input_registers}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Input Registers can be at most 65535 items long'));
    }

    my $input_registers_length = scalar(@{$input_registers});
    my $input_registers_chunk_offset = 0;

    if($input_registers_length == 0)
    {
        my $input_registers_chunk_data = [0] x 29;

        $self->modbus_slave_answer_read_input_registers_request_low_level($request_id, $input_registers_length, $input_registers_chunk_offset, $input_registers_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($input_registers_chunk_offset < $input_registers_length)
        {
            my $input_registers_chunk_data = [];
            my $input_registers_chunk_length = $input_registers_length - $input_registers_chunk_offset;

            if($input_registers_chunk_length > 29) {
                $input_registers_chunk_length = 29;
            }

            for(my $i = 0; $i < $input_registers_chunk_length; $i++) {
                push(@{$input_registers_chunk_data}, @{$input_registers}[$input_registers_chunk_offset + $i]);
            }

            if(scalar(@{$input_registers_chunk_data}) < 29)
            {
                push(@{$input_registers_chunk_data}, (0) x (29 - scalar(@{$input_registers_chunk_data})));
            }

            $self->modbus_slave_answer_read_input_registers_request_low_level($request_id, $input_registers_length, $input_registers_chunk_offset, $input_registers_chunk_data);
            $input_registers_chunk_offset += 29;
        }
    }
}

=back
=cut

1;
