#############################################################
# This file was automatically generated on 2018-06-08.      #
#                                                           #
# Perl Bindings Version 2.1.17                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletIndustrialCounter - 4 channel counter up to 4MHz

=cut

package Tinkerforge::BrickletIndustrialCounter;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Industrial Counter Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 293;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Industrial Counter Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'Industrial Counter Bricklet';

=item CALLBACK_ALL_COUNTER

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ALL_COUNTER callback.

=cut

use constant CALLBACK_ALL_COUNTER => 19;

=item CALLBACK_ALL_SIGNAL_DATA

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ALL_SIGNAL_DATA callback.

=cut

use constant CALLBACK_ALL_SIGNAL_DATA => 20;

=item FUNCTION_GET_COUNTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COUNTER => 1;

=item FUNCTION_GET_ALL_COUNTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_COUNTER => 2;

=item FUNCTION_SET_COUNTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COUNTER => 3;

=item FUNCTION_SET_ALL_COUNTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALL_COUNTER => 4;

=item FUNCTION_GET_SIGNAL_DATA

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SIGNAL_DATA => 5;

=item FUNCTION_GET_ALL_SIGNAL_DATA

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_SIGNAL_DATA => 6;

=item FUNCTION_SET_COUNTER_ACTIVE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COUNTER_ACTIVE => 7;

=item FUNCTION_SET_ALL_COUNTER_ACTIVE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALL_COUNTER_ACTIVE => 8;

=item FUNCTION_GET_COUNTER_ACTIVE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COUNTER_ACTIVE => 9;

=item FUNCTION_GET_ALL_COUNTER_ACTIVE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_COUNTER_ACTIVE => 10;

=item FUNCTION_SET_COUNTER_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COUNTER_CONFIGURATION => 11;

=item FUNCTION_GET_COUNTER_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COUNTER_CONFIGURATION => 12;

=item FUNCTION_SET_ALL_COUNTER_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALL_COUNTER_CALLBACK_CONFIGURATION => 13;

=item FUNCTION_GET_ALL_COUNTER_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_COUNTER_CALLBACK_CONFIGURATION => 14;

=item FUNCTION_SET_ALL_SIGNAL_DATA_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALL_SIGNAL_DATA_CALLBACK_CONFIGURATION => 15;

=item FUNCTION_GET_ALL_SIGNAL_DATA_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_SIGNAL_DATA_CALLBACK_CONFIGURATION => 16;

=item FUNCTION_SET_CHANNEL_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CHANNEL_LED_CONFIG => 17;

=item FUNCTION_GET_CHANNEL_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHANNEL_LED_CONFIG => 18;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant CHANNEL_0 => 0;
use constant CHANNEL_1 => 1;
use constant CHANNEL_2 => 2;
use constant CHANNEL_3 => 3;
use constant COUNT_EDGE_RISING => 0;
use constant COUNT_EDGE_FALLING => 1;
use constant COUNT_EDGE_BOTH => 2;
use constant COUNT_DIRECTION_UP => 0;
use constant COUNT_DIRECTION_DOWN => 1;
use constant COUNT_DIRECTION_EXTERNAL_UP => 2;
use constant COUNT_DIRECTION_EXTERNAL_DOWN => 3;
use constant DUTY_CYCLE_PRESCALER_1 => 0;
use constant DUTY_CYCLE_PRESCALER_2 => 1;
use constant DUTY_CYCLE_PRESCALER_4 => 2;
use constant DUTY_CYCLE_PRESCALER_8 => 3;
use constant DUTY_CYCLE_PRESCALER_16 => 4;
use constant DUTY_CYCLE_PRESCALER_32 => 5;
use constant DUTY_CYCLE_PRESCALER_64 => 6;
use constant DUTY_CYCLE_PRESCALER_128 => 7;
use constant DUTY_CYCLE_PRESCALER_256 => 8;
use constant DUTY_CYCLE_PRESCALER_512 => 9;
use constant DUTY_CYCLE_PRESCALER_1024 => 10;
use constant DUTY_CYCLE_PRESCALER_2048 => 11;
use constant DUTY_CYCLE_PRESCALER_4096 => 12;
use constant DUTY_CYCLE_PRESCALER_8192 => 13;
use constant DUTY_CYCLE_PRESCALER_16384 => 14;
use constant DUTY_CYCLE_PRESCALER_32768 => 15;
use constant FREQUENCY_INTEGRATION_TIME_128_MS => 0;
use constant FREQUENCY_INTEGRATION_TIME_256_MS => 1;
use constant FREQUENCY_INTEGRATION_TIME_512_MS => 2;
use constant FREQUENCY_INTEGRATION_TIME_1024_MS => 3;
use constant FREQUENCY_INTEGRATION_TIME_2048_MS => 4;
use constant FREQUENCY_INTEGRATION_TIME_4096_MS => 5;
use constant FREQUENCY_INTEGRATION_TIME_8192_MS => 6;
use constant FREQUENCY_INTEGRATION_TIME_16384_MS => 7;
use constant FREQUENCY_INTEGRATION_TIME_32768_MS => 8;
use constant CHANNEL_LED_CONFIG_OFF => 0;
use constant CHANNEL_LED_CONFIG_ON => 1;
use constant CHANNEL_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS => 3;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_GET_COUNTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_COUNTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COUNTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_ALL_COUNTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SIGNAL_DATA} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_SIGNAL_DATA} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COUNTER_ACTIVE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_ALL_COUNTER_ACTIVE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_COUNTER_ACTIVE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_COUNTER_ACTIVE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COUNTER_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_COUNTER_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ALL_COUNTER_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_COUNTER_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ALL_SIGNAL_DATA_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_SIGNAL_DATA_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CHANNEL_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CHANNEL_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_ALL_COUNTER} = 'q4';
	$self->{callback_formats}->{&CALLBACK_ALL_SIGNAL_DATA} = 'S4 Q4 L4 ?4';



	bless($self, $class);

	return $self;
}


=item get_counter()

Returns the current counter value for the given channel.

=cut

sub get_counter
{
	my ($self, $channel) = @_;

	return $self->_send_request(&FUNCTION_GET_COUNTER, [$channel], 'C', 'q');
}

=item get_all_counter()

Returns the current counter values for all four channels.

=cut

sub get_all_counter
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_COUNTER, [], '', 'q4');
}

=item set_counter()

Sets the counter value for the given channel.

The default value for the counters on startup is 0.

=cut

sub set_counter
{
	my ($self, $channel, $counter) = @_;

	$self->_send_request(&FUNCTION_SET_COUNTER, [$channel, $counter], 'C q', '');
}

=item set_all_counter()

Sets the counter values for all four channels.

The default value for the counters on startup is 0.

=cut

sub set_all_counter
{
	my ($self, $counter) = @_;

	$self->_send_request(&FUNCTION_SET_ALL_COUNTER, [$counter], 'q4', '');
}

=item get_signal_data()

Returns the signal data (duty cycle, period, frequency and value) for the
given channel.

The units are:

* Duty Cycle: 1/100 %
* Period: ns
* Frequency: mHz (1/1000 Hz)
* Value: true = high, false = low

=cut

sub get_signal_data
{
	my ($self, $channel) = @_;

	return $self->_send_request(&FUNCTION_GET_SIGNAL_DATA, [$channel], 'C', 'S Q L ?');
}

=item get_all_signal_data()

Returns the signal data (duty cycle, period, frequency and value) for all four
channels.

The units are:

* Duty Cycle: 1/100 %
* Period: ns
* Frequency: mHz (1/1000 Hz)
* Value: true = high, false = low

=cut

sub get_all_signal_data
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_SIGNAL_DATA, [], '', 'S4 Q4 L4 ?4');
}

=item set_counter_active()

Activates/deactivates the counter of the given channel.

true = activate, false = deactivate. 

By default all channels are activated.

=cut

sub set_counter_active
{
	my ($self, $channel, $active) = @_;

	$self->_send_request(&FUNCTION_SET_COUNTER_ACTIVE, [$channel, $active], 'C ?', '');
}

=item set_all_counter_active()

Activates/deactivates the counter of all four channels.

true = activate, false = deactivate. 

By default all channels are activated.

=cut

sub set_all_counter_active
{
	my ($self, $active) = @_;

	$self->_send_request(&FUNCTION_SET_ALL_COUNTER_ACTIVE, [$active], '?4', '');
}

=item get_counter_active()

Returns the activation state of the given channel.

true = activated, false = deactivated.

=cut

sub get_counter_active
{
	my ($self, $channel) = @_;

	return $self->_send_request(&FUNCTION_GET_COUNTER_ACTIVE, [$channel], 'C', '?');
}

=item get_all_counter_active()

Returns the activation state of all four channels.

true = activated, false = deactivated.

=cut

sub get_all_counter_active
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_COUNTER_ACTIVE, [], '', '?4');
}

=item set_counter_configuration()

Sets the counter configuration for the given channel.

* Count Edge: Counter can count on rising, falling or both edges.
* Count Direction: Counter can count up or down. You can also use 
  another channel as direction input, see 
  `here <https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Industrial_Counter.html#external-count-direction>`__
  for details.
* Duty Cycle Prescaler: Sets a divider for the internal clock. See
  `here <https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Industrial_Counter.html#duty-cycle-prescaler-and-frequency-integration-time>`__
  for details.
* Frequency Integration Time: Sets the integration time for the
  frequency measurement. See 
  `here <https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Industrial_Counter.html#duty-cycle-prescaler-and-frequency-integration-time>`__
  for details.

=cut

sub set_counter_configuration
{
	my ($self, $channel, $count_edge, $count_direction, $duty_cycle_prescaler, $frequency_integration_time) = @_;

	$self->_send_request(&FUNCTION_SET_COUNTER_CONFIGURATION, [$channel, $count_edge, $count_direction, $duty_cycle_prescaler, $frequency_integration_time], 'C C C C C', '');
}

=item get_counter_configuration()

Returns the counter configuration as set by :func:`Set Counter Configuration`.

=cut

sub get_counter_configuration
{
	my ($self, $channel) = @_;

	return $self->_send_request(&FUNCTION_GET_COUNTER_CONFIGURATION, [$channel], 'C', 'C C C C');
}

=item set_all_counter_callback_configuration()

The period in ms is the period with which the :cb:`All Counter`
callback is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change within the
period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

=cut

sub set_all_counter_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_ALL_COUNTER_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_all_counter_callback_configuration()

Returns the callback configuration as set by
:func:`Set All Counter Callback Configuration`.

=cut

sub get_all_counter_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_COUNTER_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item set_all_signal_data_callback_configuration()

The period in ms is the period with which the :cb:`All Signal Data`
callback is triggered periodically. A value of 0 turns the callback off.

If the `value has to change`-parameter is set to true, the callback is only
triggered after the value has changed. If the value didn't change within the
period, the callback is triggered immediately on change.

If it is set to false, the callback is continuously triggered with the period,
independent of the value.

The default value is (0, false).

=cut

sub set_all_signal_data_callback_configuration
{
	my ($self, $period, $value_has_to_change) = @_;

	$self->_send_request(&FUNCTION_SET_ALL_SIGNAL_DATA_CALLBACK_CONFIGURATION, [$period, $value_has_to_change], 'L ?', '');
}

=item get_all_signal_data_callback_configuration()

Returns the callback configuration as set by
:func:`Set All Signal Data Callback Configuration`.

=cut

sub get_all_signal_data_callback_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_ALL_SIGNAL_DATA_CALLBACK_CONFIGURATION, [], '', 'L ?');
}

=item set_channel_led_config()

Each channel has a corresponding LED. You can turn the LED Off, On or show a
heartbeat. You can also set the LED to "Channel Status". In this mode the
LED is on if the channel is high and off otherwise.

By default all channel LEDs are configured as "Channel Status".

=cut

sub set_channel_led_config
{
	my ($self, $channel, $config) = @_;

	$self->_send_request(&FUNCTION_SET_CHANNEL_LED_CONFIG, [$channel, $config], 'C C', '');
}

=item get_channel_led_config()

Returns the Channel LED configuration as set by :func:`Set Channel LED Config`

=cut

sub get_channel_led_config
{
	my ($self, $channel) = @_;

	return $self->_send_request(&FUNCTION_GET_CHANNEL_LED_CONFIG, [$channel], 'C', 'C');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ack checksum errors,
* message checksum errors,
* frameing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier und crc are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 'C');
}

=item get_chip_temperature()

Returns the temperature in °C as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_RESET, [], '', '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
