#############################################################
# This file was automatically generated on 2017-07-27.      #
#                                                           #
# Perl Bindings Version 2.1.14                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletOLED64x48 - 1.68cm (0.66") OLED with 64x48 pixels

=cut

package Tinkerforge::BrickletOLED64x48;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a OLED 64x48 Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 264;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a OLED 64x48 Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'OLED 64x48 Bricklet';


=item FUNCTION_WRITE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE => 1;

=item FUNCTION_NEW_WINDOW

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_NEW_WINDOW => 2;

=item FUNCTION_CLEAR_DISPLAY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_CLEAR_DISPLAY => 3;

=item FUNCTION_SET_DISPLAY_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DISPLAY_CONFIGURATION => 4;

=item FUNCTION_GET_DISPLAY_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DISPLAY_CONFIGURATION => 5;

=item FUNCTION_WRITE_LINE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_LINE => 6;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_WRITE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_NEW_WINDOW} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_CLEAR_DISPLAY} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_DISPLAY_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DISPLAY_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_WRITE_LINE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;





	bless($self, $class);

	return $self;
}


=item write()

Appends 64 byte of data to the window as set by :func:`New Window`.

Each row has a height of 8 pixels which corresponds to one byte of data.

Example: if you call :func:`New Window` with column from 0 to 63 and row
from 0 to 5 (the whole display) each call of :func:`Write` (red arrow) will
write one row.

.. image:: /Images/Bricklets/bricklet_oled_64x48_display.png
   :scale: 100 %
   :alt: Display pixel order
   :align: center
   :target: ../../_images/Bricklets/bricklet_oled_64x48_display.png

The LSB (D0) of each data byte is at the top and the MSB (D7) is at the
bottom of the row.

The next call of :func:`Write` will write the second row and so on. To
fill the whole display you need to call :func:`Write` 6 times.

=cut

sub write
{
	my ($self, $data) = @_;

	$self->_send_request(&FUNCTION_WRITE, [$data], 'C64', '');
}

=item new_window()

Sets the window in which you can write with :func:`Write`. One row
has a height of 8 pixels.

The columns have a range of 0 to 63 and the rows have a range of 0 to 5.

=cut

sub new_window
{
	my ($self, $column_from, $column_to, $row_from, $row_to) = @_;

	$self->_send_request(&FUNCTION_NEW_WINDOW, [$column_from, $column_to, $row_from, $row_to], 'C C C C', '');
}

=item clear_display()

Clears the current content of the window as set by :func:`New Window`.

=cut

sub clear_display
{
	my ($self) = @_;

	$self->_send_request(&FUNCTION_CLEAR_DISPLAY, [], '', '');
}

=item set_display_configuration()

Sets the configuration of the display.

You can set a contrast value from 0 to 255 and you can invert the color
(black/white) of the display.

The default values are contrast 143 and inverting off.

=cut

sub set_display_configuration
{
	my ($self, $contrast, $invert) = @_;

	$self->_send_request(&FUNCTION_SET_DISPLAY_CONFIGURATION, [$contrast, $invert], 'C ?', '');
}

=item get_display_configuration()

Returns the configuration as set by :func:`Set Display Configuration`.

=cut

sub get_display_configuration
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_DISPLAY_CONFIGURATION, [], '', 'C ?');
}

=item write_line()

Writes text to a specific line (0 to 5) with a specific position
(0 to 12). The text can have a maximum of 13 characters.

For example: (1, 4, "Hello") will write *Hello* in the middle of the
second line of the display.

You can draw to the display with :func:`Write` and then add text to it
afterwards.

The display uses a special 5x7 pixel charset. You can view the characters
of the charset in Brick Viewer.

=cut

sub write_line
{
	my ($self, $line, $position, $text) = @_;

	$self->_send_request(&FUNCTION_WRITE_LINE, [$line, $position, $text], 'C C Z13', '');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
