## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Sk_ec v1.1.4;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Sk_ec::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Sk_ec> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-sk.ec.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: slovak (sk)
% encoding: ec
%
% This file has been auto-generated from hyph-sk.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"E1="E1
\lccode"E4="E4
\lccode"E9="E9
\lccode"ED="ED
\lccode"F3="F3
\lccode"F4="F4
\lccode"FA="FA
\lccode"FD="FD
\lccode"A3="A3
\lccode"A4="A4
\lccode"A9="A9
\lccode"AC="AC
\lccode"AF="AF
\lccode"B2="B2
\lccode"B4="B4
\lccode"BA="BA
\patterns{
a1
^^e11
^^e41
e1
^^e91
i1
^^ed1
o1
^^f31
^^f41
u1
^^fa1
y1
^^fd1
i2a
i2^^e1
i2e
i2u
o2u
c2h
d2z
d2^^ba
2b1b
2b1c
2b1^^a3
2b1d
2b1^^a4
2b1f
2b1g
2b1h
2b1c2h
2b1j
2b1k
2b1l
2b1^^a9
2b1m
2b1n
2b1^^ac
2b1p
2b1r
2b1s
2b1^^b2
2b1t
2b1^^b4
2b1v
2b1w
2b1x
2b1z
2b1^^ba
2b1d2z
2b1d2^^ba
2c1b
2c1c
2c1^^a3
2c1d
2c1^^a4
2c1f
2c1g
2c1c2h
2c1j
2c1k
2c1l
2c1^^a9
2c1m
2c1n
2c1^^ac
2c1p
2c1r
2c1s
2c1^^b2
2c1t
2c1^^b4
2c1v
2c1w
2c1x
2c1z
2c1^^ba
2c1d2z
2c1d2^^ba
2^^a31b
2^^a31c
2^^a31^^a3
2^^a31d
2^^a31^^a4
2^^a31f
2^^a31g
2^^a31h
2^^a31c2h
2^^a31j
2^^a31k
2^^a31l
2^^a31^^a9
2^^a31m
2^^a31n
2^^a31^^ac
2^^a31p
2^^a31r
2^^a31s
2^^a31^^b2
2^^a31t
2^^a31^^b4
2^^a31v
2^^a31w
2^^a31x
2^^a31z
2^^a31^^ba
2^^a31d2z
2^^a31d2^^ba
2d1b
2d1c
2d1^^a3
2d1d
2d1^^a4
2d1f
2d1g
2d1h
2d1c2h
2d1j
2d1k
2d1l
2d1^^a9
2d1m
2d1n
2d1^^ac
2d1p
2d1r
2d1s
2d1^^b2
2d1t
2d1^^b4
2d1v
2d1d2z
2d1d2^^ba
2^^a41b
2^^a41c
2^^a41^^a3
2^^a41d
2^^a41^^a4
2^^a41f
2^^a41g
2^^a41h
2^^a41c2h
2^^a41j
2^^a41k
2^^a41l
2^^a41^^a9
.as4t4ro3
.atmo3
.a2u1to3
2^^a41m
2^^a41n
2^^a41^^ac
2^^a41p
2^^a41r
2^^a41s
2^^a41^^b2
2^^a41t
2^^a41^^b4
2^^a41v
2^^a41z
2^^a41^^ba
2^^a41d2z
2^^a41d2^^ba
2f1b
2f1c
2f1^^a3
2f1d
2f1^^a4
2f1f
2f1g
2f1h
2f1c2h
2f1j
2f1k
2f1l
2f1^^a9
2f1m
2f1n
2f1^^ac
2f1p
2f1r
2f1s
2f1^^b2
2f1t
2f1^^b4
2f1v
2f1z
2f1^^ba
2f1d2z
2f1d2^^ba
2g1b
2g1c
2g1^^a3
2g1d
2g1^^a4
2g1f
2g1g
2g1h
2g1c2h
2g1j
2g1k
2g1l
2g1^^a9
2g1m
2g1n
2g1^^ac
2g1p
2g1r
2g1s
2g1^^b2
2g1t
2g1^^b4
2g1v
2g1z
2g1^^ba
2g1d2z
2g1d2^^ba
2h1b
2h1c
2h1^^a3
2h1d
2h1^^a4
2h1f
2h1g
2h1h
2h1c2h
2h1j
2h1k
2h1l
2h1^^a9
2h1m
2h1n
2h1^^ac
2h1p
2h1r
2h1s
2h1^^b2
2h1t
2h1^^b4
2h1v
2h1z
2h1^^ba
2h1d2z
2h1d2^^ba
2c2h1b
2c2h1c
2c2h1^^a3
2c2h1d
2c2h1^^a4
2c2h1f
2c2h1g
2c2h1h
2c2h1c2h
2c2h1j
2c2h1k
2c2h1l
2c2h1^^a9
2c2h1m
2c2h1n
2c2h1^^ac
2c2h1p
2c2h1r
2c2h1s
2c2h1^^b2
2c2h1t
2c2h1^^b4
2c2h1v
2c2h1w
2c2h1^^ba
2c2h1d2z
2c2h1d2^^ba
2j1b
2j1c
2j1^^a3
2j1d
2j1^^a4
2j1f
2j1g
2j1h
2j1c2h
2j1j
2j1k
2j1l
2j1^^a9
2j1m
2j1n
2j1^^ac
2j1p
2j1r
2j1s
2j1^^b2
2j1t
2j1^^b4
2j1v
2j1w
2j1x
2j1z
2j1^^ba
2j1d2z
2j1d2^^ba
2k1b
2k1c
2k1^^a3
2k1d
2k1^^a4
2k1f
2k1g
2k1h
2k1c2h
2k1j
2k1k
2k1l
2k1^^a9
2k1m
2k1n
2k1^^ac
2k1p
2k1r
2k1s
2k1^^b2
2k1t
2k1^^b4
2k1v
2k1w
2k1x
2k1z
2k1^^ba
2k1d2z
2k1d2^^ba
2l1b
2l1c
2l1^^a3
2l1d
2l1^^a4
2l1f
2l1g
2l1h
2l1c2h
2l1j
2l1k
2l1l
2l1^^a9
2l1m
2l1n
2l1^^ac
2l1p
2l1r
2l1s
2l1^^b2
2l1t
2l1^^b4
2l1v
2l1z
2l1^^ba
2l1d2z
2l1d2^^ba
2^^a91b
2^^a91c
2^^a91^^a3
2^^a91d
2^^a91^^a4
2^^a91f
2^^a91g
2^^a91h
2^^a91c2h
2^^a91j
2^^a91k
2^^a91l
2^^a91^^a9
2^^a91m
2^^a91n
2^^a91^^ac
2^^a91p
2^^a91r
2^^a91s
2^^a91^^b2
2^^a91t
2^^a91^^b4
2^^a91v
2^^a91z
2^^a91^^ba
2^^a91d2z
2^^a91d2^^ba
2m1b
2m1c
2m1^^a3
2m1d
2m1^^a4
2m1f
2m1g
2m1h
2m1c2h
2m1j
2m1k
2m1l
2m1^^a9
2m1m
2m1n
2m1^^ac
2m1p
2m1r
2m1s
2m1^^b2
2m1t
2m1^^b4
2m1v
2m1z
2m1^^ba
2m1d2z
2m1d2^^ba
2n1b
2n1c
2n1^^a3
2n1d
2n1^^a4
2n1f
2n1g
2n1h
2n1c2h
2n1j
2n1k
2n1l
2n1^^a9
2n1m
2n1n
2n1^^ac
2n1p
2n1r
2n1s
2n1^^b2
2n1t
2n1^^b4
2n1v
2n1w
2n1x
2n1z
2n1^^ba
2n1d2z
2n1d2^^ba
2^^ac1b
2^^ac1c
2^^ac1^^a3
2^^ac1d
2^^ac1^^a4
2^^ac1f
2^^ac1g
2^^ac1h
2^^ac1c2h
2^^ac1j
2^^ac1k
2^^ac1l
2^^ac1^^a9
2^^ac1m
2^^ac1n
2^^ac1^^ac
2^^ac1p
2^^ac1r
2^^ac1s
2^^ac1^^b2
2^^ac1t
2^^ac1^^b4
2^^ac1v
2^^ac1z
2^^ac1^^ba
2^^ac1d2z
2^^ac1d2^^ba
2p1b
2p1c
2p1^^a3
2p1d
2p1^^a4
2p1f
2p1g
2p1h
2p1c2h
2p1j
2p1k
2p1l
2p1^^a9
2p1m
2p1n
2p1^^ac
2p1p
2p1r
2p1s
2p1^^b2
2p1t
2p1^^b4
2p1v
2p1w
2p1x
2p1z
2p1^^ba
2p1d2z
2p1d2^^ba
2r1b
2r1c
2r1^^a3
2r1d
2r1^^a4
2r1f
2r1g
2r1h
2r1c2h
2r1j
2r1k
2r1l
2r1^^a9
2r1m
2r1n
2r1^^ac
2r1p
2r1r
2r1s
2r1^^b2
2r1t
2r1^^b4
2r1v
2r1w
2r1x
2r1z
2r1^^ba
2r1d2z
2r1d2^^ba
2s1b
2s1c
2s1^^a3
2s1d
2s1^^a4
2s1f
2s1g
2s1h
2s1c2h
2s1j
2s1k
2s1l
2s1^^a9
2s1m
2s1n
2s1^^ac
2s1p
2s1r
2s1s
2s1^^b2
2s1t
2s1^^b4
2s1v
2s1z
2s1^^ba
2s1d2z
2s1d2^^ba
2^^b21b
2^^b21c
2^^b21^^a3
2^^b21d
2^^b21^^a4
2^^b21f
2^^b21g
2^^b21h
2^^b21c2h
2^^b21j
2^^b21k
2^^b21l
2^^b21^^a9
2^^b21m
2^^b21n
2^^b21^^ac
2^^b21p
2^^b21r
2^^b21s
2^^b21^^b2
2^^b21t
2^^b21^^b4
2^^b21v
2^^b21w
2^^b21x
2^^b21z
2^^b21^^ba
2^^b21d2z
2^^b21d2^^ba
2t1b
2t1c
2t1^^a3
2t1d
2t1^^a4
2t1f
2t1g
2t1h
2t1c2h
2t1j
2t1k
2t1l
2t1^^a9
2t1m
2t1n
2t1^^ac
2t1p
2t1r
2t1s
2t1^^b2
2t1t
2t1^^b4
2t1v
2t1w
2t1x
2t1z
2t1^^ba
2t1d2z
2t1d2^^ba
2^^b41b
2^^b41c
2^^b41^^a3
2^^b41d
2^^b41^^a4
2^^b41f
2^^b41g
2^^b41h
2^^b41c2h
2^^b41j
2^^b41k
2^^b41l
2^^b41^^a9
2^^b41m
2^^b41n
2^^b41^^ac
2^^b41p
2^^b41r
2^^b41s
2^^b41^^b2
2^^b41t
2^^b41^^b4
2^^b41v
2^^b41w
2^^b41x
2^^b41z
2^^b41^^ba
2^^b41d2z
2^^b41d2^^ba
2v1b
2v1c
2v1^^a3
2v1d
2v1^^a4
2v1f
2v1g
2v1h
2v1c2h
2v1j
2v1k
2v1l
2v1^^a9
2v1m
2v1n
2v1^^ac
2v1p
2v1r
2v1s
2v1^^b2
2v1t
2v1^^b4
2v1v
2v1w
2v1x
2v1z
2v1^^ba
2v1d2z
2v1d2^^ba
2z1b
2z1c
2z1^^a3
2z1d
2z1^^a4
2z1f
2z1g
2z1h
2z1c2h
2z1j
2z1k
2z1l
2z1^^a9
2z1m
2z1n
2z1^^ac
2z1p
2z1r
2z1s
2z1^^b2
2z1t
2z1^^b4
2z1v
2z1z
2z1^^ba
2z1d2z
2z1d2^^ba
2^^ba1b
2^^ba1c
2^^ba1^^a3
2^^ba1d
2^^ba1^^a4
2^^ba1f
2^^ba1g
2^^ba1h
2^^ba1c2h
2^^ba1j
2^^ba1k
2^^ba1l
2^^ba1^^a9
2^^ba1m
2^^ba1n
2^^ba1^^ac
2^^ba1p
2^^ba1r
2^^ba1s
2^^ba1^^b2
2^^ba1t
2^^ba1^^b4
2^^ba1v
2^^ba1z
2^^ba1^^ba
2^^ba1d2z
2^^ba1d2^^ba
2d2z1k
2d2z1n
2d2z1r
2d2z1s
2d2^^ba1^^b2
2x1t
2x1n
2b1^^af
2^^af1b
2d2z1^^af
2^^af1d2z
2d2z1^^a9
2^^af1d2^^ba
2d2^^ba1^^a9
a1^^ed2
a1o2
e1^^e12
e1^^ed2
e1o2
e1^^f32
e1u2
i1o2
o1a2
o1e2
o1i2
o1o2
u1a2
u1^^e12
u1i2
u1^^ed2
u1o2
u1u2
y1a2
y1e2
y1^^f32
y1u2
a2u1
a2i1
b2l3b
3b2l3^^a3
b2l3c2h
3b2l3k
3b2^^a93k
3b2l3^^ac
b2l3^^b2
b2^^a93^^b2
3b2r3b
b2r3d
3b2r3k
3b2^^af3k
3b2r3l
3b2^^af3^^a9
3b2r3n
3b2r3^^ac
3b2r3v
b2r3z
b3s2c
b3s2t
c3k2t
3c2r3^^a3
3c2^^af3^^a3
3c2r3k
3c2^^af3k
c3t2v
3^^a32l3n
3^^a32r3^^a3
^^a32r3p
3^^a32r3t
3^^a32r3v
d3c4h4n
3d2l3b
3d2l3h
d2l3n
3d2l3^^ba
3d2^^a93^^ba
3d2r3d
3d2r3g
d2r3l
3d2r3k
3d2r3m
d2r3n
3d2r3v
3d2r3z
3d2r3^^ba
3d2^^af3^^ba
d3s2v
d3s2t
d3v2r
3f2r3^^a3
3f2r3f
3f2r3k
3f2^^af3k
3f2r3m
3f2r3n
3g2l3g
3g2r3c
3g2r3g
3h2l3b
3h2^^a93b
3h2l3t
3h2m2l
3h2r3b
3h2^^af3b
3h2r3^^a3
3h2r3d
3h2r3d2z
3h2r3k
3h2r3m
3h2r3n
3h2r3^^ac
3h2r3t
3h2r3v
3c2h2l3p
3c2h2r3b
3c2h2r3^^a3
c2h2r3c4h
3c2h2r3l
3c2h2r3t
j2c2h3n
j3s2t
j3^^b22le
j3t2m
j3t2r
3k2l3b
3k2^^a93b
3k2l3^^a3
3k2l3z
3k2^^a93z
k2r3b
3k2r3^^a3
3k2^^af3^^a3
3k2^^af3d
3k2r3k
3k2^^af3k
3k2^^af3m
3k2r3p
3k2r3s
3k2r3t
3k2r3v
k3s2^^a9
k2s3n
k3t2r
l3d2r
^^a93k2n
l3t2r
m3b2l
m3b2^^a9
m3b2r
m3f2l
m3f2r
m3k2n
3m2l3^^a3
3m2l3k
m3p2l
m3p2^^a9
m3p2r
m3p2s
3m2r3h
m2r3c4h
3m2r3k
m2r3l
m2r3^^b2
m2r3t
3m2r3v
3m2r3z
3m2^^af3z
m3s2t
m3^^b22t
n3d^^a9a
n3d2r
n3f2l
n3f2r
n3g2h
n3g2l
n3g2^^a9
n2g3n
n3g2r
n3g2v
n3k2c
n3k2h
n3k2n
n3k2r
n3k2v
n3s2c
n3^^b22p
n3^^b22t
n3t2g
n3t2l
n3t2n
n3t2r
n2^^ba3m
3p2l3n
3p2l3^^ac
3p2^^a93^^ac
3p2l3z
3p2^^a93z
3p2^^a93^^ba
3p2^^af3c
3p2r3^^a3
3p2r3d
3p2r3s
3p2r3^^b2
p3^^b22^^b4
p3t2r
r2b3n
r3g2^^a9
r3g2r
r3g2s
r3k2d
r2k3n
r3k2t
r3k2v
r3p2c
r3p2^^a3
r3p2r
r3s2p
r3^^b22^^a3
r3^^b22l
r3^^b22r
r2t3m
r3t2n
r2t3^^ac
r3t2r
r3t2v
3s4c4h4n
s2k3l
s2k3m
s2k3n
s3k2r
s3k2v
3s2l3n
3s2l3^^ac
3s2l3z
s3p2r
3s2r3d
3s4^^af3k
3s4r3^^b2
s3t2k
^^f4s4t3k2^^e1r3s4t4v
s2t3l
s3t2m
s2t3n
s3t2r
s3t2v
s2^^b43h
s2^^b43m
s2^^b43p
^^b23k2l
^^b23k2r
^^b23t2r
3^^b24t4v
t3k2l
t3k2n
3t2l3^^a3
3t2l3k
t3h2l
3t4r3^^a3
3t4r3h
3t2r3l
3t2r3k
3t2r3m
a4t2r3n
3t2r3n
3t2^^af3n
3t2^^af3^^ac
3t4r3p
3t2r3v
3t2^^af3^^ba
3v2l3^^a3
3v2^^a93^^a3
3v2l3h
3v2l3k
3v2l3n
3v2r3h
3v2r3c2h
3v2r3l
3v2^^af3^^b2
3v2^^af3t
3v2r3z
3v2^^af3z
3v4z4d
3v4z4h
3v4z4n
3v3z2^^b4
z3d2n
noz5d4r
3z4d4r
3z4d4v
z3g2n
3z4h4r
3z2r3k
3z2r3n
3z4v4l
^^ba2d3n
3^^ba2l3^^a3
3^^ba2l3t
3^^ba2^^a9t
3^^ba2r3^^a4
^^ba3s2t
x3p2l
x3p2r
x3t2r
3b2l4^^a33n
3b2^^a94^^a33k
3b2l4n3k
3b2^^a93k2n
3b2r4b3l
3b2r4b3t
3b2r4^^a33k
3b2r4d3c
3b2^^af4d3n
3b2r3h2l
3b4^^af4k3n
3b4r4m3b
3b4r4n3^^a3
3b4r4n3k
3b4r4^^b23l
3b4r4t3l
3b4r4t3n
3b4r4v3n
3b4r4z3d
3b4r4z3l
3b4r4z3n
b3s2t2r
3c4^^af4^^a33k
3c4r4k3n
3c4v4r3^^a3
3c4v4r3k
3c4v4^^af3k
3c4v4r3l
3^^a34l4n3k
3^^a34r3^^a34r
3^^a34r4c4h3n
3^^a34r4p3k
3^^a34r4p3n
3^^a34r4t3n
3^^a34v4r3k
3^^a34v4r3l
3d4l4b3n
d4^^a94^^ba3k
d4l4^^ba3n
d4^^a94^^ba3n
3d4r4c3n
3d4r4g3^^a9
3d4r4g3n
3d4r4h3n
3d4r4n3^^a3
3d4r4n3k
3d4r4s3n
3d4r4^^ba3b
3d4r4^^ba3k
3f4r4c3k
3f4r4c3n
3f4r4^^a33k
3f4r4f3l
3f4r4k3n
3f4r4n3d
3f4r4n3d4^^ba
3f4r4n3g
3f4r4n3k
3g4l4g3n
3g2r4c3k
3h2^^a94b3k
3h2l3t4n
3h2r4b3^^a3
3h2r4^^a33k
h2r4d3l
3h2r4g3^^a9
3h2r4k3^^a9
3h2r4k3n
3h2^^af4k3n
3h2r4n3^^a3
3h2r4s3t
3h2r4s3^^b4
3ch4^^a94p3k
3c2h2r4b3t
3c2h2r4c4h3l
3c2h2r4c4h3^^a9
3c4h4r4s3t
j3s4t4r
j3s4t4v
3k4l4b3^^a3
3k4l4b3k
3k4l4z3k
3k4l4z3n
3k4r4^^a33m
3k4r4^^a33n
3k4r4k3v
3k4r4m3n
3k4^^af4m3n
3k4r4p3^^a3
3k4r4s3t
3k4r4^^b23t
3k4r4t3k
3k4r4v3n
3m2l4^^a33k
3m2^^a94k3n
3m2^^a94k3v
3m2l4s3n
m3p4r3p
m3p4r3v
3m4r4k3n
3m4r4k3v
3m4r4m3l
3m4r4n3^^a3
3m4r4n3k
3m4^^af4^^b23t
3m4^^af4t3v
3m4r4z3l
3m4r4z3k
3m4r4z3n
n4g3s4t
n3^^b24t4r
n3t4l3m
3p2l4z3l
3p2^^a94z3n
p2^^af4c3n
3p2r4^^a33k
3p4r4d3n
3p4^^af4c2h3n
3p4r4s3k
3p4r4t3k
r2s3k4d
r2s3k4t
^^a3er4s3t4v
3s4l4n3k
3s4k4r3z
3s4m4r3c
3s4m4r3^^a3
3s4m4r3d
3s4m4r3k
3s4m4r3t
3s4p4r3c4h
3s4r4d3c
3s4r4k3n
3s4r4s3t
3s4t4^^a93k
s3t4r3b
ko4s3t4r3^^a3
3s4t4r3^^a3
3s4t4^^af3h
3s4t4r3k
s4t4r3v
4s4^^b45k4r^^e1t
3^^b24k4l3b
3^^b24k4r3k
3^^b24k4^^af3k
ma^^b23k4r3t
3^^b24k4r3t
3^^b24p4l3h
3^^b24t4r3b
^^b24t4r3n
3^^b24t4v4r3t
3^^b24t4v4r3^^b4
3t2^^a94c3^^b4
3t2r4b3l
t2r4^^a33k
3t2r4d3l
3t2r4h3l
3t2r4h3n
3t2r4k3n
3t2r4k3v
3t2r4m3n
3t4^^af4p3n
3t2r4^^ba3k
3t2r4^^ba3n
3t2v4r3d
3t2v4r3d4z
3t2v4^^af3d4z
3v2l4h3^^a3
3v2l4h3k
3v2l4h3n
3v2l4n3k
3v2l4n3n
3v4r4h3n
3v4r4k3n
3v4^^af4z3g
3v4r4z3g
3v4r4z3n
3v4r4^^ba3l
3z4h4^^af3^^ac
3z4r4n3n
3^^ba4l4^^a33n
3^^ba4l4t3n
3^^ba4r4d3k
3b4r4n3k4n
b3d4^^a94^^ba3n
3c4v4r4^^a33k
3c4v4r4n3k
3^^a34^^af4s3t4v
3^^a34r4t4t3n
3^^a34v4r4k3n
3d4r4^^ba3g4r
3f4r4n4g3n
h2^^af4s3t4k
3c4h4r4s4t3n
3k4r4s4t3n
3k4r4s4t3^^ac
3s4m4r4^^b23^^b4
3s4m4r4t3k
s3t4r4n3k
3^^b24k4l4b3n
ma^^b23k4r4t3n
3^^b24k4r4t3n
3^^b24k4v4r3^^a3
3^^b24k4v4r3k
3^^b24k4v4^^af3k
3^^b24k4v4r3n
3^^b24m4r4d3k
3^^b24m4r4n3c
3^^b24p4l4h3n
3^^b24t4r4k3n
3^^b23t4r4n3g
3t4v4r4d3n
3v4r4s3t4v
3v4r4z3g4n
3c4v4r4n3g4n
3^^b24k4v4r4k3n
3^^b24k4v4^^af4k3n
k4^^a33n^^fd.
k4^^a33n^^e9ho.
k4^^a33n^^e9mu.
k4^^a33nom.
k4^^a33n^^fdm.
k4^^a33n^^e9.
k4^^a33n^^e1.
k4^^a33nej.
k4^^a33n^^fa.
k4^^a33nou.
k4^^a33n^^ed.
k4^^a33n^^fdch.
k4^^a33n^^fdmi.
k4t3n^^fd.
k4t3n^^e9ho.
k4t3n^^e9mu.
k4t3nom.
k4t3n^^fdm.
k4t3n^^e9.
k4t3n^^e1.
k4t3nej.
k4t3n^^fa.
k4t3nou.
k4t3n^^ed.
k4t3n^^fdch.
k4t3n^^fdmi.
n4^^a33n^^fd.
n4^^a33n^^e9ho.
n4^^a33n^^e9mu.
n4^^a33nom.
n4^^a33n^^fdm.
n4^^a33n^^e9.
n4^^a33n^^e1.
n4^^a33nej.
n4^^a33n^^fa.
n4^^a33nou.
n4^^a33n^^ed.
n4^^a33n^^fdch.
n4^^a33n^^fdmi.
n4k4^^a33n
n4t3n^^fd.
n4t3n^^e9ho.
n4t3n^^e9mu.
n4t3nom.
n4t3n^^fdm.
n4t3n^^e9.
n4t3n^^e1.
n4t3nej.
n4t3n^^fa.
n4t3nou.
n4t3n^^ed.
n4t3n^^fdch.
n4t3n^^fdmi.
r4d3n^^fd.
r4d3n^^e9ho.
r4d3n^^e9mu.
r4d3nom.
r4d3n^^fdm.
r4d3n^^e9.
r4d3n^^e1.
r4d3nej.
r4d3n^^fa.
r4d3nou.
r4d3n^^ed.
r4d3n^^fdch.
r4d3n^^fdmi.
r4m3n^^fd.
r4m3n^^e9ho.
r4m3n^^e9mu.
r4m3nom.
r4m3n^^fdm.
r4m3n^^e9.
r4m3n^^e1.
r4m3nej.
r4m3n^^fa.
r4m3nou.
r4m3n^^ed.
r4m3n^^fdch.
r4m3n^^fdmi.
r4p4^^a33n
r4t3n^^fd.
r4t3n^^e9ho.
r4t3n^^e9mu.
r4t3nom.
r4t3n^^fdm.
r4t3n^^e9.
r4t3n^^e1.
r4t3nej.
r4t3n^^fa.
r4t3nou.
r4t3n^^ed.
r4t3n^^fdch.
r4t3n^^fdmi.
s4t3n^^fd.
s4t3n^^e9ho.
s4t3n^^e9mu.
s4t3nom.
s4t3n^^fdm.
s4t3n^^e9.
s4t3n^^e1.
s4t3nej.
s4t3n^^fa.
s4t3nou.
s4t3n^^ed.
s4t3n^^fdch.
s4t3n^^fdmi.
z4d3ny.
z4d3neho.
z4d3nemu.
z4d3nom.
z4d3nym.
z4d3ne.
z4d3na.
z4d3nej.
z4d3nu.
z4d3nou.
z4d3ni.
z4d3nych.
z4d3nymi.
z4d3n^^fd.
z4d3n^^e9ho.
z4d3n^^e9mu.
z4d3n^^fdm.
z4d3n^^e9.
z4d3n^^e1.
z4d3n^^fa.
z4d3n^^ed.
z4d3n^^fdch.
z4d3n^^fdmi.
b2l4^^b23k
l2t3k2a.
l2t3k2y.
l2t3k2e.
l2t3k2u.
l2t3k2ou.
l2t3k2^^e1m.
l2t3k2^^e1ch.
l2t3k2a1mi.
n2t3k2a.
n2t3k2y.
n2t3k2e.
n2t3k2u.
n2t3k2ou.
n2t3k2^^e1m.
n2t3k2^^e1ch.
n2t3k2a1mi.
n2k2t3k
p2t3k2a.
p2t3k2y.
p2t3k2e.
p2t3k2u.
p2t3k2ou.
p2t3k2^^e1m.
p2t3k2^^e1ch.
p2t3k2a1mi.
s2t3k2a.
s2t3k2y.
s2t3k2e.
s2t3k2u.
s2t3k2ou.
s2t3k2^^e1m.
s2t3k2^^e1ch.
s2t3k2a1mi.
5p4r4s3t
b3s4k
d3s4k
j3s4k
l4p3s4k
l3s4k
^^a93s4k
l4t3s4k
4m3s4k
4m4p3s4k
n4d3s4k
n4k4t3s4k
n3s4k
n4t3s4k
p3s4k
p4t3s4k
r3s4k
r4t3s4k
r4z5s4k
5s4r4b3s4k
^^b23s4k
t3s4k
v3s4k
z3s4k
^^ba3s4k
n2d3^^a3
z3^^b22t2
r4z3^^b22t2
b3s4t4v
^^a33s4t4v
d3s4t4v
^^a43s4t4v
^^a93s4t4v
m3s4t4v
n3s4t4v
n4t3s4t4v
p3s4t4v
r3s4t4v
r4v5s4t4v
^^b23s4t4v
t3s4t4v
v3s4t4v
^^ba3s4t4v
.a2e2ro
.a2e2ro3d2r
.aero3g2r
.a2e2ro3k2l
.aero3p2l
.aero3s2k
.aero3s2t
.aero3t2r
.akcie3s2c2h
.ane3s2teti
.ane3s2t^^e9z
.anti5k4l
.anti5k4r
.apo5p4le
.ap4rio
.ap4ri^^f3
.arci5k4
.aristo5k4
.as3k2lep
.austro5s4
.bac2k3hand
.balne2o3
.belo5
.belo5h4
.bez5
.bez5b4
.bez5d4
.bez5h4
.bez5k4
.bez5m4
.bez5p4
.bez5s4
.bez5t4
.bez5v4
.bez5z4
.bielo5
.bielob4
.bieloh4
.bielov4
.bi2o5
.biok4
.biop4
.bios4
.blaho5
.blahop4
.blahos4
.bledo5
.boha5p4
.boho5s4
.bo^^bae5
.bo^^bae5d4
.bo^^baec2h4
.brato5v4r
.b2z2d
.c^^e1ro5v4ra
.celo5d4
.celo5k4
.celo5p4
.celo5s4
.celo5u4
.ceno5t4
.ces2t5maj
.cirkevno5
.cirkevno5p4
.c4t4n
.cudzo5k4
.cudzo5o4
.cudzo5s4
.cudzo5t4
.cudzo5v4
.cyto5p4
.^^a3aro5k4
.^^a3aro5s4
.^^a3aro5v4
.^^a3aro5z4
.^^a3erno5b4
.^^a3erno5h4
.^^a3erno5k4
.^^a3erno5o4
.^^a3erveno5a4
.^^a3erveno5b4
.^^a3erveno5h4
.^^a3erveno5k4
.^^a3erveno5o4
.^^a3erveno5p4
.^^a3ierno5b4
.^^a3ierno5h4
.^^a3ierno5o4
.^^a3o5ch4
.^^a3o5s4
.^^a3udo5t4
.da3k2d
.^^a4atelino5t4
.de5f4
.de5g4
.dek4l
.desa^^b45
.de5^^b24t2
.dez5i2
.dez5o2
.dis2k3d4
.divo5t4
.dlho5h4
.dlho5p4
.dobro5d4
.dobro5p4
.dobro5s4
.do5^^a32m
.do5d4
.do5f4
.do5h4
.do5c4h4
.do5i4
.do5k4
.do5o
.do5p4
.do5s4
.do5^^b24p
.do5^^b24tie
.do5^^b24t^^ed
.do5t4l
.do5t4m
.do5t4r
.do5t4v
.do5u
.do5v4
.do5z4
.do5^^ba4
.drevo5p4
.drevo5o
.drevo5v4
.drobno5z4
.druho5s4
.dvoj5al
.dvoj5^^a34
.dvoj5d4
.dvoj5h4
.dvoj5i4
.dvoj5k4
.dvoj5p4
.dvoj5s4
.dvoj5t4
.dvoj5u
.dvoj5v4
.dvoj5z4
.elektro5
.ex5k4
.fol2k5
.foto5
.gala5p4
.gama5g4
.ge4o
.hnedo5o
.hnedo5u
.holo5b4
.holo5h4
.holo5k4
.hore5z4
.horno5u4
.hr^^f4zo5s4t4
.hr^^f4zo5v4
.hr^^f4zy5p4
.hrubo5s4
.hydro5
.chorobo5p4
.jasno5o
.jasno5z4
.jedno5h4
.jedno5i4
.jedno5p4
.jedno5s4
.jedno5u4
.jedno5z4
.juho5a
.juho5s4
.ju^^bano5s4
.kata5k4
.kata5s4t4
.kme^^aco5t4
.koso5d4
.koso5^^b24
.koso5u
.krivo5p4
.kruto5v4
.krvi5p4
.krvi5s4
.krvi5t4
.ktovie5a2
.l^^e1sky5p4
.lesos4
.^^a94s4t
.^^a9udovo5u
.makro5k4
.makro5o4
.makro5s4
.m^^e1lo5k4
.malo5o
.m^^e1lo5v4
.m^^e1rno5t4
.medzi5h4
.medzi5i4
.medzi5p4
.medzi5^^b24
.medzi5t4
.melo5d4
.meru5^^f42
.miesto5d4
.miesto5p4
.mikro5e4
.mikro5k4
.mikro5o
.mikro5p4
.mimo5^^b24
.mimo5^^fa
.mimo5v4
.mnoho5s4
.mnoho5t4
.mnoho5u
.mnoho5v
.mnoho5z
.modro5o
.mrako5d4
.mravo5u
.mucho5t4
.m4z4d
.na5a4
.na5b4
.na5c4
.nad5h4
.na5d4nes.
.nad5p4
.na5d4p4.
.na5d4^^af4.
.na5d4robno.
.na5h4
.na5i4
.na5k4
.na5m4
.na5o4
.na5p4
.n^^e15p4
.n^^e1rodno5o
.na5s4
.na5st4
.n^^e15s4
.n^^e15st4
.na5^^b24
.na5^^b2k4
.na6^^b25sk
.na5t4
.na5u4
.na5^^fa4
.n^^e15u4
.n^^e15^^fa4
.na5v4l
.na5v4na
.na5v4r4
.n^^e15v4r4
.na5v4z4
.na5z4r
.na5z4v
.na6z5vy^^b2
.n^^e1z5v4
.na5^^ba4
.ne5a4
.ne5do3u2k
.ne5e4
.ne5i4
.ne5m4
.ne5na5h4
.ne5na5i4
.ne5na5k4
.ne5na5m4
.ne5na5p4
.ne5na5s4
.ne5na5t4
.ne5p4
.ne5s4
.ne6s5tor
.ne5^^b24
.ne5t4
.ne6t5t
.ne5u2
.ne5^^fa2
.ne5v4
.ne5z4d4r
.ne5z4d4v
.ne5z4l
.ne5z4m
.ne5z4n
.ne5z4r
.ne5z4v
.nie5k4
.ni5k4
.ni6k5to^^b2
.n^^edzko5k4
.novo5u2
.novo5z2
.obi5d4
.ob5k4
.obo5s4
.obo5z4
.ob5s4
.ob5t4
.ob5z4
.od5b4
.od5c4
.od5d4
.od5f4
.od5h4
.od5c4h4
.od5i4
.od6i5^^f3
.od5^^ed4
.od5k4
.odo5b4
.odo5h4
.odo5k4
.odo5m4k4
.odo5p4
.odo5s4
.od5p4
.od5s4
.od5^^b24
.od5t4
.od5v4
.od5z4
.t4v4r
.o5h4l
.o5h4^^a9
.o5h4na
.o5h4n^^fa
.o5h4r
.o5c4h4
.o5k4l
.o5k4^^a9
.okolo5i
.okolo5s4
.o5k4ra
.o5k4r^^e1
.o5k4resa^^b4
.o5k4res^^e1va^^b4
.o5k4ri
.o5k4r^^ed
.o5k4ru
.o5k4r^^fa
.o5m4l
.o5m4n
.o5m4r
.o5p4
.o6p5lan
.o6p5rat
.o5s4lab
.o5s4lad
.o5s4lav
.o5s4l^^e1v
.o5s4lep
.o5s4lo
.o5s4p4
.o5s4tar
.o5s4ta^^b4
.o5s4tan
.o5s4ta^^ac
.o6s5tatn
.o5s4tatok
.o5s4tatk
.o5s4t^^e1v
.o5s6to5
.o5s6t4rap
.ostro5u
.o5s4ved
.o5s4vetl
.o5s4viet
.o5s4vie^^ba
.o5s4vit
.o5s4voj
.o5^^b24k4
.o5^^b24^^a94
.o5^^b24m4
.o5^^b24p4
.o5^^b24v4
.o5t4ras
.o5t4rav
.o5t4r^^e1v
.o5t4rep
.o5t4ria
.o5v4dov
.o5v4l^^e1d
.o5v4la^^ba
.o5v4p4
.o5v4r
.o5z4l4
.o5z4n
.o5z4re
.o5z4v4l
.p^^e4^^b45izbo
.plno5a
.plno5p4
.plno5^^b24
.plno5kr4
.plocho5d4
.po5b4
.po5^^a34
.poda5k4
.pod5b4r
.pod5h4
.pod5c4h
.pod5k4
.pod5p4
.po5d4r^^e1^^ba
.po5d4rep
.pod5re
.po5d4rh
.po5d4rie
.po5d4rm
.po5d4rv
.po5d4r4^^ba
.pod5s4ko^^a3
.pod5v4
.pod3zem
.pod3zol
.pod3^^baa
.pod3^^bau
.po5h4
.po6h5reb
.po5c4h4
.po5i4
.po5k4
.pol5d4
.pol5i4z
.polo5a
.polo5b4
.pol5o4bl^^fa
.polo5d4
.polo5h4l
.polo5i
.polo5k4
.polo5m4
.polo5o4
.polo5p4
.polo5s4
.polo5t4
.polo5u4
.polo5^^fa4
.polo5v4
.polo5z4
.pol5s4t
.po5m4
.po6m5n^^edk
.po5o4
.po5ob4h
.po5ob4l
.po5s4
.po6s4t5s4k4rip
.po6s5tul
.po5^^b24
.po6^^b25ta
.po6^^b25tov
.po6^^b25v
.po5t4k4n
.po5t4^^a9
.po5t4r
.poroz5p4
.poroz5s4
.poroz5v4
.po6st5g4r
.po6s5ti
.po5t4
.po5u
.po5v4
.po4v5ra
.povy5h4
.povy5k4
.povy5p4
.povy5s4
.povy5v4
.povy5z4
.po5v4z4b
.po5z4
.pra5o4
.pra5p4
.pravicovo5o
.pra5v4l
.pra5v4nu
.pra5v4n^^fa
.pr^^e15vo5p4
.pra5vo5s4
.pre5b4
.pre5c4
.pred5c4
.pred5h4
.pred5ch4
.pred5i
.pred5k4
.pred5m4
.predo5h4
.pred5op
.pred5ostatn
.pred5p4
.pre5d4rah
.pre5d4rap
.pre5d4ra^^b4
.pre5d4ra^^ba
.pre5d4ri
.pre5d4r^^ba
.pred5s4
.pred5v4
.pred5z4
.pre5^^a34
.pre5e2
.pre5f2
.pre5h4
.pre5c4h4
.pre5i4
.pre5k4
.pre6k5vap
.pre5m4
.pre5o4
.pre5p4
.pre5s4
.pre6s5n
.pre5^^b24
.pre5t4
.pre5v4
.pre5z4
.pre5^^ba4
.pri5b4
.pri5^^a34
.pri5d4
.pri5h4
.pri5c4h4
.pri5k4
.pr^^ed5k4
.pri5m4
.pri5p4
.pri5s4
.pr^^ed5s4
.pr^^ed6s5p
.pri6s5p
.pri5s4p^^f4
.pri5^^b24
.pri6^^b25la.
.pri6^^b25li.
.pri6^^b25lo.
.pri5t4
.pri5v4
.pri5z4
.pri5^^ba4
.re5g4
.re5k4
.re6k5v
.re5p4
.re6p5n
.re5^^b24
.re5t4
.ro4z5i4
.ro6z5^^ed4
.rozo5b4
.rozo5d4
.rozo5c4h4
.rozo5m4
.rozo5p4
.rozo5r4
.rozo5s4
.rozo5^^b24
.rozo5z4
.rozo5^^ba4
.ro6z5u4
.ro6z5v4
3s4polu5
3s4polu5h4
3s4polu5p4
3s4polu5v4
.^^b2ikmo5o
.^^b2iroko5
.^^b2iroko5p4
.^^b2t^^e1to5
.^^b2t4vor5
.su4b5s4
.s^^fa5h4
.s^^fa5k4r
.s^^fa5m4r
.s^^fa5s4
.s^^fa5v4
.s^^fa5z4
.troj5
.t4v4r4do5
.viac5k4
.viac5v4
.vide2o5
.vn^^fatro5s4
.vn^^fatro5^^b24
.vo5p4ch
.vo5p4r
.vo5s4p
.vo5t4
.vo5v4
.vy5
.v^^fd5
.vy5b4
.vy5c4
.v^^fd5c4
.vy5^^a34
.v^^fd5^^a34
.vy5d4
.v^^fd5d4
.vy5h4
.vy6h5^^ac
.vy6h5ne
.v^^fd5h4
.vy5c4h4
.vy5k4
.v^^fd5k4
.vy5m4
.vy5p4
.v^^fd5p4
.vy5s4
.v^^fd5s4
.vy5^^b24
.vy6^^b25^^b2
.v^^fd6^^b25k
.vy5t4
.v^^fd5t4
.vy5v4
.vy5z4
.v^^fd5z4
.za5b4
.z^^e15b4
.za5c4
.za5^^a34
.za5d4
.za5h4
.za5c4h4
.za5k4
.za5m4
.za5p4
.za5r4
.za5s4
.za5^^b24
.za5t4
.za5v4
.za5z4
.za5^^ba4
.z^^e15k4
.z^^e15z4
.zo5b4
.zo6d5p
.zo5d4r
.zo5d4v
.zo5h4
.zo5m4l
.zo5m4r
.zo5s4
.zo5^^b24
.zo5t4
.zo5v4
.zo5z4
.zo5^^ba4
5alkohol
auto4rk
auto4rs
5b4lah
5b4ledn
5b4lesk
5b4lok
5b4l^^fad
5b4lysk
5b4lysn
5boh3vi4e3a2k
5boh3vi4e3o2d3k
5boh3z4
5boles4t5n
5b4ra^^b4
5b4r^^e1zd
5b4rec2h
5b4ronz
5b4ru^^a3
5b4r^^fas
5b4r^^fdzg
5c4muk
5c4nie
5c4vak
5c4vi^^a3
5c4vik
^^a3^^ed6s5lov
5^^a34len
5^^a34l^^e1nk
5^^a34l^^e1nok
5^^a34lov
5d4^^acov
5d4ramat
5d4ra^^b4
5d4van^^e1s4^^b45
5d4vih
5d4vi^^ba
5d4voj
5d4vor
5e2u2r^^f3p
5f4^^a9ak
5f4lias
5f4ranc^^fa
5f4rekven
5f4r^^e1z
5g4raf
5g4ram
pro6g5ram
5g4r^^e9^^a3
5g4rob
5g4vardej
5h4lad
5h4las
5h4lav
5h4^^a9ad
5h4liad
5h4luch
5h4mat
5h4mot
5h4na^^b4
5h4ned
5h4nev
5h4niezd
5h4noj
5h4nut
5h4n^^fa^^b4
5h4n^^fat
5h4rab
5h4r3mot
5h4ran
5h4ra^^b4
5h4rob
5h4rom
5h4roz
5h4rub
5h4ryz
5h4viezd
5c6h4lap
5c6h4leb
5c6hran
5c6h4r^^e1n
5c6h4r^^e1^^ac
5c6h4v^^e1l
5c6h4v^^e1t
5c6h4vat
5c6h4vost
5jeden^^e1s4t5k
5jeden^^e1s4^^b45
5k4lad
5k4la^^a4
5k4^^a9ak
5k4lam
5k4l^^e1s^^b4
5k4liat
5k4lia^^b4
5k4lep
5k4les
5k4^^a9^^fa^^a3
5k4resb
5k4res^^b4
5k4ritic
5k4r^^eddl
5k4r^^f4ch
5k4ruh
5k4r^^fa^^ba
5k4ryt
5k4valif
5k4valit
5k4vet
5k4vadr
5m4ladis4t3v
5m4no^^ba
5m4rav
5m4r^^e1z
na5d4^^ba4ga
na5d4^^ba4g^^e1
nav3^^b24tev
n^^e1v3^^b24tev
nav3^^b24t^^edv
5p4l^^e1n
5p4lastik
5p4lat
5p4lav
5p4leta
5p4letie
5p4let^^fa
5p4lies^^b4
5p4ne2umat
5p4r^^e1v
s6pr^^e1v
5p4riam
5p4rirod
5p2ris^^e1m
5p4roduk
5s4f^^e9r
5s4c2hopn
5s4k4lad
5s4k4lon
5s4ko^^a3
5s4kok
5s4kop
5s4kor
5s4k^^f4r
5s4k4romne
5s4k4rot
5s4k4r^^fac
5s4k4rutk
5s4k4r^^fdv
5s4k^^fasen
5s4kuto^^a3
5s4k4v^^fac
5s4ladk
5s4lav
5s4l^^e1v
5s4led
5s4lep
5s4lovn
5s4love
5s4lova
5s4lovk
5s4luh
5s4l^^fa^^ba
5s4^^a9ub
5s4ma^^ba
5s4mel
5s4mer
5s4piev
5s4pev
5s4por
5s4potreb
5s4p4ravod
5s4p4raved
5s4p4r^^e1vn
5s4p4ravo
5s4tarost
5s4tatic
5s4tav
5s4t4rach
5s4t4ran
5s4t4r^^e1n
5s4t4r^^e1da
5s4t4ra^^b2
5s4t2rat
5s4t2red
5s4t2rek
5s4t4rel
5s4t4re^^a9
5s4t4riel
5s4t4rie^^a9
5s4t4rih
5s4t4ri^^ba
5s4t4rom
5s4t4r^^fah
5s4t4run
5s4t4ru^^ba
5s4tati
5d2ve5s4to
5t2ri5s4to
5^^b24tyri5s4to
5p^^e4^^b45s4to
5^^b2es4^^b45s4to
5sedem5s4to
5osem5s4to
5dev^^e4^^b45s4to
5p^^e4^^b45
5^^b2es4^^b45
5s4t4la
5s4tup
5s4ved
5^^b24^^a9ah
5^^b24liap
5^^b24kola
5^^b24k4rab
5^^b24k4rie
5^^b24pin
5^^b24p4liech
5^^b24print
5^^b24tart
5^^b24t^^e1t
5^^b24tep
5^^b24t^^edt
5^^b24t4rukt^^far
5^^b24tude
5^^b24tudo
5^^b24t4vera
5^^b24t4vorec
5^^b24tyli
5^^b24^^b4ast
5^^b2tiep4
5^^b24t4v4r4^^b45k4
5^^b24t4v4r4^^b45l4
5^^b24t4v4r4^^b45r4
5^^b24t4v4r4^^b45s4
5t4la^^a3
5t4lak
5t4ran4s5
5t4ras
5t4resk
5t4retin
5t4ried
5t4rub
5t4r4vaj
5t4r4val
5t4r4van
5uholn^^edk
5uho^^a9n
5viac5h4
5v4^^a3era
5v4l^^e1d
5v4las
5v4r^^e1s
5v4rav
5v4rat
5v4r^^e1t
5v4^^b2imn
5v4t^^e1k
5v4tip
5vy5s4t4r^^e1ja
5v4z4du
5v4z4^^b4ah
5v4z4^^b4a^^ba
5z4lom
5z4lu^^a3
5z4mysel
5z4mysl
5z4nak
5z4n^^e1m
5z4n^^e1^^b2a
5z4rak
5z4v^^e4z
5z4vest
5zv4es^^b4
5z4vod
5z4vuk
5z4vu^^a3
5^^ba4r^^e1^^a3
5^^ba4rane
5^^ba4reb
5^^ba4r^^fat
.cv6
.ch6
.sp6
.st6
.^^b2k6
.^^b2p6
.^^b2t6
.tk6
.uh6
.uc6h6
.uk6
.um6
.up6
.us6
.^^fas6
.usc6h6
.^^fasc6h
.usk6
.^^fasl6
.usm6
.^^fasm6
.^^fas7ta.
.^^fas7tami.
.^^fas7to^^a3
.^^fas7ti
.ust6l
.^^fast7ny
.ust6r
.^^fas7tret
.us7t4ric
.^^fas6t6r
.^^fa^^b26
.ut6
.uv6
.uz6
.vd6
.vh6
.vk6
.vp6
.vs6
.v^^b26
.vt6
.vz6
.vzh6
.vzk6
.vzl6
.vzp6
.v^^ba6
.zb6
.zd6n
.zd6r
.zd6v
.zg6
.zh6
.zm6
.zr6
.zv6
4b4s4^^b4.
8c4h.
8d4z.
8d4^^ba.
4c4ht4.
4j4s4^^b4.
4lt.
4m4p4r.
4m4p4s.
4m4^^b24t.
4n4k4t.
4p4r4v.
4rd.
r4p4t.
r4^^b24^^a3.
r4t4z.
4st.
4s^^b4.
5k4r^^e1t.
5s4to5k4r^^e1t.
5t4^^a94c4^^b4.
akci3a2
akv^^e1ri3u2m
gymn^^e1zi3um
le2u3k^^e9mia
t2ri3u2mf
kli3e2nt
}
\hyphenation{
dos^^b4
me-t^^f3-da
me-t^^f3-dy
ne-do-stat-ka-mi
sep-tem-bra
}
\egroup

