## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

## no critic qw(ProhibitLongLines)
# $Id: P800Picture.pm 50 2009-01-31 09:22:52Z roland $
# $Revision: 50 $
# $HeadURL: svn+ssh://ipenburg.xs4all.nl/srv/svnroot/debbie/trunk/Date-Extract-P800Picture/lib/Date/Extract/P800Picture.pm$
# $Date: 2009-01-31 10:22:52 +0100 (Sat, 31 Jan 2009) $
## use critic

package TeX::Hyphen::Pattern::Et_EE;
use strict;
use warnings;
use 5.006000;
use utf8;

our $VERSION = '0.01';

my $pattern_file = q{};
while (<DATA>) {
	 $pattern_file .= $_;
}

use Class::Meta::Express qw(class ctor has meta method);

class {

    ctor 'new';

    method data => sub {
		$pattern_file;
	};

    method version => sub {
		$VERSION;
	};

};

1;
## no critic qw(RequirePodAtEnd RequireASCII)
=encoding utf8

=head1 C<Et_EE> hyphenation pattern class

=head1 Copyright

The data for this library is copied from the OpenOffice.org project and
modified to be used as a Perl module by Roland van Ipenburg.

L<http://svn.services.openoffice.org/ooo/trunk/dictionaries/et_EE/>

	Eesti keele poolitamist kirjeldav fail OpenOffice.org jaoks
	Estonian hyphenation for OpenOffice.org
	==================================================
	versioon 1.0 /version 1.0
	juuni 2004 / June 2004

	1. √úldist / General
	-------------------

	K√§esolev poolitusfail on m√µeldud OpenOffice.org tarbeks. 
	S√µnastiku paigaldamiseks tuleb tegutseda vastavalt OpenOffice.org k√§siraamatus toodud 
	juhistele.
	README k√§esoleva versiooni on koostanud ja poolitusfaili pakendanud Ain Vagula
	(vagula@openoffice.org)

	This hyphenation file is created for OpenOffice.org.
	To install the hyphenation file refer to the OpenOffice.orgOnline Help.
	Current version of README is written and packages are made by Ain Vagula
	(vagula@openoffice.org)

	2. Autorid ja litsentsid / Authors and licenses
	-----------------------------------------------

	Poolitusfaili on OpenOffice.org jaoks kohandanud Jaak Pruulmann (jjpp@meso.ee,
	http://www.meso.ee/~jjpp/speller/ ), kes on oma t√∂√∂ pannud GNU LGPL-i (GNU V√§hem √úldine
	Avalik Litsents) alla. 
	Kasutatud on Enn Saare (saar@aai.ee) poolt koostatud LaTeX-i poolitusfaili. Enn Saar on
	allkirjastanud JCA (Joint Copyright Agreement), mis lubab tema t√∂√∂d OpenOffice.org
	koosseisus kasutada.

	Hyphenation file is adapted to OpenOffice.org by Jaak Pruulmann (jjpp@meso.ee,
	http://www.meso.ee/~jjpp/speller/ ) on the base of the LaTeX hyphenation file created by Enn
	Saar (saar@aai.ee), who has signed the JCA (Joint Copyright Agreement) allowing to use
	his work for OpenOffice.org.
	The work of Jaak Pruulmann is licensed under LGPL (GNU Lesser General Public License).

	-----------------------------------

	GNU V√§hem √úldine Avalik Litsents

	Versioon number 2.1, Veebruar 1999 

	Autori√µigus (C) 1991, 1999 Free Software Foundation, Inc.

	59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

	Iga√ºks v√µib k√§esolevast dokumendist valmistada koopiaid ning valmistatud koopiaid levitada tingimusel, et need koopiad vastavad originaaldokumendile s√µnas√µnalt.

	[See on GNU V√§hem √úldise Avaliku Litsentsi esimene avaldatud versioon. See on ka GNU √úldise Avaliku Litsentsi versiooni 2 j√§reltulija, seega on versiooni number 2.1.]

	Eess√µna

	Enamik tarkvara litsentse on loodud selleks, et v√µtta Teilt √µigus tarkvara jagada ja muuta. 

	Vastukaaluks on GNU √úldine Avalik Litsents m√µeldud selleks, et tagada Teile vabadus jagada ja muuta vaba tarkvara - kindlustada, et tarkvara oleks vaba k√µigile selle kasutajatele. 

	K√§esolev, V√§hem √úldine Avalik Litsents, kehtib m√µnele spetsiaalse suunitlusega Free Software Foundation'i ja teiste autorite, kes otsustavad seda kasutada, poolt loodud tarkvara pakettidele - tavaliselt teekidele. Ka Teie v√µite k√§esolevat litsentsi kasutada, kuid soovitame Teil allpool toodud selgitustele tuginedes igal √ºksikjuhul enne hoolega m√µelda, kas strateegiliselt on parem kasutada k√§esolevat litsentsi v√µi tavalist √úldist Avalikku Litsentsi.

	R√§√§kides vabast tarkvarast peame silmas vabadust, mitte hinda. √úldised Avalikud Litsentsid on loodud selleks, et tagada Teile j√§rgnevat: √µigust levitada koopiaid vabast tarkvarast (soovi korral ka levitamise eest tasu v√µttes), tarkvara l√§htetekstide k√§ttesaadavust, √µigust tarkvara muuta v√µi kasutada tarkvara osi uute vaba tarkvaratoodete loomisel ning kindlustada, et Te olete teadlik eelpoolnimetatud √µigustest.

	Teie √µiguste tagamiseks on vaja rakendada m√µningaid piiranguid, et levitajad ei saaks Teilt neid √µigusi √§ra v√µtta v√µi n√µuda nendest loobumist. Tarkvara muutmisel v√µi selle koopiate levitamisel k√§tkevad need piirangud Teie jaoks teatud kohustusi. 

	N√§iteks levitades teegi koopiaid, kas tasuta v√µi levitamise eest tasu v√µttes, peate Te saajatele andma k√µik need √µigused, mis meie Teile andsime. Te peate kindlustama, et ka nemad saavad v√µi v√µivad soovi korral saada l√§hteteksti. 

	Kui Te lingite teegiga muud koodi, peate andma saajatele ka t√§ielikud objektfailid, et nad saaksid p√§rast muudatuste tegemist teegis ja selle uuesti kompileerimist neid uuesti teegiga linkida. Ning Te peate neid teavitama k√§esoleva Litsentsi tingimustest, et nad teaksid oma √µigusi.

	Me kaitseme Teie √µigusi kaheastmeliselt:

	1. anname teegile autori√µiguse, ja

	2. pakume Teile k√§esolevat litsentsi, mis annab Teile seadusliku √µiguse kopeerida, levitada ja/v√µi muuta teeki.

	Iga levitaja kaitsmiseks tahame me teha v√§ga selgeks, et vabal teegil pole garantiid. Kui keegi teeki muudab ja edasi levitab, peavad selle saajad teadma, et nende omanduses pole originaal v√§ltimaks teiste poolt p√µhjustatud probleemide m√µju originaali autori mainele.

	L√µpuks, tarkvara patendid kujutavad pidevat ohtu mistahes vaba programmi olemasolule. Me soovime kindlustada, et √ºkski firma ei saaks efektiivselt piirata vaba programmi kasutajaid saades patendi omanikult piirava litsentsi. Seega - me n√µuame, et mistahes patendi litsents, mis on saadud teegi versioonile, peab olema koosk√µlas k√§esolevas litsentsis s√§testatud t√§ieliku kasutamisvabadusega.

	Enamus GNU tarkvara, kaasaarvatud m√µned teegid, on kaitstud tavalise GNU √úldise Avaliku Litsentsiga. K√§esolev litsents, GNU V√§hem √úldine Avalik Litsents, kehtib teatud kindlatele teekidele ja on tavalisest √úldisest Avalikust Litsentsist k√ºllaltki erinev. Me kasutame k√§esolevat litsentsi, et lubada mitte-vabade programmide linkimist nende teekidega. 

	Kui programm on lingitud teegiga, kas staatiliselt v√µi kasutades jagatud teeki, on nende kombinatsioon juriidilises m√µistes √ºhendatud t√∂√∂, algsest teegist tulenev. Tavaline √úldine Avalik Litsents lubab seega sellist linkimist ainult kui kogu kombinatsioon vastab selle vabaduse n√µudele. V√§hem √úldine Avalik Litsents lubab vabamalt muud koodi teegiga siduda. 

	Me nimetame k√§esolevat litsentsi "V√§hem" √úldiseks Avalikuks Litsentsiks, sest see teeb kasutaja vabaduse kaitsmiseks v√§hem kui tavaline √úldine Avalik Litsents. See annab teistele vaba tarkvara arendajatele ka v√§hem eeliseid konkureerimaks mitte-vabade programmidega. Nende puuduste t√µttu kasutame me paljude teekide puhul tavalist √úldist Avalikku Litsentsi. Siiski annab V√§hem √úldine Avalik Litsents teatud kindlates olukordades eeliseid. 

	N√§iteks v√µib harvadel juhtudel olla eriline vajadus julgustada teatud teegi v√µimalikult laia kasutamist, et see muutuks de-facto standardiks. Selle saavutamiseks peab mitte-vabadele programmidele lubama teegi kasutamist. Sagedamini juhtub, et vaba teek teeb √§ra sama t√∂√∂ kui laialdaselt kasutatavad mitte-vabad teegid. Sel juhul on v√§he kasu vaba teegi kasutamise piiramisest ainult vabale tarkvarale ning me kasutame V√§hem √úldist Avalikku Litsentsi .

	Teistel juhtudel v√µimaldab luba kasutada teatud teeki mitte-vabades programmides suuremal hulgal inimestel kasutada suurt hulka vaba tarkvara. N√§iteks, luba kasutada GNU C teeki mitte-vabades programmides v√µimaldab suuremal hulgal inimestel kasutada kogu GNU operatsioonis√ºsteemi ning ka selle varianti, GNU/Linux operatsioonis√ºsteemi. 

	Kuigi V√§hem √úldine Avalik Litsents kaitseb v√§hem kasutaja vabadust, kindlustab see, et teegiga lingitud programmi kasutajal on vabadus ja vajalikud vahendid t√∂√∂tamaks programmiga kasutades teegi muudetud versiooni.

	J√§rgnevad kopeerimise, levitamise ja muutmise t√§psed terminid ning tingimused.

	P√∂√∂rake t√§helepanu erinevusele "teegil p√µhinev teos " ja "teeki kasutav teos" vahel. Esimene sisaldab teegist tuletatud koodi, teise peab teegiga √ºhendama, et t√∂√∂tada. 

	Kopeerimise, levitamise ja muutmise terminid ja tingimused.

	0. K√§esolev Litsentsileping kehtib iga tarkvara teegi v√µi muu programmi puhul, mis sisaldab autori√µiguse omaniku v√µi muu p√§deva poole m√§rget selle kohta, et antud programmi v√µib levitada vastavalt k√§esoleva V√§hem √úldise Avaliku Litsentsi (edaspidi: k√§esolev Litsents) tingimustele. Iga litsentsiaat on edaspidi "Teie".

	"Teek" t√§hendab tarkvara funktsioonide kogumit ja/v√µi andmeid, mis on ette valmistatud mugavaks linkimiseks rakendusprogrammidega (mis kasutavad neid funktsioone v√µi andmeid), et luua k√§ivitatavaid teoseid.

	Allpool viitab "Teek" igasugusele tarkvara teegile v√µi teosele, mida levitatakse nende tingimuste kohaselt. "Teegil p√µhinev teos" t√§hendab kas Teeki v√µi igasugust autori√µiguse kohaselt tuletatud teost: see t√§hendab, teost, mis sisaldab Teeki v√µi osa sellest, kas originaalis v√µi muudetuna ja/v√µi otse teise keelde t√µlgituna. (N√º√ºd ja edaspidi, t√µlge kuulub piiranguteta m√µiste "muutmine" alla.)

	Teose "L√§htekood" t√§hendab teose eelistatumat vormi, millesse muudatusi teha. Teegi t√§ielik l√§htekood t√§hendab k√µikide moodulite, mida ta sisaldab, l√§htekoode ja k√µiki sellega seotud liidese definitsioonifaile ning skripte, mida kasutatakse teegi kompileerimise ja paigaldamise kontrollimiseks.

	Litsents ei laiene muudele tegevustele kui kopeerimine, levitamine ja muutmine; need ei ole Litsentsiga kaetud. Teeki kasutava programmiga t√∂√∂tamisel pole kitsendusi ja Programmi v√§ljund on kaitstud vaid siis, kui selles sisaldub teos, mis p√µhineb Teegil (s√µltumatuna sellest, et see on kirjutatud Teegi abil). Kas see on t√µene, s√µltub sellest mida Teek teeb ja mida Teeki kasutav programm teeb.

	1. Te v√µite kopeerida ja levitada s√µnas√µnalisi koopiaid Teegi t√§ielikust l√§htekoodist nii, nagu olete selle saanud, igas vormis, eeldusel, et Te avaldate arusaadavalt ja sobivalt igal koopial vastava autori√µiguse m√§rke ja garantii v√§listamise m√§rke: hoiate puutumatuna k√µik m√§rked, mis viitavad k√§esolevale Litsentsile ja igasugusele garantii puudumisele ning levitate Teeki koos k√§esoleva Litsentsi koopiaga. 

	Te v√µite v√µtta tasu koopia f√º√ºsilise k√§ttetoimetamise akti eest ning v√µite oma valiku kohaselt pakkuda tasu eest omapoolset garantiikaitset.

	2. Te v√µite muuta Teegi koopiat v√µi koopiaid v√µi √ºksk√µik millist selle osa, luues nii Teegil p√µhineva teose ning kopeerida ja levitada selliseid muudatusi v√µi teoseid vastavalt punkti 1 tingimustele, eeldades, et Te t√§idate k√µik j√§rgnevad tingimused:

	a) muudetud teos peab ise olema tarkvara teek.

	b) Te peate kaasama muudetud failile silmatorkavad m√§rked, mis teatavad Teie poolt tehtud muudatused failides ja iga muudatuse kuup√§eva.

	c) Te peate koge teose tasuta litsenseerima k√µigile kolmandatele isikutele vastavalt k√§esoleva Litsentsi tingimustele. 

	d) Kui muudetud teegi poolt pakutav teenus kasutab funktsiooni v√µi andmeid, mille peab pakkuma rakendus, mis kasutab teenust, kuid mis ei ole selle teenuse v√§ljakutsumise argumendiks, siis peate Te tegema k√µik, et tagada teenuse t√∂√∂ ka juhul, kui rakendus vajalikku funktsiooni v√µi andmeid ei paku ja teostab √ºksk√µik millise osa oma otstarbest ning mis ka m√µtet omab. 

	(N√§iteks teegis olev funktsioon ruutjuure arvutamiseks omab otstarvet, mis on t√§iesti s√µltumatu rakendusest. Seega, alapunkt 2d n√µuab, et iga rakenduse poolt pakutav funktsioon v√µi andmekogum, mida see funktsioon kasutaks, poleks kohustuslik: kui rakendus neid funktsioone v√µi andmeid ei paku, peab ruutjuure funktsioon ikkagi arvutama ruutjuurt.)

	Need n√µuded kehtivad nii muudetud teosele kui ka tervikule. Kui eristatavad osad teosest ei ole tuletatud Teegist ja neid v√µib m√µistlikult pidada iseseisvateks ja eraldi teosteks, siis k√§esolev Litsents ja selle tingimused ei kehti nende osade suhtes kui Te levitate neid kui eraldi teoseid. Aga kui Te levitate samu osasid osana tervikust, mis on Teegil p√µhinev teos, peab levitamine toimuma vastavalt k√§esoleva Litsentsi tingimustele, mille lubadused teistele litsensiaatidele laienevad kogu teosele ja seega igale osale, olenemata sellest, kes selle kirjutas. Seega pole k√§esoleva punkti eesm√§rk n√µuda √µigusi v√µi vaidlustada Teie √µigusi teosele, mille Te olete tervikuna loonud; pigem on eesm√§rk kasutada √µigust suunata Teegil p√µhinevate teoste v√µi √ºhisteoste levitamist.

	Lisaks, ainu√ºksi asjaolu, et √ºhtsesse levitamis- v√µi s√§ilitusvormi on liidetud teine teos, mis ei p√µhine Teegil, Teegiga (v√µi Teegil p√µhineva teosega), ei muuda nimetatud teost k√§esoleva Litsentsi alla kuuluvaks.

	3. Te v√µite valida, et teatud Teegi koopiale kehtivad k√§esoleva Litsentsi asemel tavalise GNU √úldise Avaliku Litsentsi tingimused. Selleks peate Te muutma k√µiki m√§rkeid, mis viitavad k√§esolevale Litsentsile, nii et need viitaksid selle asemel tavalisele GNU √úldise Avaliku Litsentsi versioonile 2. (Kui ilmub uuem GNU √úldise Avaliku Litsentsi versioon kui praegune versioon 2, v√µite t√§psustada selle versiooni kui soovite.) √Ñrge tehke neis m√§rgetes muid muudatusi.

	Kui teatud koopiale on nimetatud muudatus tehtud, on see selle koopia suhtes p√∂√∂rdumatu, nii et tavaline GNU √úldine Avalik Litsents kehtib k√µigi sellest koopiast tulenevate teoste ja j√§rgnevate koopiate suhtes.

	See v√µimalus on kasulik, kui Te soovite kopeerida osa Teegi koodist programmi, mis pole Teek.

	4. Te v√µite Teeki kopeerida ja levitada (v√µi punkti 2 kohaselt Teegi osa v√µi Teegil p√µhinevat teost) objektkoodina v√µi k√§ivitataval kujul vastavalt punktide 1 ja 2 kohaselt eeldusel, et Te lisate sellele t√§ieliku vastava masinloetava l√§hteteksti, mida peab levitama vastavalt punktides 1 ja 2 toodud tingimustele, vormis, mida kasutatakse valdavalt tarkvara vahendustegevuses.

	Kui objektkoodi levitamine toimub ligip√§√§su pakkumisega kopeerimiseks m√§√§ratud kohas, siis ligip√§√§su pakkumine l√§hteteksti kopeerimiseks samast kohast loetakse v√µrdseks l√§hteteksti levitamisega, kuigi kolmandad osapooled pole kohustatud koos objektkoodiga l√§hteteksti kopeerima.

	5. Programmi, mis ei sisalda Teegi osa ega Teegist tuletatud teost, aga on loodud t√∂√∂tama koos Teegiga kompileerimise kaudu v√µi lingitud sellega, kutsutakse "Teeki kasutavaks teoseks". Selline teos ei ole eraldiseisvana Teegist tuletatud teos ja ei ole seega k√§esoleva Litsentsiga kaetud.

	Siiski, "Teeki kasutava teose" Teegiga linkimine loob k√§ivitatava vormi, mis on Teegist tuletatud (sest see sisaldab Teegi osi), mitte "Teeki kasutava teose". K√§ivitatav vorm on seega k√§esoleva Litsentsiga kaetud. Punktis 6 s√§testatakse selliste k√§ivitatavate vormide levitamise tingimused.

	Kui "Teeki kasutav teos" kasutab materjali Teegi osaks olevast p√§isefailist, v√µib teose objektkood olla Teegist tuletatud teos kuigi l√§htekood seda pole. Kas see on t√µene, on eriti t√§htis, kui teost saab linkida ilma Teegita, v√µi teos ise on Teek. Kas see on t√µene, ei ole t√§pselt seadusega s√§testatud.

	Kui selline objektfail kasutab ainult arvparameetreid, andmete struktuuri paigutust ja lisandeid, v√§ikseid makrosid ja v√§ikseid inline funktsioone (k√ºmme m√§rki v√µi v√§hem pikad), siis pole objektfaili kasutamine piiratud, vaatamata sellele, et see on juriidiliselt tuletatud teos. (K√§ivitatavad failid, mis sisaldavad seda objektkoodi ja osi Teegist on ikkagi kaetud punktiga 6.) 

	Vastasel juhul, kui teos tuleneb Teegist, v√µite Te levitada teose objektkoodi vastavalt punktis 6 toodud tingimustele. Iga k√§ivitatav vorm, mis sisaldab teost, k√§ib samuti punkti 6 alla, vaatamata sellele kas need on otseselt Teegiga seotud. 

	6. √úlaltoodud punktide erandina v√µite Te kombineerida v√µi linkida "Teeki kasutava teose" Teegiga, et luua teost, mis sisaldab Teegi osi, ning levitada seda teost vastavalt oma tingimustele, eeldusel, et tingimused lubavad teose muutmist kliendi soovil ning p√∂√∂rdprojekteerimist (reverse engineering) selliste muudatuste silumiseks.

	Te peate andma silmatorkavad m√§rked igale Teeki kasutava teose koopiale, et selles on kasutatud Teeki ning et Teegi kasutamine on kaetud k√§esoleva Litsentsiga. Te peate pakkuma k√§esoleva Litsentsi koopiat. Kui teos kuvab k√§ivitamisel autori√µiguse m√§rked, peate Te lisama neile ka Teegi autori√µiguse m√§rke ja viite, mis juhatab kasutaja k√§esoleva Litsentsi koopia juurde. Samuti peate Te tegema √ºhe j√§rgmistest asjadest:

	a) Lisama teosele t√§ieliku vastava masinloetava Teegi l√§hteteksti, kaasa arvatud muudatused, mida kasutati teoses (mida peab levitama vastavalt Punktidele 1 ja 2); ja, kui teos on Teegiga lingitud k√§ivitatav vorm, koos t√§ieliku masinloetava "Teeki kasutava teose" objektkoodiga ja/v√µi l√§htekoodiga, et kasutaja saaks muuta Teeki ja uuesti linkida, et valmistada muudetud k√§ivitatavat vormi, mis sisaldab muudetud Teeki. (On arusaadav, et kasutaja, kes muudab Teegi definitsioonifailide sisu, ei ole tingimata v√µimeline rakendust uuesti kompileerima, et muudetud definitsioone kasutada.) 

	b) Kasutama Teegiga linkimiseks sobivat jagatud mehanismi. Mehanism on sobiv kui see (1) kasutab k√§itusajal koopiat Teegist, mis juba on kasutaja arvutis√ºsteemis, mitte ei kopeeri teegi funktsioone k√§ivitatavasse vormi, ja (2) t√∂√∂tab korralikult teegi muudetud variandiga, kui kasutaja selle installeerib, tingimusel, et muudetud variant on liides-√ºhilduv variandiga, millega teos tehti. 

	c) Lisama teosele kirjaliku pakkumise, mis kehtib v√§hemalt 3 aastat, et anda samale kasutajale alapunktis 6a nimetatud materjalid, mitte kallimalt kui levitamise hinnaga.

	d) Kui teost levitatakse ligip√§√§su pakkumise teel koopiale m√§√§ratud kohas, v√µrdub pakkumine ligip√§√§suga kopeerida √ºlalnimetatud materjalid samast kohast.

	e) Kontrollima, et kasutaja on juba saanud koopia nii nendest materjalidest v√µi sa oled juba saatnud sellel kasutajale koopia.

	K√§ivitatava vormi jaoks peab "Teeki kasutava teose" n√µutud vorm sisaldama andmeid ja utiliite, mis on vajalikud k√§ivitatava vormi taasloomiseks. Siiski, erilise erandina, ei pea levitatavad materjalid sisaldama midagi (ei l√§hte- ega kahendvormis), mida tavaliselt levitatakse koos operatsioonis√ºsteemi p√µhiliste osadega (kompilaator, kernel jne.), millel k√§ivitatav vorm t√∂√∂tab, v√§lja arvatud juhul kui see osa k√§ib k√§ivitatava vormiga kaasas.

	V√µib juhtuda, et see n√µue l√§heb vastuollu teiste kaitstud teekide litsentsi piirangutega, mis tavaliselt ei k√§i operatsioonis√ºsteemiga kaasas. Selline vastuolu t√§hendab, et Te ei saa kasutada k√§ivitatavas vormis, mida Te levitate, neid ja Teeki koos.

	7. Te v√µite panna teegi teenused, mis on Teegil p√µhinevad teosed, k√µrvuti √ºhte teeki koos teiste teegi teenustega, mis ei ole kaetud k√§esoleva Litsentsiga, ja levitada sellist √ºhendatud teeki, tingimusel, et Teegil p√µhineva teose ja teiste teegi vahendite eraldi levitamine on lubatud ja et Te teete j√§rgmised asjad: 

	a) lisate √ºhendatud teegile koopia samast teosest, mis p√µhineb Teegil, mis ei ole √ºhendatud teiste Teegi vahenditega. Seda peab levitama vastavalt √ºlaltoodud punktidele.

	b) annate koos √ºhendatud teegiga silmatorkavad m√§rked asjaolust, et osa sellest on Teegil p√µhinev teos, ja seletate kust leida sama teose mitte √ºhendatud vorm.

	8. Te ei tohi kopeerida, muuta, edasi litsentseerida, linkida v√µi levitada Teeki teisiti kui k√§esolevas Litsentsis v√§ljendatud. Iga katse kopeerida, muuta, edasi litsentseerida, linkida v√µi levitada Teeki teisiti, on kehtetu ja l√µpetab automaatselt Teie √µigused vastavalt k√§esolevale Litsentsile. Siiski, osapoolte litsentse, kes on saanud koopiad v√µi √µigused Teilt vastavalt k√§esolevale Litsentsile, ei l√µpetata nii kaua kui k√µik osapooled t√§idavad t√§ielikult kehtestatud tingimusi.

	9. Te ei pea k√§esolevat Litsentsi arvestama, kuna Te pole sellele alla kirjutanud. Siiski, miski muu ei anna Teile luba muuta v√µi levitada Teeki v√µi sellest tulenevaid teoseid. Need tegevused on keelatud seadusega kui Te k√§esoleva Litsentsiga ei arvesta. Seega, muutes v√µi levitades Teeki (v√µi teegil p√µhinevat teost) n√§itate Te seda tehes oma n√µusolekut k√§esoleva Litsentsiga ning k√µigi selle Teegi v√µi teegil p√µhineva teose kopeerimise, levitamise v√µi muutmise terminite ja tingimustega. 

	10. Iga kord kui Te Teeki (v√µi Teegil p√µhinevat teost) edasi levitate, saab vastuv√µtja automaatselt originaallitsenstiaarilt litsentsi kopeerida, levitada, linkida v√µi muuta Teeki vastavalt nendele terminitele ja tingimustele. Te ei tohi kohustada vastuv√µtjat rohkem millekski temale siin antud √µiguste kasutamisel. Te ei ole vastutav kolmandate poolte poolt kehtestatud tingimuste t√§itmise eest. 

	11. Kui kohtulahendi v√µi v√§idetava patendi√µiguse rikkumise tagaj√§rjel v√µi m√µnel muul p√µhjusel (mis ei piirdu patendiga seotud k√ºsimustega) on Teile pandud kohustusi, mis on vastuolus k√§esoleva Litsentsi tingimustega, siis ei vabasta need Teid k√§esoleva Litsentsi tingimuste t√§itmisest. Kui Te ei suuda Teeki levitada, t√§ites samaaegselt k√§esoleva Litsentsi tingimusi ja teisi kohustusi, siis ei tohi Te Teeki √ºldse levitada. N√§iteks kui patendilitsents ei luba Teil litsentsitasuta Teeki edasi levitada neile, kes on saanud Teilt v√µi Teie kaudu Teegi koopia, siis ainus v√µimalus t√§ita nimetatud patendilitsentsi ja k√§esoleva Litsentsi tingimusi on loobuda Teegi levitamisest.

	Kui k√§esoleva punkti m√µni osa osutub mingil asjaolul kehtetuks v√µi mitterakendatavaks, siis k√§esoleva punkti √ºlej√§√§nud osa loetakse rakendatavaks ja punkt tervikuna loetakse rakendatavaks √ºlej√§√§nud tingimustel.

	K√§esoleva punkti eesm√§rk ei ole kellegi ajendamine patendi- v√µi muude √µiguste rikkumiseks v√µi nende kehtivuse vaidlustamiseks; k√§esoleva punkti ainus eesm√§rk on vaba tarkvara levitamise s√ºsteemi terviklikkuse kaitsmine, mida kasutavad avalike litsentside kasutajad. Paljud isikud on andnud suure panuse tarkvara laiale sektorile, mida levitatakse l√§bi nimetatud s√ºsteemi usaldades j√§rjekindlat s√ºsteemi rakendumist; autor/annetaja on otsustaja, kas ta soovib tarkvara levitada m√µne teise s√ºsteemi kaudu ja litsenstiaat ei saa seda valikut m√µjutada.

	Selle punkti eesm√§rk on t√§pselt selgitada, mida soovitakse k√§esoleva Litsentsi √ºlej√§√§nud osaga saavutada.

	12. Kui Teegi levitamist ja/v√µi kasutamist piiratakse m√µnedes riikides kas patentide v√µi autori√µigusega, v√µib autori√µiguse omanik, kes on Teegi litsenseerinud, lisada kindla geograafilise piirangu, j√§ttes nimekirjast v√§lja mainitud riigid, et levitamine oleks lubatud vaid nimekirjas toodud riikides v√µi riikide vahel. Nimetatud juhul Litsents liitub piiranguga, nagu see on √§ra toodud k√§esoleva Litsentsi p√µhiosas.

	13. Free Software Foundation v√µib aeg-ajalt v√§lja anda √ºmbert√∂√∂tatud ja/v√µi uusi versioone V√§hem √úldisest Avalikust Litsentsist. Need uued versioonid on k√§esoleva Litsentsi versiooniga sarnase sisuga, kuid v√µivad erineda detailides, osundades uusi probleeme v√µi huviobjekte.

	Igale versioonile antakse unikaalne versiooninumber. Kui Teegis tuuakse √§ra selle kohta kehtiva k√§esoleva litsentsi versiooninumber ja lisatakse m√§rge "k√µik hilisemad versioonid", siis on Teil v√µimalik valida, kas j√§rgida selle v√µi √ºksk√µik millise hilisema Free Software Foundation'i poolt avaldatava versiooni tingimusi. Kui Teek ei t√§psusta k√§esoleva litsentsi versiooninumbrit, on Teil v√µimalus valida √ºksk√µik milline Free Software Foundation'i poolt avaldatud k√§esoleva Litsentsi versioon.

	14. Kui Te soovite Teegi osi liita teiste vabade teekidega, mille levitamise tingimused on erinevad, siis kirjutage loa saamiseks autorile. Tarkvara puhul, mis on autori√µigusega kaitstud Free Software Foundation'i poolt, kontakteeruge Free Software Foundation'iga, m√µnikord me teeme erandeid. Meie otsuse m√§√§ravad kaks eesm√§rki: s√§ilitada vaba staatus meie vaba tarkvara igasugustele derivaatidele ja edendada tarkvara jagamist ning taaskasutamist √ºldiselt.

	GARANTII PUUDUMINE

	15. KUNA PROGRAMM ON LITSENSEERITUD TASUTA, PUUDUB TEEGIL IGASUGUNE GARANTII ULATUSENI, MIDA LUBAB RAKENDATAV SEADUS. KUI KIRJALIKULT POLE TEISITI S√ÑTESTATUD, SIIS AUTORI√ïIGUSE OMANIKUD JA/V√ïI MUUD OSAPOOLED PAKUVAD TEEKI "NII, NAGU TA ON" ILMA IGASUGUSE V√ÑLJENDATUD V√ïI OLETATAVA GARANTIITA, KAASA ARVATUD, KUID MITTE AINULT, KESKMISE/TAVALISE KVALITEEDI JA MINGILE KINDLALE EESM√ÑRGILE SOBIVUSE GARANTIITA. KOGU TEEGI KVALITEEDI JA TOIMIMISE RISK LANGEB TEILE. KUI TEEK ON PUUDULIK, KANNATE TEIE K√ïIK TEENINDUSE, PARANDUSE V√ïI TAASTAMISE KULUD.

	16. MITTE MINGIL JUHUL, V√ÑLJA ARVATUD SIIS, KUI SEDA N√ïUAB RAKENDATAV SEADUS V√ïI KIRJALIKULT ON TEISITI KOKKU LEPITUD, POLE √úKSKI AUTORI√ïIGUSE OMANIK V√ïI KOLMAS OSAPOOL, KES V√ïIB MUUTA JA/V√ïI LEVITADA TEEKI VASTAVALT √úLALPOOL TOODUD TINGIMUSTELE, TEIE EES VASTUTAV KAHJUSTUSTE EEST, KAASA ARVATUD IGASUGUSED √úLDISED, SPETSIIFILISED, JUHUSLIKUD V√ïI TAGAJ√ÑRJEL TEKKINUD KAHJUD, MIS TULENEVAD KAS TEEGI KASUTAMISEST V√ïI V√ïIMATUSEST TEEKI KASUTADA (KAASA ARVATUD, KUID MITTE AINULT, TEIE V√ïI KOLMANDATE OSAPOOLTE ANDMETE KADUMINE V√ïI ANDMETE MUUTMINE V√ïI TEEGI V√ïIMETUS T√ñ√ñTADA KOOS MISTAHES MUU TARKVARAGA), ISEGI SIIS, KUI VALDAJAT V√ïI MUUD OSAPOOLT ON TEAVITATUD SELLISTE KAHJUDE V√ïIMALIKKUSEST.

	TERMINITE JA TINGIMUSTE L√ïPP.

	Kuidas rakendada oma uutele teekidele neid termineid ja tingimusi?

	Kui Te loote uue teegi ja soovite, et see olekas avalikkusele v√µimalikult kasulik, soovitame selle muuta vabaks tarkvaraks, et iga√ºks saaks seda edasi levitada ja muuta. Te v√µite seda teha lubades edasi levitamist vastavalt k√§esolevatele tingimustele (v√µi vastavalt tavalise √úldise Avaliku Litsentsi tingimustele). 

	Et rakendada neid tingimusi, lisage teegile j√§rgmised m√§rkused. K√µige kindlam on lisada need m√§rked iga l√§htefaili algusse, et v√µimalikult efektiivselt teatada garantii puudumisest: igal failil peaks olema v√§hemalt √ºks "autori√µiguse" rida ja viide kohale, kust v√µib leida tervikliku m√§rkuse.

	√ºks rida teegi nime jaoks ja mida see teeb

	Copyright (C) aasta autori nimi

	K√§esolev teek on vaba tarkvara. Te v√µite seda edasi levitada ja/v√µi muuta vastavalt GNU V√§hem √úldise Avaliku Litsentsi tingimustele, nagu need on Vaba Tarkvara Fondi poolt avaldatud; kas Litsentsi versioon number 2.1 v√µi (vastavalt Teie valikule) √ºksk√µik milline hilisem versioon.

	Seda teeki levitatakse lootuses, et see on kasulik, kuid ILMA IGASUGUSE GARANTIITA; isegi KESKMISE/TAVALISE KVALITEEDI GARANTIITA v√µi SOBIVUSELE TEATUD KINDLAKS EESM√ÑRGIKS. √úksikasjalise info saamiseks vaata GNU √úldist V√§hem Avalikku Litsentsi.

	Te peaks olema saanud GNU √úldise V√§hem Avaliku Litsentsi koopia koos selle teegiga, kui ei, siis kontakteeruge Free Software Foundation'iga, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA 

	Samuti lisage informatsioon, kuidas Teiega kontakteeruda kas posti v√µi meili teel.

	Te peaksite laskma oma t√∂√∂andjal (kui te t√∂√∂tate programmeerijana), v√µi koolil alla kirjutada autori√µiguslike pretensioonide loobumise kohta k√§ivale dokumendile. Siin on n√§idis, muutke ise nimed:

	Yoyodyne, Inc., loobub k√µigist autori√µigustest teegile "Frob", mille on kirjutanud James Random Hacker.

	allkiri, 1 April 1990

	Ty Coon, President of Vice

	----------------------------------------------

	GNU LESSER GENERAL PUBLIC LICENSE

	Version 2.1, February 1999 


	Copyright (C) 1991, 1999 Free Software Foundation, Inc.
	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	Everyone is permitted to copy and distribute verbatim copies
	of this license document, but changing it is not allowed.

	[This is the first released version of the Lesser GPL.  It also counts
	 as the successor of the GNU Library Public License, version 2, hence
	 the version number 2.1.]
	Preamble

	The licenses for most software are designed to take away your freedom to share and change it. By contrast, the GNU General Public Licenses are intended to guarantee your freedom to share and change free software--to make sure the software is free for all its users. 

	This license, the Lesser General Public License, applies to some specially designated software packages--typically libraries--of the Free Software Foundation and other authors who decide to use it. You can use it too, but we suggest you first think carefully about whether this license or the ordinary General Public License is the better strategy to use in any particular case, based on the explanations below. 

	When we speak of free software, we are referring to freedom of use, not price. Our General Public Licenses are designed to make sure that you have the freedom to distribute copies of free software (and charge for this service if you wish); that you receive source code or can get it if you want it; that you can change the software and use pieces of it in new free programs; and that you are informed that you can do these things. 

	To protect your rights, we need to make restrictions that forbid distributors to deny you these rights or to ask you to surrender these rights. These restrictions translate to certain responsibilities for you if you distribute copies of the library or if you modify it. 

	For example, if you distribute copies of the library, whether gratis or for a fee, you must give the recipients all the rights that we gave you. You must make sure that they, too, receive or can get the source code. If you link other code with the library, you must provide complete object files to the recipients, so that they can relink them with the library after making changes to the library and recompiling it. And you must show them these terms so they know their rights. 

	We protect your rights with a two-step method: (1) we copyright the library, and (2) we offer you this license, which gives you legal permission to copy, distribute and/or modify the library. 

	To protect each distributor, we want to make it very clear that there is no warranty for the free library. Also, if the library is modified by someone else and passed on, the recipients should know that what they have is not the original version, so that the original author's reputation will not be affected by problems that might be introduced by others. 

	Finally, software patents pose a constant threat to the existence of any free program. We wish to make sure that a company cannot effectively restrict the users of a free program by obtaining a restrictive license from a patent holder. Therefore, we insist that any patent license obtained for a version of the library must be consistent with the full freedom of use specified in this license. 

	Most GNU software, including some libraries, is covered by the ordinary GNU General Public License. This license, the GNU Lesser General Public License, applies to certain designated libraries, and is quite different from the ordinary General Public License. We use this license for certain libraries in order to permit linking those libraries into non-free programs. 

	When a program is linked with a library, whether statically or using a shared library, the combination of the two is legally speaking a combined work, a derivative of the original library. The ordinary General Public License therefore permits such linking only if the entire combination fits its criteria of freedom. The Lesser General Public License permits more lax criteria for linking other code with the library. 

	We call this license the "Lesser" General Public License because it does Less to protect the user's freedom than the ordinary General Public License. It also provides other free software developers Less of an advantage over competing non-free programs. These disadvantages are the reason we use the ordinary General Public License for many libraries. However, the Lesser license provides advantages in certain special circumstances. 

	For example, on rare occasions, there may be a special need to encourage the widest possible use of a certain library, so that it becomes a de-facto standard. To achieve this, non-free programs must be allowed to use the library. A more frequent case is that a free library does the same job as widely used non-free libraries. In this case, there is little to gain by limiting the free library to free software only, so we use the Lesser General Public License. 

	In other cases, permission to use a particular library in non-free programs enables a greater number of people to use a large body of free software. For example, permission to use the GNU C Library in non-free programs enables many more people to use the whole GNU operating system, as well as its variant, the GNU/Linux operating system. 

	Although the Lesser General Public License is Less protective of the users' freedom, it does ensure that the user of a program that is linked with the Library has the freedom and the wherewithal to run that program using a modified version of the Library. 

	The precise terms and conditions for copying, distribution and modification follow. Pay close attention to the difference between a "work based on the library" and a "work that uses the library". The former contains code derived from the library, whereas the latter must be combined with the library in order to run. 

	TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

	0. This License Agreement applies to any software library or other program which contains a notice placed by the copyright holder or other authorized party saying it may be distributed under the terms of this Lesser General Public License (also called "this License"). Each licensee is addressed as "you". 

	A "library" means a collection of software functions and/or data prepared so as to be conveniently linked with application programs (which use some of those functions and data) to form executables. 

	The "Library", below, refers to any such software library or work which has been distributed under these terms. A "work based on the Library" means either the Library or any derivative work under copyright law: that is to say, a work containing the Library or a portion of it, either verbatim or with modifications and/or translated straightforwardly into another language. (Hereinafter, translation is included without limitation in the term "modification".) 

	"Source code" for a work means the preferred form of the work for making modifications to it. For a library, complete source code means all the source code for all modules it contains, plus any associated interface definition files, plus the scripts used to control compilation and installation of the library. 

	Activities other than copying, distribution and modification are not covered by this License; they are outside its scope. The act of running a program using the Library is not restricted, and output from such a program is covered only if its contents constitute a work based on the Library (independent of the use of the Library in a tool for writing it). Whether that is true depends on what the Library does and what the program that uses the Library does. 

	1. You may copy and distribute verbatim copies of the Library's complete source code as you receive it, in any medium, provided that you conspicuously and appropriately publish on each copy an appropriate copyright notice and disclaimer of warranty; keep intact all the notices that refer to this License and to the absence of any warranty; and distribute a copy of this License along with the Library. 

	You may charge a fee for the physical act of transferring a copy, and you may at your option offer warranty protection in exchange for a fee. 

	2. You may modify your copy or copies of the Library or any portion of it, thus forming a work based on the Library, and copy and distribute such modifications or work under the terms of Section 1 above, provided that you also meet all of these conditions: 

	a) The modified work must itself be a software library. 
	b) You must cause the files modified to carry prominent notices stating that you changed the files and the date of any change. 
	c) You must cause the whole of the work to be licensed at no charge to all third parties under the terms of this License. 
	d) If a facility in the modified Library refers to a function or a table of data to be supplied by an application program that uses the facility, other than as an argument passed when the facility is invoked, then you must make a good faith effort to ensure that, in the event an application does not supply such function or table, the facility still operates, and performs whatever part of its purpose remains meaningful. 

	(For example, a function in a library to compute square roots has a purpose that is entirely well-defined independent of the application. Therefore, Subsection 2d requires that any application-supplied function or table used by this function must be optional: if the application does not supply it, the square root function must still compute square roots.) 

	These requirements apply to the modified work as a whole. If identifiable sections of that work are not derived from the Library, and can be reasonably considered independent and separate works in themselves, then this License, and its terms, do not apply to those sections when you distribute them as separate works. But when you distribute the same sections as part of a whole which is a work based on the Library, the distribution of the whole must be on the terms of this License, whose permissions for other licensees extend to the entire whole, and thus to each and every part regardless of who wrote it. 

	Thus, it is not the intent of this section to claim rights or contest your rights to work written entirely by you; rather, the intent is to exercise the right to control the distribution of derivative or collective works based on the Library. 

	In addition, mere aggregation of another work not based on the Library with the Library (or with a work based on the Library) on a volume of a storage or distribution medium does not bring the other work under the scope of this License. 

	3. You may opt to apply the terms of the ordinary GNU General Public License instead of this License to a given copy of the Library. To do this, you must alter all the notices that refer to this License, so that they refer to the ordinary GNU General Public License, version 2, instead of to this License. (If a newer version than version 2 of the ordinary GNU General Public License has appeared, then you can specify that version instead if you wish.) Do not make any other change in these notices. 

	Once this change is made in a given copy, it is irreversible for that copy, so the ordinary GNU General Public License applies to all subsequent copies and derivative works made from that copy. 

	This option is useful when you wish to copy part of the code of the Library into a program that is not a library. 

	4. You may copy and distribute the Library (or a portion or derivative of it, under Section 2) in object code or executable form under the terms of Sections 1 and 2 above provided that you accompany it with the complete corresponding machine-readable source code, which must be distributed under the terms of Sections 1 and 2 above on a medium customarily used for software interchange. 

	If distribution of object code is made by offering access to copy from a designated place, then offering equivalent access to copy the source code from the same place satisfies the requirement to distribute the source code, even though third parties are not compelled to copy the source along with the object code. 

	5. A program that contains no derivative of any portion of the Library, but is designed to work with the Library by being compiled or linked with it, is called a "work that uses the Library". Such a work, in isolation, is not a derivative work of the Library, and therefore falls outside the scope of this License. 

	However, linking a "work that uses the Library" with the Library creates an executable that is a derivative of the Library (because it contains portions of the Library), rather than a "work that uses the library". The executable is therefore covered by this License. Section 6 states terms for distribution of such executables. 

	When a "work that uses the Library" uses material from a header file that is part of the Library, the object code for the work may be a derivative work of the Library even though the source code is not. Whether this is true is especially significant if the work can be linked without the Library, or if the work is itself a library. The threshold for this to be true is not precisely defined by law. 

	If such an object file uses only numerical parameters, data structure layouts and accessors, and small macros and small inline functions (ten lines or less in length), then the use of the object file is unrestricted, regardless of whether it is legally a derivative work. (Executables containing this object code plus portions of the Library will still fall under Section 6.) 

	Otherwise, if the work is a derivative of the Library, you may distribute the object code for the work under the terms of Section 6. Any executables containing that work also fall under Section 6, whether or not they are linked directly with the Library itself. 

	6. As an exception to the Sections above, you may also combine or link a "work that uses the Library" with the Library to produce a work containing portions of the Library, and distribute that work under terms of your choice, provided that the terms permit modification of the work for the customer's own use and reverse engineering for debugging such modifications. 

	You must give prominent notice with each copy of the work that the Library is used in it and that the Library and its use are covered by this License. You must supply a copy of this License. If the work during execution displays copyright notices, you must include the copyright notice for the Library among them, as well as a reference directing the user to the copy of this License. Also, you must do one of these things: 

	a) Accompany the work with the complete corresponding machine-readable source code for the Library including whatever changes were used in the work (which must be distributed under Sections 1 and 2 above); and, if the work is an executable linked with the Library, with the complete machine-readable "work that uses the Library", as object code and/or source code, so that the user can modify the Library and then relink to produce a modified executable containing the modified Library. (It is understood that the user who changes the contents of definitions files in the Library will not necessarily be able to recompile the application to use the modified definitions.) 
	b) Use a suitable shared library mechanism for linking with the Library. A suitable mechanism is one that (1) uses at run time a copy of the library already present on the user's computer system, rather than copying library functions into the executable, and (2) will operate properly with a modified version of the library, if the user installs one, as long as the modified version is interface-compatible with the version that the work was made with. 
	c) Accompany the work with a written offer, valid for at least three years, to give the same user the materials specified in Subsection 6a, above, for a charge no more than the cost of performing this distribution. 
	d) If distribution of the work is made by offering access to copy from a designated place, offer equivalent access to copy the above specified materials from the same place. 
	e) Verify that the user has already received a copy of these materials or that you have already sent this user a copy. 

	For an executable, the required form of the "work that uses the Library" must include any data and utility programs needed for reproducing the executable from it. However, as a special exception, the materials to be distributed need not include anything that is normally distributed (in either source or binary form) with the major components (compiler, kernel, and so on) of the operating system on which the executable runs, unless that component itself accompanies the executable. 

	It may happen that this requirement contradicts the license restrictions of other proprietary libraries that do not normally accompany the operating system. Such a contradiction means you cannot use both them and the Library together in an executable that you distribute. 

	7. You may place library facilities that are a work based on the Library side-by-side in a single library together with other library facilities not covered by this License, and distribute such a combined library, provided that the separate distribution of the work based on the Library and of the other library facilities is otherwise permitted, and provided that you do these two things: 

	a) Accompany the combined library with a copy of the same work based on the Library, uncombined with any other library facilities. This must be distributed under the terms of the Sections above. 
	b) Give prominent notice with the combined library of the fact that part of it is a work based on the Library, and explaining where to find the accompanying uncombined form of the same work. 

	8. You may not copy, modify, sublicense, link with, or distribute the Library except as expressly provided under this License. Any attempt otherwise to copy, modify, sublicense, link with, or distribute the Library is void, and will automatically terminate your rights under this License. However, parties who have received copies, or rights, from you under this License will not have their licenses terminated so long as such parties remain in full compliance. 

	9. You are not required to accept this License, since you have not signed it. However, nothing else grants you permission to modify or distribute the Library or its derivative works. These actions are prohibited by law if you do not accept this License. Therefore, by modifying or distributing the Library (or any work based on the Library), you indicate your acceptance of this License to do so, and all its terms and conditions for copying, distributing or modifying the Library or works based on it. 

	10. Each time you redistribute the Library (or any work based on the Library), the recipient automatically receives a license from the original licensor to copy, distribute, link with or modify the Library subject to these terms and conditions. You may not impose any further restrictions on the recipients' exercise of the rights granted herein. You are not responsible for enforcing compliance by third parties with this License. 

	11. If, as a consequence of a court judgment or allegation of patent infringement or for any other reason (not limited to patent issues), conditions are imposed on you (whether by court order, agreement or otherwise) that contradict the conditions of this License, they do not excuse you from the conditions of this License. If you cannot distribute so as to satisfy simultaneously your obligations under this License and any other pertinent obligations, then as a consequence you may not distribute the Library at all. For example, if a patent license would not permit royalty-free redistribution of the Library by all those who receive copies directly or indirectly through you, then the only way you could satisfy both it and this License would be to refrain entirely from distribution of the Library. 

	If any portion of this section is held invalid or unenforceable under any particular circumstance, the balance of the section is intended to apply, and the section as a whole is intended to apply in other circumstances. 

	It is not the purpose of this section to induce you to infringe any patents or other property right claims or to contest validity of any such claims; this section has the sole purpose of protecting the integrity of the free software distribution system which is implemented by public license practices. Many people have made generous contributions to the wide range of software distributed through that system in reliance on consistent application of that system; it is up to the author/donor to decide if he or she is willing to distribute software through any other system and a licensee cannot impose that choice. 

	This section is intended to make thoroughly clear what is believed to be a consequence of the rest of this License. 

	12. If the distribution and/or use of the Library is restricted in certain countries either by patents or by copyrighted interfaces, the original copyright holder who places the Library under this License may add an explicit geographical distribution limitation excluding those countries, so that distribution is permitted only in or among countries not thus excluded. In such case, this License incorporates the limitation as if written in the body of this License. 

	13. The Free Software Foundation may publish revised and/or new versions of the Lesser General Public License from time to time. Such new versions will be similar in spirit to the present version, but may differ in detail to address new problems or concerns. 

	Each version is given a distinguishing version number. If the Library specifies a version number of this License which applies to it and "any later version", you have the option of following the terms and conditions either of that version or of any later version published by the Free Software Foundation. If the Library does not specify a license version number, you may choose any version ever published by the Free Software Foundation. 

	14. If you wish to incorporate parts of the Library into other free programs whose distribution conditions are incompatible with these, write to the author to ask for permission. For software which is copyrighted by the Free Software Foundation, write to the Free Software Foundation; we sometimes make exceptions for this. Our decision will be guided by the two goals of preserving the free status of all derivatives of our free software and of promoting the sharing and reuse of software generally. 

	NO WARRANTY 

	15. BECAUSE THE LIBRARY IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE LIBRARY, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE LIBRARY "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE LIBRARY IS WITH YOU. SHOULD THE LIBRARY PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 

	16. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE LIBRARY AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE LIBRARY (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF THE LIBRARY TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

	END OF TERMS AND CONDITIONS
	How to Apply These Terms to Your New Libraries

	If you develop a new library, and you want it to be of the greatest possible use to the public, we recommend making it free software that everyone can redistribute and change. You can do so by permitting redistribution under these terms (or, alternatively, under the terms of the ordinary General Public License). 

	To apply these terms, attach the following notices to the library. It is safest to attach them to the start of each source file to most effectively convey the exclusion of warranty; and each file should have at least the "copyright" line and a pointer to where the full notice is found. 


	one line to give the library's name and an idea of what it does.
	Copyright (C) year  name of author

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Also add information on how to contact you by electronic and paper mail. 

	You should also get your employer (if you work as a programmer) or your school, if any, to sign a "copyright disclaimer" for the library, if necessary. Here is a sample; alter the names: 


	Yoyodyne, Inc., hereby disclaims all copyright interest in
	the library `Frob' (a library for tweaking knobs) written
	by James Random Hacker.

	signature of Ty Coon, 1 April 1990
	Ty Coon, President of Vice

	That's all there is to it!

=cut

__DATA__
ISO8859-15
.aa4 
.aasta5
.ahe4li
.al4a
.al4gas
.antiik5
.ap3l
.ap3r
.art5r
.au3a
.eba3
.ee4	
.eela4
.ek3l
.ek5r
.gu4a
.hie5
.idi4
.inim5a
.ise5e
.is4o
.ja4e
.ja4t
.ka4e
.ka2o
.ke5hi
.kip5r
.ku4pl
.ku5sa
.kusee4
.la4pl
.le4e
.le5hi
.lemmik5
.le5se
.lõpp3
.ma4a
.maa5a
.ma5j
.mi5sa
.mo4e
.nek3
.ni4p
.nisu5
.noa3
.oa3
.oo4 
.pap4p
.pea3a
.raadio5
.re4a
.re2o
.rep3r
.re5so
.rü5hi
.sak5r
.sap3r
.se4a
.sk4
.skaa5
.so5li
.sp4
.st4
.teoo4
.tet3r
.tina5
.toa3
.ts4
.tsi4s
.turba5
.tus2
.tu3sa
.ul4ga
.ulu4k
.um2b
.uu4 
.vaa3l
.vask3
.vere3
.õppe5
.ää4 
.õõ4 
.öö4 
.ühi4s
.üle3e
.ür2
.üü4 
aaa5l
a1aas
4aab
aa4bi.
5aadel.
aadio5a
a1ae
a4aer
aa4fe
aa4gan
aa2h
aa4has
aa1i
aai4g
aa4is
a5ait
aa2j
aa2la
aa4lae
aala4r
aa4las
aa4leh
aa4lek
aa4lel
aalg4
aali4ke
aal3k
a5allik
aal3t4
aa2l3õ
aa4lü
aa4mad
aa4man
aa4mee
a5ameer
aa4mö
4aan
aa4nam
aa4nat
a5andm
aan4duu
aa5ni
aant4
aa4pek
aa4pen
aa4ra4b
aa4raf
aa4raj
aara4l
a5arter
aa2r3õ
aa4rö
aa4rü
aa4sab
aa4sai
aa4sar
aa2se4
aa4so
3aas5ta
a5a4sul
aa4sut
aa4sü
4aat
aa4taa
aa4tas
aa4teh
5aatom
aa4tõ
aa4tüh
a1au
aaži5
a1b
4a3ba
a5be
3abie
a4bij
5abs
a1d
a4dad
a4deo
a2der
a3di
adu4r
adu3se
a4dö
a5eali
ae2d
3aed.
2aee
a3ees
ae4f
1aeg.
ae4ga4j
ae4gi
3aegn
2a1e2h
4aei
4aek
a3eks
2ael
a5elani
ae2le
ae4lo
ae4lu.
4ae2m
4aen
ae4pi
ae2s
a3esi
4aett
a1f
a4fek
a1g
3a4gent
agia4
a3go
5agreg
agud4
1a2hi.
ah4kar
5ahnu
4ai.
ai2a
5aian
ai4hu
ai4ke
ai4kl
a3ilm
ai4lu
ai4me.
aimp4
4ain.
a5inf
a5inime
4ains
a3inse
ai4pr
ai2sa
5aistin
aist4r
ai4va
a1j
a3ja.
a4jale
5ajalo
a4jalu
1a2jam
4ajo
ajut4
a1k
akaa4s
a4kaat
ak4as
3aken.
a3ki
ak4kis
ak4kr
a3klas
ak4lau
a5klii
a3krii
ak3ro
4aks
ak4te4l
a2ku.
aku4map
a5kvali
3alald
ala4mas
a4laüh
ale4le
al4et
alet4t
5algat
al4ged
a3li
ali4san
a4liste
5allee.
al4le4h
al4luj
al2lü
a4lob
als4
4alt
4alu.
a4lud
1alun
alü4h
a4lüt
a1m
4am.
a5ma.
a4maad
3ametn
amit4
am4o
am4pal
5amper.
4amü
2an.
3analü
5anatoom
an4das
an4deo
an4dog
2ane
a4neh
a3ni
a4niso
4anj
an4kr
3anku
an4nah
4ano
anos4
3ansam
4anst
3anten
5antilo
ao4d
ao4he
a3oht
ao4j
ao2le
ao2lu
ao2m
a3oma
ao4nu
aoo4p
ao2pe
a5opera
ao2r
a5oras
a1osa
ao4su
a1ots
a1p
a2par
5aparaa
a5part
a3parv
a3pi
a3pla
a3po
ap4pal
ap4pin
ap4pis
ap3ri
ap3ron
a4pru
a3pä
4ara
arak4k
a4rase
5areng
3aretu
3arhit
2ari
ari4al
ari4ap
4ark
ar4kel
5armast
5armee.
a4ro4l
1arst
5artikk
3arua
3arvam
5arvestus
1arvu
ar4vää
asa4las
a4same
a4sau
ase4ma
as5ema.
1a2sen
a4seos
a4sese
a4sett
3a4setu
as4fä
1a2si.
asi4ala
asi3an
a4sind
asip4
5asjan
askõ4
as4kõl
a5slaav
a4sok
as3ole
aso4p
as4pet
as3pl
as2po
a3spor
as4san
ass5t
4asti
5astme
ast4rak
a4su4b
a4sud
asui4
a4suss
a5suu
a1t
a3ta
a4taš
5ateljee
atii4v
atmi4k
5atroo
at4ros
at4rus
at4soo
ats4p
at4sü
att4s
4atu
au2a
aua3l
au4ba.
4aud
au4de.
a3ui
4au2j
au4ke
aulu3
aulus4
au4pü4
a5urg
aus4o
au2su
a3usul
1auto
autoo4
auto5s
aut4r
a1v
av4a
a4vans
a3var
a4veh
a1õ2
a1ö2
a1ä2
a1ü2
aš4ni
4a1ž
5baa
baa4g
baa4k
baa4s
bab4
bae4
bag4
ba4he
ba4ju.
ba3k4r
bak4s
bak4v
bap4l
bap4r
ba4rõ
basa4s
bas4ko
bas4pe
bat4r
4bb
2bd
be3a4
beb2
bef4
beg4
be4lü4
be2ra2
berk4
bero4
be4rõ4
be4si
be4st
bes4tis
bet4r
4bf
4bh
bha4
bi4ala
bia4v
2bi1e
bi4en
4binõ
bi4pla
bis4a
bi4si
bis4k
2b1j
2b1k
2b1l
bl4e
blet4
b2lon
2bm
2bn
4bort
2bp
2b1r
3brig
bros4
2bs
b3so
2bt4
4buks
bu4lõ
3bum
buse5
bu4si4
bus4kr
2b3v
1da
daa2
da5ab
daala4
da4do
dae4
daf4
d5ain
da4leh
da4lum
da4lus
5dam
4dann
da4num
dao4
darat4
4darb
dar4de
4da4re
4daru
2darv
d3arv.
4dasen
da4sum
2d5b2
2dd
1de
dea2
2deaa
de5av
ded4
2dee.
dee4le
4dehe
dek3l
dek4s
5del.
de4lau
4de4lek
4deluv
de4pr
dep5ressi
dere4
de4rel
de4rep
5dero
deru4
2df
2d5g
2d1h
1di
dia4v
did4
dig4
dii4g
diina4
dii4sa
dii4su
4dilm
4dini
di2os
di4plo
dis4ai
di4sar
di4sas
dis4pr
dit4r
2d1j
2d3k4
dkop4
2d1l
dle4v
dlust4
2d1m
dmee4
dmi4k
2d1n
1do
do4h
doi4r
2dos
d3osa
5dosk
2d3p4
2d1r4
5draama.
drao4
3dreen
d4rel
d2ren
3drena
2d1s4
dsar4
2d3t2
1du
du4b
due4
2d5uks
d4u2s
du4s1a
du4see
dusk4
2d1v
2dõ
dõ4l
4dä
2dül
dü4li
4dü4r
5düü
4dš
2d2ž
3džem
eaa2
ea3aj
e1aas
ea2b
e3abi
e1ae
ea2hi
e1ai
ea2j
eak4s
eak4v
ea2la
e3ala.
e1a4lu
ea2me
e5amet
e5ann
ea4nu
eao4
ea2pa
e1ar
ea4re
ea2s
e4ass
e5aste
e5asut
e3au
ea2v
e3ava.
e1b
e1d
ed4a
e3eali
e3ees
ee4fe
eei4
eek4r
ee2la
3eelar
e5elekt
eel5uu
ee4nai
ee4nal
ee4nam
ee4no
eent4
ee4pai
e5e4pit
5eepos
ee4ral
eer5ap
ee4ros
ee4rot
ee4sin
e5esine
ee4s5ist
5eeskir
ee4sü
ee4tõm
ee4tä
e1f
e1g
egaa4
egas4t
e4goi
4eha
e2he.
e2hi
e3hin
5ehist
1e4hit
5ehiti
eh4ta4
4ehä
ei4dul
ei4e
eie5ri
ei2ga
e3iga.
ei4ha
ei4he
e3ilm
ei2lu
ei4mem
5eine.
ei4roo
e5i4sa.
ei4sist
ei4tau
ei4tõ
ei4va.
e3j
e3ka
e4kahi
e3ke
ek4kap
ek2l
ek4lo
e3k4o
ek3re
e3krii
4eks.
5eksam.
3eksem
eksi3k
3ekska
eksp3r
5ekstr
ek4tül
e3kü
elaa4v
e4lagr
e2lam
3elamu
el4an
5elanik
eleis4
e4leks
5elektro
3eleme
5elevaato
e3li
e4lid
elii4t
el4kus
e4l4ob
elo4p
els4t
elt2r
el4tü
e2lu
1elu.
e5lub
elu5i4
1e4lun
e3lus.
e4luss
el5uss.
el4üh
e1m
5emand.
e5mat
emne3
emos4
emp4r
5emuls
endus3
5enelas
e5nem
3energ
e4nese
e4nesl
enk5l
enk4r
en4sal
en4tos
en4tü
eo5a
eo4ja
e3o4le
eo2lu
eo2ma
eoo4p
eo5pl
e3osa.
e3osak
e5osali
e5osav
eos4f
e3ots.
e1p
e3pl
e4pli
ep4lu
e1r
e3raa
5erakon
5erald
e4rao
erei2
erek4
5ergut
erih4
eri4uu
er4nau
e4ro4r
erp4
er2pr
ers4k
er4taa
er4tak
er4tes
e4rud
es1an
1e2se.
e5sek
e5sen
e5sil
eska4j
eska4s
eske4
es5kel
esk3l
esk3r
es2k5ö
es4laa
es3ole
es4or
es2po
e3spor
es4sist
4est
es4tü
e3su
esup4
e1t
e3t4a
e2ten
5etendus.
etii4s
et2ra
et4sin
et4soo
et4sü
et4taj
1ette
et4tru
et4tä
et4tü
4etu
e4tõ4d
e4tüm
eu4de
e3u2j
e3u2l
e5u2n
eu4p
eu4s
e5usk
e3uu
e1v
e3v4a
e1õ2
e3ö4
e1ä2
e1ü4
e1ž
5faa
faa4n
4fa4d
2ff
1fi
fii4t
4fj
4fk
2f1l
f2lo
5floora
2f1n
1fo
folk5
fo4ro
2f1r
f2re
3frees
2fs
2f1t
ftat4
3fu
3gaa
gaa4r
4gaast
4gab
4gaed
gag4
2gah
ga2hi
gai4g
ga5is
ga3k4
5gam
ga3o
ga3p
4gart
4garv
g4as
4ga4suk
5gata
gat4r
gau4
ga4va.
ga4van
2g3b
2gd4
gea4
ge4du.
gek4
ge5kl
4gekse
ge4lah
gela4s
ge4leh
ge3lu
ge4lä
ge4nan
geok4
ge4or
4geos
4gerg
ge4rus
4gf
4gg
2g1h
gi2aj
gii4s
gi3k
4ginf
4gint
gio4r
gi3pl
gi4san
gi4sil
gi4sö
git4r
gi4vaj
2g1j
2g1k
2g1l
g4lüt
2g1m
2g1n
gne4ta
gne4te4
4goh
go4le
go4ma
go4po
2g1p4
2g1r
g2ran
5granaa
3g2rav
g2ru
3grup
4g1s4
2g1t2
g3tr
3gu
gub4
gue4
gu5i
gu4nel
gu3o
gup4
gu4sen
gu4sä
guu4j
2g1v
2g3õ4
4gä
gü4l
3ha
haa4ri
haa4s
hal4lai
5har
hasa4
hat4r
1he
hee4m
hee4s
hei4s
hek4v
2hel.
hels4
het4r
4h1h
hhe4l
1hi
hia2
hii4s
5hil
5him
hio2
hi4san
hi4sar
hise4l
hi4st4
hi4sü
5hits
h1j
hjaa4
4hk
h4kal
h4kas
h4kis
hk3l
h4ko4
hk3r
hks4
hkt4
h4kusk
h4ku4su
h4kõ
h4kä
h1l
hle4n
4h1m
h4mo4
h4mü
h1n
hnika5
1ho
hom4o
4hp4
hrs4
4ht
h2ta
hta2j
h5tak
hta4l
ht5ar
hta4su
h4teg
hte4n
hte4r
h4tid
h4to
h4tr
ht5s4
h4tö
h4tä
1hu
hu3a
hue4
hui4d
huk4l
hup4
hu3sa
2h1v
hvad4
hvast4
hve4l
h4vini
h4vo
hvu4s
1hõ
3hö
1hä
3hü
4ia
iaa2
iaa4l
ia5alane
i3aast
i5a4bi
ia4bo
i1ae
ia2g
ia2h
i3aine
i1a2j
ia4kr
i3akt
i1a2la
i5alb
i3alli
i1a2lu
ia2me
i5amet.
ia2na
i5andj
i5andm
ia4ne
i5anne
ia2p4
i3apar
ia5pr
ia2re
i3arm
ia4ru
i1arv
ia2s
ias4ke
i5aste.
i3asu
ia4tel
iat4r
i1au
iau4l
i5a4vaj
i5avald
i1b
i4bad
i4bau
i1d
5ideaa
idii4
idlu4
ie2
i3eali
i1eel
iei4
i1eks
i5elani
i1elu
i3eos
ie4ri
iers4
i3esi
ie5so
i5ess
ie4st
i3eten
ietu4s
i1f
i1g
i4ga4g
i5gar
5igatsu
i4gav
ig4ram
ih4le
ih4te
ih4tin
ii4a
ii4deo
ii4du.
iie3
ii4es
ii4gaa
ii4ga4s
ii4ha
iika4
ii4kis
iik4ro
iiks4t
iikt4
ii4lab
ii4lad
ii4lae
ii4last
ii4leh
ii4lel
ii4les
ii2lõ4
ii4lü
ii4mai
iimat4
ii4met
ii4nai
ii4nau
i5inde
i5inf
ii3ni
i5inimen
iinit4
iink4
iino4
ii4nol
ii4nos
ii4nõ
ii4pr
ii4ran
ii4rau
iirs4
ii4rü
ii4san
iise4l
ii4sev
ii4sik.
ii2ta
ii4teh
iito4
ii4tom
ii4tos
iit5re
ii4tõ
ii4tü
ii4ves
ii4vet
ii2vo
i1j
i1k
i4kalu
i4ka4re
i4kark
i4kaut
i4k5elu
ike4si
i3klaa
i3klas
ik4ler
i5klub
ikop4
ikos4
i4kov
i3kre
ik3ro
ik4sar
iks4k
iks4po
ik3t2r
i3ku
iku3a
il4a
ila4s
i4lasi
ilia4
i4lisi
il4kan
il4kõ
ille5s
illo4
5ilme.
il4mot
3ilmut
ilo5g2
ilp3l
il4ti
i5lun
ilu3sa
5ilustu
ilü4h
i1m
i4melu
imi4g
imisu4
i4mo4l
5imper
i1n
ind3al
5indeks
inde4r
ind4re
2ine
inee4s
i4neh
i4neks
ini4kü
i2nim
ini4mas
i4nime
5inimene
5iniml
i4nini
inna5a
inni4si
3insen
1insp
1inst
3inven
io4de
io4h
i3oht
i5ohv
io4j
i5oks.
io2le
i3olek
io2lu
i5oluk
io4lü
io2ma
i5oman
ioo4da
ioo4ne
iooni3
io2p
i3oper
i5ork
i1osa
ios4f
ios4p
ios4t
iost4r
io4su
i3ots.
i3otsi
io4tü
i1p
i3pla
ip4lu
ip4ro
ip4sas
ipse4
ip4sep
ip4sus
i4ra4b
i4rase
ir4dis
ir4nõ
i2rui
iruu4
isaa4v
isa4ja
i4sana
isa4re
i4sarh
i4selo
i3sem
iset4s
isi4g
i2so
3isola
i5soli
is5oma
iso4r
i3sot
i3s4pek
is3pl
i3s4por
is3sp
5istand
i5s4tiil
5istme
ist4ru
ist4se
i5stsee
5istutu
i3su
i4sõm
i2sü4l
isü4r
2it
itaa2
itee4l
it4rak
it4ras
it2ru4
its3k
it4so
itte1
itt4s
iu4b
iu2da
iu4gi
iu2j
i3uju
iu4la
iu4mar
iu4me4
iu2mo
iu4ni
iu4pu
iu5sa
i5uss.
iu2su
iuti4
i3uu
i1v
i4vad
i4vakt
i4va4lus
i4vant
i4vau
i4veh
ive4l
iviil5
i4vü
i1õ2
i1ä4
i1ü2
i1š
j4a
3jaa
ja1aj
jaa4l
jaa4r
jaa4s
jab4
jad4
ja5el
jae4r
jag4
ja3i2
ja5kra
5jama
5jame
jao4h
ja3p4
jas4ke
jas4tii
jat4r
jat4su
jau4b
jau4l
je3lu
3jo
joo4k
jue4
5juma
ju4sei
juse4l
5jõ
5jä
1ka
kaa4da
kaa3de
ka5aj
ka4al
kaa4ra
kaa4sis
kaa4ta
4kader
4kaed
4kaeg
kae3lu
kag4
kahe5i
4kaia
2kain
ka5ist
kaitse5
ka4jav
ka4ju.
k5a4lus
ka4pl
ka2pr
4karm
4kaset
k5asj
kat4r
2k3b
2kd4
1k2e
ke4el
kee3lu
2kehi
4keks
ke4laj
ke4lak
ke4lok
4kemb
2ken.
5kene
keo2
kes2k
kesk3a4
ket5ra
ket4te4
2kf4
4kg
2k1h4
1ki
kie4
kik4r
4kinf
kio4
ki4pr
kis4a
ki4san
ki4sik
4kiste
kit4r
kiu4d
kiu3su
2k1j
4k1k
k3kra
kks4
kku4ro
2k1l4
k2la
k3la.
3klaas
k3lai
3k4lamb
k3lan
3klapp
5klassi
k3lat
5klaver
kle4a
k4lee
k2lei
3kleit
k3lem
k4lib
5klibu
klig4
k2lii
3kliim
5kliiste
k3lik
k3lin
k4link
k2lo
k3loom
3klots
k2lub
k3lus.
klu4sa
klu4sõ
k4lut
2k1m
2k1n
knaa4
k4nip
1ko
2koks
k4ol
ko4len
koo4sa
4ko4rie
4korpi
k5osa.
ko4va
2k3p4
2k2r
k4raan
5kraana
3kraav
3krab
3k4rae
k3rai
3kramp
4kran
k3rau
5kredii
3k4reem
4kreg
5k4res
k5ret
4krip
5kristal
k4roh
3krohv
k4rook
k3rut
3kruu
3kruvi
4k3rü
4k1s
k5sae
k4sai
ksek4
ksi2k
ksika4
ksit4
ksk4l
ks5kõ
ksp5lo
ks2pr
kst3r
ks4tü
2kt
kt2ra
1ku
kui4s
4kujuj
4kujum
kuk3la
4kuks
kul2d
2kulp
kumi4su4
kummi5
3kus
ku4siv
kut4r
kuu4ni
kuuse5
4kuš
2k1v
k4van
3kvart
5kviitu
1kõ
kõ4de.
2kõi
k5õis
4kõp
1kö
4köd
1kä
käi5s
2käk
4käm
1kü
2kühe
4küle
4küll.
2kš4
4kž
1la
5laag
la4aj
laa2r
laar5a
laa4sa
2laav
5laava
4ladj
5ladu
lae4r
3laev
4lahv
lai5ek5
lai4ga
la4jap
la4jav
la3k4r
lak4v
la4la.
4lald
la4les
4lals
la4lus
3lama
3lamp
4lams
la4nes
2lani
lap4l
4l1arv
4larü
la4sas
4lasb
la4sei
la4sem
4lasen
l2asi
4la4sut
3lau
5laud
lau4n
lau5su
4lavh
2l1b
l4bau
lb4lo
4l1d
l4dala
l5dist
l4don
l4dü
1le
le1a2
3lee
leek5l
lee4le
leep5r
le3hi
4lehit
5leht
3lej
4lekk
5leks.
4lektr
lektri5
4lele
le4lek
5lema.
le4mor
lenaa4
leo2
le3oh
le5olu
le4pl
le2s
4lese.
le3sõ
3let
4lette
4l1f
lfoo4
lf4t
l1g
l4gae
l4gai
l4gall
l4gann
l4gase
lgas4k
l4ge4le
l4gi4d
l2go
l4gu4j
2l1h
1li
li4ala
li5am
lia4v
3lid
li4dan
li4ga.
4liia
liie4
5liig
lii4na
5lik.
likai4
li3kla
lik4ro
4lilm
4li4lus
limi4s
4linf
4linim
4lins
lin4te
4linv
lio4k
li3p4l
li4sah
li4sik
4lisol
li4suj
li4sõl
li4sö
lit4r
li5tu
2liše
2l1j
lja1a
lja5os
2l1k
lkk4
l4kli
lk4lu
l3kr
2l1l
l5ler
lli3tr
l2lor
l4lots
llp4
lls4
llt4
l3lu
l4lää
2l1m
lmaa4v
lmat4
l4mau
l4meks
lmp4
2l1n
1lo
lod4r
lof4
lo4gal
4loha
4lohv
5loi
lok4r
2lo2l
l1ole
l3olij
3lolo
lo4man
5loog
loo4ram
4lord
4lorn
2losa
l3osa.
2l1p
l3plaa
lp4le
l4puk
2l1r
lrih4
2l1s
ls4ka
lske4
ls4o
lste4
2lt
l4tau
lti4l
l4tok
lt4sel
lt4sis
l4tuk
l4tõm
l4tää
l4tüt
1lu
3lua
lu3al
lud4
lue4
3lug4
4luhk
4luim
lu4juk
4luk.
3lukk
2lun
lu4nin
lu4nio
luo3r
lu4rau
lu4see
lus4tii
lu4sum
lu4sö
3luta
lut4r
3luu
2l1v
lvel4
1lõ
4lõd
4lõie
5lõik
4lõis
4lõit
lõ4l
lõ3pe
lõp2p
1lö
4löe
1lä
4län
län4gi
lääne5
1lü
lü3h
lü4ma
1ma
3maa
maa2b4
ma3abi
maa3la
maa3p
ma4bi
ma1e2
mag4l
5mahl
4mahv
4majam
4ma4ju.
ma3kl
mak4v
3mal
ma4la.
mal4ma
ma4om
ma3pl
4mart
4marv
ma5se
ma5sin
ma4st
4ma4sul
ma4sä
4maut
2m1b
mbat4
mbe2r3
mblu4
mbo4j
mb5usa
2md4
1me
me1a4
me4an
3mee
mee5la
mee4s
me3hi
4mekv
mers4
mert4
me5s4o
m4et
4met.
4metl
2metn
met4se
4mett
me5u4
2m1f
4mg4
2m1h
1mi
mia4m
mia4r
4mide
mi4kaj
mi4nah
4minf
mi3ni
mip4
mi2s
mis1a2
mi3si
mi4sig
mi4sih
4mi4sik
mi4sil
mis3k4
mis4tii
mist4r
mis3ts
mitte3
2m1j
2m3k4
2m1l
2m1m
m4maat
mma4s
mm4e
mme4r
mmika4
mmi4kal
m4mor
2m1n4
1mo
4moh
mo4ha
m3oks
4morg
4morn
mo3sa
2mp
mpa4l
m4pap
mp3l
mp3r
2m1r
mruu4
2m1s
ms4o
ms4p
2m1t2
m5ts
1mu
mua4
mu5ah
mud4
mue4
mui4m
4muls
mup4
5mus
mut4ra
2m1v
mõ4d
4mõig
4mõp
3mö
4mök
3mä
4mäk
mär4gel
3mü
4müh
4mš
1na
n4aa
na5ah
naa4lu
naa4r5a
nad4
na5ei
nag4l
nah4ke
nai4d
nai4si
na4kru
2nal4ü
4na4mer
na4mii
n5amiid
nants5a
na3o4
nap4l
na4ret
4narv
n4as
4nasb
nass4
nat4ra
nau4b
4nb4
4n1d
n4daas
n4dab
n4dae
nda4ko
nda4l
n4dau
ndif4
ndip4
n4do4r
n4duj
ndu4sõ
n4dü
1ne
5ne.
nea2
nee3la
nee4le
nee3lu
nei4v
ne4lah
4nelas
ne4lek
neo4d
ne4pl
2nerg
n4es
ne4tan
ne4tõm
2n1f
2n1g
n4gai
n4gall
n4gase
n4gau
ng4lü
n4go4r
ng3r
ngud4
ngus4t
n2gü
2n1h
1ni
ni3ap
nia4v
nig4
nii4g
nii4tu
nikkel5
4nilm
5nima
nima4s
5nimet
3nimi
ni4mig
4niml
4nint
ni4sid
nis4ke
4nisl
2n1j
2nk
n4ka4n
nk3r
nk4se
nkst4
2n1l4
2n1m
2n1n
nna3e
nna5i
nnak4r
n4ne4f
nnio4
nnk4
1no
4nob
nod4
4noks
noo4na
n4or
2n3p4
2n1r
2ns
n4salp
ns4e
nsk5r
n3so
nso4r
nste4
ns4tee
ns4tem
nstis4
nst3r
ns4tu
nsu4s
2nt
ntaa4r
n4teh
nte4l
ntig4
n4tiso
n4tots
n4tr
nt3ra
nt3re
nt4sab
nt4sal
nt4san
nt4sar
nt5sü
ntt4
n4tüh
n4tük
1nu
nu4da
nui4g
nur2k
nus4p
2n1v
1nõ
nõ4l
4nõli
1nö
1nä
1nü
4nül
4nš
4nž
oa2
oa4a
o1ae
o5aku
o3anal
o5apa
oau4b
o1b
oba4s
1obj
4o1d
odaa4
odaal3
o4deh
odu4sõ
od4ž
oe5a4
oe4fe
oe2l
o3ele
oe4mi
oe4mu
o4eo
oe4rah
oe4rõ
oe4si
oet4r
o1f
of5r
o1g
og4la
og4li
3ohaka
oh5to
5ohvits
oi2ta
oiu5a
o1j
oju2s
okast4
okku5
ok3la
ok5liin
okoos4
ok3r
ok4re
ok4ri
o5kris
ok4ru
o3la
o4lae
olag4
ola4las
ola4su
ol4do
ole4an
3olek.
o4lend
olig4
o3lii
olii4g
o4li4lu
o3lis
4olj
ol4lae
ollis4
ol4lü
ol4mai
4o3lo
ol4tam
ol4tar
1olu.
5olukor
o4luks
olõ4
o4lä
3omadu
om4baj
om4ban
o4mok
ona4a
o4naj
ona4ko
o4neh
o4nele
on4gos
onit4r
oniu4
onsoo4
ont4re
o4nuu
2o2o
oo1a
oo4kal
ook4r
oo4kää
oo4lau
oo4lee
oo4lig
oo4list
oo4log
oo4lõ
oo4lü
oo4nah
oo4nar
oo4nau
oon4dee
oonk4
oono4
oo4noh
oons4
oon5t4
o5opti
oo4rat
oo4ree
oo3sa
oo4sel
oo4tõ
o3pa
op5last.
op4lu
op3ra
op3ri
o2r3ai
o4ralg
ora4mii
o4rana
5orav
3order
1org
org4r
oria4
3orju
5orkeste
3orna
or4nel
or4tal
ort3r
oru4s
or4võ
o2sa
o4sake
3osako
4o3sau
4ose
o4seks
4osf
o2si.
4osin
3oskus
4osl
4oso
o4sok
os1ol
os4pa
4oss
os4saj
os4sü
os5taas
os4tem
4osto
ost4ru
5osuti
4osõ
oto5a
otok4
ot2ra
o3tran
3otsa
o5tsö
ot4ta
ot4teo
otus4ta
otü4l
ou4b
ou4n
o1v
ovaa4l
ovio4
ovol4
o4vu4n
o3õ4
oü2
1pa
paa4ka
pa3a2m
paa4tel
pa4e
pa4lus
pans4
pa4pr
5paras
3park
4parta
pa4sp
4pb
4pd
1pe
pe2a
pea5j
peas4
pe4au
pea3v
pe4f
4pektr
pela4
4pe4lev
pel4t
pe4lü4
p4em
pe4ol
5perd
pe4tap
peti4k
2pf4
pg4
2ph
1pi
pii4v
pik5r
pin2d
pin4gis
pip3r
pis5ta
piu4g
2p1j
2p1k
2p2l4
4pla.
p4laa
p5laasi
3plaat
p4lak
p3lam
p5lane.
3plasm
5plastik
plek2
3plekk
4p3lem
p3li
5pliia
pliig4
3plok
p3lom
p3lu
3pluus
4plõ
2p1m
2p1n
p4neu
1p4o
5po4e
3pon
3poo
poo4la
poola4v
pordi5
4p1p
ppa4k
p4pas
ppe3a
ppee4
pp3l
p2p3r
pps4
p4pud
p4põ
p4pü
p2r4
2pra
3praa
3prag
3prakt
p5rau
p4rep
p4resi
4prib
2prii
p5riit
p4rog
p4roo
4p4ros
3p4rot
4prum
5pruu
2p1s
ps4a
p4sor
3p2sü
2p1t
p4tak
3pu
pua4
pu4da
puha4
pui4t
puk4k
pul4ti
4purt
pus4p
2p1v
3põ
põhi3
p4õi
põi4s
põli4
5pö
1pä
pär4gu
4päs
3pü
pü3he
4pš
4pž
1ra
raal3a
4raale
5raalne
raa4lu
raamatu5
raa4ta4
4raatt
raa4tu
4raav
5raaž
raie3
2rain
r3aine
rai4si
r5a4la.
ral4t
ra4lus
3rame
ran4dem
ra3om
4rapa
ra4pl
4rapt
4rarb
ra4ren
4rars
2rarv
ra4sal
4rasen
ra4sis
rast4r
ra4suk
ra4sul
ra4sut
5ratas
ratiiv5a
rat4sen
raua3
rau2d
raud5o
2rauk
4raum
4raur
rau4te
5ravi
2r1b
r4bae
4r1d
r4dae
r2dar
rde3a
rd4re
r4duj
r4dü
1re
5re.
5rea
reb2
ree4le
ree4ma.
ree4man
3reer
3reet
5reg
2rehi
rei4se
rek3l
4reks
re4lai
re4liit
5relv
re4mää
4repp
re2pr
rep3re
re4sin
re3te
ret4k
re4tr
ret5s
2r1f
rf4r
2r1g
r4gae
rg3ah
rga4re
r4geh
rgi4me
r5g2ra
2r1h
1ri
3ria
ri3am
ri5ast
5rid
2rig
ri4ga.
3rige
rig4r
2riib
5riie
4riinu
ri4kis
ri3k4r
4rilm
3rim
ri5oks
rio4r
3rip
rip4li
4rip2p
4ri4sa.
ri4sah
ri4sar
ri4ses
4risol
ri4tol
ri3t2r
5riu
5riv
4riö
2r1j
2r1k
r4kad
rk5ain
rka4se
r4kek
rkt4
2r1l
2r1m
r4mald
r4me4le
r4mig
rmo4ra
rmo4s
rmp4
rms4
2r1n
r4nad
r4neh
rnk4
1ro
roa4
ro3e2
rok4k
rol4la
rol4le
4romb
2romi
ro4nop
roo4ga
4rosa
ros4po
ro5staati
rost4r
4roš
2r1p
rp5ret
2r1r
r3ri
2rs
rsaa4l
rs4l
rs4o
r5s2po
rs4tak
2rt
r4tah
r4tos
rt2r
rt4ra
r4tri
rt5roo
rt4sai
1ru
2rua4
rud4
r4uj
ru3kr
3ruma
4rumb
2rumm
4rump
5rus.
ru4set
ru4sin
ru4sul
rut4r
ruum5a
4ruur
2r1v
rva4la
rva4lu
r4vann
rvas5k
rvis4k
r4voh
r4vok
1rõ
2rõ2l
r5õli
rõn4gu
4rõr
3rö
4rök
röö4pe
rööp5l
1rä
4rä4r
1rü
4rük
4rüm
4rü4r
4rš
4rž
1sa
3s2aa
saa5j
saa4lu
sa4an
4s3aas
3saba
sa4bi.
4sabo
s4ad
5sada
4sade
s5ader
2s1ae
sae4l
5sa5ga
s4age
sa4gu
4sahv
3sai.
4saia
s1ain
s4ajan
sa4ju.
sak4ro
5saks
4saku.
sa4kää
4s3a4la.
4salas
s4alat
5salat.
sa4lev
4salla
4sallu
3salt
sa4lum
5salv
3s4am
4samp
4sank
4s5ann
s4ant
4santi
s4anu
sa4num
sa2pr
sa4ris
s4arv.
sar4va
sase4
3sasti
sas4tii
sa4suk
sa4sum
3sat
4satl
s5avald
2s3b2
2s3d2
1se
3sead
se3ala
s5eali
se5aval
se4du.
4seela
see4le
s5eeln
see4ma
4seepi
3seer
see4si
see4ta4
4se4fe
5seg
sega5a
2seh
3seha
3seho
5sehu
5sehä
3sei
sei4d
sei4si
3seka
se3kl
4s5eksp
se4laj
4selek
5seli
4sellu
3selt
2selu
4sens
se5oh
seo4k
se5om
seo4p
seo4r
3sep
sepat4
4serem
4sese.
se4si.
4se4sin
s5esit
ses4k
3sest
4s5eten
se3t2r
4sette
2s1f2
2s1g2
2s1h
1si
3sia
sia4h
sie4
5sign
sig4ra
s5i4ha.
sii4g
sii4sa
sii4se
4siits
sii4tu
si4ket
siko4d
siks4p
sikt4
sik4vi
4sinim
s5inime
4sins
sio4le
si4pro
4sirr
5siru
4si4sa.
si3se
s5i4sik
sis2p
sisse3
s5istuj
5sisu
2s1j
sja5ar
2s1k
4ska
5skaa5la
ska4no
5skeem.
s4kela
5skelet
s5ken
ski4g
sk2l
s5klas
5skler
skuk4
3skulp
sku4si
2s1l
4s1m
sma4sa
2s1n
sne4p
1so
3sobi
3soe
s1oht
3soi
s5oks.
2so2l
s3olek
s3olij
5solo
so3lut
so2ma
3son
3soo
soo5o
4so4pe
so4pr
5sor.
s3orj
3sort
2s1os
4sotsu
2s1p
s5per
2s1r
2s1s
ssel4l
ss2fä
ssin4
s4sinf
ssk4
ss4ke
ss2p
s5spor
ss2t
s5stat
ss4ti
sst5r
s4suss
2s1t
s2taa
3staad
5staaž
s4tain
4stam
5standard
3start
s4tati
5statis
s4teno
5stepp
stet4
s4toh
s4top
s4tot
5streik
5strek
5struktu
st4so
stt4
stu2s
stu4s5a
3stuud
stä4
s4tär
s4tüh
1su
sua2
su4bar
sud4r
su4du
su5e
su4jul
4suks
s5uks.
5sulg
sul4ga
sun4de4
su4nis
supe4
supe5s
su4pr
4surb
5sus.
sus4aa
su4ses
s5uss.
sus4ti
su4sun
sut4r
sut4ü
4suug
suu4ra
suusa3
2s1v
svus4t
1sõ
5sõda
sõ4de
4s3õh
3sõid
4sõie
2s1õig
2s5õis
3sõit
sõ2l
2s3õli
3sõlm
3sõn
2s1õp
5sõr
sõsa4
2s3õu
1sö
4söd
sö2k
2sön
1sä
4säk
4säm
1sü
4süa
5süd
5süg
2süh
s3ühi
2sük
s3üks
sü4la
sül5di
sü3lem
4sülo
sü4ra
3süs
3süü
4sš
1ta
3ta.
3taat.
2tabi
4t3aed
t3aine
4tais
4ta4ko
t2al
4ta4laj
ta4lev
tal4las
ta3lu
ta4lus
3tam
5tama
4tanda
ta4ot
ta4pla
ta4pr
4ta4ret
4tarm
2tart
ta4se4r
ta4ses
ta4set
ta4sis
ta4sü
2taut
3tav
ta4vaj
2t1b4
2td2
1t2e
te4aa
tea4g
tea4h
te3an
te5as
3tee
tee5lu
te4et
te3hi
tehi4s
te3kl
tek4r
tek4v
tel4ke
te4lok
te3lu.
4tepiv
tep4l
2tepp
3ter
5ter.
te5r4a
terd4
4terg
ters4
tes4a
te4sin
tes4k
2t1f
4t1g4
2t1h
thõl4
3ti
tia2
ti3e
tii2k
tii4ma
tii4sa
tii4ve
tik4o
ti3k4r
tik4vi
4tilm
5tima
4tinf
tin4ga
ti4sai
tisa4v
ti4sik
titee4
2t1j
2t1k2
t3kl
t3kr
2t1l4
tlu4
2t1m
tmika4
tmis3
2t1n
3t2o
4to4da
toen4
tog6
4toks.
toksi5k
to4lek
to4lu.
to4lum
tonis4
to4o
too4no
too4pe
to4rau
tos4p
tost4
2t3p4
2t1r
t4rad
t2raf
3trafo
t4rahh
5trall
t2ran
3trans
t4rate
5traum
t2re
3treen
t4rei
5treim
3trep
t3rig
5triib
5triip
5trikoo.
tri4pl
t4ross
3trumm
5t4rup
3t2ruu
3t2rü
4trüü
2t1s
t3s2a
ts4aa
tsa5is
t4saju
tsa4lan
3tsehh
tse3la
5tsellu
5tsemen
4tsena
5tsensu
tsig4
5tsiitsi
t4sink
5tsiste
ts4laa
t2soo
t4sor
tsp4
t4suss
2t1t
t4tad
ttee2
ttes2
t5tsem
3tu
4tuim
tu4raj
tus1a
tu4s5ee
tu2si
tus3s
4t5uss.
tus3t2
tu5su
tu4sä4
tusü4
4tutop
4tuud
tuule5
2t1v
1tõ
5tõb
2tõi
tõ4l
4tõ4n
4tõp
2t5õun
1tö
4töe
4tök
töö5k
töö3p
1tä
täh4t3a
tä5ke
4täm
1tü
tü5he.
tü3hi
2t1š
t2še
5tšek
3tšem
uaa4
u3aast
ua2b
u5abi
u1ae
ua4he
uai4k
u3ain
ua2ja
u3akt
ua2l
u3all
u3amet
u1an
ua4nu
u5apar
ua2re
ua5ree
u5art
ua2s
u3ast
u1au
uau4d
ua2v
u5avald
u1b
u4dalu
u4deh
udeo4
udo4r
u5eal
u3eel
u3eks
ue2ma
ueo4
ue4r
u1f
u1g
u4gi4d
ug2ra
u5graa
u4gü
uh4tem
uh4ter
uh4tin
uh4tis
uidu5
ui2ga
ui4h
u3iha
u3ilm
5uim.
uina2
uinas5
ui4si
3uisut
uite4h
ui4to
ui4vala
ui4vel
ui4vo
u1j
u5ja
u4juj
u4jum
3ujumi
u1k
ukaa4s
ukii4g
ukki5
ukop4
u3kraa
u5kro
uku4sa
uk4vi
ul4a
ul4deh
uldi4
ul4kr
ul4len
ul4lui
ultra5
u3lu
uluo4
4u1m
umaf4
u4mau
5umbroh
umet4
umf4
umia4
umit4
um5p4r
unaa4
unaal5
un4dak
un4dan
un4das
un4do
u4ni.
u1o2
uo4h
u2or
u3org
u1p
u3pla
up3le
uppe4
up4pis
uraa4l
u4rag
ura4ju
u4rala
u4rap
ur5auk
ura4va
3urb.
urde3
urea4
u4reos
ures4k
u4rett
urgas4
5urge.
u4ri4met
u4rini
uris4k
urka4v
uro4r
u4rulu
u2sa2
u5sa.
usad4
u4sae
u4salu
us5aste
u3sea
useg4
us5elek
u4sett
u3setu
u5sev
us4fä
us5g
u4si4d
usi4g
u4si4h
us5ind
usi4va
us3kr
u2so
us5o2h
us3ole
uso4r
us3p4
u3s4por
usui4
3usuli
u4suss
u2sõ
u2sü
us3üh
u1t
ut4kl
utos2
utot4
ut4ru
ut4so
utt4r
utu4s
utü4h
uu5al
4uud
uu4du.
uu4kak
uuk5ri
uu4mal
uu4mis
uu4pü
uu4ran
uu4ras
uu4rau
uu4rav
uu3sa
uusa3k
uus4ke
u3uss.
uu4sul
4uut
uu4tas
uu4tis
uu4tüh
u5uuri
u1v
u4vau
u1õ2
uä2
u3är
u1ü2
uš4l
vaa4re4
va4as
4vabi
vae4r
vag4
va5he
4vaia
4v3ain
vak4v
va4la.
va4lai
4valdi
val4ga4
va4lü
vana5i
vane2
4vanku
van4ta
van4te
vap4r
v4ar
4varm
var4p
2vart
4varuh
4varve
va4sas
vas4k
vast4r
vat4r
4vatud
vau4d
vav4
4vb
2v1d
3ve
vee3a
vee3k
vee5la
vee3sp
4vehi
vei4sa
ve4ol
veot4
ve4rah
ves4p
2vf
2vg4
2v1h
3vi
via2
vid4
4videa
vip4
vi3pl
vir4k
vi4sak
vis4ko4d
2v1j
2v1k
2v1l
2v1m
2v1n
voo5lu
2v5p
2v1r
2v1s
2v1t2
v3tr
vu4sa
vu4su4
2v1v
3võ
4võig
4võ4li
4võm
võr4k5
3vä
vää4re4
vää4ru
3zo
zook4
zoos4
õ1b
õbe3
õ1d
õea4
õe4lan
õe3lu
õet2
õeu4
õ1g
õh4vu
õi4a
õi4b
õie5k
3õiel
3õigu
õi4ko
õise4
õi4su4
õ1j
õk4kõ
õl2d
õ4lim
õ4lit
õl4mad
3õmbl
õnet4s
õ2p
õ3pa
õpi5e
õp2pa
4õp3r
õranda5
õra4s
õr4da
õr4gaa
õr4gar
õr4go
4õs
õs4a
õ4tü4
õude3
õ1v4
õõ5p
õõre4
õõ4rel
õõ4ta
öa2
ö1b
ö1d
5ö2dee
ödi4k
3öeld
öep4
öet4r
ö1g4
ö1h
öi4a
öi4g
öi4s
ö1j
ö1k
ö2kon
3ökono
ök4v
ö1l
öli2s
ölis5a
ö1m
öo2
ö2p3au
öp4lu
ö4raa
ö4rau
ör4da
ör4dell
ör4e
ö4ri4l
ö4ro4
ö4rä
ö4rül
ös4tii
ö4to4
ö4tü4
ö1v
ö3õ
öö3a
öö3e4
öö5i
3öölan
öö3o
ööt4r
öü4
äa4
ä1b
äbus5
äbut4
ä1d
äe3a4
äe1o
ä1g
äga4ri
ähe5a
äidi4s
äike3
äi4lo
äi4lu
äi2s
äisa4
äi4sõ
äi4tar
ä3j
ä2ke
3äke.
ä5ker
ä4kõ
äli2s
äl4ko
5ämbl
ä4nah
än4deo
änet4
än4to4
äok4
ä4ra5a
ära3o4
ä4rar
äre4lis
äret4
ärge4l
ärii4
äri4kl
äri4sel
ä4riste
är4kar
ä4ro
5ärrit
är4ta
är2va
ä4rõ
äs4ko
äs4nai
äs4p
äs4san
äs4so
ät4ri
äu4d
ä1v
ävee4
ää4kin
ääo4
ää4rase
5ääris.
üaa4
ü1b
üdame5
ü1g
ü2h
ühe5i4
1ühen
3ühik.
ü3hit
ü1j
ükan4
ük4kas
ük3l
ül2d
üld5a2
ü2le
3ülek
ü5lel
üle4mas
1üles
ülesä4
ül4gav
ül4gee
ü4lih
ülii4
3üliko
ü4liõ
ül5kl
ül5la
ül4mei
ülo4r
ülp4
ült4
üma4rak
üma4ru
ümi4ko
ü5ne
üni4s
üot4
üp3l
üp5p4
üp3r
üpsu4
ürd4
ürik4
üs4o
üs4pr
üs4tal
üs4tas
üta4r
ütee4l
5ütlev
ü4t3r
üt4ru
ü1v
ü4ü
üü2l3a2
üü4le
üü4lo
üü4pe
1ša
4šb
1še
5šee
5šer
4šf
1ši
4šj
4šk
4šl
4šm
4šn
3šo
4šp
4št
5šö
5šü
2šš
3ža
4žak
4žau
1že
3ž4i
žis4k
4žk
5žo
4žt
3žu4

