use Config;
use ExtUtils::MakeMaker;

$inc    = "";
# The existence of the ./pTk/Makefile.PL file causes MakeMaker
# to automatically include Makefile code for the targets
#	config, all, clean, realclean and sdbm/Makefile
# which perform the corresponding action in the subdirectory.

unless (defined $dirTk) {
  if (-r "../Tk/tkGlue.h") {$dirTk = "../Tk";}
  elsif (-r "Tk/tkGlue.h") {$dirTk = "Tk" }
  elsif (-r "../../tkGlue.h") {$dirTk = "../.." }
  elsif (-r "../../Tk/tkGlue.h") {$dirTk = "../../Tk" }
  # Try harder
  elsif (@list = <../../Tk-*> and -d $list[-1]) {$dirTk = $list[-1] }
  elsif (@list = <../Tk-*> and -d $list[-1]) {$dirTk = $list[-1] }
  die "Please define \$dirTk in Makefile.PL, cannot find it automatically.\n"
    unless defined $dirTk;
}

print "Tk found in $dirTk.\n";

eval 'use lib $dirTk';
#print "@INC\n";
#require "$dirTk/myConfig.out";
require Tk::MMutil;

$inc .= " -I. -I$dirTk/pTk" ; 
#$define .= " -DTK_LIBRARY=\\\"$Config{'privlib'}/Tk\\\"";
$Tk::MMutil::define .= " -DLangIsPerl";

#$tklibdir = "$Config{archlib}/auto/Tk";
#print "OK 1\n" if -d $tklibdir;
#print "OK 2\n" if -r $tklibdir . "/Tk.so";

#WriteMakefile
Tk::MMutil::TkExtMakefile(
    #'LINKTYPE' => 'static',
    'DISTNAME'  => 'eText',
    'NAME'      => 'Tk::eText',
    #'DEFINE'	=> $Tk::MMutil::define,
    'INC'	=> $inc,
    'MYEXTLIB'  => 'libpTkeText$(LIB_EXT)',
    #'SKIP'	=> [qw(distclean perldepend)],
    #'LIBS'      => ["$xlib -lX11 -lpt -lsocket -lnsl -lm"],
#    'LDFROM'    => "\$(OBJECT) $tklibdir/Tk.so",
    'clean' 	=> {'FILES' => 'libpTkeText$(LIB_EXT) *%'}
);


sub try_compile
{
 my $msgs  = `$Config{'cc'} config/Hstrtoul.c 2>&1`;
 my $ok = ($? == 0);
 unlink('a.out') if (-f 'a.out');
 return $ok;
}

sub MY::post_constants {

my $objects = "LIBOBJS =";
#unless (defined($Config{'i_stdlib'}) && &try_compile())
# {
#  $objects .= " strtoul.o" 
# }
my $len     = length($objects);
foreach (<tkT*.c mTk/tkText*.c pperlGlue.c>)
{
 s/\.c/\$(OBJ_EXT)/;
 s:^mTk/::;
 if (($len+length($_)+1) > 72)
  {
   $objects .= "\\\n\t";
   $len = 8;
  }
 $objects .= " $_";
 $len     += 1+length($_);
} 
$objects .= "\n";

return "\n" . $objects;		# . &upgrade_pic();
};

sub MY::install {
'
install :: all
';
}

sub MY::top_targets {
MM->top_targets . '
libpTkeText$(LIB_EXT): $(LIBOBJS)
	$(AR) cr $@ $(LIBOBJS)
	$(RANLIB) $@

$(LIBOBJS): $(HDRS)

config ::

';
}

sub MY::realclean {
	'
realclean :: clean
	rm -f Makefile
';
}

sub MY::postamble {
my $dep = join('',`cat $dirTk/pTk/tkText*.d`);
$dep =~ s:[ \t]\b: $dirTk/pTk/:g ;
$dep =~ s:\Q$dirTk\E/pTk/tkText:tkText:g ;
$dep =~ s:(.)(\s+\\)$:$1 pperl.h $2:gm ;
$dep . "
Makefile : $dirTk/myConfig
";
}


