use SDL;

class Game::QFG::AI {

	has @!msg-list is rw;  ### the message list to be processed
	has @!msg-return-values is rw; ### the message responses of a pass msg

	method BUILD() {

	}

	method pass-message($entity, $msg) {

		return $entity.pass-message($msg);

	}

	method accept-message($return-msg) {

	}

	method field-return-message($return-msg) {

		if ($return-msg == Nil) {
			return;
		}

		push (@!msg-return-values, $return-msg);

		self.accept-message($return-msg);
	}

	method flush-messages-to-all-entities(@entities) {

		for @entities -> $k {
			for @!msg-list -> $msg {
				self.field-return-message(self.pass-message($k, $msg));
			}
		}	

	}

	method flush-first-message-to-entities(@entities) {

		if (@!msg-list.elems == 0) {
			return Nil;
		}

		my $msg = @!msg-list[0];

		for @entities -> $k {
			self.field-return-message(self.pass-message($k, $msg));
		}	

	}

	method flush-message-to-entities($msg, @entities) {


		for @entities -> $k {
			self.field-return-message(self.pass-message($k, $msg));
		}
	}



}
