class Agent is Actor
{	
	has $.status;
	
	method BUILD($stat) {
		$status = $stat;
	}

	method ask(%args) {
		return "You can ask me the following :\n
			agent, args={\"agent\", Agent instance\n"};
			
	}

	### agent dispatched, return his choose actor function
	method dispatch_agent($agent) {
		return \$agent.choose;
	} 

	### Look if an agent is dispatched
	method agent(%args) {
		%args{"agent"}.dispatch_agent(self);
	}

	method choose($msg, %optargs = undef) {
		given $msg {
		when "ask" { self.ask(%optargs); }
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
