/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.BiFunction;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;
import org.openqa.selenium.remote.SessionId;

class SessionIdCoercer
extends TypeCoercer<SessionId> {
    SessionIdCoercer() {
    }

    @Override
    public boolean test(Class<?> aClass) {
        return SessionId.class.isAssignableFrom(aClass);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, SessionId> apply(Type type) {
        return (jsonInput, setting) -> {
            switch (jsonInput.peek()) {
                case NAME: {
                    return new SessionId(jsonInput.nextName());
                }
                case STRING: {
                    return new SessionId(jsonInput.nextString());
                }
                case START_MAP: {
                    Map map = (Map)jsonInput.read(Json.MAP_TYPE);
                    if (!map.containsKey("value")) break;
                    return new SessionId(String.valueOf(map.get("value")));
                }
            }
            throw new JsonException("Unable to convert json to session id");
        };
    }
}

