/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.netty;

import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.webbitserver.WebbitException;

abstract class ConnectionHelper {
    protected final Executor executor;
    protected final Thread.UncaughtExceptionHandler exceptionHandler;
    private final Thread.UncaughtExceptionHandler ioExceptionHandler;

    public ConnectionHelper(Executor executor, Thread.UncaughtExceptionHandler exceptionHandler, Thread.UncaughtExceptionHandler ioExceptionHandler) {
        this.ioExceptionHandler = ioExceptionHandler;
        this.executor = executor;
        this.exceptionHandler = exceptionHandler;
    }

    public void fireOnClose(ChannelStateEvent e) {
        final Thread thread = Thread.currentThread();
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.webbitExceptionWrappingExceptionHandler(e.getChannel());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ConnectionHelper.this.fireOnClose();
                }
                catch (Throwable t) {
                    uncaughtExceptionHandler.uncaughtException(thread, t);
                }
            }
        });
    }

    public void fireConnectionException(final ExceptionEvent e) {
        if (e.getCause() instanceof ClosedChannelException) {
            e.getChannel().close();
        } else {
            final Thread thread = Thread.currentThread();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ConnectionHelper.this.ioExceptionHandler.uncaughtException(thread, WebbitException.fromExceptionEvent(e));
                }
            });
        }
    }

    protected abstract void fireOnClose() throws Throwable;

    protected Thread.UncaughtExceptionHandler webbitExceptionWrappingExceptionHandler(final Channel channel) {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ConnectionHelper.this.exceptionHandler.uncaughtException(t, WebbitException.fromException(e, channel));
            }
        };
    }
}

