/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClasses={HtmlScript.class})
public class HTMLScriptElement
extends HTMLElement {
    @JsxGetter
    public String getSrc() {
        return this.getDomNodeOrDie().getAttribute("src");
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getDomNodeOrDie().setAttribute("src", src);
    }

    @Override
    @JsxGetter
    public String getText() {
        StringBuilder scriptCode = new StringBuilder();
        for (DomNode node : this.getDomNodeOrDie().getChildren()) {
            if (!(node instanceof DomText)) continue;
            DomText domText = (DomText)node;
            scriptCode.append(domText.getData());
        }
        return scriptCode.toString();
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        htmlElement.removeAllChildren();
        DomText textChild = new DomText(htmlElement.getPage(), text);
        htmlElement.appendChild(textChild);
        HtmlScript tmpScript = (HtmlScript)htmlElement;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SCRIPT_ALWAYS_REEXECUTE_ON_SET_TEXT)) {
            tmpScript.resetExecuted();
        }
        tmpScript.executeScriptIfNeeded();
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getAttribute("type");
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getOnreadystatechange() {
        return this.getEventHandlerProp("onreadystatechange");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setOnreadystatechange(Object handler) {
        this.setEventHandlerProp("onreadystatechange", handler);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Object getOnload() {
        return this.getEventHandlerProp("onload");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setOnload(Object handler) {
        this.setEventHandlerProp("onload", handler);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getReadyState() {
        return this.getDomNodeOrDie().getReadyState();
    }

    @Override
    public Object appendChild(Object childObject) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SCRIPT_APPEND_CHILD_THROWS_EXCEPTION)) {
            throw Context.reportRuntimeError("Unexpected call to method or property access");
        }
        HtmlScript tmpScript = (HtmlScript)this.getDomNodeOrDie();
        boolean wasEmpty = tmpScript.getFirstChild() == null;
        Object result = super.appendChild(childObject);
        if (wasEmpty) {
            tmpScript.executeScriptIfNeeded();
        }
        return result;
    }

    @Override
    protected Object insertBeforeImpl(Object[] args) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SCRIPT_INSERT_BEFORE_THROWS_EXCEPTION)) {
            throw Context.reportRuntimeError("Unexpected call to method or property access");
        }
        return super.insertBeforeImpl(args);
    }
}

