package Tk::TabbedForm::CRadioItem;

=head1 NAME

Tk::TabbedForm::CRadioItem - Array of Radiobuttons for Tk::TabbedForm.

=cut

use strict;
use warnings;
use Tk;
use base qw(Tk::Derived Tk::TabbedForm::CBaseClass);
Construct Tk::Widget 'CRadioItem';

=head1 SYNOPSIS

 require Tk::TabbedForm::CRadioItem;
 my $bool = $window->CRadioItem(@options)->pack;

=head1 DESCRIPTION

Inherits L<Tk::TabbedForm::CBaseClass>.  Providess a row of Radiobuttons for L<Tk::TabbedForm>.

You should never create an instance directly like above. This should
be handled by L<Tk::TabbedForm>.

=head1 B<CONFIG VARIABLES>

=over 4

=item Switch: B<-values>

The list of possible values.

=back

=cut

sub Populate {
	my ($self,$args) = @_;

	my $values = delete $args->{'-values'};
	warn "You need to set the -values option" unless defined $values;
	$self->{VALUES} = $values;

	$self->SUPER::Populate($args);

	
	$self->ConfigSpecs(
		DEFAULT => ['SELF'],
	);
}

sub createHandler {
	my ($self, $var) = @_;
	my $values = $self->{VALUES};
	for (@$values) {
		$self->Radiobutton(
			-text => $_,
			-value => $_,
			-variable => $var,
		)->pack(-side => 'left', -padx => 2, -pady => 2);
	}
}

=head1 LICENSE

Same as Perl.

=head1 AUTHOR

Hans Jeuken (hanje at cpan dot org)

=head1 BUGS

Unknown. If you find any, please contact the author.

=head1 SEE ALSO

=over 4

=item L<Tk::Radiobutton>

=item L<Tk::TabbedForm>

=item L<Tk::TabbedForm::CBaseClass>

=back

=cut

1;

__END__
