#!/usr/bin/perl

use Test::Simple tests => 1;
use Graph::SocialMap;
use IO::All;
use YAML;

my $relation = {
    1357 => [qw/Marry Rose Autrijus/],
    3579 => [qw/Marry Peacock/],
    2468 => [qw/Joan/],
    4680 => [qw/Rose Joan/],
    OSSF => [qw/Gugod Autrijus/],
    GGYY => [qw/Gugod Autrijus Joan Peacock/],
    1234 => [qw/Tifa Dora Charlee Angie/],
    5555 => [qw/A B C D E F G H I J K/],
};

my $gsm = sm(-relation => $relation);

$gsm->save(-format=> 'dot',-file=> 't/graphtest1.dot');
my $tmp = io('t/graphtest1.dot');
my $d2 = $tmp->slurp;
my $d1;
{
    local $/ = undef;
    $d1 = <DATA>;
}
ok($d1 eq $d2);

__DATA__
digraph test {
	node [label="\N", fontsize=12];
	edge [arrowsize="0.5"];
	graph [bb="0,0,516,516"];
	A [label=A, pos="451,19", width="0.75", height="0.50"];
	Angie [label=Angie, pos="437,450", width="0.83", height="0.50"];
	Autrijus [label=Autrijus, pos="75,229", width="1.03", height="0.50"];
	B [label=B, pos="424,55", width="0.75", height="0.50"];
	C [label=C, pos="412,104", width="0.75", height="0.50"];
	Charlee [label=Charlee, pos="383,425", width="0.97", height="0.50"];
	D [label=D, pos="488,67", width="0.75", height="0.50"];
	Dora [label=Dora, pos="352,473", width="0.75", height="0.50"];
	E [label=E, pos="392,44", width="0.75", height="0.50"];
	F [label=F, pos="454,75", width="0.75", height="0.50"];
	G [label=G, pos="419,19", width="0.75", height="0.50"];
	Gugod [label=Gugod, pos="58,150", width="0.89", height="0.50"];
	H [label=H, pos="474,102", width="0.75", height="0.50"];
	I [label=I, pos="442,114", width="0.75", height="0.50"];
	J [label=J, pos="393,79", width="0.75", height="0.50"];
	Joan [label=Joan, pos="28,208", width="0.75", height="0.50"];
	K [label=K, pos="477,37", width="0.75", height="0.50"];
	Marry [label=Marry, pos="121,272", width="0.86", height="0.50"];
	Peacock [label=Peacock, pos="108,191", width="1.00", height="0.50"];
	Rose [label=Rose, pos="51,287", width="0.75", height="0.50"];
	Tifa [label=Tifa, pos="405,497", width="0.75", height="0.50"];
	A -> B [pos="e,436,39 439,35 439,35 439,35 439,35"];
	A -> C [pos="e,420,87 443,37 437,52 429,67 422,82"];
	A -> D [pos="e,475,51 463,35 466,39 469,43 472,47"];
	A -> E [pos="e,415,34 428,29 426,30 423,32 420,33"];
	A -> F [pos="e,453,57 452,37 453,42 453,47 453,52"];
	A -> G [pos="e,424,19 424,19 424,19 424,19 424,19"];
	A -> H [pos="e,469,84 456,37 460,51 464,66 468,79"];
	A -> I [pos="e,444,96 449,37 447,55 445,73 444,91"];
	A -> J [pos="e,408,64 436,34 428,43 419,52 411,60"];
	A -> K [pos="e,470,32 470,32 470,32 470,32 470,32"];
	Angie -> Charlee [pos="e,409,437 413,439 413,439 413,439 413,439"];
	Angie -> Dora [pos="e,377,466 410,457 401,460 391,462 382,465"];
	Angie -> Tifa [pos="e,416,481 426,467 424,470 421,473 419,477"];
	Autrijus -> Gugod [pos="e,62,168 71,211 68,199 66,186 63,173"];
	Autrijus -> Gugod [pos="e,62,168 71,211 68,199 66,186 63,173"];
	Autrijus -> Joan [pos="e,47,217 47,217 47,217 47,217 47,217"];
	Autrijus -> Marry [pos="e,105,256 92,245 95,248 98,251 101,253"];
	Autrijus -> Peacock [pos="e,94,208 90,212 90,212 90,212 90,212"];
	Autrijus -> Rose [pos="e,58,270 68,247 66,253 63,259 60,265"];
	B -> A [pos="e,439,35 436,39 436,39 436,39 436,39"];
	B -> C [pos="e,417,86 420,73 419,75 419,78 418,81"];
	B -> D [pos="e,462,62 450,60 452,61 455,61 457,61"];
	B -> E [pos="e,400,47 400,47 400,47 400,47 400,47"];
	B -> F [pos="e,443,68 443,68 443,68 443,68 443,68"];
	B -> G [pos="e,422,37 422,37 422,37 422,37 422,37"];
	B -> H [pos="e,458,87 440,70 445,75 449,79 454,84"];
	B -> I [pos="e,437,96 429,73 431,79 433,86 435,91"];
	B -> J [pos="e,406,69 406,69 406,69 406,69 406,69"];
	B -> K [pos="e,453,45 448,47 448,47 448,47 448,47"];
	C -> A [pos="e,443,36 420,86 426,72 434,56 441,41"];
	C -> B [pos="e,419,73 416,86 417,84 417,81 418,78"];
	C -> D [pos="e,466,78 434,93 443,89 452,84 461,80"];
	C -> E [pos="e,398,62 406,86 404,80 401,73 399,67"];
	C -> F [pos="e,435,88 431,91 431,91 431,91 431,91"];
	C -> G [pos="e,417,37 413,86 414,72 416,57 417,42"];
	C -> H [pos="e,447,103 439,103 440,103 441,103 442,103"];
	C -> I [pos="e,436,112 436,112 436,112 436,112 436,112"];
	C -> J [pos="e,400,88 400,88 400,88 400,88 400,88"];
	C -> K [pos="e,462,52 427,89 437,77 448,66 458,56"];
	Charlee -> Angie [pos="e,413,439 409,437 409,437 409,437 409,437"];
	Charlee -> Dora [pos="e,363,456 372,442 370,445 368,449 366,452"];
	Charlee -> Tifa [pos="e,400,479 388,443 391,453 395,464 398,474"];
	D -> A [pos="e,464,35 476,51 473,47 470,44 467,39"];
	D -> B [pos="e,450,60 462,62 460,61 458,61 455,61"];
	D -> C [pos="e,434,93 466,78 457,82 448,87 439,91"];
	D -> E [pos="e,418,50 463,61 450,57 436,54 423,51"];
	D -> F [pos="e,462,73 462,73 462,73 462,73 462,73"];
	D -> G [pos="e,438,32 469,54 460,48 451,41 442,35"];
	D -> H [pos="e,481,85 481,85 481,85 481,85 481,85"];
	D -> I [pos="e,457,99 473,82 469,87 465,91 460,95"];
	D -> J [pos="e,420,75 461,70 450,72 437,74 425,75"];
	D -> K [pos="e,481,49 481,49 481,49 481,49 481,49"];
	Dora -> Angie [pos="e,409,457 377,466 386,464 395,461 404,459"];
	Dora -> Charlee [pos="e,372,442 363,456 365,453 367,450 369,447"];
	Dora -> Tifa [pos="e,383,487 375,483 376,483 377,484 379,484"];
	E -> A [pos="e,428,29 415,34 418,33 420,32 423,30"];
	E -> B [pos="e,416,52 416,52 416,52 416,52 416,52"];
	E -> C [pos="e,406,86 398,62 400,68 403,75 405,81"];
	E -> D [pos="e,462,61 418,50 431,54 444,57 457,60"];
	E -> F [pos="e,432,64 414,55 419,57 423,60 428,62"];
	E -> G [pos="e,408,29 408,29 408,29 408,29 408,29"];
	E -> H [pos="e,455,89 411,57 425,67 438,76 451,86"];
	E -> I [pos="e,431,98 404,60 411,72 420,82 428,94"];
	E -> J [pos="e,393,62 393,62 393,62 393,62 393,62"];
	E -> K [pos="e,450,39 419,42 427,41 436,40 445,39"];
	F -> A [pos="e,452,37 453,57 452,52 452,47 452,42"];
	F -> B [pos="e,435,62 435,62 435,62 435,62 435,62"];
	F -> C [pos="e,431,91 435,88 435,88 435,88 435,88"];
	F -> D [pos="e,480,69 480,69 480,69 480,69 480,69"];
	F -> E [pos="e,414,55 432,64 428,62 423,60 419,57"];
	F -> G [pos="e,429,36 444,58 440,52 436,46 432,40"];
	F -> H [pos="e,466,91 466,91 466,91 466,91 466,91"];
	F -> I [pos="e,448,96 449,93 449,93 449,93 449,93"];
	F -> J [pos="e,420,77 427,77 427,77 426,77 425,77"];
	F -> K [pos="e,467,54 464,58 464,58 464,58 464,58"];
	G -> A [pos="e,446,19 446,19 446,19 446,19 446,19"];
	G -> B [pos="e,422,37 422,37 422,37 422,37 422,37"];
	G -> C [pos="e,414,86 418,37 417,51 415,66 414,81"];
	G -> D [pos="e,469,54 438,32 447,39 456,45 465,51"];
	G -> E [pos="e,403,34 403,34 403,34 403,34 403,34"];
	G -> F [pos="e,444,58 429,36 433,42 437,48 441,54"];
	G -> H [pos="e,463,85 430,36 440,51 450,66 460,81"];
	G -> I [pos="e,438,96 423,37 428,55 432,74 437,91"];
	G -> J [pos="e,401,62 412,36 409,43 406,50 403,57"];
	G -> K [pos="e,452,29 444,27 445,27 446,28 447,28"];
	Gugod -> Autrijus [pos="e,71,211 62,168 65,180 67,193 70,206"];
	Gugod -> Autrijus [pos="e,71,211 62,168 65,180 67,193 70,206"];
	Gugod -> Joan [pos="e,37,191 49,168 46,174 43,180 39,187"];
	Gugod -> Peacock [pos="e,89,175 76,165 79,168 82,170 85,172"];
	H -> A [pos="e,456,37 469,84 465,70 461,56 457,42"];
	H -> B [pos="e,440,70 458,87 453,82 449,78 444,73"];
	H -> C [pos="e,439,103 447,103 446,103 445,103 444,103"];
	H -> D [pos="e,481,84 481,85 481,85 481,85 481,85"];
	H -> E [pos="e,411,57 455,89 441,79 428,70 415,60"];
	H -> F [pos="e,462,86 462,86 462,86 462,86 462,86"];
	H -> G [pos="e,430,36 463,85 453,70 443,55 433,40"];
	H -> I [pos="e,450,111 450,111 450,111 450,111 450,111"];
	H -> J [pos="e,418,86 449,95 440,93 431,90 423,88"];
	H -> K [pos="e,476,55 475,84 476,76 476,68 476,60"];
	I -> A [pos="e,449,37 444,96 446,78 448,60 449,42"];
	I -> B [pos="e,429,73 437,96 435,90 433,84 431,78"];
	I -> C [pos="e,418,106 418,106 418,106 418,106 418,106"];
	I -> D [pos="e,473,82 457,99 461,94 465,90 470,86"];
	I -> E [pos="e,403,60 430,98 423,86 414,76 406,64"];
	I -> F [pos="e,448,93 447,96 447,96 447,96 447,96"];
	I -> G [pos="e,423,37 438,96 433,78 429,59 424,42"];
	I -> H [pos="e,466,105 466,105 466,105 466,105 466,105"];
	I -> J [pos="e,412,92 423,101 421,99 418,97 416,95"];
	I -> K [pos="e,469,54 450,97 455,85 461,71 467,59"];
	J -> A [pos="e,436,34 408,64 416,55 425,47 433,38"];
	J -> B [pos="e,411,65 411,65 411,65 411,65 411,65"];
	J -> C [pos="e,405,95 405,95 405,95 405,95 405,95"];
	J -> D [pos="e,461,71 420,76 431,74 444,73 456,71"];
	J -> E [pos="e,392,61 392,61 392,61 392,61 392,61"];
	J -> F [pos="e,427,77 420,77 421,77 421,77 422,77"];
	J -> G [pos="e,411,36 400,62 403,55 407,48 409,41"];
	J -> H [pos="e,449,95 418,86 427,88 436,91 444,93"];
	J -> I [pos="e,423,101 412,92 415,94 417,96 419,98"];
	J -> K [pos="e,455,48 415,68 427,63 438,57 450,50"];
	Joan -> Autrijus [pos="e,51,218 51,218 51,218 51,218 51,218"];
	Joan -> Gugod [pos="e,49,168 37,191 40,185 43,178 47,172"];
	Joan -> Peacock [pos="e,75,198 54,203 59,201 65,201 70,199"];
	Joan -> Rose [pos="e,46,269 33,226 37,238 41,251 45,264"];
	K -> A [pos="e,458,24 458,24 458,24 458,24 458,24"];
	K -> B [pos="e,448,47 453,45 453,45 453,45 453,45"];
	K -> C [pos="e,427,89 462,52 452,64 441,75 431,85"];
	K -> D [pos="e,484,55 484,55 484,55 484,55 484,55"];
	K -> E [pos="e,419,42 450,39 442,40 433,41 424,42"];
	K -> F [pos="e,464,58 467,54 467,54 467,54 467,54"];
	K -> G [pos="e,444,27 452,29 451,29 450,28 449,28"];
	K -> H [pos="e,475,84 476,55 475,63 475,71 475,79"];
	K -> I [pos="e,450,97 469,54 464,66 458,80 452,92"];
	K -> J [pos="e,415,68 455,48 443,53 432,59 420,66"];
	Marry -> Autrijus [pos="e,93,245 105,257 102,254 100,252 97,249"];
	Marry -> Peacock [pos="e,111,209 118,254 116,241 114,228 112,214"];
	Marry -> Rose [pos="e,77,281 92,278 89,279 85,279 82,280"];
	Peacock -> Autrijus [pos="e,90,212 94,208 94,208 94,208 94,208"];
	Peacock -> Gugod [pos="e,76,165 89,175 86,173 84,170 80,168"];
	Peacock -> Joan [pos="e,54,203 75,198 70,200 64,200 59,202"];
	Peacock -> Marry [pos="e,118,254 111,209 113,222 115,235 117,249"];
	Rose -> Autrijus [pos="e,67,247 58,269 60,264 63,257 65,252"];
	Rose -> Joan [pos="e,33,226 46,269 42,257 38,244 34,231"];
	Rose -> Marry [pos="e,92,278 77,281 80,280 84,280 87,279"];
	Tifa -> Angie [pos="e,426,467 416,480 418,477 420,474 423,471"];
	Tifa -> Charlee [pos="e,388,443 400,479 397,469 393,458 390,448"];
	Tifa -> Dora [pos="e,375,483 382,487 381,487 380,486 379,486"];
}
