# NOTE: Derived from blib/lib/IPC/Shareable.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package IPC::Shareable;

#line 1565 "blib/lib/IPC/Shareable.pm (autosplit into blib/lib/auto/IPC/Shareable/shunlock.al)"
sub shunlock {
    my($variable) = @_;
    my($semid, $opstring, $arg);
    $arg = 0;
    debug "called on $variable" if ($Debug);

    # --- Don't unlock it again if we don't have a lock on it
    return 1 unless $Shm_Info{$$variable}{'lock'};

    # --- Get the semaphore ID
    $semid = $Shm_Info{$$variable}{'sem_id'};
    debug "$Package\:\:shunlock: got sem_id $semid" if ($Debug);

    # --- Debugging
    _show_sems ($semid) if ($Debug);

    # --- Define the operation
    $opstring = pack('sss sss',
		     SHM_RLOCKSEM, -1, SEM_UNDO,
		     SHM_WLOCKSEM, -1, SEM_UNDO 
		     );

    # --- Remove the lock flag for this process
    $Shm_Info{$$variable}{'lock'} = 0;

    # --- Do it
    semop($semid, $opstring) or
	croak "$Package\:\:shunlock: semop returned false: $!";

    # --- More debugging
    _show_sems($semid) if ($Debug);

    1;
}

# end of IPC::Shareable::shunlock
1;
