# NOTE: Derived from blib/lib/IPC/Shareable.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package IPC::Shareable;

#line 1641 "blib/lib/IPC/Shareable.pm (autosplit into blib/lib/auto/IPC/Shareable/FIRSTKEY.al)"
sub FIRSTKEY {
    my($shm_hash) = @_;
    my($first_key);
    # --- Called when the user begins an iteration via each() or keys().
    debug "called on $shm_hash ($$shm_hash)" if ($Debug);

    # --- Make sure that %Shm_Info is up-to-date
    FETCH($shm_hash);

    # --- Now the $hash_ref obtained on the next line should be (reasonably) up-to-date
    $first_key = scalar each %{$Shm_Info{$$shm_hash}{'DATA'}{'user'}};
    debug "$Package\:\:FIRSTKEY: \$first_key is $first_key" 
      if ((defined $first_key) and ($Debug));

    # --- Set the magical token indicating an iteration has begun, but
    # --- only if there's something in the hash
    $Shm_Info{$$shm_hash}{'hash_iterating'} = 1 if defined $first_key;

    # --- Return the first key
    $first_key;
}

# end of IPC::Shareable::FIRSTKEY
1;
