use strict;
use warnings;

use Test::More;
use File::LibMagic;

my %standard = (
    'foo.foo' => [ 'ASCII text',           'text/plain charset=us-ascii' ],
    'foo.c'   => [ 'ASCII C program text', 'text/x-c charset=us-ascii'   ],
);

my %custom = (
    'foo.foo' => [ 'A foo file',           'text/plain charset=us-ascii' ],
    'foo.c'   => [ 'ASCII C program text', 'text/x-c charset=us-ascii'   ],
);

plan tests => 4 + 4*(keys %standard) + 4*(keys %custom);

# try using a the standard magic database
my $flm = File::LibMagic->new();
isa_ok($flm, 'File::LibMagic');

while ( my ($file, $expect) = each %standard ) {
    my ($descr, $mime) = @$expect;
    $file = "t/samples/$file";

    is( $flm->checktype_filename($file), $mime,  "MIME $file"     );
    is( $flm->describe_filename($file),  $descr, "Describe $file" );

    my $data = do {
        local $/;
        open my $fh, '<', $file or die $!;
        <$fh>;
    };

    is( $flm->checktype_contents($data), $mime,  "MIME data $file"     );
    is( $flm->describe_contents($data),  $descr, "Describe data $file" );
}

# try using a custom magic database
$flm = File::LibMagic->new('t/samples/magic');
isa_ok($flm, 'File::LibMagic');

while ( my ($file, $expect) = each %custom ) {
    my ($descr, $mime) = @$expect;
    $file = "t/samples/$file";

    is( $flm->checktype_filename($file), $mime,  "MIME $file"     );
    is( $flm->describe_filename($file),  $descr, "Describe $file" );

    my $data = do {
        local $/;
        open my $fh, '<', $file or die $!;
        <$fh>;
    };

    is( $flm->checktype_contents($data), $mime,  "MIME data $file"     );
    is( $flm->describe_contents($data),  $descr, "Describe data $file" );
}

my $subclass = My::Magic::Subclass->new();
isa_ok( $subclass, 'My::Magic::Subclass', 'subclass' );
is( $subclass->checktype_filename('t/samples/missing'), 'text/x-test-passes' );

# define a subclass of File::LibMagic to test subclassing
package My::Magic::Subclass;
use base qw( File::LibMagic );
sub checktype_filename { 'text/x-test-passes' }
