package Task::Padre::Plugins;

use warnings;
use strict;

our $VERSION = '0.20';

1;
__END__

=head1 NAME

Task::Padre::Plugins - Get many Plugins of Padre at once

=head1 SYNOPSIS

Most plugins will just run with the text you selected if there is any selection.

If not, they run with the whole text from selected document.

=head1 MODULES

=head2 Padre::Plugin::AcmePlayCode

L<Acme::PlayCode> Plugin for L<Padre>

=head2 Padre::Plugin::Alarm

Alarm Clock in Padre

=head2 Padre::Plugin::Autoformat

reformat your text within Padre

=head2 Padre::Plugin::CSS

L<Padre> and CSS

=head2 Padre::Plugin::Catalyst

Simple Catalyst helper interface for Padre

=head2 Padre::Plugin::CommandLine

vi and emacs in Padre ?

=head2 Padre::Plugin::DataWalker

Simple Perl data structure browser Padre

=head2 Padre::Plugin::Debugger

Debug Perl code from Padre editor

=head2 Padre::Plugin::Encode

convert file to different encoding in Padre

=head2 Padre::Plugin::Encrypt

encrypt/decrypt file in Padre

=head2 Padre::Plugin::Git

Simple Git interface for Padre

=head2 Padre::Plugin::HTML

L<Padre> and HTML

=head2 Padre::Plugin::HTMLExport

export highlighted HTML in Padre

=head2 Padre::Plugin::InstallPARDist

Installation of .par archives into the system

=head2 Padre::Plugin::JavaScript

L<Padre> and JavaScript

=head2 Padre::Plugin::Mojolicious

Simple Mojolicious helper interface for Padre

=head2 Padre::Plugin::Nopaste

send code on a nopaste website from padre

=head2 Padre::Plugin::PAR

PAR generation from Padre

=head2 Padre::Plugin::PSI

Experimental Padre plugin written in Perl 6

=head2 Padre::Plugin::Parrot

Experimental Padre plugin that runs on Parrot

=head2 Padre::Plugin::Perl6

Padre plugin for Perl6

=head2 Padre::Plugin::PerlCritic

Analyze perl files with Perl::Critic

=head2 Padre::Plugin::PerlTidy

Format perl files using Perl::Tidy

=head2 Padre::Plugin::SVK

Simple SVK interface for Padre

=head2 Padre::Plugin::SVN

Simple SVN interface for Padre

=head2 Padre::Plugin::SpellCheck

check spelling in Padre

=head2 Padre::Plugin::Vi

vi keyboard for Padre

=head2 Padre::Plugin::ViewInBrowser

view selected doc in browser for L<Padre>

=head2 Padre::Plugin::XML

L<Padre> and XML

=head1 AUTHOR

Gabor Szabo, C<< <szabgab at gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to L<http://padre.perlide.org/>

=head1 SUPPORT

You can find documentation for Padre on L<http://padre.perlide.org/>

=head1 COPYRIGHT & LICENSE

Copyright 2008-2009 Gabor Szabo, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

