use strict;
use warnings;
BEGIN { require "t/tools.pl" };
use Test2::Event::Diag;
use Test2::Context::Trace;

my $diag = Test2::Event::Diag->new(
    trace => Test2::Context::Trace->new(frame => [__PACKAGE__, __FILE__, __LINE__]),
    message => 'foo',
);

$diag = Test2::Event::Diag->new(
    trace => Test2::Context::Trace->new(frame => [__PACKAGE__, __FILE__, __LINE__]),
    message => undef,
);

is($diag->message, 'undef', "set undef message to undef");

$diag = Test2::Event::Diag->new(
    trace => Test2::Context::Trace->new(frame => [__PACKAGE__, __FILE__, __LINE__]),
    message => {},
);

like($diag->message, qr/^HASH\(.*\)$/, "stringified the input value");

done_testing;
