#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ColorInfoD30',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo1D',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PictureInfo',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'actionadvised' => { 28 => 0x2a },
	'activearea' => { 24 => 0xc68d },
	'addoriginaldecisiondata' => { 13 => 0x11 },
	'adjustmentmode' => { 65 => 0x15 },
	'advancedraw' => { 49 => 0x76a43203 },
	'advisory' => { 76 => 'Advisory' },
	'aebbracketvalue' => { 10 => 0x11 },
	'aebsequence' => { 11 => 0x9, 12 => 0x9, 13 => 0x8, 14 => 0x7 },
	'afareas' => { 53 => 0x304 },
	'afassist' => { 11 => 0x5, 14 => 0x5 },
	'afassistbeam' => { 13 => 0x4 },
	'afmode' => { 65 => 0x5 },
	'afpoint' => { 0 => 0x13, 41 => 0x88 },
	'afpointactivationarea' => { 12 => 0x11 },
	'afpointillumination' => { 12 => 0xa },
	'afpointregistration' => { 11 => 0x7 },
	'afpointselection' => { 12 => 0xb },
	'afpointselectionmethod' => { 13 => 0xc },
	'afpointspotmetering' => { 12 => 0xd },
	'afpointsused' => { 8 => 0x16 },
	'afsearch' => { 53 => 0x303 },
	'aiservotrackingsensitivity' => { 12 => 0x14 },
	'analogzoom' => { 33 => 0x1e },
	'antialiasstrength' => { 24 => 0xc632 },
	'aperturevalue' => { 24 => 0x9202, 71 => 'ApertureValue' },
	'app1_profile' => { 59 => 'Raw profile type APP1' },
	'applicationrecordversion' => { 28 => 0x0 },
	'armidentifier' => { 29 => 0x78 },
	'armversion' => { 29 => 0x7a },
	'artist' => { 24 => 0x13b, 59 => 'Artist', 75 => 'Artist' },
	'asshotwhitexy' => { 24 => 0xc629 },
	'assistbuttonfunction' => { 11 => 0xd },
	'audio' => { 60 => 0x20 },
	'audioduration' => { 28 => 0x99 },
	'audiooutcue' => { 28 => 0x9a },
	'audiosamplingrate' => { 28 => 0x97 },
	'audiosamplingresolution' => { 28 => 0x98 },
	'audiotype' => { 28 => 0x96 },
	'author' => { 59 => 'Author', 73 => 'Author' },
	'authorsposition' => { 74 => 'AuthorsPosition' },
	'autoafpoint' => { 61 => 0xf },
	'autobracket' => { 65 => 0x19 },
	'autobracketing' => { 26 => 0x1100 },
	'autoexposurebracketing' => { 10 => 0x10 },
	'autofocus' => { 55 => 0x209 },
	'autorotate' => { 10 => 0x1b },
	'auxiliarylens' => { 41 => 0x82 },
	'avvalue' => { 15 => 0x2 },
	'baseiso' => { 18 => 0x101c },
	'baselineexposure' => { 24 => 0xc62a },
	'baselinenoise' => { 24 => 0xc62b },
	'baselinesharpness' => { 24 => 0xc62c },
	'baseurl' => { 76 => 'BaseURL' },
	'bayergreensplit' => { 24 => 0xc62d },
	'bestqualityscale' => { 24 => 0xc65c },
	'bestshotmode' => { 22 => 0x3007 },
	'bitspercomponent' => { 30 => 0x87 },
	'bitspersample' => { 24 => 0x102, 75 => 'BitsPerSample' },
	'blacklevel' => { 57 => 0x1012 },
	'blackpoint' => { 61 => 0x200 },
	'bluebalance' => { 37 => 0x1, 38 => 0x1, 39 => 0x1, 57 => 0x1018, 61 => 0x1b },
	'bluehue' => { 68 => 'BlueHue' },
	'bluesaturation' => { 68 => 'BlueSaturation' },
	'blurwarning' => { 26 => 0x1300 },
	'bodyfirmwareversion' => { 54 => 0x104 },
	'bracketstep' => { 35 => 0xe },
	'brightness' => { 24 => 0xfe53, 35 => 0x2c, 68 => 'Brightness' },
	'brightnessadj' => { 44 => 0x0 },
	'brightnessvalue' => { 24 => 0x9203, 71 => 'BrightnessValue' },
	'bulbduration' => { 10 => 0x18 },
	'burstmode' => { 31 => 0xa },
	'burstmode2' => { 31 => 0x18 },
	'bwfilter' => { 35 => 0x2a },
	'bwmode' => { 57 => 0x203 },
	'by-line' => { 28 => 0x50 },
	'by-linetitle' => { 28 => 0x55 },
	'calibrationilluminant1' => { 24 => 0xc65a },
	'calibrationilluminant2' => { 24 => 0xc65b },
	'cameraid' => { 57 => 0x209, 64 => 0x209 },
	'cameraiso' => { 0 => 0x10 },
	'cameraserialnumber' => { 24 => 0xc62f },
	'camerasettings' => { 57 => 0x2020 },
	'camerasettingsversion' => { 53 => 0x0 },
	'cameratype' => { 57 => 0x207 },
	'canonexposuremode' => { 0 => 0x14 },
	'canonfiledescription' => { 18 => 0x805 },
	'canonfilelength' => { 6 => 0xe },
	'canonfirmwareversion' => { 6 => 0x7, 18 => 0x80b },
	'canonflashmode' => { 0 => 0x4 },
	'canonimageheight' => { 8 => 0x3 },
	'canonimageheightasshot' => { 8 => 0x5 },
	'canonimagesize' => { 0 => 0xa },
	'canonimagetype' => { 6 => 0x6, 18 => 0x815 },
	'canonimagewidth' => { 8 => 0x2 },
	'canonimagewidthasshot' => { 8 => 0x4 },
	'caption-abstract' => { 28 => 0x78 },
	'captionwriter' => { 74 => 'CaptionWriter' },
	'casioimagesize' => { 22 => 0x9 },
	'category' => { 28 => 0xf, 74 => 'Category' },
	'ccdisosensitivity' => { 22 => 0x3014 },
	'ccdsensitivity' => { 21 => 0x14, 43 => 0x6 },
	'celllength' => { 24 => 0x109 },
	'cellwidth' => { 24 => 0x108 },
	'certificate' => { 80 => 'Certificate' },
	'cfapattern' => { 24 => 0xa302 },
	'cfapatterncolumns' => { 71 => 'CFAPatternColumns' },
	'cfapatternrows' => { 71 => 'CFAPatternRows' },
	'cfapatternvalues' => { 71 => 'CFAPatternValues' },
	'chromablurradius' => { 24 => 0xc631 },
	'chromaticaberrationb' => { 68 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 68 => 'ChromaticAberrationR' },
	'city' => { 28 => 0x5a, 74 => 'City' },
	'classifystate' => { 28 => 0xe1 },
	'codedcharacterset' => { 29 => 0x5a },
	'coloradjustment' => { 65 => 0x14 },
	'coloradjustmentmode' => { 64 => 0x210 },
	'colorbalance1' => { 41 => 0xc },
	'colorbalanceadj' => { 49 => 0x76a43202 },
	'colorbalanceblue' => { 35 => 0x1e },
	'colorbalancegreen' => { 35 => 0x1d },
	'colorbalancered' => { 35 => 0x1c },
	'colorbooster' => { 49 => 0x5f0e7d23 },
	'colorboostlevel' => { 45 => 0x1 },
	'colorboosttype' => { 45 => 0x0 },
	'colorcontrol' => { 57 => 0x102b },
	'coloreffect' => { 60 => 0x28 },
	'colorfilter' => { 35 => 0x29 },
	'colorhue' => { 41 => 0x8d },
	'colormatrix' => { 2 => 0xa, 56 => 0x200, 57 => 0x1011 },
	'colormode' => { 22 => 0x3015, 31 => 0x66, 35 => 0x28, 36 => 0x101, 41 => 0x3, 43 => 0x4, 57 => 0x101 },
	'colormoirereduction' => { 50 => 0x5 },
	'colornoisereduction' => { 68 => 'ColorNoiseReduction' },
	'colorprofile' => { 35 => 0x33 },
	'colorrepresentation' => { 30 => 0x3c },
	'colorsequence' => { 30 => 0x41 },
	'colorspace' => { 18 => 0x10b4, 24 => 0xa001, 53 => 0x507, 65 => 0xb, 71 => 'ColorSpace' },
	'colortemperature' => { 1 => 0x9, 2 => 0x9, 6 => 0xae, 18 => 0x10ae },
	'colortone' => { 0 => 0x2a },
	'comment' => { 25 => 'Comment', 59 => 'Comment' },
	'componentsconfiguration' => { 24 => 0x9101, 71 => 'ComponentsConfiguration' },
	'componentversion' => { 18 => 0x80c },
	'compressedbitsperpixel' => { 24 => 0x9102, 71 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 36 => 0x40, 57 => 0x40 },
	'compression' => { 24 => 0x103, 75 => 'Compression' },
	'compressionfactor' => { 53 => 0x50d },
	'compressionratio' => { 57 => 0x1034 },
	'contact' => { 28 => 0x76 },
	'contentlocationcode' => { 28 => 0x1a },
	'contentlocationname' => { 28 => 0x1b },
	'continuousdrive' => { 0 => 0x5 },
	'contrast' => { 0 => 0xd, 21 => 0xc, 22 => 0x20, 24 => [0xa408,0xfe54], 26 => 0x1004, 35 => 0x20, 57 => 0x1029, 60 => 0x2c, 61 => 0x20, 65 => 0xd, 68 => 'Contrast', 71 => 'Contrast' },
	'contrastsetting' => { 53 => 0x505 },
	'contributor' => { 69 => 'contributor' },
	'converter' => { 24 => 0xfe4d, 43 => 0xb },
	'copyright' => { 24 => 0x8298, 59 => 'Copyright', 75 => 'Copyright' },
	'copyrightflag' => { 62 => 0x40a },
	'copyrightnotice' => { 28 => 0x74 },
	'coringfilter' => { 57 => 0x102d },
	'country' => { 74 => 'Country' },
	'country-primarylocationcode' => { 28 => 0x64 },
	'country-primarylocationname' => { 28 => 0x65 },
	'countrycode' => { 72 => 'CountryCode' },
	'coverage' => { 69 => 'coverage' },
	'crc32' => { 70 => 'crc32' },
	'createdate' => { 24 => 0x9004, 76 => 'CreateDate' },
	'creationdate' => { 73 => 'CreationDate' },
	'creationtime' => { 59 => 'Creation Time' },
	'creator' => { 69 => 'creator' },
	'creatorcontactinfociadrcity' => { 72 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 72 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 72 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 72 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 72 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 72 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 72 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 72 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 76 => 'CreatorTool' },
	'credit' => { 28 => 0x6e, 74 => 'Credit' },
	'creditlinereq' => { 79 => 'CreditLineReq' },
	'cropbottom' => { 46 => 0x36 },
	'cropleft' => { 46 => 0x1e },
	'cropoutputscale' => { 46 => 0xbe },
	'cropright' => { 46 => 0x2e },
	'croptop' => { 46 => 0x26 },
	'curves' => { 49 => 0x76a43201 },
	'customrendered' => { 24 => 0xa401, 71 => 'CustomRendered' },
	'customsaturation' => { 53 => 0x503 },
	'd-lightinghq' => { 49 => 0x2175eb78 },
	'd-lightinghqselected' => { 49 => 0x6a6e36b6 },
	'd-lightinghs' => { 49 => 0xce5554aa },
	'd-lightinghsadjustment' => { 48 => 0x0 },
	'd-lightinghscolorboost' => { 47 => 0x2, 48 => 0x1 },
	'd-lightinghshighlight' => { 47 => 0x1 },
	'd-lightinghsshadow' => { 47 => 0x0 },
	'datacompressionmethod' => { 30 => 0x6e },
	'dataimprint' => { 35 => 0x34 },
	'date' => { 61 => 0x6, 69 => 'date' },
	'datecreated' => { 28 => 0x37, 74 => 'DateCreated' },
	'datesent' => { 29 => 0x46 },
	'datetime' => { 75 => 'DateTime' },
	'datetimedigitized' => { 71 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 20 => 0x0, 24 => 0x9003, 71 => 'DateTimeOriginal' },
	'datetimestamp' => { 31 => 0x64 },
	'decposition' => { 35 => 0x32 },
	'defaultcroporigin' => { 24 => 0xc61f },
	'defaultcropsize' => { 24 => 0xc620 },
	'defaultscale' => { 24 => 0xc61e },
	'derivedfromdocumentid' => { 78 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 78 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 78 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 78 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 78 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 78 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 78 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 78 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 78 => 'DerivedFromVersionID' },
	'description' => { 59 => 'Description', 69 => 'description' },
	'destination' => { 29 => 0x5 },
	'destinationcity' => { 61 => 0x24 },
	'destinationcitycode' => { 61 => 0x1001 },
	'destinationdst' => { 61 => 0x26 },
	'devicesettingdescriptioncolumns' => { 71 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 71 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 71 => 'DeviceSettingDescriptionSettings' },
	'digitalcreationdate' => { 28 => 0x3e },
	'digitalcreationtime' => { 28 => 0x3f },
	'digitalzoom' => { 0 => 0xc, 21 => 0xa, 31 => 0x68, 35 => 0xc, 41 => 0x86, 43 => 0xa, 57 => 0x204, 61 => 0x1e, 64 => 0x204 },
	'digitalzoomon' => { 64 => 0x21b },
	'digitalzoomratio' => { 24 => 0xa404, 71 => 'DigitalZoomRatio' },
	'disclaimer' => { 59 => 'Disclaimer' },
	'distance1' => { 31 => 0x28 },
	'distance2' => { 31 => 0x2c },
	'distance3' => { 31 => 0x30 },
	'distance4' => { 31 => 0x34 },
	'distortioncorrection' => { 53 => 0x50b },
	'dngbackwardversion' => { 24 => 0xc613 },
	'dnglensinfo' => { 24 => 0xc630 },
	'dngversion' => { 24 => 0xc612 },
	'document' => { 59 => 'Document' },
	'documenthistory' => { 28 => 0xe7 },
	'documentid' => { 78 => 'DocumentID' },
	'documentname' => { 24 => 0x10d },
	'documentnotes' => { 28 => 0xe6 },
	'dotrange' => { 24 => 0x150 },
	'drivemode' => { 35 => 0x6, 65 => 0x3 },
	'easymode' => { 0 => 0xb },
	'edgenoisereduction' => { 50 => 0x4 },
	'editorialupdate' => { 28 => 0x8 },
	'editstatus' => { 28 => 0x7 },
	'enhancedarktones' => { 44 => 0x8 },
	'enhancement' => { 22 => 0x3016 },
	'envelopenumber' => { 29 => 0x28 },
	'envelopepriority' => { 29 => 0x3c },
	'enveloperecordversion' => { 29 => 0x0 },
	'epsonimageheight' => { 57 => 0x20c },
	'epsonimagewidth' => { 57 => 0x20b },
	'epsonsoftware' => { 57 => 0x20d },
	'equipment' => { 57 => 0x2010 },
	'equipmentversion' => { 54 => 0x0 },
	'ettlii' => { 13 => 0xd },
	'excursiontolerance' => { 30 => 0x82 },
	'exif_profile' => { 59 => 'Raw profile type exif' },
	'exifcamerainfo' => { 28 => 0xe8 },
	'exifimageheight' => { 71 => 'PixelYDimension' },
	'exifimagelength' => { 24 => 0xa003 },
	'exifimagewidth' => { 24 => 0xa002, 71 => 'PixelXDimension' },
	'exifversion' => { 24 => 0x9000, 71 => 'ExifVersion' },
	'expirationdate' => { 28 => 0x25 },
	'expirationtime' => { 28 => 0x26 },
	'exposure' => { 24 => 0xfe51, 68 => 'Exposure' },
	'exposurebracketvalue' => { 41 => 0x19 },
	'exposurecompensation' => { 10 => 0x6, 15 => 0x0, 24 => 0x9204, 31 => 0x24, 35 => 0xd, 61 => 0x16, 65 => 0xc, 71 => 'ExposureBiasValue' },
	'exposuredifference' => { 41 => 0xe },
	'exposureindex' => { 24 => 0xa215, 71 => 'ExposureIndex' },
	'exposurelevelincrements' => { 11 => 0x6, 12 => 0x6, 13 => 0x5, 14 => 0x4 },
	'exposuremode' => { 24 => 0xa402, 35 => 0x1, 53 => 0x200, 65 => 0x8, 71 => 'ExposureMode' },
	'exposureprogram' => { 24 => 0x8822, 71 => 'ExposureProgram' },
	'exposuretime' => { 5 => 0x4, 10 => 0x16, 24 => 0x829a, 31 => 0x20, 33 => 0x38, 61 => 0x12, 71 => 'ExposureTime' },
	'exposurewarning' => { 26 => 0x1302 },
	'extender' => { 54 => 0x301 },
	'extenderfirmwareversion' => { 54 => 0x304 },
	'extenderserialnumber' => { 54 => 0x302 },
	'externalflash' => { 55 => 0x1201 },
	'ffid' => { 70 => 'ffid' },
	'fileformat' => { 17 => 0x0, 29 => 0x14 },
	'filemodifydate' => { 25 => 'FileModifyDate' },
	'filenumber' => { 3 => 0x1, 6 => 0x8, 18 => 0x1817 },
	'filenumbermemory' => { 35 => 0x1a },
	'filesource' => { 24 => 0xa300, 71 => 'FileSource' },
	'fileversion' => { 29 => 0x16 },
	'fillflashautoreduction' => { 11 => 0xe, 12 => 0xe, 14 => 0xa },
	'fillorder' => { 24 => 0x10a },
	'filter' => { 22 => 0x3017 },
	'finderdisplayduringexposure' => { 12 => 0x1 },
	'firmware' => { 65 => 0x17 },
	'firmwareversion' => { 41 => 0x1, 60 => 0x2 },
	'firmwareversion2' => { 54 => 0x100 },
	'fixtureidentifier' => { 28 => 0x16 },
	'flash' => { 24 => 0x9209 },
	'flashactivity' => { 0 => 0x1c },
	'flashbias' => { 60 => 0x24 },
	'flashbits' => { 0 => 0x1d },
	'flashdevice' => { 57 => 0x1005 },
	'flashdistance' => { 22 => 0x2034 },
	'flashenergy' => { 24 => 0xa20b, 71 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 41 => 0x18 },
	'flashexposurecomp' => { 10 => 0xf, 35 => 0x23, 41 => 0x12 },
	'flashexposurecompensation' => { 53 => 0x401 },
	'flashfired' => { 31 => 0x5d, 35 => 0x14, 71 => 'FlashFired' },
	'flashfiring' => { 13 => 0x6 },
	'flashfirmwareversion' => { 54 => 0x1004 },
	'flashfunction' => { 71 => 'FlashFunction' },
	'flashguidenumber' => { 16 => 0x0 },
	'flashintensity' => { 21 => 0x5 },
	'flashmode' => { 21 => 0x4, 31 => 0x5c, 35 => 0x2, 41 => 0x87, 53 => 0x400, 57 => 0x1004, 61 => 0xc, 64 => 0x225, 71 => 'FlashMode' },
	'flashmodel' => { 54 => 0x1001 },
	'flashpixversion' => { 24 => 0xa000, 71 => 'FlashpixVersion' },
	'flashredeyemode' => { 71 => 'FlashRedEyeMode' },
	'flashreturn' => { 71 => 'FlashReturn' },
	'flashserialnumber' => { 54 => 0x1003 },
	'flashsetting' => { 41 => 0x8 },
	'flashstrength' => { 26 => 0x1011 },
	'flashsyncspeedav' => { 11 => 0x3, 13 => 0x2, 14 => 0x6 },
	'flashthreshold' => { 16 => 0x1 },
	'flashtype' => { 41 => 0x9, 54 => 0x1000 },
	'flickerreduce' => { 64 => 0x218 },
	'fliphorizontal' => { 49 => 0x76a43206 },
	'fnumber' => { 10 => 0x15, 24 => 0x829d, 31 => 0x1e, 33 => 0x3c, 61 => 0x13, 71 => 'FNumber' },
	'focallength' => { 4 => 0x1, 5 => 0xa, 22 => 0x1d, 24 => 0x920a, 35 => 0x12, 61 => 0x1d, 71 => 'FocalLength' },
	'focallengthin35mmformat' => { 24 => 0xa405, 71 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 54 => 0x103, 57 => 0x205 },
	'focalplaneresolutionunit' => { 24 => 0xa210, 71 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 24 => 0xa20e, 71 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 4 => 0x2 },
	'focalplaneyresolution' => { 24 => 0xa20f, 71 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 4 => 0x3 },
	'focaltype' => { 4 => 0x0, 5 => 0x2d },
	'focalunits' => { 0 => 0x19 },
	'focus' => { 43 => 0x8 },
	'focusarea' => { 35 => 0x31 },
	'focuscontinuous' => { 0 => 0x20 },
	'focusdistance' => { 35 => 0x13, 55 => 0x305 },
	'focusdistancelower' => { 10 => 0x14 },
	'focusdistanceupper' => { 10 => 0x13 },
	'focusinfo' => { 57 => 0x2050 },
	'focusinfoversion' => { 55 => 0x0 },
	'focusingscreen' => { 12 => 0x0 },
	'focusmode' => { 0 => 0x7, 21 => 0x3, 22 => [0x3003,0xd], 26 => 0x1021, 31 => 0x38, 35 => 0x30, 41 => 0x7, 53 => 0x301, 60 => 0x7, 61 => 0xd },
	'focusposition' => { 61 => 0x10 },
	'focusprocess' => { 53 => 0x302 },
	'focussetting' => { 65 => 0x6 },
	'focustype' => { 0 => 0x12 },
	'focuswarning' => { 26 => 0x1301 },
	'foldername' => { 35 => 0x27 },
	'format' => { 69 => 'format' },
	'framenumber' => { 61 => 0x29 },
	'freebytes' => { 18 => 0x1 },
	'fujiflashmode' => { 26 => 0x1010 },
	'gaincontrol' => { 24 => 0xa407, 71 => 'GainControl' },
	'gamma' => { 24 => 0xa500 },
	'gammacompensatedvalue' => { 30 => 0x91 },
	'gpsaltitude' => { 27 => 0x6, 71 => 'GPSAltitude' },
	'gpsaltituderef' => { 27 => 0x5, 71 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 27 => 0x1c, 71 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 27 => 0x1d },
	'gpsdestbearing' => { 27 => 0x18, 71 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 27 => 0x17, 71 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 27 => 0x1a, 71 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 27 => 0x19, 71 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 27 => 0x14, 71 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 27 => 0x13 },
	'gpsdestlongitude' => { 27 => 0x16, 71 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 27 => 0x15 },
	'gpsdifferential' => { 27 => 0x1e, 71 => 'GPSDifferential' },
	'gpsdop' => { 27 => 0xb, 71 => 'GPSDOP' },
	'gpsimgdirection' => { 27 => 0x11, 71 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 27 => 0x10, 71 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 27 => 0x2, 71 => 'GPSLatitude' },
	'gpslatituderef' => { 27 => 0x1 },
	'gpslongitude' => { 27 => 0x4, 71 => 'GPSLongitude' },
	'gpslongituderef' => { 27 => 0x3 },
	'gpsmapdatum' => { 27 => 0x12, 71 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 27 => 0xa, 71 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 27 => 0x1b, 71 => 'GPSProcessingMethod' },
	'gpssatellites' => { 27 => 0x8, 71 => 'GPSSatellites' },
	'gpsspeed' => { 27 => 0xd, 71 => 'GPSSpeed' },
	'gpsspeedref' => { 27 => 0xc, 71 => 'GPSSpeedRef' },
	'gpsstatus' => { 27 => 0x9, 71 => 'GPSStatus' },
	'gpstimestamp' => { 27 => 0x7, 71 => 'GPSTimeStamp' },
	'gpstrack' => { 27 => 0xf, 71 => 'GPSTrack' },
	'gpstrackref' => { 27 => 0xe, 71 => 'GPSTrackRef' },
	'gpsversionid' => { 27 => 0x0, 71 => 'GPSVersionID' },
	'gradation' => { 53 => 0x50f },
	'grayresponseunit' => { 24 => 0x122 },
	'greenhue' => { 68 => 'GreenHue' },
	'greensaturation' => { 68 => 'GreenSaturation' },
	'halftonehints' => { 24 => 0x141 },
	'headline' => { 28 => 0x69, 74 => 'Headline' },
	'highlight' => { 65 => 0xf },
	'historyaction' => { 78 => 'HistoryAction' },
	'historyinstanceid' => { 78 => 'HistoryInstanceID' },
	'historyparameters' => { 78 => 'HistoryParameters' },
	'historysoftwareagent' => { 78 => 'HistorySoftwareAgent' },
	'historywhen' => { 78 => 'HistoryWhen' },
	'hometowncity' => { 61 => 0x23 },
	'hometowncitycode' => { 61 => 0x1000 },
	'hometowndst' => { 61 => 0x25 },
	'hostcomputer' => { 24 => 0x13c },
	'hueadjustment' => { 41 => 0x92 },
	'icc_profile' => { 59 => ['Raw profile type icc','Raw profile type icm'] },
	'identifier' => { 69 => 'identifier', 76 => 'Identifier' },
	'imageadjustment' => { 41 => 0x80, 43 => 0x5 },
	'imageboundary' => { 41 => 0x16 },
	'imagedatasize' => { 41 => 0xa2 },
	'imagedescription' => { 24 => 0x10e, 75 => 'ImageDescription' },
	'imagedustoff' => { 49 => 0xfe443a45 },
	'imageheight' => { 24 => 0x101, 75 => 'ImageLength' },
	'imageoptimization' => { 41 => 0xa9 },
	'imageorientation' => { 28 => 0x83 },
	'imageprocessing' => { 57 => 0x2040 },
	'imageprocessingversion' => { 56 => 0x0 },
	'imagequality' => { 60 => 0x1 },
	'imagequality2' => { 53 => 0x603 },
	'imagestabilizer' => { 60 => 0x1a },
	'imagetype' => { 28 => 0x82 },
	'imageuniqueid' => { 24 => 0xa420, 71 => 'ImageUniqueID' },
	'imagewidth' => { 24 => 0x100, 75 => 'ImageWidth' },
	'inkset' => { 24 => 0x14c },
	'instructions' => { 74 => 'Instructions' },
	'intellectualgenre' => { 72 => 'IntellectualGenre' },
	'interchangecolorspace' => { 30 => 0x40 },
	'internalflash' => { 35 => 0x2b, 55 => 0x1208 },
	'interopindex' => { 24 => 0x1 },
	'interopversion' => { 24 => 0x2 },
	'intervallength' => { 35 => 0x10 },
	'intervalmode' => { 35 => 0x26 },
	'intervalnumber' => { 35 => 0x11 },
	'iptc-naa' => { 24 => 0x83bb },
	'iptc_profile' => { 59 => 'Raw profile type iptc' },
	'iptcbitspersample' => { 30 => 0x56 },
	'iptcimageheight' => { 30 => 0x1e },
	'iptcimagerotation' => { 30 => 0x66 },
	'iptcimagewidth' => { 30 => 0x14 },
	'iptcpicturenumber' => { 30 => 0xa },
	'iptcpixelheight' => { 30 => 0x32 },
	'iptcpixelwidth' => { 30 => 0x28 },
	'iso' => { 10 => 0x2, 22 => 0x14, 24 => 0x8827, 31 => 0x60, 33 => 0x4e, 41 => 0x2, 61 => 0x14, 71 => 'ISOSpeedRatings' },
	'isoexpansion' => { 13 => 0x7 },
	'isoselection' => { 41 => 0xf },
	'isosetting' => { 31 => 0x5e, 35 => 0x24, 41 => 0x13 },
	'isospeedexpansion' => { 12 => 0x3 },
	'ixusafpoint' => { 10 => 0xe },
	'jobid' => { 28 => 0xb8 },
	'jobrefid' => { 77 => 'JobRefId' },
	'jobrefname' => { 77 => 'JobRefName' },
	'jobrefurl' => { 77 => 'JobRefUrl' },
	'jpgfromraw' => { 18 => 0x2007, 23 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 24 => 0x202 },
	'jpgfromrawstart' => { 24 => 0x201 },
	'keywords' => { 28 => 0x19, 73 => 'Keywords' },
	'kodakimageheight' => { 31 => 0xe, 32 => 0x70 },
	'kodakimagewidth' => { 31 => 0xc, 32 => 0x6c },
	'kodakmaker' => { 32 => 0x8 },
	'kodakmodel' => { 31 => 0x0, 32 => 0x28 },
	'label' => { 59 => 'Label', 76 => 'Label' },
	'language' => { 69 => 'language' },
	'languageidentifier' => { 28 => 0x87 },
	'lastfilenumber' => { 35 => 0x1b },
	'lasturl' => { 78 => 'LastURL' },
	'lcdpanels' => { 12 => 0x8 },
	'lcheditor' => { 49 => 0x8ae85e },
	'lens' => { 24 => 0xfdea, 41 => 0x84, 65 => 0xa, 66 => 'Lens' },
	'lensafstopbutton' => { 11 => 0x11, 12 => 0x13, 13 => 0x10, 14 => 0x9 },
	'lensdata0100' => { 41 => 0x98 },
	'lensdata0101' => { 41 => 0x98 },
	'lensdata0201' => { 41 => 0x98 },
	'lensdataversion' => { 40 => 0x0 },
	'lensfirmwareversion' => { 54 => 0x204 },
	'lensfstops' => { 40 => 0x7, 41 => 0x8b },
	'lensid' => { 36 => 0x10c, 40 => 0x6 },
	'lensserialnumber' => { 54 => 0x202 },
	'lenstype' => { 0 => 0x16, 5 => 0xd, 41 => 0x83, 54 => 0x201, 61 => 0x3f },
	'license' => { 67 => 'license' },
	'licensetype' => { 70 => 'licensetype' },
	'lightsource' => { 24 => 0x9208, 41 => 0x90, 71 => 'LightSource' },
	'lightsourcespecial' => { 64 => 0x21d },
	'linearresponselimit' => { 24 => 0xc62e },
	'localcaption' => { 28 => 0x79 },
	'localizedcameramodel' => { 24 => 0xc615 },
	'location' => { 72 => 'Location' },
	'longexposurenoisereduction' => { 13 => 0x1, 14 => 0x1 },
	'longfocal' => { 0 => 0x17, 5 => 0x14 },
	'luminancesmoothing' => { 68 => 'LuminanceSmoothing' },
	'macro' => { 26 => 0x1020, 57 => 0x202, 64 => 0x202 },
	'macromode' => { 0 => 0x1, 35 => 0xb, 53 => 0x300, 60 => 0x1c },
	'make' => { 19 => 0x0, 24 => 0x10f, 59 => 'Make', 75 => 'Make' },
	'makernote' => { 71 => 'MakerNote' },
	'makernotecanon' => { 24 => 0x927c },
	'makernotecasio' => { 24 => 0x927c },
	'makernotecasio2' => { 24 => 0x927c },
	'makernotefujifilm' => { 24 => 0x927c },
	'makernotejvc' => { 24 => 0x927c },
	'makernotejvctext' => { 24 => 0x927c },
	'makernotekodak1a' => { 24 => 0x927c },
	'makernotekodak1b' => { 24 => 0x927c },
	'makernotekodak2' => { 24 => 0x927c },
	'makernotekodak3' => { 24 => 0x927c },
	'makernotekodak4' => { 24 => 0x927c },
	'makernotekodak5' => { 24 => 0x927c },
	'makernotekodak6a' => { 24 => 0x927c },
	'makernotekodak6b' => { 24 => 0x927c },
	'makernotekodakunknown' => { 24 => 0x927c },
	'makernotekyocera' => { 24 => 0x927c },
	'makernoteleica' => { 24 => 0x927c },
	'makernoteminolta' => { 24 => 0x927c },
	'makernotenikon' => { 24 => 0x927c },
	'makernotenikon2' => { 24 => 0x927c },
	'makernotenikon3' => { 24 => 0x927c },
	'makernoteoffset' => { 64 => 0xff },
	'makernoteolympus' => { 24 => 0x927c },
	'makernotepanasonic' => { 24 => 0x927c },
	'makernotepentax' => { 24 => 0x927c },
	'makernotericoh' => { 24 => 0x927c },
	'makernotericohtext' => { 24 => 0x927c },
	'makernotesafety' => { 24 => 0xc635 },
	'makernotesanyo' => { 24 => 0x927c },
	'makernotesigma' => { 24 => 0x927c },
	'makernotesony' => { 24 => 0x927c },
	'makernotesonysrf' => { 24 => 0x927c },
	'makernotetype' => { 63 => 0x1 },
	'makernoteunknown' => { 24 => 0x927c },
	'makernoteversion' => { 36 => 0x0, 57 => 0x0, 63 => 0x2 },
	'managedfromdocumentid' => { 78 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 78 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 78 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 78 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 78 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 78 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 78 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 78 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 78 => 'ManagedFromVersionID' },
	'manager' => { 78 => 'Manager' },
	'managervariant' => { 78 => 'ManagerVariant' },
	'manageto' => { 78 => 'ManageTo' },
	'manageui' => { 78 => 'ManageUI' },
	'manualfocusdistance' => { 41 => 0x85, 64 => 0x223 },
	'manualtv' => { 12 => 0x5 },
	'marked' => { 80 => 'Marked' },
	'maskedareas' => { 24 => 0xc68e },
	'masterdocumentid' => { 28 => 0xb9 },
	'maxaperture' => { 0 => 0x1a, 35 => 0x17 },
	'maxapertureatmaxfocal' => { 40 => 0xb, 54 => 0x206 },
	'maxapertureatminfocal' => { 40 => 0xa },
	'maxaperturevalue' => { 24 => 0x9205, 71 => 'MaxApertureValue' },
	'maxfocallength' => { 40 => 0x9, 54 => 0x208 },
	'maximumdensityrange' => { 30 => 0x8c },
	'maxpagesizeh' => { 81 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 81 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 81 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 24 => 0x119 },
	'mcuversion' => { 40 => 0xc },
	'measuredev' => { 18 => 0x1814 },
	'menubuttondisplayposition' => { 11 => 0xb, 13 => 0xa },
	'menubuttonreturn' => { 14 => 0xb },
	'metadatadate' => { 76 => 'MetadataDate' },
	'meteringmode' => { 0 => 0x11, 24 => 0x9207, 31 => 0x1c, 35 => 0x7, 53 => 0x202, 61 => 0x17, 65 => 0x9, 71 => 'MeteringMode' },
	'minfocallength' => { 40 => 0x8, 54 => 0x207 },
	'minoltaaperture' => { 35 => 0xa },
	'minoltacamerasettings' => { 36 => 0x3, 57 => 0x3 },
	'minoltacamerasettingsold' => { 36 => 0x1, 57 => 0x1 },
	'minoltadate' => { 35 => 0x15 },
	'minoltaimagesize' => { 35 => 0x4, 36 => 0x103 },
	'minoltaiso' => { 35 => 0x8 },
	'minoltamodel' => { 35 => 0x25 },
	'minoltaquality' => { 35 => 0x5, 36 => [0x102,0x103], 57 => [0x102,0x103] },
	'minoltashutterspeed' => { 35 => 0x9 },
	'minoltatime' => { 35 => 0x16 },
	'minsamplevalue' => { 24 => 0x118 },
	'mirrorlockup' => { 11 => 0xc, 12 => 0xc, 13 => 0xb, 14 => 0x3 },
	'moddate' => { 73 => 'ModDate' },
	'model' => { 19 => 0x6, 24 => 0x110, 59 => 'Model', 75 => 'Model' },
	'modifiedsaturation' => { 53 => 0x504 },
	'modifydate' => { 24 => 0x132, 76 => 'ModifyDate' },
	'moirefilter' => { 24 => 0xfe58 },
	'monthdaycreated' => { 31 => 0x12, 33 => 0xe },
	'nefthumbnailsize' => { 41 => 0x99 },
	'newsphotoversion' => { 30 => 0x0 },
	'nickname' => { 76 => 'Nickname' },
	'nikoncaptureversion' => { 41 => 0xe09 },
	'nikonpreview' => { 41 => 0x11 },
	'noisefilter2' => { 56 => 0x1010 },
	'noisereduction' => { 41 => 0x95, 49 => 0x753dcbc0, 53 => 0x50a, 60 => 0x2d },
	'noisereductionintensity' => { 50 => 0x9 },
	'noisereductionmethod' => { 50 => 0x11 },
	'noisereductionsharpness' => { 50 => 0xd },
	'npages' => { 81 => 'NPages' },
	'nullrecord' => { 18 => 0x0 },
	'numindexentries' => { 30 => 0x54 },
	'objectattributereference' => { 28 => 0x4 },
	'objectcycle' => { 28 => 0x4b },
	'objectdistance' => { 21 => 0x6, 22 => 0x2022 },
	'objectname' => { 28 => 0x5 },
	'objectpreviewdata' => { 28 => 0xca },
	'objectpreviewfileformat' => { 28 => 0xc8 },
	'objectpreviewfileversion' => { 28 => 0xc9 },
	'objecttypereference' => { 28 => 0x3 },
	'oecfcolumns' => { 71 => 'OECFColumns' },
	'oecfnames' => { 71 => 'OECFNames' },
	'oecfrows' => { 71 => 'OECFRows' },
	'oecfvalues' => { 71 => 'OECFValues' },
	'oldsubfiletype' => { 24 => 0xff },
	'olympusimageheight' => { 57 => 0x102f },
	'olympusimageheight2' => { 56 => 0x615 },
	'olympusimagewidth' => { 57 => 0x102e },
	'olympusimagewidth2' => { 56 => 0x614 },
	'onetouchwb' => { 57 => 0x302 },
	'opticalzoomon' => { 64 => 0x219 },
	'orientation' => { 24 => 0x112, 75 => 'Orientation' },
	'originalfilename' => { 18 => 0x816, 34 => 0x20 },
	'originalrawfiledata' => { 24 => 0xc68c },
	'originalrawfilename' => { 24 => 0xc68b },
	'originaltransmissionreference' => { 28 => 0x67 },
	'originatingprogram' => { 28 => 0x41 },
	'os' => { 70 => 'os' },
	'outputheight' => { 46 => 0xce },
	'outputheightinches' => { 46 => 0x96 },
	'outputpixels' => { 46 => 0xd6 },
	'outputresolution' => { 46 => 0xb6 },
	'outputwidth' => { 46 => 0xc6 },
	'outputwidthinches' => { 46 => 0x8e },
	'owner' => { 80 => 'Owner' },
	'ownerid' => { 28 => 0xbc },
	'ownername' => { 6 => 0x9, 18 => 0x810, 24 => 0xfde8 },
	'pagename' => { 24 => 0x11d },
	'pagenumber' => { 24 => 0x129 },
	'panoramadirection' => { 7 => 0x5 },
	'panoramaframe' => { 7 => 0x2 },
	'panoramamode' => { 31 => 0x3c },
	'pdfversion' => { 73 => 'PDFVersion' },
	'pentaximagesize' => { 61 => 0x9 },
	'pentaxmode' => { 61 => 0x1 },
	'photoeffects' => { 49 => 0xab5eca5e },
	'photoeffectsblue' => { 51 => 0x8 },
	'photoeffectsgreen' => { 51 => 0x6 },
	'photoeffectsred' => { 51 => 0x4 },
	'photoeffectstype' => { 51 => 0x0 },
	'photometricinterpretation' => { 24 => 0x106, 75 => 'PhotometricInterpretation' },
	'pictinfo' => { 64 => 0x208 },
	'picturemode' => { 26 => 0x1031, 61 => 0xb },
	'planarconfiguration' => { 24 => 0x11c, 75 => 'PlanarConfiguration' },
	'pngwarning' => { 59 => 'Warning' },
	'precaptureframes' => { 57 => 0x300 },
	'predictor' => { 24 => 0x13d },
	'previewfocalplanexresolution' => { 9 => 0x6 },
	'previewfocalplaneyresolution' => { 9 => 0x8 },
	'previewimage' => { 22 => 0x2000, 23 => 'PreviewImage', 24 => 0x927c, 36 => 0x81 },
	'previewimagedata' => { 61 => 0x2000 },
	'previewimageheight' => { 9 => 0x4 },
	'previewimagelength' => { 9 => 0x2, 22 => 0x3, 24 => [0x117,0x202], 36 => 0x89, 42 => 0x202, 53 => 0x102, 57 => 0x1037, 61 => 0x3 },
	'previewimagesize' => { 22 => 0x2, 61 => 0x2 },
	'previewimagestart' => { 9 => 0x5, 22 => 0x4, 24 => [0x111,0x201], 36 => 0x88, 42 => 0x201, 53 => 0x101, 57 => 0x1036, 61 => 0x4 },
	'previewimagevalid' => { 53 => 0x100, 57 => 0x1035 },
	'previewimagewidth' => { 9 => 0x3 },
	'primarychromaticities' => { 24 => 0x13f, 75 => 'PrimaryChromaticities' },
	'printim' => { 21 => 0xe00, 24 => 0xc4a5 },
	'producer' => { 73 => 'Producer' },
	'productid' => { 29 => 0x32 },
	'programversion' => { 28 => 0x46 },
	'province-state' => { 28 => 0x5f },
	'publisher' => { 69 => 'publisher' },
	'quality' => { 0 => 0x3, 21 => 0x2, 22 => 0x3002, 26 => 0x1000, 31 => 0x9, 41 => 0x4, 43 => 0x3, 57 => 0x201, 61 => 0x8, 65 => 0x16 },
	'qualitymode' => { 22 => 0x8 },
	'quantizationmethod' => { 30 => 0x78 },
	'quickshot' => { 64 => 0x213 },
	'rasterizedcaption' => { 28 => 0x7d },
	'rating' => { 76 => 'Rating' },
	'rawandjpgrecording' => { 11 => 0x8 },
	'rawdevcolorspace' => { 58 => 0x108 },
	'rawdevcontrastvalue' => { 58 => 0x106 },
	'rawdeveditstatus' => { 58 => 0x10b },
	'rawdevelopment' => { 57 => 0x2030 },
	'rawdevengine' => { 58 => 0x109 },
	'rawdevexposurebiasvalue' => { 58 => 0x100 },
	'rawdevgraypoint' => { 58 => 0x103 },
	'rawdevmemorycoloremphasis' => { 58 => 0x105 },
	'rawdevnoisereduction' => { 58 => 0x10a },
	'rawdevsaturationemphasis' => { 58 => 0x104 },
	'rawdevsettings' => { 58 => 0x10c },
	'rawdevsharpnessvalue' => { 58 => 0x107 },
	'rawdevversion' => { 58 => 0x0 },
	'rawdevwbfineadjustment' => { 58 => 0x102 },
	'rawdevwhitebalancevalue' => { 58 => 0x101 },
	'rawfile' => { 24 => 0xfe4c },
	'rawfilename' => { 68 => 'RawFileName' },
	'rawimagesize' => { 61 => 0x39 },
	'recordid' => { 18 => 0x1804 },
	'recordingmode' => { 21 => 0x1 },
	'recordmode' => { 22 => 0x3000 },
	'recordshutterrelease' => { 64 => 0x217 },
	'redbalance' => { 37 => 0x0, 38 => 0x0, 39 => 0x0, 57 => 0x1017, 61 => 0x1c },
	'redbluebias' => { 56 => 0x100 },
	'redhue' => { 68 => 'RedHue' },
	'redsaturation' => { 68 => 'RedSaturation' },
	'referenceblackwhite' => { 24 => 0x214, 75 => 'ReferenceBlackWhite' },
	'referencedate' => { 28 => 0x2f },
	'referencenumber' => { 28 => 0x32 },
	'referenceservice' => { 28 => 0x2d },
	'relatedimagelength' => { 24 => 0x1002 },
	'relatedimagewidth' => { 24 => 0x1001 },
	'relatedsoundfile' => { 24 => 0xa004, 71 => 'RelatedSoundFile' },
	'relation' => { 69 => 'relation' },
	'releasedate' => { 28 => 0x1e },
	'releasesetting' => { 18 => 0x1016 },
	'releasetime' => { 28 => 0x23 },
	'renditionclass' => { 78 => 'RenditionClass' },
	'renditionofdocumentid' => { 78 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 78 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 78 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 78 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 78 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 78 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 78 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 78 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 78 => 'RenditionOfVersionID' },
	'renditionparams' => { 78 => 'RenditionParams' },
	'resaved' => { 64 => 0x21e },
	'resolutionmode' => { 65 => 0x4 },
	'resolutionunit' => { 24 => 0x128, 75 => 'ResolutionUnit' },
	'reuseallowed' => { 79 => 'ReuseAllowed' },
	'revision' => { 70 => 'revision' },
	'ricohrr1subdir' => { 63 => 0x2001 },
	'ricohsubdir' => { 63 => 0x2001 },
	'rights' => { 69 => 'rights' },
	'romoperationmode' => { 18 => 0x80d },
	'rotation' => { 49 => 0x76a43207 },
	'rowsperstrip' => { 24 => 0x116 },
	'safetyshiftinavortv' => { 11 => 0x10, 12 => 0x10, 13 => 0xf },
	'samplesperpixel' => { 24 => 0x115, 75 => 'SamplesPerPixel' },
	'samplestructure' => { 30 => 0x5a },
	'sanyoquality' => { 64 => 0x201 },
	'sanyothumbnail' => { 64 => 0x100 },
	'saturation' => { 0 => 0xe, 21 => 0xd, 22 => 0x1f, 24 => [0xa409,0xfe55], 26 => 0x1003, 35 => 0x1f, 41 => [0x94,0xaa], 61 => 0x1f, 65 => 0x10, 68 => 'Saturation', 71 => 'Saturation' },
	'saveid' => { 78 => 'SaveID' },
	'scaledresolution' => { 46 => 0x9e },
	'scanningdirection' => { 30 => 0x64 },
	'scene' => { 72 => 'Scene' },
	'scenecapturetype' => { 24 => 0xa406, 71 => 'SceneCaptureType' },
	'scenemode' => { 41 => 0x8f, 53 => 0x509 },
	'sceneselect' => { 64 => 0x21f },
	'scenetype' => { 24 => 0xa301, 71 => 'SceneType' },
	'self-timer' => { 0 => 0x2 },
	'self-timer2' => { 10 => 0x1d },
	'selftimer' => { 22 => 0x3001, 64 => 0x214 },
	'selftimermode' => { 24 => 0x882b },
	'selftimertime' => { 18 => 0x1806 },
	'sensingmethod' => { 24 => 0xa217, 71 => 'SensingMethod' },
	'sensorcleaning' => { 14 => 0xd },
	'sensorpixelsize' => { 41 => 0x9a },
	'sequence' => { 53 => 0x600 },
	'sequencenumber' => { 10 => 0x9, 31 => 0x1d },
	'sequenceshotinterval' => { 64 => 0x224 },
	'sequentialshot' => { 64 => 0x20e },
	'serialnumber' => { 6 => 0xc, 18 => 0x180b, 24 => 0xfde9, 41 => 0xa0, 54 => 0x101, 57 => [0x404,0x101a], 60 => 0x25, 65 => 0x2, 66 => 'SerialNumber' },
	'serviceidentifier' => { 29 => 0x1e },
	'setbuttonfunction' => { 11 => 0x1, 14 => 0xc },
	'setfunctionwhenshooting' => { 13 => 0x0 },
	'shadingcompensation' => { 53 => 0x50c },
	'shadingcompensation2' => { 56 => 0x1012 },
	'shadow' => { 65 => 0xe },
	'shadows' => { 24 => 0xfe52, 68 => 'Shadows' },
	'shadowscale' => { 24 => 0xc633 },
	'shadowtint' => { 68 => 'ShadowTint' },
	'sharpness' => { 0 => 0xf, 21 => 0xb, 22 => 0x21, 24 => [0xa40a,0xfe56], 26 => 0x1001, 31 => 0x6b, 33 => 0x37, 35 => 0x21, 41 => 0x6, 61 => 0x21, 65 => 0x11, 68 => 'Sharpness', 71 => 'Sharpness' },
	'sharpnessfactor' => { 57 => 0x102a },
	'sharpnesssetting' => { 53 => 0x506 },
	'shootingmode' => { 41 => 0x89, 60 => 0x1f },
	'shortdescription' => { 70 => 'shortdescription' },
	'shortdocumentid' => { 28 => 0xba },
	'shortfocal' => { 0 => 0x18, 5 => 0x12 },
	'shutter-aelock' => { 11 => 0x4, 13 => 0x3, 14 => 0x2 },
	'shutteraelbutton' => { 12 => 0x4 },
	'shuttercount' => { 3 => 0x1 },
	'shuttercurtainsync' => { 11 => 0xf, 12 => 0xf, 13 => 0xe, 14 => 0x8 },
	'shuttermode' => { 31 => 0x1b },
	'shutterreleasemethod' => { 18 => 0x1010 },
	'shutterreleasenocfcard' => { 11 => 0x2, 12 => 0x2, 14 => 0xf },
	'shutterreleasetiming' => { 18 => 0x1011 },
	'shutterspeedvalue' => { 24 => 0x9201, 71 => 'ShutterSpeedValue' },
	'similarityindex' => { 28 => 0xe4 },
	'slowsync' => { 26 => 0x1030 },
	'smoothingparameter1' => { 56 => 0x300 },
	'smoothingparameter2' => { 56 => 0x310 },
	'smoothingthreshold2' => { 56 => 0x610 },
	'smoothingthresholds' => { 56 => 0x600 },
	'smoothness' => { 24 => 0xfe57 },
	'software' => { 24 => 0x131, 59 => 'Software', 65 => 0x18, 75 => 'Software' },
	'softwareversion' => { 64 => 0x207 },
	'source' => { 28 => 0x73, 59 => 'Source', 69 => 'source', 74 => 'Source' },
	'sourceresolution' => { 46 => 0xae },
	'spatialfrequencyresponsecolumns' => { 71 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 71 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 71 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 71 => 'SpatialFrequencyResponseValues' },
	'specialinstructions' => { 28 => 0x28 },
	'specialmode' => { 57 => 0x200, 64 => 0x200 },
	'spectralsensitivity' => { 24 => 0x8824, 71 => 'SpectralSensitivity' },
	'spotfocuspointx' => { 35 => 0x2d },
	'spotfocuspointy' => { 35 => 0x2e },
	'spotmode' => { 60 => 0xf },
	'state' => { 74 => 'State' },
	'sub-location' => { 28 => 0x5c },
	'subfiletype' => { 24 => 0xfe },
	'subject' => { 69 => 'subject' },
	'subjectarea' => { 71 => 'SubjectArea' },
	'subjectcode' => { 72 => 'SubjectCode' },
	'subjectdistance' => { 24 => 0x9206, 31 => 0x3e, 71 => 'SubjectDistance' },
	'subjectdistancerange' => { 24 => 0xa40c, 71 => 'SubjectDistanceRange' },
	'subjectlocation' => { 24 => [0x9214,0xa214], 71 => 'SubjectLocation' },
	'subjectprogram' => { 35 => 0x22 },
	'subjectreference' => { 28 => 0xc },
	'subsectime' => { 24 => 0x9290 },
	'subsectimedigitized' => { 24 => 0x9292 },
	'subsectimeoriginal' => { 24 => 0x9291 },
	'superimposeddisplay' => { 11 => 0xa, 13 => 0x9, 14 => 0xe },
	'supplementalcategories' => { 28 => 0x14, 74 => 'SupplementalCategories' },
	'supplementaltype' => { 30 => 0x37 },
	'switchtoregisteredafpoint' => { 12 => 0x12 },
	'targetaperture' => { 10 => 0x4 },
	'targetcompressionratio' => { 17 => 0x1 },
	'targetdistancesetting' => { 18 => 0x1807 },
	'targetexposuretime' => { 10 => 0x5 },
	'targetimagetype' => { 18 => 0x100a },
	'textinfo' => { 57 => 0x208 },
	'thresholding' => { 24 => 0x107 },
	'thumbnailfilename' => { 18 => 0x817 },
	'thumbnailimage' => { 18 => 0x2008, 23 => 'ThumbnailImage', 57 => 0x100 },
	'thumbnaillength' => { 24 => 0x202 },
	'thumbnailoffset' => { 24 => 0x201 },
	'thumbnailsformat' => { 76 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 76 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 76 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 76 => 'ThumbnailsWidth' },
	'tilelength' => { 24 => 0x143 },
	'tilewidth' => { 24 => 0x142 },
	'time' => { 61 => 0x7 },
	'timecreated' => { 28 => 0x3c, 31 => 0x14, 33 => 0x10 },
	'timesent' => { 29 => 0x50 },
	'timestamp' => { 59 => 'TimeStamp' },
	'timezone' => { 22 => 0x3006 },
	'timezonecode' => { 20 => 0x1 },
	'timezoneinfo' => { 20 => 0x2 },
	'timezoneoffset' => { 24 => 0x882a },
	'title' => { 59 => 'Title', 69 => 'title' },
	'tonecomp' => { 41 => 0x81 },
	'tonecurve' => { 61 => 0x402 },
	'tonecurves' => { 61 => 0x403 },
	'totalzoom' => { 31 => 0x62 },
	'transferfunction' => { 75 => 'TransferFunction' },
	'transmissionreference' => { 74 => 'TransmissionReference' },
	'tvvalue' => { 15 => 0x1 },
	'type' => { 69 => 'type' },
	'uniquecameramodel' => { 24 => 0xc614 },
	'uniquedocumentid' => { 28 => 0xbb },
	'uniqueobjectname' => { 29 => 0x64 },
	'unsharp1color' => { 52 => 0x13 },
	'unsharp1halowidth' => { 52 => 0x19 },
	'unsharp1intensity' => { 52 => 0x17 },
	'unsharp1threshold' => { 52 => 0x1b },
	'unsharp2color' => { 52 => 0x2e },
	'unsharp2halowidth' => { 52 => 0x34 },
	'unsharp2intensity' => { 52 => 0x32 },
	'unsharp2threshold' => { 52 => 0x36 },
	'unsharp3color' => { 52 => 0x49 },
	'unsharp3halowidth' => { 52 => 0x4f },
	'unsharp3intensity' => { 52 => 0x4d },
	'unsharp3threshold' => { 52 => 0x51 },
	'unsharp4color' => { 52 => 0x64 },
	'unsharp4halowidth' => { 52 => 0x6a },
	'unsharp4intensity' => { 52 => 0x68 },
	'unsharp4threshold' => { 52 => 0x6c },
	'unsharpcount' => { 52 => 0x0 },
	'unsharpmask' => { 49 => 0x76a43200 },
	'urgency' => { 28 => 0xa, 74 => 'Urgency' },
	'url' => { 59 => 'URL', 62 => 0x40b },
	'usageterms' => { 80 => 'UsageTerms' },
	'usercomment' => { 18 => 0x805, 24 => 0x9286, 71 => 'UserComment' },
	'usmlenselectronicmf' => { 12 => 0x7 },
	'validbits' => { 56 => 0x611, 57 => 0x102c },
	'variousmodes' => { 31 => 0x26 },
	'variousmodes2' => { 31 => 0x3a },
	'variprogram' => { 41 => 0xab },
	'version' => { 26 => 0x0, 68 => 'Version' },
	'versionid' => { 78 => 'VersionID' },
	'versionscomments' => { 78 => 'VersionsComments' },
	'versionseventaction' => { 78 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 78 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 78 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 78 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 78 => 'VersionsEventWhen' },
	'versionsmodifier' => { 78 => 'VersionsModifier' },
	'versionsmodifydate' => { 78 => 'VersionsModifyDate' },
	'versionsversion' => { 78 => 'VersionsVersion' },
	'vignetteamount' => { 68 => 'VignetteAmount' },
	'vignettecontrol' => { 49 => 0x76a43205 },
	'vignettecontrolintensity' => { 49 => 0xac6bd5c0 },
	'vignettemidpoint' => { 68 => 'VignetteMidpoint' },
	'voicememo' => { 64 => 0x216 },
	'webstatement' => { 80 => 'WebStatement' },
	'whitebalance' => { 10 => 0x7, 21 => 0x7, 22 => [0x19,0x2012], 24 => [0xa403,0xfe4e], 26 => 0x1002, 31 => 0x40, 35 => 0x3, 41 => 0x5, 43 => 0x7, 60 => 0x3, 61 => 0x19, 65 => 0x7, 68 => 'WhiteBalance', 71 => 'WhiteBalance' },
	'whitebalanceadj' => { 49 => 0x76a43204 },
	'whitebalancebias' => { 22 => 0x2011, 60 => 0x23 },
	'whitebalancebracket' => { 53 => 0x502 },
	'whitebalancefinetune' => { 41 => 0xb },
	'whitebalancemode' => { 61 => 0x1a },
	'whitebalancetemperature' => { 53 => 0x501 },
	'whitepoint' => { 24 => 0x13e, 61 => 0x201, 75 => 'WhitePoint' },
	'widefocuszone' => { 35 => 0x2f },
	'widerange' => { 64 => 0x20f },
	'worldtimelocation' => { 61 => 0x22 },
	'writer-editor' => { 28 => 0x7a },
	'x3filllight' => { 65 => 0x12 },
	'xmp' => { 25 => 'XMP' },
	'xmp_profile' => { 59 => 'Raw profile type xmp' },
	'xpauthor' => { 24 => 0x9c9d },
	'xpcomment' => { 24 => 0x9c9c },
	'xpkeywords' => { 24 => 0x9c9e },
	'xposition' => { 24 => 0x11e },
	'xpsubject' => { 24 => 0x9c9f },
	'xptitle' => { 24 => 0x9c9b },
	'xresolution' => { 24 => 0x11a, 75 => 'XResolution' },
	'ycbcrcoefficients' => { 24 => 0x211, 75 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 24 => 0x213 },
	'ycbcrsubsampling' => { 24 => 0x212, 75 => 'YCbCrSubSampling' },
	'yearcreated' => { 31 => 0x10, 33 => 0xc },
	'yposition' => { 24 => 0x11f },
	'yresolution' => { 24 => 0x11b, 75 => 'YResolution' },
	'zoomedresolution' => { 0 => 0x24 },
	'zoomedresolutionbase' => { 0 => 0x25 },
	'zoomposition' => { 55 => 0x300 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'adobephotoshop' => 1,
	'afaperture' => 1,
	'album' => 1,
	'albumsortorder' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphasample' => 1,
	'analogbalance' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'applicationnotes' => 1,
	'archivallocation' => 1,
	'artisturl' => 1,
	'asshoticcprofile' => 1,
	'asshotneutral' => 1,
	'asshotpreprofilematrix' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'aux' => 1,
	'avgbytespersec' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'band' => 1,
	'basisobject' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitdepth' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blueadjust' => 1,
	'bluebalanceauto' => 1,
	'bluebalanceb&w' => 1,
	'bluebalancecloudy' => 1,
	'bluebalancecustom' => 1,
	'bluebalancedaylight' => 1,
	'bluebalanceflash' => 1,
	'bluebalancefluorescent' => 1,
	'bluebalanceshade' => 1,
	'bluebalancetungsten' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'calibrationdatetime' => 1,
	'camerabacktype' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofile' => 1,
	'cameraprofileversion' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canoncolorinfod30' => 1,
	'canoncustomfunctions10d' => 1,
	'canoncustomfunctions1d' => 1,
	'canoncustomfunctions20d' => 1,
	'canoncustomfunctionsd30' => 1,
	'canonfileinfo' => 1,
	'canonflashinfo' => 1,
	'canonfocallength' => 1,
	'canonlensinfo1d' => 1,
	'canonpanorama' => 1,
	'canonpictureinfo' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colormatrix2' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortype' => 1,
	'comments' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'compilation' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composer' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressedtext' => 1,
	'compressor' => 1,
	'compressorid' => 1,
	'concreteflag' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'consecutivebadfaxlines' => 1,
	'contake' => 1,
	'contiguouscodestream' => 1,
	'copyrighturl' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'currenticcprofile' => 1,
	'currentpreprofilematrix' => 1,
	'currenttime' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datareference' => 1,
	'datatype' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dealeridnumber' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'directory' => 1,
	'discardobjects' => 1,
	'displayedunitsx' => 1,
	'displayedunitsy' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'dngprivatedata' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'duration' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectivemaxaperture' => 1,
	'effectsvisible' => 1,
	'encodedby' => 1,
	'encodersettings' => 1,
	'encoding' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'engineer' => 1,
	'epsoptions' => 1,
	'error' => 1,
	'exif' => 1,
	'exifinfo' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposureinfo' => 1,
	'extrasamples' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'filename' => 1,
	'fileowner' => 1,
	'filerul' => 1,
	'filesize' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmcategory' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmsize' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flashinfo' => 1,
	'flashon' => 1,
	'focallength35efl' => 1,
	'focuspos' => 1,
	'for' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'gamut' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'genre' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'globalaltitude' => 1,
	'globalangle' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'gpsdatetime' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'grouping' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'hasicc' => 1,
	'hcusage' => 1,
	'header' => 1,
	'headerext' => 1,
	'highlightendpoints' => 1,
	'hyperfocaldistance' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'imagebounds' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imagehistory' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagenumber' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesize' => 1,
	'imagesourcedata' => 1,
	'imagesourceek' => 1,
	'imagestabilization' => 1,
	'imagestatus' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'info' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner ' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc-naa2' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'it8header' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'jfifversion' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'kids' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensaperturerange' => 1,
	'lensdataunknown' => 1,
	'lensfocalrange' => 1,
	'lensspec' => 1,
	'lightness' => 1,
	'lights' => 1,
	'linearizationtable' => 1,
	'list' => 1,
	'localdeltatype' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loop' => 1,
	'loopstyle' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maximumobjectsize' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mdat' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediadata' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'metadata' => 1,
	'metadatanumber' => 1,
	'mimetype' => 1,
	'minf' => 1,
	'minoltacamerasettings2' => 1,
	'mngheader' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modenumber' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'multiquality' => 1,
	'musiciancredits' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'namelength' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nefcurve1' => 1,
	'nefcurve2' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'npts' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'opacity' => 1,
	'opiproxy' => 1,
	'opticalzoom' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'originalalbum' => 1,
	'originalartist' => 1,
	'originallyricist' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pages' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pentaxtags' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'photoeffectsdata' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopquality' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'picture' => 1,
	'pieceinfo' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'planes' => 1,
	'play counter' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'properties' => 1,
	'protect' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'quickmaskinfo' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdatarotation' => 1,
	'rawdatauniqueid' => 1,
	'rawimagemode' => 1,
	'readerrequirements' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'redadjust' => 1,
	'redbalanceauto' => 1,
	'redbalanceb&w' => 1,
	'redbalancecloudy' => 1,
	'redbalancecustom' => 1,
	'redbalancedaylight' => 1,
	'redbalanceflash' => 1,
	'redbalancefluorescent' => 1,
	'redbalanceshade' => 1,
	'redbalancetungsten' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'relatedimagefile' => 1,
	'relatedimagefileformat' => 1,
	'renderingintent' => 1,
	'requirements' => 1,
	'resolution' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'rgb_profile' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'sampleformat' => 1,
	'samplerate' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalefactor35efl' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'securityclassification' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sensorbottomborder' => 1,
	'sensorheight' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortemperature' => 1,
	'sensortopborder' => 1,
	'sensorwidth' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'significantbits' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spothalftone' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stbl' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stonits' => 1,
	'stream' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd_offset' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtitle' => 1,
	'suggestedpalette' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'textualdata' => 1,
	'thumbnailresource' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timescale' => 1,
	'titlesortorder' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'topmag' => 1,
	'track' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapped' => 1,
	'ucrbg' => 1,
	'unicodealphanames' => 1,
	'units' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'uuid-geojp2' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'vendorid' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'videocardgamma' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'whitebalancetable' => 1,
	'whitelevel' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'wide' => 1,
	'windowlocation' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmpbj' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        &$writeProc();
                        @infoList = GetTagInfoList($table,$tagID);
                    }
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
