# This Makefile.PL for JSON-Any was generated by
# inc::MakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.20.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Wrapper Class for the various JSON classes.",
  "AUTHOR" => "Chris Thompson <cthom\@cpan.org>, Chris Prather <chris\@prather.org>, Robin Berjon <robin\@berjon.com>, Marc Mims <marc\@questright.com>, Tomas Doran <bobtfish\@bobtfish.net>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "JSON-Any",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "JSON::Any",
  "PREREQ_PM" => {
    "Carp" => 0,
    "constant" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Data::Dumper" => 0,
    "Devel::StringInfo" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec::Functions" => 0,
    "List::Util" => 0,
    "Storable" => 0,
    "Test::Fatal" => 0,
    "Test::More" => 0,
    "Test::Requires" => 0,
    "Test::Warnings" => "0.009",
    "Test::Without::Module" => 0,
    "utf8" => 0,
    "version" => 0
  },
  "VERSION" => "1.33",
  "test" => {
    "TESTS" => "t/*.t"
  }
);
;


    sub has_json () {
        our @order = qw(CPANEL XS PP JSON DWIW);
        foreach my $testmod (@order) {
            $testmod = "JSON::$testmod" unless $testmod eq "JSON";
            $testmod = "Cpanel::JSON::XS" if $testmod eq "JSON::CPANEL";
            eval "require $testmod";
            return 1 unless $@;
        }
        return 0;
    }

    if (has_json) {
        # we have some kind of supported JSON module, we're good
    }
    else {
        # we need to have a version of JSON, go with JSON::PP as a sane default
        $WriteMakefileArgs{PREREQ_PM}{'JSON::PP'} = '0';
    }




my %FallbackPrereqs = (
  "Carp" => 0,
  "Data::Dumper" => 0,
  "Devel::StringInfo" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec::Functions" => 0,
  "List::Util" => 0,
  "Storable" => 0,
  "Test::Fatal" => 0,
  "Test::More" => 0,
  "Test::Requires" => 0,
  "Test::Warnings" => "0.009",
  "Test::Without::Module" => 0,
  "constant" => 0,
  "strict" => 0,
  "utf8" => 0,
  "version" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



