#!/usr/bin/perl -w
##

package Bundle::Modules::CPAN::Unstable;

use 5.005;

our $VERSION = 2006.0528; ## (YYYY.MMDD)

##
## Bundle::Modules::CPAN::Unstable
##

package main;

use strict;

use warnings;

require Shell;

require XML::Dumper;

require CPANPLUS::Backend;

require Bundle::Modules::Test::Reporter;

my $context = 'Bundle::Modules::CPAN::Unstable';

$context =~ m/::(\w)$/;

$context = lc( $1 );

$context = 'stable' if ( $context ne 'unstable' );

my $xml = XML::Dumper->new();

$xml->dtd();

my $sh = Shell->new();

my $plus = CPANPLUS::Backend->new( 'conf' => { 'no_update'  => 0,
                                                 'allow_build_interactivity' => 1,
                                                 'verbose' => 1,
                                               } );

my $conf = $plus->configure_object();

$conf->set_conf( 'force' => 0 );

my $perm = ( $conf->get_conf( 'cpantest' ) )? 'Y' : 'N';

$conf->set_conf( 'cpantest' => 0 );

$conf->set_conf( 'prereqs' => 3 ); ## follow

$conf->set_conf( 'signature' => 1 );

$conf->set_conf( 'skiptest' => 0 );

$conf->set_conf( 'timeout' => 1 );

if ( defined( $ENV{'TEST_POD'} ) && ( $ENV{'TEST_POD'} == 1 ) )
{

}
else
{
   $plus->reload_indices( 'update_source' => 1, 'verbose' => 1 );

} ## end if

eval
{
   local $SIG{'ALRM'} = sub { die( "alarm\n" ) };

   alarm 30;

   $perm = ExtUtils::MakeMaker::prompt( "May I report installation security and stability statistics, via email, about the installs performed on your system?", $perm );

   alarm 0;

}; ## end eval

if ( $@ )
{
   ##
   ## timeout
   ##
   die( $@ ) unless ( $@ eq "alarm\n" );

   $perm = 'y';

   print "\n";

} ## end if

if ( $perm =~ /^y/i )
{
   $perm = 1;

}
else
{
   $perm = 0;

} ## end if

my $reporter = Bundle::Modules::Test::Reporter->new(
   'grade' => 'unstable',
   'distribution' => 'TBD',
   'comments' => 'Generated by Bundle::Modules::CPAN::Unstable.',
   'via' => 'Bundle::Modules::CPAN::Unstable 2006.0528'

   );

my @module = ();



push( @module, 'MacPerl::AppleScript' );
push( @module, 'SAS::Parser' );
push( @module, 'Win32::File::Ver' );
push( @module, 'Win32::MIDI' );
push( @module, 'PDF::Xtract' );
push( @module, 'SVK' );
push( @module, 'Config::Objective' );
push( @module, 'AxKit::XSP::MD5' );
push( @module, 'Myco::Core::Person' );
push( @module, 'Win32::MMF' );
push( @module, 'Net::Subnet::Count' );
push( @module, 'Number::WithError::LaTeX' );
push( @module, 'BTRIEVE::Native' );
push( @module, 'Gtk2::Spell' );
push( @module, 'Business::CSI' );
push( @module, 'Win32::File::VersionInfo' );
push( @module, 'Mac::Apps::PBar' );
push( @module, 'Catalyst::Model::Xapian' );
push( @module, 'Joystick' );
push( @module, 'Class::DBI::DB2' );
push( @module, 'c_plus_plus' );
push( @module, 'AxKit::Provider::HTML' );
push( @module, 'DBD::TSM' );
push( @module, 'Pilot' );
push( @module, 'Win32::GUI::SplashScreen' );
push( @module, 'Catalyst::Model::DBIC' );
push( @module, 'Games::Go::SGF2misc' );
push( @module, 'Scripting' );
push( @module, 'DBIx::MSSQLReporter' );
push( @module, 'Video::Capture::V4l' );
push( @module, 'DBD::ADO' );
push( @module, 'Catalyst::Plugin::Authentication::Credential::Hatena' );
push( @module, 'forks::BerkeleyDB' );
push( @module, 'Data::Dumper' );
push( @module, 'Mail::MsgStore' );
push( @module, 'DateTime::Format::RSS' );
push( @module, 'Win32::Net::Session' );
push( @module, 'Net::OpenID::Consumer' );
push( @module, 'Astro::FITS::CFITSIO::Simple' );
push( @module, 'Curses::UI::DelimitedTextViewer' );
push( @module, 'POE::Component::Cron' );
push( @module, 'MIME::Lite::TT::Japanese' );
push( @module, 'Math::Vector' );
push( @module, 'CAM::Template' );
push( @module, 'Win32::GUI::Scintilla' );
push( @module, 'CAD::Drawing::IO::PostScript' );
push( @module, 'IO::KQueue' );
push( @module, 'CIAO::Lib::Param' );
push( @module, 'Mac::Carbon' );
push( @module, 'CGI::Untaint::hostname' );
push( @module, 'Lab::Instrument' );
push( @module, 'HTTP::ProxyPAC' );
push( @module, 'Hardware::Verilog::Parser' );
push( @module, 'Win32API::Registry' );
push( @module, 'Rudesind' );
push( @module, 'Pod::LaTeX::TPR' );
push( @module, 'Device::QuickCam' );
push( @module, 'WWW::Scraper::ISBN::TWYlib_Driver' );
push( @module, 'Image::Magick::Chart' );
push( @module, 'Locale::Framework::wxLocale' );
push( @module, 'Net::Address::IPv4::Local' );
push( @module, 'DynaPage::Document::ext::include' );
push( @module, 'GnuPG' );
push( @module, 'Mac::Apps::Launch' );
push( @module, 'Acme::Octarine' );
push( @module, 'Win32::TieRegistry' );
push( @module, 'Samba::LDAP' );
push( @module, 'Verity::Collection' );
push( @module, 'WWW::Blog::Metadata::AccountAutoDiscovery' );
push( @module, 'Gnome2::Vte' );
push( @module, 'CGI::AppBuilder::Frame' );
push( @module, 'Win32::SqlServer' );
push( @module, 'Authen::Krb5::KDB' );
push( @module, 'Movie::Info' );
push( @module, 'WWW::ImageSpool' );
push( @module, 'Plagger' );
push( @module, 'Image::DS9' );
push( @module, 'POE::Session::GladeXML2' );
push( @module, 'Lingua::MAF' );
push( @module, 'Benchmark::Harness' );
push( @module, 'CPAN::YACSmoke::Plugin::WebList' );
push( @module, 'SVK::Log::Filter::Babelfish' );
push( @module, 'Sys::Syslog' );
push( @module, 'Net::MDNS::Server' );
push( @module, 'IBM::LoadLeveler' );
push( @module, 'Games::Chess::Coverage' );
push( @module, 'Multimedia::SDP::SinisterSdp' );
push( @module, 'Gtk2::TrayIcon' );
push( @module, 'Authen::Bitcard' );
push( @module, 'Algorithm::RabinKarp' );
push( @module, 'Win32::SerialPort' );
push( @module, 'Acme::PGPSign' );
push( @module, 'URI::Fetch::SimpleCache' );
push( @module, 'HOP::Parser' );
push( @module, 'Class::Delay' );
push( @module, 'PDF::FDF::Simple' );
push( @module, 'Haver::Core' );
push( @module, 'PDL::IO::Grib' );
push( @module, 'Devel::Graph' );
push( @module, 'RT::Extension::ServiceUpdates' );
push( @module, 'Math::TrulyRandom' );
push( @module, 'HTTP::QuickBase' );
push( @module, 'Maypole::Redirect' );
push( @module, 'Net::FeedBurner' );
push( @module, 'SNMP::Multi' );
push( @module, 'CGI::Application::Plugin::Output::XSV' );
push( @module, 'File::Searcher' );
push( @module, 'Persistent::Sybase' );
push( @module, 'SVN::Notify' );
push( @module, 'Tk::Calculator::RPN::HP' );
push( @module, 'Db::Documentum' );
push( @module, 'Wx::Perl::Throbber' );
push( @module, 'Inline::WSC' );
push( @module, 'POE::Component::Spread' );
push( @module, 'Term::Sample' );
push( @module, 'Pogo' );
push( @module, 'Pipe' );
push( @module, 'Gnome2' );
push( @module, 'Win32::Font::NameToFile' );
push( @module, 'MCrypt' );
push( @module, 'AI::NeuralNet::Kohonen::Demo::RGB' );
push( @module, 'Authen::Simple::NIS' );
push( @module, 'Class::DBI::Loader::Sybase' );
push( @module, 'SetDualVar' );
push( @module, 'Net::BitTorrent::PeerPacket' );
push( @module, 'Geo::Coordinates::Convert' );
push( @module, 'WWW::WebStore::TinyURL' );
push( @module, 'Audio::MPC' );
push( @module, 'Dicop::Proxy' );
push( @module, 'Mail::Cclient' );
push( @module, 'Win32::NetName' );
push( @module, 'Wx::Perl::ListCtrl' );
push( @module, 'WWW::Shorten' );
push( @module, 'File::BSDGlob' );
push( @module, 'DBO' );
push( @module, 'CGI::Application::Framework' );
push( @module, 'Wais' );
push( @module, 'DBD::Illustra' );
push( @module, 'Persistent::LDAP' );
push( @module, 'Math::Matlab::Engine' );
push( @module, 'Geo::Coordinates::Parser' );
push( @module, 'Net::APP' );
push( @module, 'CGI::Application::Plugin::ViewSource' );
push( @module, 'Net::SXIP::Membersite' );
push( @module, 'WordNet::Similarity' );
push( @module, 'Tie::Cache::LRU::Expires' );
push( @module, 'DataFax' );
push( @module, 'MKDoc::Authz' );
push( @module, 'Log::Dispatch::Win32EventLog' );
push( @module, 'GraphViz::Zone' );
push( @module, 'punctuation' );
push( @module, 'CGI::XML' );
push( @module, 'IP::Unique' );
push( @module, 'Graph::Dependency' );
push( @module, 'Sub::ParamLoader' );
push( @module, 'Spread::Session' );
push( @module, 'NetAddr::IP::Count' );
push( @module, 'Net::NISplusTied' );
push( @module, 'Text::PORE' );
push( @module, 'Language::Homespring::Visualise::GraphViz' );
push( @module, 'Chart::Plot::Annotated' );
push( @module, 'Wx::SimplePlotter' );
push( @module, 'Image::RGBA' );
push( @module, 'Tie::LDAP' );
push( @module, 'XML::Generator::Win32OLETypeLib' );
push( @module, 'CORBA::ORBit' );
push( @module, 'Tie::Hash::Create' );
push( @module, 'Geo::TigerLine::Abbreviations' );
push( @module, 'Sub::ParamFrame' );
push( @module, 'HTTP::MessageParser' );
push( @module, 'Catalyst::Plugin::Unicode::Encoding' );
push( @module, 'ObjStore' );
push( @module, 'Storable' );
push( @module, 'AudioFile::Info::MP3::ID3Lib' );
push( @module, 'Finance::Bank::easybank' );
push( @module, 'Unicode::Collate' );
push( @module, 'Gtk2::Ex::Geo' );
push( @module, 'Teradata::SQL' );
push( @module, 'Solaris::loadavg' );
push( @module, 'DBD::Adabas' );
push( @module, 'AudioFile::Info::Ogg::Vorbis::Header' );
push( @module, 'Java::Build' );
push( @module, 'Inline::Befunge' );
push( @module, 'RTx::Shredder' );
push( @module, 'Festival::Client' );
push( @module, 'Net::Z3950::AsyncZ' );
push( @module, 'Win32::API' );
push( @module, 'Win32::MprApi' );
push( @module, 'WWW::Scraper::ISBN::TWTenlong_Driver' );
push( @module, 'Gtk2::Ex::VolumeButton' );
push( @module, 'String::Thai::Segmentation' );
push( @module, 'Getopt::Long' );
push( @module, 'Net::FreeDB' );
push( @module, 'Tie::Hash::KeysMask' );
push( @module, 'Safe::Caller' );
push( @module, 'Filter::CBC' );
push( @module, 'Feed::Find' );
push( @module, 'Getopt::Plus' );
push( @module, 'Bot::BasicBot::Pluggable' );
push( @module, 'AI::jNeural' );
push( @module, 'Authen::Simple::Passwd' );
push( @module, 'HTTP::CryptoCookie' );
push( @module, 'URI::Fetch' );
push( @module, 'Business::NoChex' );
push( @module, 'Image::TestJPG' );
push( @module, 'Devel::Peek' );
push( @module, 'Cmenu' );
push( @module, 'FreePAN::SVKMirror' );

fisher_yates_shuffle( \@module );

for ( my $i = 0; $i <= $#module; $i++ )
{
   my $name = $module[$i];

   $name =~ s/[:][:]/-/g;

   my $mi = $plus->module_tree( $module[$i] );


   eval( '$mi->package_name()' );

   next if ( @$ );

   next if ( $name ne $mi->package_name() );

   my $mid = $mi->package_name() . '-' . $mi->package_version();

   printf( "[BEGINNING] Distribution named %s is to be installed.\n", $mid );

   $mi->install();

   my $mist = $mi->status();

   my $xml_gz = undef;

   my $context_pl = undef;

   $reporter->distribution( $mid );

   if ( defined( $mist->extract() ) )
   {
      if ( $perm && ! -f $mist->extract().'/SIGNATURE' )
      {
         printf( "[REPORTING] %s missing SIGNATURE, sending insecurity message.\n", $mid );

         $reporter->grade( 'unsigned' );

         $reporter->send() || die $reporter->errstr();

      } ## end if

   } ## end if

   if ( ( $context eq 'stable' ) && ! $mist->installed() )
   {
      if ( $perm )
      {
         printf( "[REPORTING] %s failed to install, sending instablity message.\n", $mid );

         $reporter->grade( 'unstable' );

         $reporter->send() || die $reporter->errstr();

      } ## end if

      if ( -d '_dat' )
      {
         $xml_gz = 'Bundle::Modules::CPAN::Unstable::Unstable.xml.gz';

         $xml_gz =~ s/[:][:]/__/g;

         $context_pl = $xml->xml2pl( $xml_gz );

         $context_pl->{$module[$i]} = 1;

         $xml->pl2xml( $context_pl, $xml_gz );

      } ## end if

      printf( "[COMPLETED] Distribution named %s is not installed.\n", $mid );

   }
   elsif ( ( $context eq 'unstable' ) && $mist->installed() )
   {
      if ( ( $mist->signature() && $mist->checksum_ok() && -f $mist->extract().'/SIGNATURE' ) || ! $mist->created() )
      {
         if ( defined( $mist->extract() ) )
         {
            if ( $perm )
            {
               printf( "[REPORTING] %s is installed with a trusted signature, sending stablity message.\n", $mid );

               $reporter->grade( 'stable' );

            } ## end if

            if ( -d '_dat' )
            {
               $xml_gz = 'Bundle::Modules::CPAN::Unstable.xml.gz';

               $xml_gz =~ s/[:][:]/__/g;

               $context_pl = $xml->xml2pl( $xml_gz );

               $context_pl->{$module[$i]} = 0;

               $xml->pl2xml( $context_pl, $xml_gz );

            } ## end if

         }
         else
         {
            if ( $perm )
            {
               printf( "[REPORTING] %s is already installed, sending installed message.\n", $mid );

               $reporter->grade( 'installed' );

            } ## end if

         } ## end if

      }
      else
      {
         if ( $perm )
         {
            printf( "[REPORTING] %s is installed without a trusted signature, sending insecurity message.\n", $mid );

         $reporter->grade( 'signature' );

         } ## end if

      } ## end if

      if ( $perm )
      {
         $reporter->send() || die $reporter->errstr();

      } ## end if

      printf( "[COMPLETED] Distribution named %s is installed.\n", $mid );

   }
   elsif ( ( $context eq 'stable' ) && $mist->installed() )
   {
      printf( "[COMPLETED] Distribution named %s is installed.\n", $mid );

   }
   elsif ( ( $context eq 'unstable' ) && ! $mist->installed() )
   {
      printf( "[COMPLETED] Distribution named %s is not installed.\n", $mid );

   } ## end if

   if ( defined( $mist->extract() ) )
   {
      $sh->rm( '-Rf ' . $mist->extract() );

   } ## end if

} ## end for

##
## fisher_yates_shuffle - cookbook's in-place array permutation
##
sub fisher_yates_shuffle
{
   my $a = shift;

   for ( my $i = @$a; $i--; )
   {
      my $j = int( rand( $i + 1 ) );

      next if ( $i == $j );

      @$a[$i,$j] = @$a[$j,$i];

   } ## end for

} ## end sub fisher_yates_shuffle

1;

__END__

=head1 NAME

Bundle::Modules::CPAN::Unstable - All current I<unstable> modules in CPAN

=head1 SYNOPSIS

perl -MCPAN -e B<'install Bundle::Modules::CPAN::Unstable'>

cpan B<-i Bundle::Modules::CPAN::Unstable>

perl -MBundle::Modules::CPAN::Unstable

=head1 CONTENTS
Bundle::CPAN
Bundle::CPANPLUS
Bundle::Expect
Bundle::Test
Shell
=head1 CHANGES

=over

=item 2006.0510 (YYYY.MMDD)

Initial version of: Bundle::Modules::CPAN::Unstable-2006.0510

This B<L<Bundle::Modules>> component package is in pre-alpha state with hash ordering.

The ordering of listed modules will eventually be prioritized for efficiency and completeness.

Modules commented out of this module list are either I<unstable> or I<stable> in the B<L<Bundle::Modules>> context.

Optimistically, if there are a lot of the modules commented out, then they are I<stable>, and we're listing I<unstable> context.

Optimistically, if there are a few of the modules commented out, then they are I<unstable>, and we're listing I<stable> context.

If you use the command C<B<man Bundle::Modules::CPAN::Unstable>>, type C<B</#>> to see the commented out modules as they're higlighted for you by B<man>.

=item 2006.0520

This contains a newly refined concept of: Bundle::Modules::CPAN::Unstable-2006.0520

This B<L<Bundle::Modules>> component package is in pre-alpha state with randomized hash ordering.

The ordering of listed modules is now shuffled randomly on each run for better efficiency and completeness.

Modules are no longer listed in CONTENTS, like other 'Bundle::' bundles out there.  I just list Bundle::CPANPLUS.

I support the idea of testing of installations in mass, and I use the information provided by CPANPLUS test reports.

The B<L<Bundle::Modules>> suite has I<stable> and I<unstable> listings that will be updated using the information provided by the testers.db

The B<L<Bundle::Modules>> suite uses Module::Build in its Build.PL, and generates a compatible Makefile.PL.

The B<L<Bundle::Modules>> suite uses the CPANPLUS::Backend to create its own random-ordered installations.

=back

=head1 DESCRIPTION

This Bundle package will install all of the modules listed, if they're not commented out of the B<L<Bundle::Modules>> context.

=head1 SEE ALSO

I<L<Bundle::Modules>>, I<L<Bundle::Modules::Unstable>>, I<L<Bundle::Modules::CPAN>>, I<L<Bundle::Modules::Apache>>, I<L<Bundle::Modules::Apache::Unstable>>

=head1 AUTHORS

Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>

=head1 LICENSE for http://www.cpan.org/authors/id/E/ER/ERMEYERS/Bundle-Modules-2006.0528

perl

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=head1 COPYRIGHT

Copyright (C) 2006 by Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>


