package Bundle::Modules::Apache::Unstable;

use 5.005;

our $VERSION = 2006.0519; ## (YYYY.MMDD)

1;

__END__

=head1 NAME

Bundle::Modules::Apache::Unstable - All current I<unstable> Apache modules in CPAN

=head1 SYNOPSIS

perl -MCPAN -e B<'install Bundle::Modules::Apache::Unstable'>

cpan B<-i Bundle::Modules::Apache::Unstable>

=head1 CONTENTS

##Apache2::SiteControl::UserFactory
##Apache::Throttle::Log
##Apache::PageKit::Edit
##Apache::DnsZone
##Apache::MP3::L10N::nn_no
##Wizard::Examples::Apache::Server
##CPANXR::Apache::Search
##Apache::Keywords
##Apache::JemplateFilter
##Apache::Template
##Apache::Zobel
##Apache::Session::Sybase
##Apache::Wyrd::Services::FileCache
##Apache2::AuthenNTLM
##Apache::AxKit::Util::LibXSLTAddonFunction
##Apache::AuthenNIS
##Apache2::RequestUtil
##Wizard::Examples::Apache::Directory
##Apache::Session::Store::PHP
##Apache::DAV::DynModule
##Apache::Wyrd::Input::Set
##Apache::Wyrd::Interfaces::Setter
##Apache::XBEL
##Apache::Server
##Apache::Wyrd::Interfaces::Indexable
##Apache::Imager::Resize
##Apache::Session::SharedMem
##Apache::Motd
##Apache::FormatLog
##Apache::SWIT
##Apache::Backhand
##Apache::XPP::Inline
##Apache::AuthDigest::API::Full
##Apache::WAP::AutoIndex
##Apache::Wyrd::Lookup
##Apache::App::Mercury::Message
##Apache::AuthenPasswd
##Apache::Sybase::CTlib2
##Apache2::SiteControl::ManagerFactory
##Apache::PageKit::View
##Apache::Wyrd::Lattice
##Apache::AuthenNTLM
##Apache::AntiSpam::SpamTrap
##Bundle::Apache::ASP
##ApacheMagicApp
##Apache::AxKit::Plugins::Session
##Apache::ContentHandler
##Apache::SiteControl::GrantAllRule
##Apache::Mmap
##Apache::TestReportPerl
##Apache::Dir
##Apache::CVS::Revision
##Apache::TestHarness
##Apache::Perldoc
##Apache::HeavyCGI
##CPANXR::Apache::Header
##Apache::ASP::ApacheCommon
##OpenInteract::ApacheStartup
##Apache2::SiteControl::Rule
##Apache::TestRunPHP
##Apache::Wombat
##Apache::TopicMaps
##Apache::Storage
##Apache::Session::DBIBase64Store
##Apache::RPC::Status
##Template::Service::Apache
##Apache::AuthzNetLDAP
##Apache::iNcom::UserDBAuthen
##Apache::PHLogin
##Apache::JAF::Session
##Apache::Auth::User::Digest
##Apache::HTMLView
##Apache::AuthenIMAP
##Apache::Watchdog::RunAway
##Apache::Wyrd::Input::Opt
##Apache::AntiSpam
##Apache::Voodoo::Loader
##Apache::CVS::PlainFile
##Apache::Quota::BerkeleyDB
##Apache::LogF
##Apache::Wyrd::Services::SAK
##Apache::AuthKrb5Afs
##Apache::SWIT::Test
##Apache::Request::I18N
##Apache::HeavyCGI::ExePlan
##Apache2::Log
##Apache::DnsZone::DB::Oracle
##Apache::Voodoo::Debug
##Apache::Wyrd::Bot
##Apache::SessionManager
##Apache::DnsZone::DB
##Apache2::ParseSource
##Apache::AxKit::Exception
##Apache::Wyrd::Lattice::Header
##Apache::SiteControl::Radius
##Apache2::Protocol
##Apache::Wyrd::Number
##Apache::Session::PHP
##Apache::WeSQL::Session
##Apache::GeoIP
##Apache::AxKit::Provider::Gestinanna
##Apache::AxKit::StyleChooser::Hostname
##Apache2::AuthenMSAD
##Apache::SWIT::Maker::FileWriter
##Apache::Session::Lock::Memorycached
##Apache::HTTunnel::Keeper
##Apache::AuthPOP3
##Apache::JSONRPC
##Apache::DAV::XMLAttr
##Catalyst::Engine::Apache::MP13::Base
##Apache::AxKit::Provider::DOM
##Apache::CIPP
##Bundle::Apache
##Apache::Wombat::FileLogger
##Apache::DAV::XMLElem
##Apache::TestCharsetModify
##Apache::iTunes
##Apache::RSS::Encoding::JcodeUTF8
##Apache::AxKit::Provider::RDBMS::DBCacheAdapter
##Apache::Test
##Apache::JumpByReferer
##Apache::SecSess::Cookie
##Apache::Earlybird
##Apache::XAO
##Apache::Log
##Apache::Quota::DB_File::Lock
##Apache::Logmonster::Perl
##Apache2::Geo::IP
##Apache::DnsZone::Language
##Apache::Wyrd::CGISetter
##Apache::TestConfigC
##Sledge::Pages::Apache::I18N
##Apache::VimColor
##Apache::MP3::L10N::ca
##Apache::Logmonster::Utility
##Apache2::PerlSections::Dump
##Apache::Wombat::Connector
##Apache2::ModSSL
##Apache::Geo::IP::Record
##Apache::Constants::Exports
##Apache::Symdump
##Wizard::Examples::Apache
##Apache::OneTimeURL
##Apache2::ClickPath::Decode
##Apache::Session::DBI
##Apache::TaintRequest
##Apache::AxKit::Language::LibXSLT
##Apache::ErrorReport
##OpenPlugin::Upload::Apache2
##Apache::App::Mercury::DBI
##Apache2::Command
##Slauth::Config::Apache
##Apache::CompressClientFixup
##Apache::ASP::Server
##Apache::GuessCharset
##Apache::SizeLimit
##Apache::JAF
##Apache::TestCommonPost
##Apache::AxKit::Provider::RDBMS::ContentProvider
##Apache::MP3::L10N::hr
##Apache::Auth::User
##HTML::Mason::ApacheHandler2
##Apache::Auth::UserDB
##Apache::XPointer::XPath
##Apache::App::Mercury::Base
##Apache::PrettyText
##Apache::MakeCapital
##Apache2::RequestIO
##Apache::GopherHandler
##Apache::Roaming::LiPrefs
##Apache::Backend::POE
##Apache::MP3::L10N::cs
##Apache::AxKit::Language::AxPoint
##CPANXR::Apache::ClassBrowser
##Apache::TestBuild
##Apache::AuthzCache
##Apache::CryptHash
##Apache2::SourceTables
##Apache2::Cookie
##Apache2::ExplorerDestroyer::Level2
##MasonX::Request::WithApacheSession
##Apache::Wyrd::Chart
##Apache::MP3::L10N::fi
##Apache::Auth::UserDB::File
##Apache::MP3::L10N::tr
##Apache::DAV::HooksLiveprop
##OpenPlugin::Param::Apache
##App::Control::Apache
##Apache::ASP
##DynaPage::Apache2
##Apache2::URI
##Apache::FileManager
##Apache::ProxyScan
##Apache::PageKit::Config
##Apache::Wyrd::Services::CodeRing
##Apache::PAR::ScriptBase
##Apache::AxKit::Provider::RDBMS::ContentProvider::MultiSQL
##Apache2::StructureTable
##Apache::TinyCP
##Apache::Session::Store::SQLite3
##Apache::TestSort
##Apache::Session::Serialize::Dumper
##Apache::WebSNMP
##Apache2::Access
##Apache::TieBucketBrigade
##Wizard::Examples::Apache::Admin
##Apache::AuthenRadius
##Apache::Session::Flex
##Apache::SessionX::Manager
##Catalyst::Engine::Apache::MP13::Apreq
##Apache2::CPAN::SOAP
##Apache::AxKit::Provider::File
##Apache::ASP::Response
##Log::Agent::Driver::Apache
##Apache::AuthzUserDir
##Apache::ConfigParser
##Apache2::AUS
##Apache2::AuthenSmb
##Apache::ASP::Application
##Apache::ChooseLanguage
##Apache::XPointer::RDQL::Parser
##Apache::AxKit::Language::Query
##Apache::MP3::L10N::nn
##Apache::iNcom::UserDBAuthz
##Apache::BruteWatch
##OpenPlugin::HttpHeader::Apache
##Apache::Wyrd::Cookie
##Apache::Admin::Config
##Apache::AxKit::Provider::RDBMS
##Apache::DAV::Datum
##MasonX::Request::Apache2Handler
##RunApp::Control::ApacheCtl
##SQCAS::Apache
##Apache2::Build
##Apache::SSI
##Apache::ImageMagick
##Apache::CustomKeywords
##Apache2::CPAN::Search
##Apache::TimedRedirect
##Apache::ASP::Request
##Apache::Mmap::Handle
##Apache::RegistryNG
##Apache::SubProcess
##Wizard::Examples::Apache::Host
##Apache::Session::Serialize::SOAPEnvelope
##Apache2::ConstantsTable
##Apache::Request::Controller
##Apache::Session::Postgres
##Apache::DAV::LockupResult
##Apache::AuthDBI
##Apache::LoadAvgLimit::GetAvg
##OpenPlugin::Session::ApacheSession
##Apache::AliasList
##OpenFrame::Segment::Apache
##Apache::PrettyPerl
##Apache::AuthCAS
##CGI::Lite::Request::Apache
##Apache::XPP::Cache::Expiry::Duration
##Apache::AuthPAM
##Apache::AxKit::Language::XSP
##Apache::App::Mercury
##Apache::DnsZone::DB::Postgresql
##Apache2::WebStart
##OpenFrame::Segment::Apache::Request
##CIPP::Apache
##Apache::DB
##Apache2::TieBucketBrigade
##PurpleWiki::Apache2Handler
##Sledge::Request::Apache::I18N
##Apache::DBILogger
##Apache::Session::Store::File
##Bundle::Apache::Wombat
##Apache2::DebugFilter
##Apache2::SiteControl::User
##Apache::UploadSvr::Directory
##Apache::SWIT::Test::Apache
##Apache::Wyrd::DBL
##Apache::PerlRunXS
##Apache::SWIT::Maker::GeneratorBase
##Apache::MP3::L10N::ja
##Wizard::Examples::Apache::Config
##Apache::Wyrd::Lattice::Footer
##Apache::MP3::L10N::ms
##Apache::Session::Store::Memcached
##MyApache::Apache2Handler
##Apache::Action::State
##Apache::test
##Apache::Wyrd::Services::Index
##Apache2::ModBT
##Apache::TestTieBucketBrigade
##Apache::SecSess::DBI
##Apache::Precompress
##Apache::Pod
##Apache::MP3::L10N::Aliases
##Apache::DAV
##Apache::Proxy
##Apache::HEADRegistry
##Apache2::JemplateFilter
##Apache::Archive
##Apache::Emulator::Test
##Apache::GD::Thumbnail
##Apache::MP3::L10N::is
##Apache::AddReqHeader
##Apache::MultiAuth
##Apache::Traffic
##Apache2::SiteControl::Radius
##Apache::NavBarDD
##Apache::Singleton
##HTML::Mason::Resolver::File::ApacheHandler2
##HTML::Mason::ApacheHandler
##Apache::Emulator::Apache::TableHash
##Apache::DAV::LockTokenList
##Apache::MIMEMapper
##Apache::DBILogConfig
##Apache::MP3::L10N::nl_be
##Apache2::TrapSubRequest
##Apache::Embperl
##Apache::Clickable
##Apache::Session::FileStore
##MasonX::Request::HTMLTemplate::WithApacheSession
##Apache::DBI
##Apache::PerlSections
##Apache::Quota
##Apache::Application::Plus
##Apache::AxKit::Plugin::AddXSLParams::Request
##Apache::ModuleConfig
##Apache::Session::Store::CacheAny
##Apache2::SOAP
##Apache::MP3::L10N::no_no
##Apache::ModuleDoc
##Apache::Wyrd::Interfaces::GetUser
##Apache::AxKit::Language::YPathScript
##Apache::AxKit::Provider::File::Syntax
##Apache::ErrorControl
##Apache::AxKit::StyleChooser::FileSuffix
##Apache::Geo::Mirror
##Apache::AutoIndex
##Apache::AxKit::Language::SAXMachines
##Apache::Wyrd::Services::Tree
##Apache::Language::SW
##Apache::FakeTable
##Apache::Icon
##Apache::SecSess::Cookie::X509PIN
##Apache::Session::Serialize::YAML
##Apache::XPP::Cache::Store
##Apache::XMLRPC::Lite
##Apache::GD::Graph
##Apache::Stage
##Apache::Session::Serialize::Sybase
##Apache::DoCoMoUID
##Apache::WAP::MailPeek
##Apache::DBILogin
##Apache::OpenIndex
##Apache::Template::Provider::Gestinanna
##Apache::Scoreboard
##Sledge::Request::Apache::I18N::Upload
##OpenFrame::Segment::Apache2::Request
##Apache::Session::Oracle
##Apache2::PPI::HTML
##Apache::CVS::File
##CPANXR::Apache::File
##Apache::Wyrd::Input::Condenser
##Apache::Session::Daemon
##Apache::MP3::L10N
##Apache::PageKit
##Apache::CacheContent
##Apache::PAR::RegistryCooker
##Apache::DAV::PropsResult
##Apache::RewritingProxy
##Apache::SMTP
##Wizard::Examples::Apache::VirtualServer
##Apache::AuthDigest
##Apache::MP3::L10N::ar
##Catalyst::Engine::Apache::Base
##Apache::ePerl
##Apache::DAV::HooksLocks
##Apache::Emulator::Constants
##Apache::TestMB
##SML::Apache
##Apache::DAV::DynProvider
##Apache::SWIT::Subsystem::Generator
##Apache::ChefProxy
##Apache::MP3::L10N::es
##Apache::httpd_conf
##Apache::SecSess::Cookie::LoginForm
##Froody::Request::Apache
##Apache::Session::Store::Sybase
##Apache::Gestinanna
##Apache::TopicMaps::application::xtmPLUSxml::topic
##Apache2::CGI::Builder
##Apache::SSIChain
##Apache::ConfigParser::Directive
##Apache::Test5005compat
##Apache::RandomImage
##Apache::AxKit::Language
##Apache2::HookRun
##Apache::SecSess::URL::Cookie
##Apache::CVS::RcsConfig
##Apache::SiteControl::User
##Apache::Wyrd::Defaults
##Apache::AxKit::Language::XSP::ObjectTaglib
##Apache::DAV::HooksRepository
##Log::Dispatch::ApacheLog
##Apache::DefaultCharset
##HTML::Mason::Resolver::File::ApacheHandler
##Apache::Gateway
##Apache::SWIT::Maker::Generator
##Apache::LogRegex
##Apache::PageKit::Param
##Apache::Centipaid
##Apache2::DocServer
##Apache::MP3::L10N::sl
##Apache::SearchEngineLog
##Apache::LogFile
##Apache::DebugLog
##Apache::TopicMaps::text::html::search
##Bundle::ApacheTest
##Apache::AuthzLDAP
##Apache::AutoLogin
##Apache::AuthenNISPlus
##Apache::DAV::HooksDb
##Apache::Wyrd::Request
##Apache2::ServerUtil
##Apache::DnsZone::Config
##Apache::iNcom::SessionLocker
##Apache::Voodoo::Loader::Static
##Apache::Session::TreeStore
##Apache::Constants
##Apache2::Geo::IP::Record
##Apache::Wyrd::Query
##Apache2::AuthCookieDBI
##Apache::Peek
##Apache::Wyrd::Services::Auth
##Apache::iNcom::Localizer
##OpenFrame::Segment::Apache2::NoImages
##OpenInteract::Cookies::Apache
##Apache::SWIT::Test::Mechanize
##Siesta::Web::FakeApache
##Apache::Session::SingleThread
##Apache::ShowStatus
##Apache::AxKit::Language::XMLNewsRDF
##Apache::TestRun
##Apache::AuthenCache
##Apache::Layer
##Apache2::Filter::HTTPHeadersFixup
##Apache::Session::Serialize::UUEncode
##XML::MetaGenerator::Formula::Collector::Apache
##Apache2::Translation::DB
##Apache::OneTimeDownload
##Apache
##Apache::Backend::POE::Message
##Apache::AxKit::StyleChooser::UserAgent
##Authen::Simple::Apache
##Apache::PSP
##Apache::WeSQL::AppHandler
##Apache::Session::SysVSemaphoreLocker
##MKDoc::Apache_Cache
##Apache2::SubProcess
##HTTPD::Bench::ApacheBench
##Apache::SWIT::Subsystem::Base
##Apache::ParseFormData
##Apache::AxKit::Plugin::BasicSession
##Apache2::Module
##Apache2::AUS::RequestRec
##Apache::Emulator::Apache::Table
##RDBAL::Layer::ApacheSybaseDBlib
##Apache2::SafePnotes
##Apache::AuthTypeKey
##Apache2::Filter
##Apache::HTPL::Lib
##Apache::Voodoo::Pager
##Apache::PAR::Static
##Apache::Singleton::Request
##Apache::TopicMaps::text::html::index
##Apache2::JSONRPC
##Apache::AuthCookieNTLM
##Apache::App::Gallery::Simple
##Apache::App::Mercury::Message::Attachment
##Apache::AxKit::Plugin::Fragment
##Catalyst::Engine::Apache::MP19
##Apache::Wyrd::MySQLForm
##Apache::Filter::HanConvert
##Apache::HTTunnel::Handler
##Apache::AxKit::Plugin::Param::Expr
##Apache::AxKit::Cache
##Apache2::AuthCookieDBImg
##RunApp::Apache
##Apache::MagicPOST
##OpenFrame::Segment::Apache::NoImages
##Apache::ProxyStuff
##Apache::MP3::L10N::nl
##Apache::Wyrd::Services::SearchParser
##Apache::Wyrd::Lib
##Bundle::Apache2
##Apache::XPointer::RDQL
##Apache::Wombat::Response
##Apache::Authen::Program
##Apache::SetWWWTheme
##Apache::TestConfigPHP
##Apache::MP3::L10N::zh_tw
##Catalyst::Engine::Apache::MP20::Base
##Apache::TestSmokePerl
##Apache::AxKit::Provider
##Apache::TestCharset
##HTML::Mason::Request::ApacheHandler
##Apache::RegistryBB
##Apache::CGI::Builder
##Apache::MVC
##Apache::Session::Store::Informix
##Apache::ACEProxy::UTF8_RACE
##Apache::ParseControl
##Apache::Description
##Apache::ASP::Date
##Apache::LoadAvgLimit
##Apache::Singleton::Server
##Apache::Wyrd::Services::Key
##Apache::Session::Memorycached
##Apache::MP3::L10N::pl
##Apache::TestHarnessPHP
##Catalyst::Engine::Apache2
##OpenPlugin::Request::Apache2
##Apache::AuthenLDAP
##Apache::MP3::L10N::uk
##Apache::SecSess::Wrapper
##Apache::DAV::DynHooks
##Apache::AuthenSecurID::Auth
##Apache::Profiler
##Apache::XPP::PreParse
##CPANXR::Apache::Stats
##Apache::MP3::L10N::ru
##Apache::PageKit::Model
##Apache::TestTrace
##Apache::CVS::Directory
##Apache::Upload::I18N
##Apache::TopicMaps::application::xtmPLUSxml::search
##Apache::AxKit::Plugin::SvgCgiSerialize
##Apache2::SiteControl::PermissionManager
##Apache::Session::Store::Memorycached
##Apache::Lint
##Apache::Voodoo::ServerConfig
##Apache::AntiSpam::NoSpam
##Apache::HTPL
##Apache::Registry
##Apache::SmartProxy
##Apache::src
##Apache::PassFile
##Apache::Session::Generate::ModUniqueId
##Apache::DnsZone::AuthCookie
##Apache::AuthenN2
##Apache::Session::Counted
##Apache::ProxyRewrite
##OpenPlugin::HttpHeader::Apache2
##Apache::RegistryFilter
##Apache::Authen::Generic
##Apache::SWIT::HTPage
##OpenPlugin::Upload::Apache
##Apache::iNcom
##Apache::FakeCookie
##HTML::Mason::FakeApache
##Apache::Emulator
##Apache::Voodoo::Valid_URL
##Apache::DnsZone::DB::MySQL
##Apache::AuthenPasswdSrv
##OpenFrame::Segment::Apache::Response
##Apache::MP3::L10N::fr
##Apache::DProf
##Apache::AxKit::Language::XSP::SimpleTaglib
##HTTP::WebTest::Plugin::Apache
##Apache::HeavyCGI::Debug
##Apache2::AuthColloquy
##Apache::Wyrd::Form::Preload
##Apache::TestSSLCA
##Apache::Session::SQLite3
##Apache::Singleton::Process
##OpenFrame::Example::ApacheSimple
##Apache::MP3::L10N::ko
##Apache::Recorder
##Apache::Cookie
##Apache2::UploadProgress
##Apache::ACEProxy::RACE
##Apache::Album
##Apache::AxKit::Language::HtmlDoc
##Apache::Session::Tree
##Apache::DAV::LockDB
##Apache::DAV::Lock
##Bundle::Apache::ASP::Extra
##Apache::HeavyCGI::Layout
##Apache::AxKit::Provider::RDBMS::ContentProvider::SQL
##Apache2::Connection
##Apache2::ExplorerDestroyer
##Apache::ParseLog
##Apache2::AuthNetLDAP
##Apache::Pod::Text
##Apache::PassHtml
##Apache::SimpleTemplate
##Apache::TestCommon
##Apache::TestReport
##Apache::HeavyCGI::Date
##Apache::AuthTkt
##Apache::AxKit::Provider::Scalar
##Apache::XPP::Cache::Expiry
##Apache2::ExplorerDestroyer::Level3
##Apache::SIG
##Apache::Usertrack
##Apache::SiteControl::PermissionManager
##Catalyst::Engine::Apache::MP20::Apreq
##Apache::TestMM
##Apache::Session::Lock::MySQL
##Apache::XPP
##Apache::LangPrefCookie
##Apache::Voodoo
##Apache2::Geo::Mirror
##Apache::WeSQL::SqlFunc
##Apache2::FilterRec
##Apache::Session::Lazy
##Apache::HeavyCGI::SquidRemoteAddr
##SOAP::Transport::HTTP::Apache
##Apache::Wyrd::ErrField
##Apache::JAF::Util
##CGI::Application::Plugin::Apache::Request
##Apache::TestUtil
##Apache::Geo::IP
##Apache::DAV::DynContext
##Apache::ASP::State
##Apache::SessionX::Generate::MD5
##Apache::DebugInfo
##Apache::MP3::L10N::ga
##Apache::libapreq
##Apache::AuthPerLDAP
##Pangloss::Apache::Handler
##OpenPlugin::Cookie::Apache
##Apache::Session::Generate::MD5
##Apache2::PerlSections
##ePortal::Apache
##Apache::AuthenSecurID
##Apache::App::Mercury::SMTP_Message
##Apache::JAF::Cookies
##Apache2::AuthenDBMCache
##Apache::AuthzNIS
##Apache::AuthDigest::API
##SOAP::Transport::ActiveWorks::HTTP::Apache
##Apache::Resource
##OpenFrame::Segment::Apache2
##Apache::MP3::L10N::en
##Apache::No404Proxy::Google
##Apache::App::Mercury::UserManager::Demo
##Apache::TestHandler
##Apache::Session::Serialize::PHP
##Apache::RegistryLexInfo
##Apache::ASP::CGI::Table
##Apache::Options
##Apache::Sybase::CTlib
##Apache::RSS
##Apache::ASP::Session
##Apache::AntiSpam::Heuristic
##Apache::Session::Lock::File
##Apache::AppCluster
##Apache::ProxyConf
##Apache::Throttle
##XML::Directory::Apache
##Apache2::CPAN::Query
##Apache::SharedMem
##Apache::Session::Store::MySQL
##Apache::AuthzDigest
##Apache::VMonitor
##Apache::GopherHandler::TiedSocket
##Apache::DAV::PropCtx
##Apache::Sybase::ConPool
##Apache::Wyrd::Datum
##Apache::Session::Manager
##Catalyst::Engine::Apache
##Apache::TestSmoke
##Apache::HeavyCGI::IfModified
##Apache::UploadMeter
##Apache::AuthenProgram
##Apache2::Directive
##Apache::AntiSpam::JavaScript
##MyApache::Mason::ApacheHandler2
##Apache::Access::Headers
##Apache::AxKit::MediaChooser::WAPCheck
##Messaging::Courier::ApacheGateway
##OpenPlugin::Cookie::Apache2
##Apache::AxKit::Language::XMLNewsNITF
##Apache::Session::Store::Oracle
##Data::Phrasebook::Loader::ApacheFormat
##Apache::Emulator::Apache::Constants
##Apache2::Util
##Apache::Session::DB_File
##Apache::PhotoIndex
##Apache2::Upload
##Apache::ASP::CGI
##Apache::AuthenMT
##Apache::DAV::Text
##Apache::ASP::GlobalASA
##Bundle::Apache::Roaming
##Apache::AuthenSmb
##Apache::AxKit::Provider::Filter
##Apache::ReverseProxy
##Apache::App::Mercury::Display
##Apache::Wyrd::Services::TicketPad
##Apache::Wyrd::ErrTag
##Apache::FakeRequest
##Apache::MP3::L10N::no
##Apache::ShowRequest
##Apache::AxKit::Language::Svg2AnyFormat
##Apache::SWIT::Maker::Conversions
##Apache::WeSQL::Journalled
##Apache2::SiteControl::GrantAllRule
##Apache::Request::Dispatcher
##Apache::AxKit::Plugin::Passthru
##Apache::AddHostPath
##Apache2::AuthCookie
##Catalyst::Engine::Apache::MP19::Base
##Apache::MP3
##Apache::SmallProf
##Apache::Voodoo::ValidURL
##Apache::AuthCookiePAM
##SQCAS::Apache::EditAccount
##Apache::FilteringProxy
##Apache::DAV::Response
##Apache::Request
##Apache::DAV::WalkerCtx
##Catalyst::Engine::Apache::MP20
##Apache::AntiSpam::HTMLEncode
##Apache::AxKit::Provider::FileWrite
##CPANXR::Apache
##Apache::Application::Magic
##Apache::MP3::L10N::fa
##Apache::Language::Constants
##Apache2::Status
##Apache::MP3::L10N::sk
##Text::MicroMason::ApacheHandler
##Apache::AxKit::ConfigReader
##Apache::Session::DaemonLocker
##Apache::SessionX
##Apache2::ClickPath
##Apache::TestRequest
##Apache::Session::Serialize::Base64
##Apache::Session::Generate::ModUsertrack
##Apache::MP3::L10N::he
##Apache::TestRunParrot
##Apache::AxKit::Language::XSP::TaglibHelper
##Apache::AuthDigest::API::Multi
##Apache::RandomLocation
##Apache::AxKit::Provider::File::Formatter
##Apache::AuthCookie
##Apache::SecSess
##Apache::ASP::Collection
##Apache2::CmdParms
##Apache::GTopLimit
##Apache2::ExplorerDestroyer::Level1
##Apache::MP3::L10N::x_marklar
##Apache::Cache
##SQCAS::Apache::NewUser
##Catalyst::Engine::Apache2::MP19
##Apache::Request::PageKit
##Apache::MP3::L10N::nb_no
##Apache::Leak
##Apache::AuthCookieDBI
##Apache::SecSess::URL
##Apache::AuthzPasswd
##Apache::AuthExpire
##Apache2::ClickPath::_parse
##Apache::GzipChain
##Apache::OWA
##Apache::XPP::Cache
##Apache::Session::IPC
##Apache2::Reload
##Apache2::ServerRec
##Apache::Htpasswd
##Apache::DAV::Resource
##Apache::AxKit::Provider::CGI
##Apache::Debug
##Apache::PAR::PerlRun
##Apache::Session::Lock::Semaphore
##Apache::MP3::L10N::RightToLeft
##Apache::iNcom::OrderManager
##Apache::Sandwich
##XML::ApacheFOP
##Apache::Wyrd::User
##Apache::Wombat::Logger
##Apache::Access::Abuse
##Apache::UploadSvr
##Apache::AuthCookie::Util
##Apache::RequestNotes
##Apache::SWIT::DB::Connection
##Apache::AxKit::Plugin::QueryStringCacheRegexp
##Apache::Wyrd::Handler
##ExBase::ApacheHandler
##Apache::AxKit::Plugin::Upload
##Apache::JavaScript::DocumentWrite
##Apache2::Translation
##Apache::Backend::POE::Connection
##ENH::Apache
##Apache::Session::Win32
##Apache::ImageShoehorn
##Apache::Session::SQLite
##Apache::URI
##Apache::Emulator::Apache
##Apache::TestRunPerl
##Template::Plugin::Apache::SessionManager
##APR::Request::Apache2
##Apache::DoCoMoProxy
##Apache::iNcom::Session
##Apache::Mysql
##Apache::Session::Informix
##Apache::Wyrd::Debug
##Apache::DAV::XMLDoc
##Apache::SiteControl::Rule
##Apache::StickyQuery
##Apache::MP3::Playlist
##Apache::AuthCookieLDAP
##CPANXR::Apache::Util
##Apache::AxKit::Language::LibXSLTEnhanced
##MasonX::Resolver::File::Apache2Handler
##Apache::Session
##Apache::Array
##RunApp::Template::Apache
##Apache::Wyrd::LogDump
##Apache2::MPM
##Apache::testold
##Apache::SAPSOAP
##Apache::TestConfigParrot
##Devel::Profiler::Apache
##Apache::Session::MemoryStore
##Apache::FakeSSI
##Apache::SimpleReplace
##Apache::Session::Lock::Sybase
##Apache::DAV::IfHeader
##OpenFrame::Server::Apache
##Apache::Pod::HTML
##Apache::ChildExit
##Apache::SWIT::Subsystem::Maker
##Apache2::Const
##Apache::AuthenURL
##CPANXR::Apache::Symbol
##Apache::Session::Embperl
##CPANXR::Apache::Distribution
##Apache::URI2param
##SQCAS::Apache::Login
##Apache::iNcom::CartManager
##Apache::Auth::UserDB::File::Digest
##Apache::TestConfig
##Apache::SecSess::Cookie::URL
##Apache::Reload
##Apache::App::Mercury::Controller
##Apache::ASP::Lang::PerlScript
##Apache::Wyrd::Redirect
##Apache2::RequestRec
##Apache::PageKit::Content
##Apache::Dynagzip
##Apache::SWIT::Maker::GeneratorsQueue
##Apache::Module
##Apache::SMTP::Server
##Apache::XPP::Cache::Store::File
##Apache::Voodoo::Handler
##Apache::UploadSvr::Dictionary
##Apache::Auth::User::Basic
##Apache::MP3::L10N::sr
##Apache::RedirectDBI
##Apache::AppCluster::Client
##DBI::ProfileDumper::Apache
##Apache::AxKit::LibXMLSupport
##Apache::Mailtrack
##Apache::Table
##Apache::CVS::Graph
##SQCAS::Apache::Authentication
##Apache::Voodoo::Table
##Apache::MP3::L10N::nb
##Apache::AuthNetLDAP
##Apache::MiniWiki
##Apache::Wyrd::FileSize
##Config::ApacheExtended::Grammar
##Apache::StatINC
##Apache::LangURI
##Apache::File::Resumable
##Apache::XPointer
##Apache::Include
##Apache::Wombat::Request
##Apache::Voodoo::DisplayError
##Config::ApacheExtended
##Apache::UploadSvr::User
##Apache::SOAP
##Apache::Taco
##Apache::MP3::L10N::de
##Apache::App::Mercury::Message::DBI
##Apache::AxKit::Language::SpellCheck
##Apache::Wyrd
##Apache::App::Mercury::Config
##Apache::SWIT::Session
##Apache::DBI::Cache
##Apache::CookieToQuery
##Apache::AxKit::Language::PassiveTeX
##Mail::Toaster::Apache
##Apache::EP
##Apache::Session::Lock::Null
##Apache::DumpHeaders
##Apache::AxKit::StyleChooser::Cookie
##Apache::Session::PosixFileLocker
##Apache::PAR
##Apache::Voodoo::Theme
##Apache::Session::Serialize::Storable
##Apache::HeavyCGI::UnmaskQuery
##Apache::Session::DBIStore
##Apache::Wyrd::ShowParams
##Apache::PassExec
##Apache::NNTPGateway
##Apache::ASP::Load
##Acme::Apache::Werewolf
##Apache::AuthCookieURL
##Apache2::ShowStatus
##Apache::DAV::StateList
##Apache2::AUS::Util
##Apache2::porting
##Apache::ScoreboardGraph
##Apache::MP3::L10N::it
##Apache::Blog
##Apache::Gallery
##Apache2::FunctionTable
##Apache::RegistryLoader
##Apache::TopicMaps::application::xtmPLUSxml::index
##Apache::Status
##Apache::No404Proxy
##PurpleWiki::Apache2NidHandler
##OpenFrame::Segment::Apache2::Response
##Apache2::SizeLimit
##Apache::PerlRun
##Apache::AuthLDAP
##Apache2::AuthTicket
##Apache::AuthLDAPBind
##Apache::AuthDigestDBI
##Apache2::ClickPath::StoreClient
##SOAP::Apache
##Apache::LogFile::Config
##Apache::Session::Wrapper
##Apache::MP3::Resample
##Apache::Roaming
##Apache::AxKit::Plugin::AddXSLParams::BasicSession
##Apache::TransLDAP
##Apache::Session::Memcached
##Catalyst::Engine::Apache2::MP20
##CGI::Application::Plugin::Apache
##OpenPlugin::Request::Apache
##Apache::WeSQL::Auth
##Apache::WeSQL
##Apache::Wyrd::Interfaces::XMLer
##Apache::OutputChain
##Apache::RefererBlock
##CIPP::Compile::Apache
##Apache::Htgroup
##Apache::MP3::L10N::sh
##Apache::PerlRunFilter
##Apache::CVS
##Apache::DummyScoreboard
##Apache::DAV::Error
##Apache::AuthDigest::API::Session
##Apache2::Request
##Apache::Wyrd::Interfaces::Stealth
##Apache::PerlVINC
##Apache::DBI::Cache::mysql
##Logfile::Apache
##Apache::Session::Store::Postgres
##Apache::Symbol
##Apache::CVS::HTML
##Apache::AuthzSplitDomainUser
##OpenPlugin::Param::Apache2
##Apache2::Resource
##Apache::Htpasswd::Perishable
##Apache::AuthChecker
##Apache2::Protocol::ESMTP
##Apache::Action::DesignDB::Feedback
##Apache::AxKit::Plugin::OpenOffice
##Apache::Wyrd::Template
##Apache::Auth::UserDB::File::Basic
##Apache::AxKit::Plugin::BasicAuth
##HTML::Mason::Request::ApacheHandler2
##Apache::ExtUtils
##Apache::CVS::Diff
##Apache::Util
##Apache::Voodoo::Zombie
##Apache::PAR::Registry
##Apache::Syntax::Highlight::Perl
##Apache::Cookie::Encrypted
##Apache::HeavyCGI::Exception
##Config::ApacheFormat
##Apache2::compat
##Apache::Mason
##Apache::Session::MySQL
##Apache::Session::Store::DB_File
##Apache::SecSess::Cookie::BasicAuth
##Apache::Wyrd::Interfaces::Mother
##Apache::Handlers
##Apache::XPointer::RDQL::RDFStore
##MasonX::Request::ExtendedCompRoot::WithApacheSession
##Apache::TableEntry
##Apache::MP3::Skin
##Apache::DnsZone::Resolver
##CPANXR::Apache::Footer
##Parse::RecDescent::Config::ApacheExtended::Grammar
##Apache::AxKit::CharsetConv
##Apache::Wyrd::SQLForm
##CPANXR::Apache::SubBrowser
##Apache::Wyrd::Var
##Apache2::LogF
##Apache::AppCluster::Server
##Apache::SWIT::Maker
##Apache::ASP::CollectionItem
##Apache2::SubRequest
##Apache::SpellingProxy
##Apache2::TomKit::Processor::XPathScript
##Apache2::DebugLog
##Apache::ASP::CGI::Test
##Bundle::ABH::Apache
##Apache::Bwlog
##Apache2::SiteControl
##Apache::Language
##Apache::AxKit::Plugin::QueryStringCache
##Apache::ACEProxy
##Apache::Opcode
##Apache::Session::CacheAny
##Apache::EnvDir
##Apache::JAF::MyJAF
##Apache::TopicMaps::text::html::topic
##Apache::Request::Redirect
##Apache::SecSess::Cookie::X509
##Apache::FormatLog::Combined
##Apache::Wyrd::Form::View
##Apache::TestServer
##Apache::AxKit::Language::XPathScript
##Apache::Queue
##MasonX::Request::WithApache2Session
##Apache::AxKit::Plugin::Session
##Apache::SiteControl
##Apache2::ModBT::LeechNuker
##Apache::LoggedAuthDBI
##Apache::RPC::Server
##Apache::Action
##Apache2::XSLoader
##Apache::AxKit::Language::Sablot
##Apache::Wyrd::Lattice::Grid
##Apache::Wyrd::Input
##Apache::Wyrd::Form::Template
##SQCAS::Apache::Authorization
##Apache::App::Mercury::UserManager
##Apache::ForwardedFor
##Apache::WeSQL::Display
##Apache::Language::DBI
##Apache::File
##Apache::Language::PlainFile
##Apache::Compress
##Apache::Filter
##Apache::Wyrd::Attribute
##Apache::Toe
##Apache::AxKit::StyleChooser::PathInfo
##Apache::Wyrd::CSSGene
##Apache::DAV::TextHeader
##MasonX::Apache2Handler
##Apache::Framework::App
##Apache::ACEProxy::SJIS_RACE
##Apache::SiteControl::UserFactory
##Apache::FormatLog::Common
##XML::ApplyXSLT::Apache
##Apache::Wyrd::Services::LoginServer
##Apache::TableHash
##Apache::AuthenURL::Cache
##Apache::Voodoo::Loader::Dynamic
##Apache::MONITOR
##Apache::RSS::Encoding
##Apache::Wyrd::Form
##Apache::DebugLog::Config
##Apache::SAPSOAPServer
##Apache::BioChrome
##Apache::AuthTicket
##Apache::CodeRed
##Apache::SWIT::Maker::FileWriterData
##Apache::SessionX::Store::File
##Apache::AxKit::Provider::RDBMS::DBCacheAdapter::SQLite
##App::Info::HTTPD::Apache
##Apache::Wyrd::Input::Complex
##Apache::MP3::Sorted
##Apache::AxKit::Provider::PodSAX
##Apache::ProxyPassThru
##Apache::RedirectLogFix
##Apache::Connection
##Apache::MP3::L10N::zh_cn
##PurpleWiki::Apache1Handler
##CPANXR::Apache::Visualizer
##Apache::AwSOAP
##Apache::XMLRPC
##Apache::ASP::STDERR
##Apache2::ClickPath::Store
##Apache::LogIgnore
##Apache::Wyrd::CGICond
##Apache::AuthCookieDBIRadius
##Apache::Session::Generate::AutoIncrement
##Catalyst::Engine::Apache::MP13
##Apache::TempFile
##Apache::Dispatch
##Apache::Wyrd::Interfaces::SmartInput
##Apache::SWIT::Test::ModuleTester
##Apache::TestClient
##Catalyst::Engine::Apache::MP19::Apreq
##Data::ObjectDriver::Driver::Cache::Apache
##Maypole::Plugin::Config::Apache
##Apache::mod_pml
##Apache2::GeoIP
##Apache::iNcom::Request
##Apache2::Process
##Apache::SiteControl::ManagerFactory
##Apache::HTTunnel
##Apache::ProxyPass
##Froody::Server::Apache
##LiveGeez::Apache
##Apache::Session::Store::DBI
##Apache::Session::File
##Apache2::Response
##Apache::WinBitHack
##Apache::MSIISProbes
##Apache2::POST200
##Apache::AxKit::StyleChooser::QueryString
##OpenFrame::Example::Apache2Simple
##Apache::Session::NullLocker
##Apache::SWIT::Test::Request
##Apache::AxKit::Provider::OpenOffice
##MasonX::Request::WithApacheSession2
##Apache::MP3::L10N::nl_nl

=head1 CHANGES

=over

=item 2006.0510 (YYYY.MMDD)

Initial version of: Bundle::Modules::Apache::Unstable-2006.0510

This B<L<Bundle::Modules>> component package is in pre-alpha state with hash ordering.

The ordering of listed modules will eventually be prioritized for efficiency and completeness.

Modules commented out of this module list are either I<unstable> or I<stable> in the B<L<Bundle::Modules>> context.

Optimistically, if there are a lot of the modules commented out, then they are I<stable>, and we're listing I<unstable> context.

Optimistically, if there are a few of the modules commented out, then they are I<unstable>, and we're listing I<stable> context.

If you use the command C<B<man Bundle::Modules::Apache::Unstable>>, type C<B</#>> to see the commented out modules as they're higlighted for you by B<man>.

=back

=head1 DESCRIPTION

This Bundle package will install all of the modules listed, if they're not commented out of the B<L<Bundle::Modules>> context.

=head1 SEE ALSO

I<L<Bundle::Modules>>, I<L<Bundle::Modules::Unstable>>, I<L<Bundle::Modules::CPAN>>, I<L<Bundle::Modules::CPAN::Unstable>>, I<L<Bundle::Modules::Apache>>, I<L<Bundle::Modules::Acme::Everything>>, I<L<Bundle::Modules::Acme::Everything::Unstable>>, I<L<Bundle::Modules::Acme::Everything::Unique>>, I<L<Bundle::Modules::Acme::Everything::Unique::Unstable>>

=head1 AUTHORS

Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>

=head1 LICENSE for http://www.cpan.org/authors/id/E/ER/ERMEYERS/Bundle-Modules-2006.0519

perl

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=head1 COPYRIGHT

Copyright (c) 2006 by Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>


