package SparkX::Form::BasicFields;

our $VERSION = '0.01';

1;
__END__

=head1 NAME

SparkX::Form::BasicFields - A collection of basic fields for Spark::Form

L<Spark::Form> is a way to define your own forms with validation and auto-printing. See that module for more information.

This file is just explanatory. SEE ALSO for more interesting files.

=head1 VERSION

Version 0.01

=head1 SEE ALSO

L<Spark::Form> - The forms handling system itself
L<SparkX::BasicValidators> - If you want to have validation of these fields
L<SparkX::Form::Field::Text> - A text field
L<SparkX::Form::Field::Checkbox> - A checkbox field
L<SparkX::Form::Field::Radio> - A radio button set
L<SparkX::Form::Field::Select> - A select button set
L<SparkX::Form::Field::TextArea> - A textarea field

=head1 AUTHOR

James Laver, C<< <printf(qw[%s@%s.%s cpan jameslaver com])> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-sparkx-form-basicfields at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=SparkX-Form-BasicFields>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

=head1 SUPPORT

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=SparkX-Form-BasicFields>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/SparkX-Form-BasicFields>

=back

=head1 ACKNOWLEDGEMENTS

=head1 COPYRIGHT & LICENSE

Copyright 2009 James Laver, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.


=cut
