#!/usr/local/bin/perl
# Hit_rpt.pl - example CGI script using IBPerl 0.2
# to report data in the database populated by pagehit.pl.
# Copyright 1996 Bill Karwin

use IBPerl;
use CGI qw(:standard);
$request = new CGI;
$specific = $request->param('page');

$db = new IBPerl::Connection(
	Server   => 'www',
	Path     => '/usr/httpd/data/hit.gdb',
	User     => 'sysdba',
	Password => 'masterkey');

$tr = new IBPerl::Transaction( Database => $db);

print header;
print start_html(   -title   => 'Page Hit Report',
			-author  => 'Bill Karwin',
			-BGCOLOR => 'White' );

if (!$specific)
{
	print h1('Page Hit Summary'), hr, "\n";
	$query = 'SELECT URL, COUNT(URL) FROM HIT_LOG GROUP BY URL ORDER BY 2';
	$st = new IBPerl::Statement( Transaction => $tr, Stmt => $query);
	$st->open;
	print "<CENTER><TABLE BORDER CELLPADDING=10><TR>\n";
	while ( ! $st->fetch(\@datum) )
	{
		$self_url = $request->script_name() . "?page=$datum[0]";
		print	"<TR>\n <TD> $datum[1] </TD>\n";
		print	"<TD>", a( { href => "$self_url" }, $datum[0] ),
			"</TD></TR>\n";
	}
	print "</TABLE></CENTER>";
	$st->close;
} 

else
{
	print "<CENTER>\n";
	print h2("Page Hit Report: $specific"), hr, "\n";
	$query = 'SELECT HOST, COUNT(HOST) FROM HIT_LOG WHERE URL = "' . $specific . '" GROUP BY HOST ORDER BY 2';
	$st = new IBPerl::Statement( Transaction => $tr, Stmt => $query, Sep => ' ');
	$st->open;
	print h4( "Summary for page by client host:\n");
	print "<TABLE BORDER CELLPADDING=10><TR>\n";
	while ( ! $st->fetch(\@datum) )
	{
		print	"<TR>\n <TD> $datum[0] </TD>\n";
		print	"       <TD> $datum[1] </TD> </TR>\n";
	}
	print "</TABLE>", p;
	$st->close;
	print hr, "\n";

	$query = 'SELECT COUNT(DAY), DAY FROM HIT_LOG WHERE URL = "' . $specific. '" GROUP BY DAY ORDER BY 1';
	$st = new IBPerl::Statement( Transaction => $tr, Stmt => $query, Sep => ' ');
	$st->open;
	print h4( "Summary for page by date:\n");
	print "<TABLE BORDER CELLPADDING=10><TR>\n";
	while ( ! $st->fetch(\@datum) )
	{
		print	"<TR>\n <TD> $datum[0] </TD>\n";
		print	"       <TD> $datum[1] </TD> </TR>\n";
	}
	print "</TABLE>\n", p;
	$st->close;
	print "</CENTER>\n";
	
}

$tr->commit;
$db->disconnect;
print hr, end_html, "\n";
close(STDOUT);
exit(0);

