/*
 * IBPerl -- a Perl 5 extension for SQL RDBMS programming
 *   with InterBase client library.
 *
 * IBPerl.h
 *
 * Copyright (c) 1996-1999 Bill Karwin
 *
 * This is unsupported, free software.  Neither Bill Karwin,
 * InterBase Software Corporation, nor Inprise Corporation are
 * responsible for damages resulting from the use or misuse of
 * this software.  Test early, test well, test often.
 *
 * You may distribute under the terms of either the GNU General
 * Public License or the Artistic License, as specified in the
 * Perl README file.
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <perl.h>
#include <config.h>
#include <ibase.h>
#include <malloc.h>

#ifndef ISC_STATUS_LENGTH
#define ISC_STATUS_LENGTH 20
#endif

#define DPB_FILL(x) *dpb++ = (x)
#define DPB_FILL_INT(x)					\
    {							\
	long l;						\
	char *d;					\
	l = isc_vax_integer((char *) &(x), 4);		\
	d = (char *) &l;				\
	DPB_FILL( 4 );					\
	DPB_FILL(*d++);					\
	DPB_FILL(*d++);					\
	DPB_FILL(*d++);					\
	DPB_FILL(*d++);					\
    }


typedef struct vary {
    short          vary_length;
    char           vary_string [1];
} VARY;


typedef struct _db {
    char		inuse;		/* TAKEN or AVAILABLE */
    int			id;
    isc_db_handle	handle;
    long		status[ISC_STATUS_LENGTH];
    char *		dpb_buffer;	/* database parameter buffer */
    short		dpb_length;
} DB_info;

typedef struct _tr {
    char		inuse;		/* TAKEN or AVAILABLE */
    int			id;
    isc_tr_handle	handle;
    long		status[ISC_STATUS_LENGTH];
    char *		tpb_buffer;	/* transaction parameter buffer */
    short		tpb_length;
    DB_info *		db;		/* pointer to parent database */
} TR_info;

typedef struct _st {
    char		inuse;		/* TAKEN or AVAILABLE */
    int			id;
    isc_stmt_handle	handle;
    long		status[ISC_STATUS_LENGTH];
    XSQLDA *		out_sqlda;
    XSQLDA *		in_sqlda;
    char *		cursor_name;
    long		stmt_type;
    TR_info *		trans;		/* pointer to parent transaction */
    long		count;
    short *		osqlind;
    short *		isqlind;
    unsigned short	sqldialect;
    ISC_STATUS          sp_fetched;
} ST_info;

DB_info * IB_new_DB();
DB_info * IB_get_DB(int);
void      IB_free_DB(DB_info *);
TR_info * IB_new_TR(int);
TR_info * IB_get_TR(int);
void      IB_free_TR(TR_info *);
ST_info * IB_new_ST(int);
ST_info * IB_get_ST(int);
void      IB_free_ST(ST_info *);

/*
 * Make "gcc -Wall -pedantic" happy.
 */
void croak (const char * pat, ...);

#define FIRST		(1)
#define CHUNK		(5)
#define AVAILABLE	(0)
#define TAKEN		(1)
#define BLOB_SEGMENT	(256)
#define MAX_BLOB_SEGMENT (65535)
#define IBPERL_DEFAULT_SQL_DIALECT (1)

#define SUCCESS		(0)
#define FAILURE		(-1)

#ifdef IBPERL_THREAD_SAFE

#define ERRCHECK(stat, hash)					\
	if ((stat)[0] == 1 && (stat)[1])			\
	{							\
	    char *err = Error_Vector((stat));			\
	    if (err) {						\
		Error_String((hash), err);			\
		free(err);	 				\
	    } else {						\
		Error_String((hash), "Indeterminant error");	\
	    }							\
	    RETVAL = FAILURE;					\
	    goto end;						\
	}

#else

#define ERRCHECK(stat, hash)					\
	if ((stat)[0] == 1 && (stat)[1])			\
	{							\
	    char *err = Error_Vector((stat));			\
	    if (err) {						\
		Error_String((hash), err);			\
	    } else {						\
		Error_String((hash), "Indeterminant error");	\
	    }							\
	    RETVAL = FAILURE;					\
	    goto end;						\
	}

#endif /* IBPERL_THREAD_SAFE */

/*
 * To protect us from really killing our system, IBPerl has hardcoded
 * a limit on the length of a Blob that can be fetched into a scalar.
 * If you want to fetch Blobs that are bigger, write your own Perl
 * interface!  ;-)
 * But seriously, it'd be nice in the future to write some methods
 * for fetching and storing blobs by segment, so IBPerl didn't have
 * this limitation.  That's for a future version.
 */
#define MAX_SAFE_BLOB_LENGTH (1000000)

