package Params::CheckCompiler::Exception::Positional::Required;

use strict;
use warnings;

our $VERSION = '0.02';

use Moo;

extends 'Throwable::Error';

has minimum => (
    is       => 'ro',
    required => 1,
);

has got => (
    is       => 'ro',
    required => 1,
);

1;

# ABSTRACT: Exception thrown when a required positional parameter is not passed

__END__

=pod

=encoding UTF-8

=head1 NAME

Params::CheckCompiler::Exception::Positional::Required - Exception thrown when a required positional parameter is not passed

=head1 VERSION

version 0.02

=for Pod::Coverage .*

=head1 SUPPORT

Bugs may be submitted through L<the RT bug tracker|http://rt.cpan.org/Public/Dist/Display.html?Name=Params-CheckCompiler>
(or L<bug-params-checkcompiler@rt.cpan.org|mailto:bug-params-checkcompiler@rt.cpan.org>).

I am also usually active on IRC as 'drolsky' on C<irc://irc.perl.org>.

=head1 AUTHOR

Dave Rolsky <autarch@urth.org>

=head1 COPYRIGHT AND LICENCE

This software is Copyright (c) 2016 by Dave Rolsky.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
